//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//.
////\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\.
//
// This file implements a class which keeps the state information of the plugin
// This is the main class from the navigator standpoin but from a java standpoint
// this class is useless since all the avi functionalities are exposed from CCAvi
//
////\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\.
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//.

#ifndef __PLGWND_H__
#define __PLGWND_H__

//\\// INCLUDE
#ifndef _INC_WINDOWS    
#include <windows.h>
#endif
#ifndef _NPAPI_H_
#include "npapi.h"
#endif
#ifndef __CAVI_H__
#include "cavi.h"
#endif

//\\// DEFINE
// menu identifiers
#define ID_VIDEO_PLAY				5000
#define ID_VIDEO_STOP				5001
#define ID_VIDEO_REWIND				5002
#define ID_VIDEO_FORWARD			5003
#define ID_VIDEO_FRAME_BACK			5004
#define ID_VIDEO_FRAME_FORWARD		5005
#define ID_VIDEO_SEEK				5006
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//.
////\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\.
//
// CPluginWindow
//
//	Main plugin object. Keep the state of any single avi instance
//
class CPluginWindow 
{
	private:
		HWND		_hPluginWnd;	// plugin window handle coming from the navigator
		WNDPROC		_pfnDefault;	// old window proc (before subclassing)

		CAvi *		_pAvi;			// avi object
		uint16		_mode;			// full screen or not

	private:
		// used to register this object instance in the window property
		static LPSTR _ThisLookUp;

	public:
		static LRESULT CALLBACK PluginWndProc(HWND hWnd, UINT Msg, WPARAM WParam, LPARAM lParam);

	public:
		CPluginWindow(BOOL bAutoStart, BOOL bLoop, uint16 mode, NPP instance);
		~CPluginWindow();

		void		SetWindow(HWND hWnd);
		void		Print(NPPrint* printInfo) const;

		CAvi&		GetAviStream() const		{return *_pAvi;}
#ifdef STRICT
		WNDPROC		GetWndProc() const			{return _pfnDefault;}
#else
		FARPROC		GetWndProc() const			{return (FARPROC)_pfnDefault;}
#endif
		operator	HWND() const				{return _hPluginWnd;}

		//\\// windows messages overloading
		void		OnLButtonDown(UINT uFlags, LPPOINT pPoint);
		void		OnRButtonDown(UINT uFlags, LPPOINT pPoint);
		void		OnPaint();
		void		OnPaletteChanged(HWND hFocusWnd);

};


#endif
