<SERVER PURPOSE="JSConstructor" CLASS="netscape.peas.FormAccept">
</SERVER>
function npfa_formatDate(format, dateObj) {
    month = dateObj.getMonth() + 1
    day = dateObj.getDate()
    year = dateObj.getYear()
    if (format == "mm/dd/yy")
      return month + "/" + day + "/" + year
    else if (format == "dd/mm/yy")
      return day + "/" + month + "/" + year
    else
      return dateObj.toString()
}


function npfa_stripAnd(str) {
    L = str.length
    if (str.substring(L-3, L) == "AND" )
        return str.substring(0, L-3)
    else
        return str
}

function npfa_getVal(typeStr, valStr) {
    //debug( "npfa_getVal (type, val ) = " + typeStr + ", " + valStr + ")" );
   if (typeStr == "string") {
      return "'" + valStr + "'"
   } else if ( typeStr == "object" ) {
      debug( "type is object (DATE!!), returning: " +  "'" + valStr + "'" );
      return "'" + valStr + "'"
   } else {
      return valStr;
   }
}

// This function sets the keyFields object to contains fieldname/datatype pairs, e.g.
// keyFields.address = "String", keyFields.id = "number". In server 2.0, guess, in 3.0+ get automatically
function npfa_getColTypes(p) {
    o = new Object()

    if (server.httpdlwVersion.indexOf("1.0") != -1) { //--- Server 2.0

        typeCursor = db.cursor("SELECT * FROM " + p.table )
        typeCursor.next()
        for (i in typeCursor) {
            var sType = npfa_typeOf( typeCursor[i] );
            o[i.toUpperCase()] = sType;
        }
        typeCursor.close()

    } else { //--- Server 3.x+

        typeCursor = db.cursor("SELECT * FROM " + p.table )
        typeCursor.next()
        for (i in typeCursor) {
            //debug( "type of " + i + " = " + typeof( typeCursor[i] ) );
            o[i.toUpperCase()] = typeof( typeCursor[i] )
        }
        typeCursor.close()
    }
    return o
}

function npfa_typeOf( val ) {

    if (server.httpdlwVersion.indexOf("1.0") != -1) { //----- Server 2.0

	    if ( val == null )  return ("number");
	    if ( val.charAt != null )  return ("string");
	    var valStr = "" + val
	    var intValue = parseInt( valStr )
	    var floatValue = parseFloat( valStr )
	    if ( isNaN(intValue) && isNaN(floatValue) )
	        return("object")
	    else
	        return("number")
	}

	else { //----- Server 3.x
	    return( typeof( val ) )
	}
}

function npfa_toString( value, sDateFormat ) {
    if ( npfa_typeOf( value ) == "object" ) {
        if ( value == null  ) {
            return "";
        } else {
            //its a date
            return npfa_formatDate( sDateFormat, value )
        }
    } else {
        return value.toString();
    }
}

function npfa_displayQuery( c, sDateFormat ) {
	write("<TABLE BORDER>")
	write("<TR>")
	for (col in c)
		write( "<TH>" + col.toUpperCase() + "</TH>" )
	write("</TR>")
	while (c.next()) {
		write("<TR>")
		for (col in c)
			write("<TD>" + npfa_toString( c[col], sDateFormat ) + "</TD>")
			//write("<TD>" +  c[col] + "</TD>")
		write("</TR>")
	}
	write("</TABLE>")
} //displayQuery


// given a cursor, the column name, and new value, assign it
function npfa_assignValue( curs, colName, newVal ) {
    if ( newVal == "" ) {
        if ( curs[colName] != null ) {
            if ( npfa_typeOf( curs[colName] ) == "object" ) {
                curs[colName] = null;
            } else {
                curs[colName] = "";
            }
        }
    } else {
        curs[colName] = newVal;
    }

}


function netscape_peas_FormAccept(params) {
    if ( (params.operation == null) || (params.operation == "") ) {
        return;
    }

    if (server.httpdlwVersion.indexOf("1.0") != -1) { // Server 2.0
        db = database

    } else { // Server 3.x+
        if (params.dbpool == null) {
            debug("Cursor's DBPool property is null - using generic database object.")
            db = database
        } else {
            pool = project[params.dbpool]
            db = pool.connection(pool.id, pool.timeout)
        }
    }

    if  (!db.connected()) {
        displayErrMsgs(db)
    } else {

        if ( params.operation == "SELECT" ) {
            result = 1;
		    curs = db.cursor( request.__SQL );
		    npfa_displayQuery( curs,params.dateFormat )
		    result = 0;

		} else if ( params.operation == "EXECUTE" ) {

    		result = db.execute( request.__SQL );

        } else {

            // other commands (INSERT, UPDATE, DELETE) involve transactions

            // make fields and old fields objects
            fields = new Object()
            oldfields = new Object()
            for (i in request) {
                sTest = i.toUpperCase()
                if ( sTest.substring(0,5) == "_OLD_" ) {
                    colName = sTest.substring(5,i.length)
                    oldfields[colName] = request[i] // oldfields[i] is the value of a column named "_old_i"
                } else if ( sTest.substring(0,1) == "_" ) {
                    colName = sTest.substring(1, i.length)
                    fields[colName] = request[i]  // fields[i] is the value of a column named "_i"
                }
            } //for


            // other commands (INSERT, UPDATE, DELETE) involve transactions
            db.beginTransaction()
            if (params.operation == "INSERT") {
                curs = db.cursor("select * from " + params.table + " where 1=0", true)
                for ( i in curs ) {

                    npfa_assignValue( curs, i, fields[i.toUpperCase()] );
                    //curs[i] = fields[i.toUpperCase()];

                }
                result = curs.insertRow(params.table)

            } else {  // Common procedure for update and delete
                keyFields = npfa_getColTypes(params)
                SQL = "SELECT * FROM " + params.table + " WHERE "

                if (params.operation == "UPDATE") {
                    for (i in oldfields) {
                        if ( (keyFields[i] != "object") && (fields[i] != "") && (fields[i] != null) ) {
                            SQL += " " + i + " = " + npfa_getVal(keyFields[i], oldfields[i]) + " AND"
                        }
                    }
                    curs = db.cursor(npfa_stripAnd(SQL), true)
                    if (curs.next()) {
                        for ( i in curs ) {
                            npfa_assignValue( curs, i, fields[i.toUpperCase()] );
                            //curs[i] = fields[i.toUpperCase()];
                        }
                        result = curs.updateRow(params.table)
                    } else {
                        result = "Could not retrieve record to " + params.operation
                    }
                } else if (params.operation == "DELETE") {
                    for (i in keyFields)
                        if ( (keyFields[i] != "object") && (fields[i] != "") && (fields[i] != null) )
                            SQL += " " + i + " = " + npfa_getVal(keyFields[i], fields[i]) + " AND"
                    curs = db.cursor(npfa_stripAnd(SQL), true)
                    if (curs.next()) {
                        result = curs.deleteRow(params.table)
                    } else
                        result = "Could not retrieve record to " + params.operation

                } //DELETE
            } //Update or Delete

            db.commitTransaction()

        } // (INSERT,DELETE,UPDATE)


        // Close cursor and release connection
        curs.close()
        if ( (server.httpdlwVersion.indexOf("1.0") == -1) ) {
            db.release()
        }


        // failure / success notification
        if ((params.onSuccessServer == null) || (params.onSuccessServer == ""))
            params.onSuccessServer =0
        if ((params.onFailServer == null) || (params.onFailServer == ""))
            params.onFailServer =0

        if (result == 0) {
            eval(params.onSuccessServer)
            write("<SCRIPT>" + params.onSuccessClient + "</SCRIPT>")
        } else {
            eval(params.onFailServer)
            write("<SCRIPT>" + params.onFailClient + "</SCRIPT>")
        }

    } // end of stuff to do if connection successful

} //netscape_peas_FormAccept


