<SERVER PURPOSE="JSConstructor" CLASS="netscape.peas.JSBufferedCursor">
</SERVER>
function writeln(str) {
  write(str + "\n")
}

function lit(original) {
    input = "" + original
    output = '"';
    for(x=0; x<input.length; x++) {
        ch = input.charAt(x);
        if (ch == '"') {
            output += "\\\"";
        } else if (ch == '\\') {
            output += "\\\\";
        } else if (ch == '\r') {
            output += "\\r";
        } else if (ch == '\n') {
            output += "\\n";
        } else if (ch == '\t') {
            output += "\\t";
        } else {
            output += ch
        }
        if (x % 80 == 79)
            output += "\"+\n\""
    }
    output += '"';
    return output;
}

function _typeOf( val ) {

    if (server.httpdlwVersion.indexOf("1.0") != -1) { //----- Server 2.0
	    if ( val == null )  return ("number");
	    if ( val.charAt != null )  return ("string");
	    var valStr = "" + val
	    var intValue = parseInt( valStr )
	    var floatValue = parseFloat( valStr )
	    if ( isNaN(intValue) && isNaN(floatValue) )
	        return("object")
	    else
	        return("number")
	}

	else { //----- ES Server 3.0+
	    return( typeof( val ) )
	}
}

writeln("<SCRIPT SRC=\"cBufferedCursor.js\"></SCRIPT>")


// Generates client-side RowBuffer constructor function

    function createClientSideRowBuffer(c) {
	writeln("<SCRIPT>")
	writeln("   function gotoRowByColValue(colName, colValue) {")
	writeln("      i = 0;")
	writeln("      while ( ("+ c.cursorName +"Rows[i][colName] != colValue) && (i <= this.getNumRowsFetched()) )")
	writeln("         i++;")
	writeln("      this.setCurrentRowNumber(i)")
	writeln("   }")

	colNameList = ""
	for( col in c ) {
	    if ( colNameList != "" ) colNameList += ","
	    colNameList += ('"' + col + '"')
	}
	colNameList = colNameList.toUpperCase();  //!!DBCASE!!
	writeln( c.cursorName + "RowBuffer = new RowBuffer(" + c.columns() + "," + colNameList + ")" )
	writeln('</SCRIPT>')
    } // createClientSideRowBuffer


// Generates client-side Column Property array
    function createClientSideColumnProperty(c) {
        writeln('function ColProp() {')
        writeln('    this._dataType = arguments[0]')
        writeln('    this._updateKey = arguments[1]')
        writeln('}')
        write(c.cursorName + 'ColProps = new Array(')
        firstCol = true
        for( col in c) {
            if ( !firstCol ) write( ',' )
            write( '"' + col.toUpperCase() +'"' )
            firstCol = false
        }
        writeln( ')' )

	for (col in c) {
            writeln(c.cursorName + 'ColProps["' + col.toUpperCase() + '"] = new ColProp("' + _typeOf(c[col]) + '", true)')
	}
    }


// Generates client-side Row constructor function, instantiates Row objects on client
// and calls client-side constructor (csjsCursor)
// Client-side Cursor Constructor Function

    function createClientSideJSCursor(c,sql,DBPool) {
        writeln("<SCRIPT>")

        writeln('function RowInfo() {')
        writeln('    this.isDbRow = false')
	  writeln('    this.oldRowValue = null')
        writeln('}')

        writeln(c.cursorName + 'RowInfo = new Array(' + c.maxRows + ')')
        writeln('for (row=0; row <' + c.maxRows + '; row++ ) {')
        writeln('    ' + c.cursorName + 'RowInfo[row] = new RowInfo()')
        writeln('}')

        writeln('function Row() {')
        for (i = 0; i < c.columns(); i++)
            //writeln('   this.' + c.columnName(i) + ' = arguments[' + i +']') //!!DBCASE!!
            writeln('   this.' + c.columnName(i).toUpperCase() + ' = arguments[' + i +']')
        writeln('}')

        writeln(c.cursorName + 'Rows = new Array(' + c.maxRows + ')')
        row = 0
        numRows = 0
        while (row < c.maxRows && c.next() ) {
            if ( numRows == 0 ) createClientSideColumnProperty(cursorObj)
            numRows++
            write(c.cursorName + 'Rows[' + row + '] = new Row(\n')
            for( i = 0; i < c.columns(); i++) {
                if ( c[i] == null ) {
                    if ((server.httpdlwVersion.indexOf("1.0") != -1) && _typeOf(c[i])=="number")
                        write( lit(c[i]) )
                    else
                        write('null')
                }
                else if ( _typeOf(c[i]) == "object" ) {
                    if ( c[i].toLocaleString != null )
                        write( lit(c[i].toLocaleString().substring(0,8)) ) // DATE type
                    else
                        write( lit(c[i].toString()) )
                }
                else {
                    write( lit(c[i]) )
                }

                if ( i < (c.columns()-1) )
                    writeln(",")
                else
                    writeln(")")
            }
            writeln(c.cursorName + 'RowInfo[' + row + '].isDbRow = true')
            row++
        } //while

        writeln("function getNumColumns() {")
        writeln("   return " + c.columns() + "}")

	writeln("function setValueByName(colName, colVal) {")
	writeln("    if (this.__oRowBuffer != null) {")
	writeln("        this.__oRowBuffer.setValueByName(colName, colVal)")
	writeln("    } else {")
	writeln("        this[colName] = colVal")
	writeln("    }")
	writeln("    saveOldRowValue( this )")
	writeln("}")

    writeln("function getValueByName(colName) {")
    writeln("   return this.__currentRow[colName]")
    writeln("}")

    writeln("function getValueByNumber(colNum) {")
    for (i = 0; i < c.columns(); i++) {
       writeln("if (colNum == " + i + ")")
       writeln("   return this.__currentRow[" + lit(c.columnName(i)) + "]")
    }//for
    writeln("else return null }\n")

    writeln("function getNumRowsFetched() {")
    writeln("    return this.__numRows")
    writeln("}")

    writeln("function getCurrentRowNumber() {")
    writeln("   return this.__currentRowNumber")
    writeln("}")

    writeln("function getColumnName(colNum) {")
    for (i = 0; i < c.columns(); i++) {
        writeln("if (colNum == " + i + ")")
        writeln("   return " + lit(c.columnName(i).toUpperCase()))
        }
    writeln("}")

	for ( col in c) {
        firstChar = col.substring(0,1).toUpperCase()
        setterName = "set" + firstChar + col.substring(1,col.length).toUpperCase()
	    writeln("function " + setterName + "(val) {")
	    writeln("    this.__oRowBuffer.setValueByName('" + col.toUpperCase() + "', val)")
	    writeln("    saveOldRowValue( this )")
	    writeln("}")
	}






    writeln("function csjsCursor() {")
    writeln("   this.__name = " + lit(c.cursorName))
    writeln("   this.__numRows = " + numRows) // numRows may be less than maxRows
//  writeln("   this.__oRowSupport = " + c.cursorName + "RowSupport")
    writeln("   this.__oRowBuffer = " + c.cursorName + "RowBuffer")
    writeln("   this.__oRowInfo = " + c.cursorName + "RowInfo")
//  writeln("   this.__SQL = '" + sql + "'") fails if qry has 's
    writeln("   this.__SQL = " + lit( sql ))
    if ( null == DBPool ) {
        writeln("   this.__DBPool = \"\"" );
    } else {
        writeln("   this.__DBPool = \"" + DBPool + "\"" );
    }
    writeln("   this.__currentRowNumber = -1")
    writeln("   this.__currentRow = new Object()")
    writeln("   this.fireChangeEvent = fireChangeEvent")
    writeln("   this.executeQuery = executeQuery")
    writeln("   this.nextRow = next")
    writeln("   this.previousRow = previous ")
    writeln("   this.updateCurrentRow = updateCurrentRow ")
    writeln("   this.deleteRow = deleteRow ")
    writeln("   this.addRow = addRow ")
    writeln("   this.getCurrentRowNumber = getCurrentRowNumber")
    writeln("   this.setCurrentRowNumber = setCurrentRowNumber")
    writeln("   this.setValueByName = setValueByName")
    writeln("   this.getValueByName = getValueByName")
    writeln("   this.getValueByNumber = getValueByNumber")
    writeln("   this.getNumRowsFetched = getNumRowsFetched")
    writeln("   this.getNumColumns = getNumColumns")
    writeln("   this.getColumnName = getColumnName")
    writeln("   this._updateRow = _updateRow ")
    writeln("   this._insertRow = _insertRow ")
    writeln("   this._performRequest = _performRequest" )
    writeln("   this._enableSqlResultWindow = true")
    writeln("   this.gotoRowByColValue = gotoRowByColValue")

//  Dynamic Column Property Setters
    for ( col in c ) {
        firstChar = col.substring(0,1).toUpperCase()
        setterName = "set" + firstChar + col.substring(1,col.length).toUpperCase()
        writeln("    this." + setterName + " = " + setterName)
    }

    // wire in our onload
    writeln( "this.saveOnLoad = window.onload;" );
    writeln( "window.onload = netscape_peas_JSBC_onLoad;" );


    writeln("}//csjsCursor\n")

    writeln( "function netscape_peas_JSBC_onLoad() {" );

    writeln(    "if ( " + c.cursorName + ".getNumRowsFetched() > 0 ) {" );
    writeln(       c.cursorName + ".nextRow();" );
    writeln(    "} else {" );
    writeln(       c.cursorName + ".addRow();" );
    writeln(    "}" );
    writeln(    "if ( null != " + c.cursorName + ".saveOnLoad ) {" );
    writeln(       c.cursorName + ".saveOnLoad()" );
    writeln(    "}" );
    writeln( "}" );

    writeln(c.cursorName + " = new csjsCursor()")

    // register our onload event



    writeln('</SCRIPT>')
} // createClientSideJSCursor



// Server-side Cursor Constructor Function
function netscape_peas_JSBufferedCursor(params) {
   if (  ! netscape_peas_isSet( params.updatable ) ) {
	   params.updatable = false
   }

   netscape_peas_processFilterColumns( params );


   if (netscape_peas_isSet(params.sortCol) ) {
      sOrdering =  params.sortCol;
      if ( "Descending" == params.sortAscending )
         sOrdering += " DESC";
      params.SQL = netscape_peas_addOrdering( params.SQL, sOrdering );
   }

    if (server.httpdlwVersion.indexOf("1.0") != -1) {  //--- Server 2.0 ---
         cursorObj = database.cursor(params.SQL, params.updatable)

	} else { //---Server 3.0---
         if (params.dbpool == null) {
            debug("Cursor's DBPool property is null - using generic database object.")
            //cursorObj = database.cursor(params.SQL, params.updatable)
            cursorObj = database.cursor(params.SQL, false)
         } else {
             pool = project[params.dbpool]
             this.connection = pool.connection(pool.id, pool.timeout)
             cursorObj = this.connection.cursor(params.SQL, false)
         }
	}
	// Prop assignments common to both server versions
    cursorObj.cursorName = params.id
    cursorObj.maxRows = params.maxRows
    createClientSideRowBuffer(cursorObj)
    createClientSideJSCursor(cursorObj, params.SQL, params.dbpool )
	cursorObj.close()
    if ( (server.httpdlwVersion.indexOf("1.0") == -1) ) {
		this.connection.release()
	}
      return cursorObj
} // netscape_peas_JSBufferedCursor
