#define STRICT
#include <windows.h>
#include <memory.h>

extern HINSTANCE hInst;

static char * FindHelp()
{
	static char helpname[256];

	if (helpname[0] == 0) {
		int len = GetModuleFileName(hInst,helpname,256);
		if (!memicmp(&helpname[len-4],".EXE",4)) {
			helpname[len-4] = 0;
			strcat(helpname,".hlp");
		}
	}
	return helpname;
}
void HelpIndex(HWND hWnd)
{
	
	WinHelp(hWnd,FindHelp(),HELP_INDEX,0L);
}
void HelpWind(HWND hWnd, int index)
{
	WinHelp(hWnd,"WINHELP.HLP",index,0L);
}
void Help(HWND hWnd, int index)
{
	WinHelp(hWnd,FindHelp(),HELP_CONTEXT,index);
}