//
// MODTOOL
//
// Copyright (c) !998 David Lindauer (LADSOFT)
//
// see license.txt for licensing info
//
//
// profile handling
//
// this exports all the routines required to handle the profile file
//
#define STRICT
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>

#include "password.h"

// ==============================================================

// all the variables we are exporting

char groupid[256];
char pop3server[256];
char smtpserver[256];
int usesmtp,usenntp,pop3dele,archivefromserver,sortmail,partialapprove;
int datedarchive,topostedfolder,configured;
char nntppostserver[256];
char nntparchiveserver[256];
char nntpalternateserver[256];
char pop3password[256];
char mailfolder[256];
char archivefolder[256];
char alternatefolder[256];
char archivedirectory[256];
char pop3username[256];
char smtpsourcehost[256];
char smtpsourcepath[256];
char approvalmailbox[256];
char rejectfolder[256];
char outbox[256];
char inbox[256];
char whitelist[256];
char greylist[256];
char brownlist[256];
char blacklist[256];
char modlist[256];
char approvalfolder[256];
char rejectmessagedir[256];
char rejectarchivefolder[256];
char postedfolder[256];

// ==============================================================
// ini file name
static char *profile = "modtool.ini";

// ==============================================================
//
// a bunch of boring stuff relating to profiles
// exported stuff comes after all this
static char *pop3key = "POP3Server";
static void Readpop3Profile(void)
{
	GetPrivateProfileString(groupid,pop3key,"",pop3server,256,profile);
}
static void Writepop3Profile(void)
{
	WritePrivateProfileString(groupid,pop3key,pop3server,profile);
}
static char *pop3userkey = "POP3UserName";
static void Readpop3usernameProfile(void)
{
	GetPrivateProfileString(groupid,pop3userkey,"",pop3username,256,profile);
}
static void Writepop3usernameProfile(void)
{
	WritePrivateProfileString(groupid,pop3userkey,pop3username,profile);
}
static char *pop3passkey = "POP3ID";
static void Readpop3PasswordProfile(void)
{
	char temp[256];
	GetPrivateProfileString(groupid,pop3passkey,"",temp,256,profile);
	decrypt(pop3password,temp);
}
static void Writepop3PasswordProfile(void)
{
	char temp[256];
	encrypt(temp,pop3password);
	WritePrivateProfileString(groupid,pop3passkey,temp,profile);
}

static char *smtpkey = "SMTPServer";
static void ReadsmtpProfile(void)
{
	GetPrivateProfileString(groupid,smtpkey,"",smtpserver,256,profile);
}
static void WritesmtpProfile(void)
{
	WritePrivateProfileString(groupid,smtpkey,smtpserver,profile);
}
static char *smtpsourcehostkey = "SMTPSourceHost";
static void ReadsmtpsourcehostProfile(void)
{
	GetPrivateProfileString(groupid,smtpsourcehostkey,"Group Moderator",smtpsourcehost,256,profile);
}
static void WritesmtpsourcehostProfile(void)
{
	WritePrivateProfileString(groupid,smtpsourcehostkey,smtpsourcehost,profile);
}
static char *smtpsourcepathkey = "SMTPSourcePath";
static void ReadsmtpsourcepathProfile(void)
{
	GetPrivateProfileString(groupid,smtpsourcepathkey,"",smtpsourcepath,256,profile);
}
static void WritesmtpsourcepathProfile(void)
{
	WritePrivateProfileString(groupid,smtpsourcepathkey,smtpsourcepath,profile);
}
static char *smtpusekey = "SMTPuseServer";
static void ReadsmtpuseProfile(void)
{
	char string[100];
	GetPrivateProfileString(groupid,smtpusekey,"Yes",string,256,profile);
	usesmtp = (string[0] == 'Y' || string[0] == 'y');
		
}
static void WritesmtpuseProfile(void)
{
	char *string;
	if (usesmtp)
		string = "Yes";
	else
		string = "No";
	WritePrivateProfileString(groupid,smtpusekey,string,profile);
}
static char *pop3delekey = "POP3DeleteAll";
static void Readpop3deleProfile(void)
{
	char string[100];
	GetPrivateProfileString(groupid,pop3delekey,"Yes",string,256,profile);
	pop3dele = (string[0] == 'Y' || string[0] == 'y');
		
}
static void Writepop3deleProfile(void)
{
	char *string;
	if (pop3dele)
		string = "Yes";
	else
		string = "No";
	WritePrivateProfileString(groupid,pop3delekey,string,profile);
}
static char *topostedfolderkey = "ToPostedFolder";
static void ReadtopostedfolderProfile(void)
{
	char string[100];
	GetPrivateProfileString(groupid,topostedfolderkey,"No",string,256,profile);
	topostedfolder = (string[0] == 'Y' || string[0] == 'y');
		
}
static void WritetopostedfolderProfile(void)
{
	char *string;
	if (topostedfolder)
		string = "Yes";
	else
		string = "No";
	WritePrivateProfileString(groupid,topostedfolderkey,string,profile);
}
static char *archivefromserverkey = "ArchiveFromServer";
static void ReadarchivefromserverProfile(void)
{
	char string[100];
	GetPrivateProfileString(groupid,archivefromserverkey,"No",string,256,profile);
	archivefromserver = (string[0] == 'Y' || string[0] == 'y');
		
}
static void WritearchivefromserverProfile(void)
{
	char *string;
	if (archivefromserver)
		string = "Yes";
	else
		string = "No";
	WritePrivateProfileString(groupid,archivefromserverkey,string,profile);
}
static char *sortmailkey = "SortMail";
static void ReadsortmailProfile(void)
{
	char string[100];
	GetPrivateProfileString(groupid,sortmailkey,"Yes",string,256,profile);
	sortmail = (string[0] == 'Y' || string[0] == 'y');
		
}
static void WritesortmailProfile(void)
{
	char *string;
	if (sortmail)
		string = "Yes";
	else
		string = "No";
	WritePrivateProfileString(groupid,sortmailkey,string,profile);
}
static char *nntppostkey = "NNTPPostServer";
static void ReadnntppostProfile(void)
{
	GetPrivateProfileString(groupid,nntppostkey,"",nntppostserver,256,profile);
}
static void WritenntppostProfile(void)
{
	WritePrivateProfileString(groupid,nntppostkey,nntppostserver,profile);
}
static char *nntpusekey = "NNTPuseServer";
static void ReadnntpuseProfile(void)
{
	char string[100];
	GetPrivateProfileString(groupid,nntpusekey,"Yes",string,256,profile);
	usenntp = (string[0] == 'Y' || string[0] == 'y');
		
}
static void WritenntpuseProfile(void)
{
	char *string;
	if (usenntp)
		string = "Yes";
	else
		string = "No";
	WritePrivateProfileString(groupid,nntpusekey,string,profile);
}
static char *datedarchivekey = "UseDatedArchive";
static void ReaddatedarchiveProfile(void)
{
	char string[100];
	GetPrivateProfileString(groupid,datedarchivekey,"No",string,256,profile);
	datedarchive == (string[0] == 'Y' || string[0] == 'y');
		
}
static void WritedatedarchiveProfile(void)
{
	char *string;
	if (datedarchive)
		string = "Yes";
	else
		string = "No";
	WritePrivateProfileString(groupid,datedarchivekey,string,profile);
}
static char *partialapprovekey = "PartialApproval";
static void ReadpartialapproveProfile(void)
{
	char string[100];
	GetPrivateProfileString(groupid,partialapprovekey,"Yes",string,256,profile);
	partialapprove = (string[0] == 'Y' || string[0] == 'y');
		
}
static void WritepartialapproveProfile(void)
{
	char *string;
	if (partialapprove)
		string = "Yes";
	else
		string = "No";
	WritePrivateProfileString(groupid,partialapprovekey,string,profile);
}
static char *configuredkey = "Configured";
static void ReadconfiguredProfile(void)
{
	char string[100];
	GetPrivateProfileString(groupid,configuredkey,"No",string,256,profile);
	configured = (string[0] == 'Y' || string[0] == 'y');
		
}
static void WriteconfiguredProfile(void)
{
	char *string;
	if (configured)
		string = "Yes";
	else
		string = "No";
	WritePrivateProfileString(groupid,configuredkey,string,profile);
}
static char *nntparchivekey = "NNTPArchiveServer";
static void ReadnntparchiveProfile(void)
{
	GetPrivateProfileString(groupid,nntparchivekey,"",nntparchiveserver,256,profile);
}
static void WritenntparchiveProfile(void)
{
	WritePrivateProfileString(groupid,nntparchivekey,nntparchiveserver,profile);
}
static char *nntpalternatekey = "NNTPAlternateServer";
static void ReadnntpalternateProfile(void)
{
	GetPrivateProfileString(groupid,nntpalternatekey,"",nntpalternateserver,256,profile);
}
static void WritenntpalternateProfile(void)
{
	WritePrivateProfileString(groupid,nntpalternatekey,nntpalternateserver,profile);
}
static char *mailfolderkey = "MailFolder";
static void ReadmailfolderProfile(void)
{
	GetPrivateProfileString(groupid,mailfolderkey,"approved",mailfolder,256,profile);
}
static void WritemailfolderProfile(void)
{
	WritePrivateProfileString(groupid,mailfolderkey,mailfolder,profile);
}
static char *archivefolderkey = "ArchiveFolder";
static void ReadarchivefolderProfile(void)
{
	GetPrivateProfileString(groupid,archivefolderkey,"archive.nar",archivefolder,256,profile);
}
static void WritearchivefolderProfile(void)
{
	WritePrivateProfileString(groupid,archivefolderkey,archivefolder,profile);
}
static char *archivedirectorykey = "ArchiveDirectory";
static void ReadarchivedirectoryProfile(void)
{
	GetPrivateProfileString(groupid,archivedirectorykey,"",archivedirectory,256,profile);
}
static void WritearchivedirectoryProfile(void)
{
	WritePrivateProfileString(groupid,archivedirectorykey,archivedirectory,profile);
}
static char *rejectfolderkey = "RejectFolder";
static void ReadrejectfolderProfile(void)
{
	GetPrivateProfileString(groupid,rejectfolderkey,"reject",rejectfolder,256,profile);
}
static void WriterejectfolderProfile(void)
{
	WritePrivateProfileString(groupid,rejectfolderkey,rejectfolder,profile);
}
static char *alternatefolderkey = "AlternateFolder";
static void ReadalternatefolderProfile(void)
{
	GetPrivateProfileString(groupid,alternatefolderkey,"alt.nar",alternatefolder,256,profile);
}
static void WritealternatefolderProfile(void)
{
	WritePrivateProfileString(groupid,alternatefolderkey,alternatefolder,profile);
}
static char *approvalmailboxkey = "ApprovalMailbox";
static void ReadapprovalmailboxProfile(void)
{
	GetPrivateProfileString(groupid,approvalmailboxkey,"",approvalmailbox,256,profile);
}
static void WriteapprovalmailboxProfile(void)
{
	WritePrivateProfileString(groupid,approvalmailboxkey,approvalmailbox,profile);
}
static char *inboxkey = "NonGroupInbox";
static void ReadinboxProfile(void)
{
	GetPrivateProfileString(groupid,inboxkey,"inbox",inbox,256,profile);
}
static void WriteinboxProfile(void)
{
	WritePrivateProfileString(groupid,inboxkey,inbox,profile);
}
static char *outboxkey = "Outbox";
static void ReadoutboxProfile(void)
{
	GetPrivateProfileString(groupid,outboxkey,"outbox",outbox,256,profile);
}
static void WriteoutboxProfile(void)
{
	WritePrivateProfileString(groupid,outboxkey,outbox,profile);
}
static char *whitelistkey = "WhiteList";
static void ReadwhitelistProfile(void)
{
	GetPrivateProfileString(groupid,whitelistkey,"white.nam",whitelist,256,profile);
}
static void WritewhitelistProfile(void)
{
	WritePrivateProfileString(groupid,whitelistkey,whitelist,profile);
}
static char *greylistkey = "GreyList";
static void ReadgreylistProfile(void)
{
	GetPrivateProfileString(groupid,greylistkey,"grey.nam",greylist,256,profile);
}
static void WritegreylistProfile(void)
{
	WritePrivateProfileString(groupid,greylistkey,greylist,profile);
}
static char *brownlistkey = "BrownList";
static void ReadbrownlistProfile(void)
{
	GetPrivateProfileString(groupid,brownlistkey,"brown.nam",brownlist,256,profile);
}
static void WritebrownlistProfile(void)
{
	WritePrivateProfileString(groupid,brownlistkey,brownlist,profile);
}
static char *blacklistkey = "BlackList";
static void ReadblacklistProfile(void)
{
	GetPrivateProfileString(groupid,blacklistkey,"black.nam",blacklist,256,profile);
}
static void WriteblacklistProfile(void)
{
	WritePrivateProfileString(groupid,blacklistkey,blacklist,profile);
}
static char *modlistkey = "ModList";
static void ReadmodlistProfile(void)
{
	GetPrivateProfileString(groupid,modlistkey,"modlist.grp",modlist,256,profile);
}
static void WritemodlistProfile(void)
{
	WritePrivateProfileString(groupid,modlistkey,modlist,profile);
}
static char *approvalfolderkey = "ApprovalFolder";
static void ReadapprovalfolderProfile(void)
{
	GetPrivateProfileString(groupid,approvalfolderkey,"approved",approvalfolder,256,profile);
}
static void WriteapprovalfolderProfile(void)
{
	WritePrivateProfileString(groupid,approvalfolderkey,approvalfolder,profile);
}
static char *rejectmessagedirkey = "RejectMessageDir";
static void ReadrejectmessagedirProfile(void)
{
	GetPrivateProfileString(groupid,rejectmessagedirkey,"",rejectmessagedir,256,profile);
}
static void WriterejectmessagedirProfile(void)
{
	WritePrivateProfileString(groupid,rejectmessagedirkey,rejectmessagedir,profile);
}
static char *rejectarchivefolderkey = "RejectArchiveFolder";
static void ReadrejectarchivefolderProfile(void)
{
	GetPrivateProfileString(groupid,rejectarchivefolderkey,"reject.nar",rejectarchivefolder,256,profile);
}
static void WriterejectarchivefolderProfile(void)
{
	WritePrivateProfileString(groupid,rejectarchivefolderkey,rejectarchivefolder,profile);
}
static char *postedfolderkey = "PostedFolder";
static void ReadpostedfolderProfile(void)
{
	GetPrivateProfileString(groupid,postedfolderkey,"posted",postedfolder,256,profile);
}
static void WritepostedfolderProfile(void)
{
	WritePrivateProfileString(groupid,postedfolderkey,postedfolder,profile);
}
// ==============================================================
//
// export for the 'last' field of archiving
//
static char *archivecountkey = "ArchiveLast";
long ReadArchiveCountProfile(void)
{
	char string[40];
	GetPrivateProfileString(groupid,archivecountkey,"0",string,40,profile);
	return atol(string);
}
void WriteArchiveCountProfile(long count)
{
	char string[40];
	sprintf(string,"%d",count);
	WritePrivateProfileString(groupid,archivecountkey,string,profile);
}
// ==============================================================
//
// export for default group key
//
static char *defaultkey = "Defaults";
static char *groupkey = "Group";
void WriteDefaultGroup(void);
void ReadDefaultGroup(void)
{
	GetPrivateProfileString(defaultkey,groupkey,"",groupid,256,profile);
	if (groupid[0] == '\0') {
		strcpy(groupid,"misc.test");
		WriteDefaultGroup();
	}
}
void WriteDefaultGroup(void)
{
	WritePrivateProfileString(defaultkey,groupkey,groupid,profile);
}
// ==============================================================
//
// folders export, also analyzer export
//
void GetFolders()
{
	ReadmailfolderProfile();
	ReadarchivefolderProfile();
	ReadarchivedirectoryProfile();
	ReadalternatefolderProfile();
	ReadrejectfolderProfile();
	ReadarchivefromserverProfile();
	ReadinboxProfile();
	ReadoutboxProfile();
	ReadsortmailProfile();
	ReadapprovalfolderProfile();
	ReadpartialapproveProfile();
	ReadrejectmessagedirProfile();
	ReadrejectarchivefolderProfile();
	ReadpostedfolderProfile();
	ReadconfiguredProfile();
	ReadtopostedfolderProfile();
}
void SetFolders()
{
	WritemailfolderProfile();
	WritearchivefolderProfile();
	WritearchivedirectoryProfile();
	WritealternatefolderProfile();
	WriterejectfolderProfile();
	WritearchivefromserverProfile();
	WriteinboxProfile();
	WriteoutboxProfile();
	WritesortmailProfile();
	WriteapprovalfolderProfile();
	WritepartialapproveProfile();
	WriterejectmessagedirProfile();
	WriterejectarchivefolderProfile();
	WritepostedfolderProfile();
	WriteconfiguredProfile();
	WritetopostedfolderProfile();
}
// ==============================================================
//
// servers exports
// also exports passwords
//
void GetNetworkServers(void)
{
	Readpop3Profile();
	Readpop3PasswordProfile();
	Readpop3deleProfile();
	ReadsmtpProfile();
	ReadsmtpuseProfile();
	ReadnntppostProfile();
	ReadnntparchiveProfile();
	ReadnntpalternateProfile();
	ReadnntpuseProfile();
	Readpop3usernameProfile();
}
void SetNetworkServers(void)
{
	Writepop3Profile();
	Writepop3PasswordProfile();
	Writepop3deleProfile();
	WritesmtpProfile();
	WritesmtpuseProfile();
	WritenntppostProfile();
	WritenntparchiveProfile();
	WritenntpalternateProfile();
	WritenntpuseProfile();
	Writepop3usernameProfile();
}
// ==============================================================
//
// group properties export
//
void GetGroupProperties(void)
{
	ReadsmtpsourcehostProfile();
	ReadsmtpsourcepathProfile();
	ReadapprovalmailboxProfile();
	ReadmodlistProfile();
}
void SetGroupProperties(void)
{
	WritesmtpsourcehostProfile();
	WritesmtpsourcepathProfile();
	WriteapprovalmailboxProfile();
	WritemodlistProfile();
}
// ==============================================================
//
// lists export
//
void GetListProperties(void)
{
	ReadwhitelistProfile();
	ReadgreylistProfile();
	ReadbrownlistProfile();
	ReadblacklistProfile();
}
void SetListProperties(void)
{
	WritewhitelistProfile();
	WritegreylistProfile();
	WritebrownlistProfile();
	WriteblacklistProfile();
}