/* $NetBSD: qcomgpioreg.h,v 1.3 2024/12/17 22:05:11 riastradh Exp $ */
/*
 * Copyright (c) 2022 Mark Kettenis <kettenis@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef QCOMGPIOREG_H
#define QCOMGPIOREG_H

#include <sys/cdefs.h>

#define _TLMM_GPIO_PIN_OFFSET(pin, reg)	((pin) * 0x1000 + (reg))

#define TLMM_GPIO_CTL(pin)		_TLMM_GPIO_PIN_OFFSET(pin, 0x0)
#define  TLMM_GPIO_CTL_OE			__BIT(9)
#define  TLMM_GPIO_CTL_MUX			__BITS(5,2)
#define   TLMM_GPIO_CTL_MUX_GPIO			0

#define TLMM_GPIO_IN_OUT(pin)		_TLMM_GPIO_PIN_OFFSET(pin, 0x4)
#define  TLMM_GPIO_IN_OUT_GPIO_IN		__BIT(0)
#define  TLMM_GPIO_IN_OUT_GPIO_OUT		__BIT(1)

#define TLMM_GPIO_INTR_CFG(pin)		_TLMM_GPIO_PIN_OFFSET(pin, 0x8)
#define  TLMM_GPIO_INTR_CFG_TARGET_PROC_MASK	__BITS(7,5)
#define   TLMM_GPIO_INTR_CFG_TARGET_PROC_RPM		3
#define  TLMM_GPIO_INTR_CFG_INTR_RAW_STATUS_EN	__BIT(4)
#define  TLMM_GPIO_INTR_CFG_INTR_DECT_CTL_MASK	__BITS(3,2)
#define   TLMM_GPIO_INTR_CFG_INTR_DECT_CTL_LEVEL	0
#define   TLMM_GPIO_INTR_CFG_INTR_DECT_CTL_EDGE_POS	1
#define   TLMM_GPIO_INTR_CFG_INTR_DECT_CTL_EDGE_NEG	2
#define   TLMM_GPIO_INTR_CFG_INTR_DECT_CTL_EDGE_BOTH	3
#define  TLMM_GPIO_INTR_CFG_INTR_POL_CTL	__BIT(1)
#define  TLMM_GPIO_INTR_CFG_INTR_ENABLE		__BIT(0)

#define TLMM_GPIO_INTR_STATUS(pin)	_TLMM_GPIO_PIN_OFFSET(pin, 0xc)
#define  TLMM_GPIO_INTR_STATUS_INTR_STATUS	__BIT(0)

#endif /* !QCOMGPIOREG_H */
