/* $NetBSD: syscalls.c,v 1.334 2024/10/09 16:29:11 christos Exp $ */

/*
 * System call names.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.316 2024/10/09 16:27:28 christos Exp
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: syscalls.c,v 1.334 2024/10/09 16:29:11 christos Exp $");

#if defined(_KERNEL_OPT)
#ifdef _KERNEL_OPT
#include "opt_modular.h"
#include "opt_ntp.h"
#include "opt_sysv.h"
#endif
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <sys/mount.h>
#include <sys/sched.h>
#include <sys/idtype.h>
#include <sys/syscallargs.h>
#include <sys/acl.h>
#else /* _KERNEL_OPT */
#include <sys/null.h>
#endif /* _KERNEL_OPT */

const char *const syscallnames[] = {
	/*   0 */	"syscall",
	/*   1 */	"exit",
	/*   2 */	"fork",
	/*   3 */	"read",
	/*   4 */	"write",
	/*   5 */	"open",
	/*   6 */	"close",
	/*   7 */	"compat_50_wait4",
	/*   8 */	"compat_43_ocreat",
	/*   9 */	"link",
	/*  10 */	"unlink",
	/*  11 */	"#11 (obsolete execv)",
	/*  12 */	"chdir",
	/*  13 */	"fchdir",
	/*  14 */	"compat_50_mknod",
	/*  15 */	"chmod",
	/*  16 */	"chown",
	/*  17 */	"break",
	/*  18 */	"compat_20_getfsstat",
	/*  19 */	"compat_43_olseek",
	/*  20 */	"getpid",
	/*  21 */	"compat_40_mount",
	/*  22 */	"unmount",
	/*  23 */	"setuid",
	/*  24 */	"getuid",
	/*  25 */	"geteuid",
	/*  26 */	"ptrace",
	/*  27 */	"recvmsg",
	/*  28 */	"sendmsg",
	/*  29 */	"recvfrom",
	/*  30 */	"accept",
	/*  31 */	"getpeername",
	/*  32 */	"getsockname",
	/*  33 */	"access",
	/*  34 */	"chflags",
	/*  35 */	"fchflags",
	/*  36 */	"sync",
	/*  37 */	"kill",
	/*  38 */	"compat_43_stat43",
	/*  39 */	"getppid",
	/*  40 */	"compat_43_lstat43",
	/*  41 */	"dup",
	/*  42 */	"pipe",
	/*  43 */	"getegid",
	/*  44 */	"profil",
	/*  45 */	"ktrace",
	/*  46 */	"compat_13_sigaction13",
	/*  47 */	"getgid",
	/*  48 */	"compat_13_sigprocmask13",
	/*  49 */	"__getlogin",
	/*  50 */	"__setlogin",
	/*  51 */	"acct",
	/*  52 */	"compat_13_sigpending13",
	/*  53 */	"compat_13_sigaltstack13",
	/*  54 */	"ioctl",
	/*  55 */	"compat_12_oreboot",
	/*  56 */	"revoke",
	/*  57 */	"symlink",
	/*  58 */	"readlink",
	/*  59 */	"execve",
	/*  60 */	"umask",
	/*  61 */	"chroot",
	/*  62 */	"compat_43_fstat43",
	/*  63 */	"compat_43_ogetkerninfo",
	/*  64 */	"compat_43_ogetpagesize",
	/*  65 */	"compat_12_msync",
	/*  66 */	"vfork",
	/*  67 */	"#67 (obsolete vread)",
	/*  68 */	"#68 (obsolete vwrite)",
	/*  69 */	"#69 (obsolete sbrk)",
	/*  70 */	"#70 (obsolete sstk)",
	/*  71 */	"compat_43_ommap",
	/*  72 */	"vadvise",
	/*  73 */	"munmap",
	/*  74 */	"mprotect",
	/*  75 */	"madvise",
	/*  76 */	"#76 (obsolete vhangup)",
	/*  77 */	"#77 (obsolete vlimit)",
	/*  78 */	"mincore",
	/*  79 */	"getgroups",
	/*  80 */	"setgroups",
	/*  81 */	"getpgrp",
	/*  82 */	"setpgid",
	/*  83 */	"compat_50_setitimer",
	/*  84 */	"compat_43_owait",
	/*  85 */	"compat_12_oswapon",
	/*  86 */	"compat_50_getitimer",
	/*  87 */	"compat_43_ogethostname",
	/*  88 */	"compat_43_osethostname",
	/*  89 */	"compat_43_ogetdtablesize",
	/*  90 */	"dup2",
	/*  91 */	"getrandom",
	/*  92 */	"fcntl",
	/*  93 */	"compat_50_select",
	/*  94 */	"#94 (unimplemented setdopt)",
	/*  95 */	"fsync",
	/*  96 */	"setpriority",
	/*  97 */	"compat_30_socket",
	/*  98 */	"connect",
	/*  99 */	"compat_43_oaccept",
	/* 100 */	"getpriority",
	/* 101 */	"compat_43_osend",
	/* 102 */	"compat_43_orecv",
	/* 103 */	"compat_13_sigreturn13",
	/* 104 */	"bind",
	/* 105 */	"setsockopt",
	/* 106 */	"listen",
	/* 107 */	"#107 (obsolete vtimes)",
	/* 108 */	"compat_43_osigvec",
	/* 109 */	"compat_43_osigblock",
	/* 110 */	"compat_43_osigsetmask",
	/* 111 */	"compat_13_sigsuspend13",
	/* 112 */	"compat_43_osigstack",
	/* 113 */	"compat_43_orecvmsg",
	/* 114 */	"compat_43_osendmsg",
	/* 115 */	"#115 (obsolete vtrace)",
	/* 116 */	"compat_50_gettimeofday",
	/* 117 */	"compat_50_getrusage",
	/* 118 */	"getsockopt",
	/* 119 */	"#119 (obsolete resuba)",
	/* 120 */	"readv",
	/* 121 */	"writev",
	/* 122 */	"compat_50_settimeofday",
	/* 123 */	"fchown",
	/* 124 */	"fchmod",
	/* 125 */	"compat_43_orecvfrom",
	/* 126 */	"setreuid",
	/* 127 */	"setregid",
	/* 128 */	"rename",
	/* 129 */	"compat_43_otruncate",
	/* 130 */	"compat_43_oftruncate",
	/* 131 */	"flock",
	/* 132 */	"mkfifo",
	/* 133 */	"sendto",
	/* 134 */	"shutdown",
	/* 135 */	"socketpair",
	/* 136 */	"mkdir",
	/* 137 */	"rmdir",
	/* 138 */	"compat_50_utimes",
	/* 139 */	"#139 (obsolete 4.2 sigreturn)",
	/* 140 */	"compat_50_adjtime",
	/* 141 */	"compat_43_ogetpeername",
	/* 142 */	"compat_43_ogethostid",
	/* 143 */	"compat_43_osethostid",
	/* 144 */	"compat_43_ogetrlimit",
	/* 145 */	"compat_43_osetrlimit",
	/* 146 */	"compat_43_okillpg",
	/* 147 */	"setsid",
	/* 148 */	"compat_50_quotactl",
	/* 149 */	"compat_43_oquota",
	/* 150 */	"compat_43_ogetsockname",
	/* 151 */	"#151 (unimplemented)",
	/* 152 */	"#152 (unimplemented)",
	/* 153 */	"#153 (unimplemented)",
	/* 154 */	"#154 (unimplemented)",
	/* 155 */	"nfssvc",
	/* 156 */	"compat_43_ogetdirentries",
	/* 157 */	"compat_20_statfs",
	/* 158 */	"compat_20_fstatfs",
	/* 159 */	"#159 (unimplemented)",
	/* 160 */	"#160 (unimplemented)",
	/* 161 */	"compat_30_getfh",
	/* 162 */	"compat_09_ogetdomainname",
	/* 163 */	"compat_09_osetdomainname",
	/* 164 */	"compat_09_ouname",
	/* 165 */	"sysarch",
	/* 166 */	"__futex",
	/* 167 */	"__futex_set_robust_list",
	/* 168 */	"__futex_get_robust_list",
#if !defined(_LP64)
	/* 169 */	"compat_10_osemsys",
#else
	/* 169 */	"#169 (excluded 1.0 semsys)",
#endif
#if !defined(_LP64)
	/* 170 */	"compat_10_omsgsys",
#else
	/* 170 */	"#170 (excluded 1.0 msgsys)",
#endif
#if !defined(_LP64)
	/* 171 */	"compat_10_oshmsys",
#else
	/* 171 */	"#171 (excluded 1.0 shmsys)",
#endif
	/* 172 */	"#172 (unimplemented)",
	/* 173 */	"pread",
	/* 174 */	"pwrite",
	/* 175 */	"compat_30_ntp_gettime",
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* 176 */	"ntp_adjtime",
#else
	/* 176 */	"#176 (excluded ntp_adjtime)",
#endif
	/* 177 */	"timerfd_create",
	/* 178 */	"timerfd_settime",
	/* 179 */	"timerfd_gettime",
	/* 180 */	"#180 (unimplemented)",
	/* 181 */	"setgid",
	/* 182 */	"setegid",
	/* 183 */	"seteuid",
	/* 184 */	"lfs_bmapv",
	/* 185 */	"lfs_markv",
	/* 186 */	"lfs_segclean",
	/* 187 */	"compat_50_lfs_segwait",
	/* 188 */	"compat_12_stat12",
	/* 189 */	"compat_12_fstat12",
	/* 190 */	"compat_12_lstat12",
	/* 191 */	"pathconf",
	/* 192 */	"fpathconf",
	/* 193 */	"getsockopt2",
	/* 194 */	"getrlimit",
	/* 195 */	"setrlimit",
	/* 196 */	"compat_12_getdirentries",
	/* 197 */	"mmap",
	/* 198 */	"__syscall",
	/* 199 */	"lseek",
	/* 200 */	"truncate",
	/* 201 */	"ftruncate",
	/* 202 */	"__sysctl",
	/* 203 */	"mlock",
	/* 204 */	"munlock",
	/* 205 */	"undelete",
	/* 206 */	"compat_50_futimes",
	/* 207 */	"getpgid",
	/* 208 */	"reboot",
	/* 209 */	"poll",
	/* 210 */	"afssys",
	/* 211 */	"#211 (unimplemented)",
	/* 212 */	"#212 (unimplemented)",
	/* 213 */	"#213 (unimplemented)",
	/* 214 */	"#214 (unimplemented)",
	/* 215 */	"#215 (unimplemented)",
	/* 216 */	"#216 (unimplemented)",
	/* 217 */	"#217 (unimplemented)",
	/* 218 */	"#218 (unimplemented)",
	/* 219 */	"#219 (unimplemented)",
	/* 220 */	"compat_14___semctl",
	/* 221 */	"semget",
	/* 222 */	"semop",
	/* 223 */	"semconfig",
	/* 224 */	"compat_14_msgctl",
	/* 225 */	"msgget",
	/* 226 */	"msgsnd",
	/* 227 */	"msgrcv",
	/* 228 */	"shmat",
	/* 229 */	"compat_14_shmctl",
	/* 230 */	"shmdt",
	/* 231 */	"shmget",
	/* 232 */	"compat_50_clock_gettime",
	/* 233 */	"compat_50_clock_settime",
	/* 234 */	"compat_50_clock_getres",
	/* 235 */	"timer_create",
	/* 236 */	"timer_delete",
	/* 237 */	"compat_50_timer_settime",
	/* 238 */	"compat_50_timer_gettime",
	/* 239 */	"timer_getoverrun",
	/* 240 */	"compat_50_nanosleep",
	/* 241 */	"fdatasync",
	/* 242 */	"mlockall",
	/* 243 */	"munlockall",
	/* 244 */	"compat_50___sigtimedwait",
	/* 245 */	"sigqueueinfo",
	/* 246 */	"modctl",
	/* 247 */	"_ksem_init",
	/* 248 */	"_ksem_open",
	/* 249 */	"_ksem_unlink",
	/* 250 */	"_ksem_close",
	/* 251 */	"_ksem_post",
	/* 252 */	"_ksem_wait",
	/* 253 */	"_ksem_trywait",
	/* 254 */	"_ksem_getvalue",
	/* 255 */	"_ksem_destroy",
	/* 256 */	"_ksem_timedwait",
	/* 257 */	"mq_open",
	/* 258 */	"mq_close",
	/* 259 */	"mq_unlink",
	/* 260 */	"mq_getattr",
	/* 261 */	"mq_setattr",
	/* 262 */	"mq_notify",
	/* 263 */	"mq_send",
	/* 264 */	"mq_receive",
	/* 265 */	"compat_50_mq_timedsend",
	/* 266 */	"compat_50_mq_timedreceive",
	/* 267 */	"eventfd",
	/* 268 */	"#268 (unimplemented)",
	/* 269 */	"#269 (unimplemented)",
	/* 270 */	"__posix_rename",
	/* 271 */	"swapctl",
	/* 272 */	"compat_30_getdents",
	/* 273 */	"minherit",
	/* 274 */	"lchmod",
	/* 275 */	"lchown",
	/* 276 */	"compat_50_lutimes",
	/* 277 */	"__msync13",
	/* 278 */	"compat_30___stat13",
	/* 279 */	"compat_30___fstat13",
	/* 280 */	"compat_30___lstat13",
	/* 281 */	"__sigaltstack14",
	/* 282 */	"__vfork14",
	/* 283 */	"__posix_chown",
	/* 284 */	"__posix_fchown",
	/* 285 */	"__posix_lchown",
	/* 286 */	"getsid",
	/* 287 */	"__clone",
	/* 288 */	"fktrace",
	/* 289 */	"preadv",
	/* 290 */	"pwritev",
	/* 291 */	"compat_16___sigaction14",
	/* 292 */	"__sigpending14",
	/* 293 */	"__sigprocmask14",
	/* 294 */	"__sigsuspend14",
	/* 295 */	"compat_16___sigreturn14",
	/* 296 */	"__getcwd",
	/* 297 */	"fchroot",
	/* 298 */	"compat_30_fhopen",
	/* 299 */	"compat_30_fhstat",
	/* 300 */	"compat_20_fhstatfs",
	/* 301 */	"compat_50_____semctl13",
	/* 302 */	"compat_50___msgctl13",
	/* 303 */	"compat_50___shmctl13",
	/* 304 */	"lchflags",
	/* 305 */	"issetugid",
	/* 306 */	"utrace",
	/* 307 */	"getcontext",
	/* 308 */	"setcontext",
	/* 309 */	"_lwp_create",
	/* 310 */	"_lwp_exit",
	/* 311 */	"_lwp_self",
	/* 312 */	"_lwp_wait",
	/* 313 */	"_lwp_suspend",
	/* 314 */	"_lwp_continue",
	/* 315 */	"_lwp_wakeup",
	/* 316 */	"_lwp_getprivate",
	/* 317 */	"_lwp_setprivate",
	/* 318 */	"_lwp_kill",
	/* 319 */	"_lwp_detach",
	/* 320 */	"compat_50__lwp_park",
	/* 321 */	"_lwp_unpark",
	/* 322 */	"_lwp_unpark_all",
	/* 323 */	"_lwp_setname",
	/* 324 */	"_lwp_getname",
	/* 325 */	"_lwp_ctl",
	/* 326 */	"#326 (unimplemented)",
	/* 327 */	"#327 (unimplemented)",
	/* 328 */	"#328 (unimplemented)",
	/* 329 */	"#329 (unimplemented)",
	/* 330 */	"compat_60_sa_register",
	/* 331 */	"compat_60_sa_stacks",
	/* 332 */	"compat_60_sa_enable",
	/* 333 */	"compat_60_sa_setconcurrency",
	/* 334 */	"compat_60_sa_yield",
	/* 335 */	"compat_60_sa_preempt",
	/* 336 */	"#336 (obsolete sys_sa_unblockyield)",
	/* 337 */	"#337 (unimplemented)",
	/* 338 */	"#338 (unimplemented)",
	/* 339 */	"#339 (unimplemented)",
	/* 340 */	"__sigaction_sigtramp",
	/* 341 */	"#341 (obsolete sys_pmc_get_info)",
	/* 342 */	"#342 (obsolete sys_pmc_control)",
	/* 343 */	"rasctl",
	/* 344 */	"kqueue",
	/* 345 */	"compat_50_kevent",
	/* 346 */	"_sched_setparam",
	/* 347 */	"_sched_getparam",
	/* 348 */	"_sched_setaffinity",
	/* 349 */	"_sched_getaffinity",
	/* 350 */	"sched_yield",
	/* 351 */	"_sched_protect",
	/* 352 */	"#352 (unimplemented)",
	/* 353 */	"#353 (unimplemented)",
	/* 354 */	"fsync_range",
	/* 355 */	"uuidgen",
	/* 356 */	"compat_90_getvfsstat",
	/* 357 */	"compat_90_statvfs1",
	/* 358 */	"compat_90_fstatvfs1",
	/* 359 */	"compat_30_fhstatvfs1",
	/* 360 */	"extattrctl",
	/* 361 */	"extattr_set_file",
	/* 362 */	"extattr_get_file",
	/* 363 */	"extattr_delete_file",
	/* 364 */	"extattr_set_fd",
	/* 365 */	"extattr_get_fd",
	/* 366 */	"extattr_delete_fd",
	/* 367 */	"extattr_set_link",
	/* 368 */	"extattr_get_link",
	/* 369 */	"extattr_delete_link",
	/* 370 */	"extattr_list_fd",
	/* 371 */	"extattr_list_file",
	/* 372 */	"extattr_list_link",
	/* 373 */	"compat_50_pselect",
	/* 374 */	"compat_50_pollts",
	/* 375 */	"setxattr",
	/* 376 */	"lsetxattr",
	/* 377 */	"fsetxattr",
	/* 378 */	"getxattr",
	/* 379 */	"lgetxattr",
	/* 380 */	"fgetxattr",
	/* 381 */	"listxattr",
	/* 382 */	"llistxattr",
	/* 383 */	"flistxattr",
	/* 384 */	"removexattr",
	/* 385 */	"lremovexattr",
	/* 386 */	"fremovexattr",
	/* 387 */	"compat_50___stat30",
	/* 388 */	"compat_50___fstat30",
	/* 389 */	"compat_50___lstat30",
	/* 390 */	"__getdents30",
	/* 391 */	"#391 (ignored old posix_fadvise)",
	/* 392 */	"compat_30___fhstat30",
	/* 393 */	"compat_50___ntp_gettime30",
	/* 394 */	"__socket30",
	/* 395 */	"__getfh30",
	/* 396 */	"__fhopen40",
	/* 397 */	"compat_90_fhstatvfs1",
	/* 398 */	"compat_50___fhstat40",
	/* 399 */	"aio_cancel",
	/* 400 */	"aio_error",
	/* 401 */	"aio_fsync",
	/* 402 */	"aio_read",
	/* 403 */	"aio_return",
	/* 404 */	"compat_50_aio_suspend",
	/* 405 */	"aio_write",
	/* 406 */	"lio_listio",
	/* 407 */	"#407 (unimplemented)",
	/* 408 */	"#408 (unimplemented)",
	/* 409 */	"#409 (unimplemented)",
	/* 410 */	"__mount50",
	/* 411 */	"mremap",
	/* 412 */	"pset_create",
	/* 413 */	"pset_destroy",
	/* 414 */	"pset_assign",
	/* 415 */	"_pset_bind",
	/* 416 */	"__posix_fadvise50",
	/* 417 */	"__select50",
	/* 418 */	"__gettimeofday50",
	/* 419 */	"__settimeofday50",
	/* 420 */	"__utimes50",
	/* 421 */	"__adjtime50",
	/* 422 */	"__lfs_segwait50",
	/* 423 */	"__futimes50",
	/* 424 */	"__lutimes50",
	/* 425 */	"__setitimer50",
	/* 426 */	"__getitimer50",
	/* 427 */	"__clock_gettime50",
	/* 428 */	"__clock_settime50",
	/* 429 */	"__clock_getres50",
	/* 430 */	"__nanosleep50",
	/* 431 */	"____sigtimedwait50",
	/* 432 */	"__mq_timedsend50",
	/* 433 */	"__mq_timedreceive50",
	/* 434 */	"compat_60__lwp_park",
	/* 435 */	"compat_100___kevent50",
	/* 436 */	"__pselect50",
	/* 437 */	"__pollts50",
	/* 438 */	"__aio_suspend50",
	/* 439 */	"__stat50",
	/* 440 */	"__fstat50",
	/* 441 */	"__lstat50",
	/* 442 */	"____semctl50",
	/* 443 */	"__shmctl50",
	/* 444 */	"__msgctl50",
	/* 445 */	"__getrusage50",
	/* 446 */	"__timer_settime50",
	/* 447 */	"__timer_gettime50",
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* 448 */	"__ntp_gettime50",
#else
	/* 448 */	"#448 (excluded ___ntp_gettime50)",
#endif
	/* 449 */	"__wait450",
	/* 450 */	"__mknod50",
	/* 451 */	"__fhstat50",
	/* 452 */	"#452 (obsolete 5.99 quotactl)",
	/* 453 */	"pipe2",
	/* 454 */	"compat_100_dup3",
	/* 455 */	"kqueue1",
	/* 456 */	"paccept",
	/* 457 */	"linkat",
	/* 458 */	"renameat",
	/* 459 */	"mkfifoat",
	/* 460 */	"mknodat",
	/* 461 */	"mkdirat",
	/* 462 */	"faccessat",
	/* 463 */	"fchmodat",
	/* 464 */	"fchownat",
	/* 465 */	"fexecve",
	/* 466 */	"fstatat",
	/* 467 */	"utimensat",
	/* 468 */	"openat",
	/* 469 */	"readlinkat",
	/* 470 */	"symlinkat",
	/* 471 */	"unlinkat",
	/* 472 */	"futimens",
	/* 473 */	"__quotactl",
	/* 474 */	"posix_spawn",
	/* 475 */	"recvmmsg",
	/* 476 */	"sendmmsg",
	/* 477 */	"clock_nanosleep",
	/* 478 */	"___lwp_park60",
	/* 479 */	"posix_fallocate",
	/* 480 */	"fdiscard",
	/* 481 */	"wait6",
	/* 482 */	"clock_getcpuclockid2",
	/* 483 */	"__getvfsstat90",
	/* 484 */	"__statvfs190",
	/* 485 */	"__fstatvfs190",
	/* 486 */	"__fhstatvfs190",
	/* 487 */	"__acl_get_link",
	/* 488 */	"__acl_set_link",
	/* 489 */	"__acl_delete_link",
	/* 490 */	"__acl_aclcheck_link",
	/* 491 */	"__acl_get_file",
	/* 492 */	"__acl_set_file",
	/* 493 */	"__acl_get_fd",
	/* 494 */	"__acl_set_fd",
	/* 495 */	"__acl_delete_file",
	/* 496 */	"__acl_delete_fd",
	/* 497 */	"__acl_aclcheck_file",
	/* 498 */	"__acl_aclcheck_fd",
	/* 499 */	"lpathconf",
	/* 500 */	"memfd_create",
	/* 501 */	"__kevent100",
	/* 502 */	"epoll_create1",
	/* 503 */	"epoll_ctl",
	/* 504 */	"epoll_pwait2",
	/* 505 */	"__dup3100",
	/* 506 */	"semtimedop",
	/* 507 */	"# filler",
	/* 508 */	"# filler",
	/* 509 */	"# filler",
	/* 510 */	"# filler",
	/* 511 */	"# filler",
};


/* libc style syscall names */
const char *const altsyscallnames[] = {
	/*   0 */	NULL, /* syscall */
	/*   1 */	NULL, /* exit */
	/*   2 */	NULL, /* fork */
	/*   3 */	NULL, /* read */
	/*   4 */	NULL, /* write */
	/*   5 */	NULL, /* open */
	/*   6 */	NULL, /* close */
	/*   7 */	NULL, /* compat_50_wait4 */
	/*   8 */	NULL, /* compat_43_ocreat */
	/*   9 */	NULL, /* link */
	/*  10 */	NULL, /* unlink */
	/*  11 */	NULL, /* obsolete execv */
	/*  12 */	NULL, /* chdir */
	/*  13 */	NULL, /* fchdir */
	/*  14 */	NULL, /* compat_50_mknod */
	/*  15 */	NULL, /* chmod */
	/*  16 */	NULL, /* chown */
	/*  17 */	"obreak",
	/*  18 */	NULL, /* compat_20_getfsstat */
	/*  19 */	NULL, /* compat_43_olseek */
	/*  20 */	"getpid_with_ppid",
	/*  21 */	NULL, /* compat_40_mount */
	/*  22 */	NULL, /* unmount */
	/*  23 */	NULL, /* setuid */
	/*  24 */	"getuid_with_euid",
	/*  25 */	NULL, /* geteuid */
	/*  26 */	NULL, /* ptrace */
	/*  27 */	NULL, /* recvmsg */
	/*  28 */	NULL, /* sendmsg */
	/*  29 */	NULL, /* recvfrom */
	/*  30 */	NULL, /* accept */
	/*  31 */	NULL, /* getpeername */
	/*  32 */	NULL, /* getsockname */
	/*  33 */	NULL, /* access */
	/*  34 */	NULL, /* chflags */
	/*  35 */	NULL, /* fchflags */
	/*  36 */	NULL, /* sync */
	/*  37 */	NULL, /* kill */
	/*  38 */	NULL, /* compat_43_stat43 */
	/*  39 */	NULL, /* getppid */
	/*  40 */	NULL, /* compat_43_lstat43 */
	/*  41 */	NULL, /* dup */
	/*  42 */	NULL, /* pipe */
	/*  43 */	NULL, /* getegid */
	/*  44 */	NULL, /* profil */
	/*  45 */	NULL, /* ktrace */
	/*  46 */	NULL, /* compat_13_sigaction13 */
	/*  47 */	"getgid_with_egid",
	/*  48 */	NULL, /* compat_13_sigprocmask13 */
	/*  49 */	NULL, /* __getlogin */
	/*  50 */	NULL, /* __setlogin */
	/*  51 */	NULL, /* acct */
	/*  52 */	NULL, /* compat_13_sigpending13 */
	/*  53 */	NULL, /* compat_13_sigaltstack13 */
	/*  54 */	NULL, /* ioctl */
	/*  55 */	NULL, /* compat_12_oreboot */
	/*  56 */	NULL, /* revoke */
	/*  57 */	NULL, /* symlink */
	/*  58 */	NULL, /* readlink */
	/*  59 */	NULL, /* execve */
	/*  60 */	NULL, /* umask */
	/*  61 */	NULL, /* chroot */
	/*  62 */	NULL, /* compat_43_fstat43 */
	/*  63 */	NULL, /* compat_43_ogetkerninfo */
	/*  64 */	NULL, /* compat_43_ogetpagesize */
	/*  65 */	NULL, /* compat_12_msync */
	/*  66 */	NULL, /* vfork */
	/*  67 */	NULL, /* obsolete vread */
	/*  68 */	NULL, /* obsolete vwrite */
	/*  69 */	NULL, /* obsolete sbrk */
	/*  70 */	NULL, /* obsolete sstk */
	/*  71 */	NULL, /* compat_43_ommap */
	/*  72 */	"ovadvise",
	/*  73 */	NULL, /* munmap */
	/*  74 */	NULL, /* mprotect */
	/*  75 */	NULL, /* madvise */
	/*  76 */	NULL, /* obsolete vhangup */
	/*  77 */	NULL, /* obsolete vlimit */
	/*  78 */	NULL, /* mincore */
	/*  79 */	NULL, /* getgroups */
	/*  80 */	NULL, /* setgroups */
	/*  81 */	NULL, /* getpgrp */
	/*  82 */	NULL, /* setpgid */
	/*  83 */	NULL, /* compat_50_setitimer */
	/*  84 */	NULL, /* compat_43_owait */
	/*  85 */	NULL, /* compat_12_oswapon */
	/*  86 */	NULL, /* compat_50_getitimer */
	/*  87 */	NULL, /* compat_43_ogethostname */
	/*  88 */	NULL, /* compat_43_osethostname */
	/*  89 */	NULL, /* compat_43_ogetdtablesize */
	/*  90 */	NULL, /* dup2 */
	/*  91 */	NULL, /* getrandom */
	/*  92 */	NULL, /* fcntl */
	/*  93 */	NULL, /* compat_50_select */
	/*  94 */	NULL, /* unimplemented setdopt */
	/*  95 */	NULL, /* fsync */
	/*  96 */	NULL, /* setpriority */
	/*  97 */	NULL, /* compat_30_socket */
	/*  98 */	NULL, /* connect */
	/*  99 */	NULL, /* compat_43_oaccept */
	/* 100 */	NULL, /* getpriority */
	/* 101 */	NULL, /* compat_43_osend */
	/* 102 */	NULL, /* compat_43_orecv */
	/* 103 */	NULL, /* compat_13_sigreturn13 */
	/* 104 */	NULL, /* bind */
	/* 105 */	NULL, /* setsockopt */
	/* 106 */	NULL, /* listen */
	/* 107 */	NULL, /* obsolete vtimes */
	/* 108 */	NULL, /* compat_43_osigvec */
	/* 109 */	NULL, /* compat_43_osigblock */
	/* 110 */	NULL, /* compat_43_osigsetmask */
	/* 111 */	NULL, /* compat_13_sigsuspend13 */
	/* 112 */	NULL, /* compat_43_osigstack */
	/* 113 */	NULL, /* compat_43_orecvmsg */
	/* 114 */	NULL, /* compat_43_osendmsg */
	/* 115 */	NULL, /* obsolete vtrace */
	/* 116 */	NULL, /* compat_50_gettimeofday */
	/* 117 */	NULL, /* compat_50_getrusage */
	/* 118 */	NULL, /* getsockopt */
	/* 119 */	NULL, /* obsolete resuba */
	/* 120 */	NULL, /* readv */
	/* 121 */	NULL, /* writev */
	/* 122 */	NULL, /* compat_50_settimeofday */
	/* 123 */	NULL, /* fchown */
	/* 124 */	NULL, /* fchmod */
	/* 125 */	NULL, /* compat_43_orecvfrom */
	/* 126 */	NULL, /* setreuid */
	/* 127 */	NULL, /* setregid */
	/* 128 */	NULL, /* rename */
	/* 129 */	NULL, /* compat_43_otruncate */
	/* 130 */	NULL, /* compat_43_oftruncate */
	/* 131 */	NULL, /* flock */
	/* 132 */	NULL, /* mkfifo */
	/* 133 */	NULL, /* sendto */
	/* 134 */	NULL, /* shutdown */
	/* 135 */	NULL, /* socketpair */
	/* 136 */	NULL, /* mkdir */
	/* 137 */	NULL, /* rmdir */
	/* 138 */	NULL, /* compat_50_utimes */
	/* 139 */	NULL, /* obsolete 4.2 sigreturn */
	/* 140 */	NULL, /* compat_50_adjtime */
	/* 141 */	NULL, /* compat_43_ogetpeername */
	/* 142 */	NULL, /* compat_43_ogethostid */
	/* 143 */	NULL, /* compat_43_osethostid */
	/* 144 */	NULL, /* compat_43_ogetrlimit */
	/* 145 */	NULL, /* compat_43_osetrlimit */
	/* 146 */	NULL, /* compat_43_okillpg */
	/* 147 */	NULL, /* setsid */
	/* 148 */	NULL, /* compat_50_quotactl */
	/* 149 */	NULL, /* compat_43_oquota */
	/* 150 */	NULL, /* compat_43_ogetsockname */
	/* 151 */	NULL, /* unimplemented */
	/* 152 */	NULL, /* unimplemented */
	/* 153 */	NULL, /* unimplemented */
	/* 154 */	NULL, /* unimplemented */
	/* 155 */	NULL, /* nfssvc */
	/* 156 */	NULL, /* compat_43_ogetdirentries */
	/* 157 */	NULL, /* compat_20_statfs */
	/* 158 */	NULL, /* compat_20_fstatfs */
	/* 159 */	NULL, /* unimplemented */
	/* 160 */	NULL, /* unimplemented */
	/* 161 */	NULL, /* compat_30_getfh */
	/* 162 */	NULL, /* compat_09_ogetdomainname */
	/* 163 */	NULL, /* compat_09_osetdomainname */
	/* 164 */	NULL, /* compat_09_ouname */
	/* 165 */	NULL, /* sysarch */
	/* 166 */	NULL, /* __futex */
	/* 167 */	NULL, /* __futex_set_robust_list */
	/* 168 */	NULL, /* __futex_get_robust_list */
#if !defined(_LP64)
	/* 169 */	NULL, /* compat_10_osemsys */
#else
	/* 169 */	NULL, /* excluded 1.0 semsys */
#endif
#if !defined(_LP64)
	/* 170 */	NULL, /* compat_10_omsgsys */
#else
	/* 170 */	NULL, /* excluded 1.0 msgsys */
#endif
#if !defined(_LP64)
	/* 171 */	NULL, /* compat_10_oshmsys */
#else
	/* 171 */	NULL, /* excluded 1.0 shmsys */
#endif
	/* 172 */	NULL, /* unimplemented */
	/* 173 */	NULL, /* pread */
	/* 174 */	NULL, /* pwrite */
	/* 175 */	NULL, /* compat_30_ntp_gettime */
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* 176 */	NULL, /* ntp_adjtime */
#else
	/* 176 */	NULL, /* excluded ntp_adjtime */
#endif
	/* 177 */	NULL, /* timerfd_create */
	/* 178 */	NULL, /* timerfd_settime */
	/* 179 */	NULL, /* timerfd_gettime */
	/* 180 */	NULL, /* unimplemented */
	/* 181 */	NULL, /* setgid */
	/* 182 */	NULL, /* setegid */
	/* 183 */	NULL, /* seteuid */
	/* 184 */	NULL, /* lfs_bmapv */
	/* 185 */	NULL, /* lfs_markv */
	/* 186 */	NULL, /* lfs_segclean */
	/* 187 */	NULL, /* compat_50_lfs_segwait */
	/* 188 */	NULL, /* compat_12_stat12 */
	/* 189 */	NULL, /* compat_12_fstat12 */
	/* 190 */	NULL, /* compat_12_lstat12 */
	/* 191 */	NULL, /* pathconf */
	/* 192 */	NULL, /* fpathconf */
	/* 193 */	NULL, /* getsockopt2 */
	/* 194 */	NULL, /* getrlimit */
	/* 195 */	NULL, /* setrlimit */
	/* 196 */	NULL, /* compat_12_getdirentries */
	/* 197 */	NULL, /* mmap */
	/* 198 */	NULL, /* __syscall */
	/* 199 */	NULL, /* lseek */
	/* 200 */	NULL, /* truncate */
	/* 201 */	NULL, /* ftruncate */
	/* 202 */	NULL, /* __sysctl */
	/* 203 */	NULL, /* mlock */
	/* 204 */	NULL, /* munlock */
	/* 205 */	NULL, /* undelete */
	/* 206 */	NULL, /* compat_50_futimes */
	/* 207 */	NULL, /* getpgid */
	/* 208 */	NULL, /* reboot */
	/* 209 */	NULL, /* poll */
	/* 210 */	NULL, /* afssys */
	/* 211 */	NULL, /* unimplemented */
	/* 212 */	NULL, /* unimplemented */
	/* 213 */	NULL, /* unimplemented */
	/* 214 */	NULL, /* unimplemented */
	/* 215 */	NULL, /* unimplemented */
	/* 216 */	NULL, /* unimplemented */
	/* 217 */	NULL, /* unimplemented */
	/* 218 */	NULL, /* unimplemented */
	/* 219 */	NULL, /* unimplemented */
	/* 220 */	NULL, /* compat_14___semctl */
	/* 221 */	NULL, /* semget */
	/* 222 */	NULL, /* semop */
	/* 223 */	NULL, /* semconfig */
	/* 224 */	NULL, /* compat_14_msgctl */
	/* 225 */	NULL, /* msgget */
	/* 226 */	NULL, /* msgsnd */
	/* 227 */	NULL, /* msgrcv */
	/* 228 */	NULL, /* shmat */
	/* 229 */	NULL, /* compat_14_shmctl */
	/* 230 */	NULL, /* shmdt */
	/* 231 */	NULL, /* shmget */
	/* 232 */	NULL, /* compat_50_clock_gettime */
	/* 233 */	NULL, /* compat_50_clock_settime */
	/* 234 */	NULL, /* compat_50_clock_getres */
	/* 235 */	NULL, /* timer_create */
	/* 236 */	NULL, /* timer_delete */
	/* 237 */	NULL, /* compat_50_timer_settime */
	/* 238 */	NULL, /* compat_50_timer_gettime */
	/* 239 */	NULL, /* timer_getoverrun */
	/* 240 */	NULL, /* compat_50_nanosleep */
	/* 241 */	NULL, /* fdatasync */
	/* 242 */	NULL, /* mlockall */
	/* 243 */	NULL, /* munlockall */
	/* 244 */	NULL, /* compat_50___sigtimedwait */
	/* 245 */	NULL, /* sigqueueinfo */
	/* 246 */	NULL, /* modctl */
	/* 247 */	NULL, /* _ksem_init */
	/* 248 */	NULL, /* _ksem_open */
	/* 249 */	NULL, /* _ksem_unlink */
	/* 250 */	NULL, /* _ksem_close */
	/* 251 */	NULL, /* _ksem_post */
	/* 252 */	NULL, /* _ksem_wait */
	/* 253 */	NULL, /* _ksem_trywait */
	/* 254 */	NULL, /* _ksem_getvalue */
	/* 255 */	NULL, /* _ksem_destroy */
	/* 256 */	NULL, /* _ksem_timedwait */
	/* 257 */	NULL, /* mq_open */
	/* 258 */	NULL, /* mq_close */
	/* 259 */	NULL, /* mq_unlink */
	/* 260 */	NULL, /* mq_getattr */
	/* 261 */	NULL, /* mq_setattr */
	/* 262 */	NULL, /* mq_notify */
	/* 263 */	NULL, /* mq_send */
	/* 264 */	NULL, /* mq_receive */
	/* 265 */	NULL, /* compat_50_mq_timedsend */
	/* 266 */	NULL, /* compat_50_mq_timedreceive */
	/* 267 */	NULL, /* eventfd */
	/* 268 */	NULL, /* unimplemented */
	/* 269 */	NULL, /* unimplemented */
	/* 270 */	NULL, /* __posix_rename */
	/* 271 */	NULL, /* swapctl */
	/* 272 */	NULL, /* compat_30_getdents */
	/* 273 */	NULL, /* minherit */
	/* 274 */	NULL, /* lchmod */
	/* 275 */	NULL, /* lchown */
	/* 276 */	NULL, /* compat_50_lutimes */
	/* 277 */	"msync",
	/* 278 */	NULL, /* compat_30___stat13 */
	/* 279 */	NULL, /* compat_30___fstat13 */
	/* 280 */	NULL, /* compat_30___lstat13 */
	/* 281 */	"sigaltstack",
	/* 282 */	"vfork",
	/* 283 */	NULL, /* __posix_chown */
	/* 284 */	NULL, /* __posix_fchown */
	/* 285 */	NULL, /* __posix_lchown */
	/* 286 */	NULL, /* getsid */
	/* 287 */	NULL, /* __clone */
	/* 288 */	NULL, /* fktrace */
	/* 289 */	NULL, /* preadv */
	/* 290 */	NULL, /* pwritev */
	/* 291 */	NULL, /* compat_16___sigaction14 */
	/* 292 */	"sigpending",
	/* 293 */	"sigprocmask",
	/* 294 */	"sigsuspend",
	/* 295 */	NULL, /* compat_16___sigreturn14 */
	/* 296 */	NULL, /* __getcwd */
	/* 297 */	NULL, /* fchroot */
	/* 298 */	NULL, /* compat_30_fhopen */
	/* 299 */	NULL, /* compat_30_fhstat */
	/* 300 */	NULL, /* compat_20_fhstatfs */
	/* 301 */	NULL, /* compat_50_____semctl13 */
	/* 302 */	NULL, /* compat_50___msgctl13 */
	/* 303 */	NULL, /* compat_50___shmctl13 */
	/* 304 */	NULL, /* lchflags */
	/* 305 */	NULL, /* issetugid */
	/* 306 */	NULL, /* utrace */
	/* 307 */	NULL, /* getcontext */
	/* 308 */	NULL, /* setcontext */
	/* 309 */	NULL, /* _lwp_create */
	/* 310 */	NULL, /* _lwp_exit */
	/* 311 */	NULL, /* _lwp_self */
	/* 312 */	NULL, /* _lwp_wait */
	/* 313 */	NULL, /* _lwp_suspend */
	/* 314 */	NULL, /* _lwp_continue */
	/* 315 */	NULL, /* _lwp_wakeup */
	/* 316 */	NULL, /* _lwp_getprivate */
	/* 317 */	NULL, /* _lwp_setprivate */
	/* 318 */	NULL, /* _lwp_kill */
	/* 319 */	NULL, /* _lwp_detach */
	/* 320 */	NULL, /* compat_50__lwp_park */
	/* 321 */	NULL, /* _lwp_unpark */
	/* 322 */	NULL, /* _lwp_unpark_all */
	/* 323 */	NULL, /* _lwp_setname */
	/* 324 */	NULL, /* _lwp_getname */
	/* 325 */	NULL, /* _lwp_ctl */
	/* 326 */	NULL, /* unimplemented */
	/* 327 */	NULL, /* unimplemented */
	/* 328 */	NULL, /* unimplemented */
	/* 329 */	NULL, /* unimplemented */
	/* 330 */	NULL, /* compat_60_sa_register */
	/* 331 */	NULL, /* compat_60_sa_stacks */
	/* 332 */	NULL, /* compat_60_sa_enable */
	/* 333 */	NULL, /* compat_60_sa_setconcurrency */
	/* 334 */	NULL, /* compat_60_sa_yield */
	/* 335 */	NULL, /* compat_60_sa_preempt */
	/* 336 */	NULL, /* obsolete sys_sa_unblockyield */
	/* 337 */	NULL, /* unimplemented */
	/* 338 */	NULL, /* unimplemented */
	/* 339 */	NULL, /* unimplemented */
	/* 340 */	NULL, /* __sigaction_sigtramp */
	/* 341 */	NULL, /* obsolete sys_pmc_get_info */
	/* 342 */	NULL, /* obsolete sys_pmc_control */
	/* 343 */	NULL, /* rasctl */
	/* 344 */	NULL, /* kqueue */
	/* 345 */	NULL, /* compat_50_kevent */
	/* 346 */	NULL, /* _sched_setparam */
	/* 347 */	NULL, /* _sched_getparam */
	/* 348 */	NULL, /* _sched_setaffinity */
	/* 349 */	NULL, /* _sched_getaffinity */
	/* 350 */	NULL, /* sched_yield */
	/* 351 */	NULL, /* _sched_protect */
	/* 352 */	NULL, /* unimplemented */
	/* 353 */	NULL, /* unimplemented */
	/* 354 */	NULL, /* fsync_range */
	/* 355 */	NULL, /* uuidgen */
	/* 356 */	NULL, /* compat_90_getvfsstat */
	/* 357 */	NULL, /* compat_90_statvfs1 */
	/* 358 */	NULL, /* compat_90_fstatvfs1 */
	/* 359 */	NULL, /* compat_30_fhstatvfs1 */
	/* 360 */	NULL, /* extattrctl */
	/* 361 */	NULL, /* extattr_set_file */
	/* 362 */	NULL, /* extattr_get_file */
	/* 363 */	NULL, /* extattr_delete_file */
	/* 364 */	NULL, /* extattr_set_fd */
	/* 365 */	NULL, /* extattr_get_fd */
	/* 366 */	NULL, /* extattr_delete_fd */
	/* 367 */	NULL, /* extattr_set_link */
	/* 368 */	NULL, /* extattr_get_link */
	/* 369 */	NULL, /* extattr_delete_link */
	/* 370 */	NULL, /* extattr_list_fd */
	/* 371 */	NULL, /* extattr_list_file */
	/* 372 */	NULL, /* extattr_list_link */
	/* 373 */	NULL, /* compat_50_pselect */
	/* 374 */	NULL, /* compat_50_pollts */
	/* 375 */	NULL, /* setxattr */
	/* 376 */	NULL, /* lsetxattr */
	/* 377 */	NULL, /* fsetxattr */
	/* 378 */	NULL, /* getxattr */
	/* 379 */	NULL, /* lgetxattr */
	/* 380 */	NULL, /* fgetxattr */
	/* 381 */	NULL, /* listxattr */
	/* 382 */	NULL, /* llistxattr */
	/* 383 */	NULL, /* flistxattr */
	/* 384 */	NULL, /* removexattr */
	/* 385 */	NULL, /* lremovexattr */
	/* 386 */	NULL, /* fremovexattr */
	/* 387 */	NULL, /* compat_50___stat30 */
	/* 388 */	NULL, /* compat_50___fstat30 */
	/* 389 */	NULL, /* compat_50___lstat30 */
	/* 390 */	"getdents",
	/* 391 */	NULL, /* ignored old posix_fadvise */
	/* 392 */	NULL, /* compat_30___fhstat30 */
	/* 393 */	NULL, /* compat_50___ntp_gettime30 */
	/* 394 */	"socket",
	/* 395 */	"getfh",
	/* 396 */	"fhopen",
	/* 397 */	NULL, /* compat_90_fhstatvfs1 */
	/* 398 */	NULL, /* compat_50___fhstat40 */
	/* 399 */	NULL, /* aio_cancel */
	/* 400 */	NULL, /* aio_error */
	/* 401 */	NULL, /* aio_fsync */
	/* 402 */	NULL, /* aio_read */
	/* 403 */	NULL, /* aio_return */
	/* 404 */	NULL, /* compat_50_aio_suspend */
	/* 405 */	NULL, /* aio_write */
	/* 406 */	NULL, /* lio_listio */
	/* 407 */	NULL, /* unimplemented */
	/* 408 */	NULL, /* unimplemented */
	/* 409 */	NULL, /* unimplemented */
	/* 410 */	"mount",
	/* 411 */	NULL, /* mremap */
	/* 412 */	NULL, /* pset_create */
	/* 413 */	NULL, /* pset_destroy */
	/* 414 */	NULL, /* pset_assign */
	/* 415 */	NULL, /* _pset_bind */
	/* 416 */	"posix_fadvise",
	/* 417 */	"select",
	/* 418 */	"gettimeofday",
	/* 419 */	"settimeofday",
	/* 420 */	"utimes",
	/* 421 */	"adjtime",
	/* 422 */	"lfs_segwait",
	/* 423 */	"futimes",
	/* 424 */	"lutimes",
	/* 425 */	"setitimer",
	/* 426 */	"getitimer",
	/* 427 */	"clock_gettime",
	/* 428 */	"clock_settime",
	/* 429 */	"clock_getres",
	/* 430 */	"nanosleep",
	/* 431 */	"__sigtimedwait",
	/* 432 */	"mq_timedsend",
	/* 433 */	"mq_timedreceive",
	/* 434 */	NULL, /* compat_60__lwp_park */
	/* 435 */	NULL, /* compat_100___kevent50 */
	/* 436 */	"pselect",
	/* 437 */	"pollts",
	/* 438 */	"aio_suspend",
	/* 439 */	"stat",
	/* 440 */	"fstat",
	/* 441 */	"lstat",
	/* 442 */	"__semctl",
	/* 443 */	"shmctl",
	/* 444 */	"msgctl",
	/* 445 */	"getrusage",
	/* 446 */	"timer_settime",
	/* 447 */	"timer_gettime",
#if defined(NTP) || !defined(_KERNEL_OPT)
	/* 448 */	"ntp_gettime",
#else
	/* 448 */	NULL, /* excluded ___ntp_gettime50 */
#endif
	/* 449 */	"wait4",
	/* 450 */	"mknod",
	/* 451 */	"fhstat",
	/* 452 */	NULL, /* obsolete 5.99 quotactl */
	/* 453 */	NULL, /* pipe2 */
	/* 454 */	NULL, /* compat_100_dup3 */
	/* 455 */	NULL, /* kqueue1 */
	/* 456 */	NULL, /* paccept */
	/* 457 */	NULL, /* linkat */
	/* 458 */	NULL, /* renameat */
	/* 459 */	NULL, /* mkfifoat */
	/* 460 */	NULL, /* mknodat */
	/* 461 */	NULL, /* mkdirat */
	/* 462 */	NULL, /* faccessat */
	/* 463 */	NULL, /* fchmodat */
	/* 464 */	NULL, /* fchownat */
	/* 465 */	NULL, /* fexecve */
	/* 466 */	NULL, /* fstatat */
	/* 467 */	NULL, /* utimensat */
	/* 468 */	NULL, /* openat */
	/* 469 */	NULL, /* readlinkat */
	/* 470 */	NULL, /* symlinkat */
	/* 471 */	NULL, /* unlinkat */
	/* 472 */	NULL, /* futimens */
	/* 473 */	NULL, /* __quotactl */
	/* 474 */	NULL, /* posix_spawn */
	/* 475 */	NULL, /* recvmmsg */
	/* 476 */	NULL, /* sendmmsg */
	/* 477 */	NULL, /* clock_nanosleep */
	/* 478 */	"_lwp_park",
	/* 479 */	NULL, /* posix_fallocate */
	/* 480 */	NULL, /* fdiscard */
	/* 481 */	NULL, /* wait6 */
	/* 482 */	NULL, /* clock_getcpuclockid2 */
	/* 483 */	"getvfsstat",
	/* 484 */	"statvfs1",
	/* 485 */	"fstatvfs1",
	/* 486 */	"fhstatvfs1",
	/* 487 */	NULL, /* __acl_get_link */
	/* 488 */	NULL, /* __acl_set_link */
	/* 489 */	NULL, /* __acl_delete_link */
	/* 490 */	NULL, /* __acl_aclcheck_link */
	/* 491 */	NULL, /* __acl_get_file */
	/* 492 */	NULL, /* __acl_set_file */
	/* 493 */	NULL, /* __acl_get_fd */
	/* 494 */	NULL, /* __acl_set_fd */
	/* 495 */	NULL, /* __acl_delete_file */
	/* 496 */	NULL, /* __acl_delete_fd */
	/* 497 */	NULL, /* __acl_aclcheck_file */
	/* 498 */	NULL, /* __acl_aclcheck_fd */
	/* 499 */	NULL, /* lpathconf */
	/* 500 */	NULL, /* memfd_create */
	/* 501 */	"kevent",
	/* 502 */	NULL, /* epoll_create1 */
	/* 503 */	NULL, /* epoll_ctl */
	/* 504 */	NULL, /* epoll_pwait2 */
	/* 505 */	"dup3",
	/* 506 */	NULL, /* semtimedop */
	/* 507 */	NULL, /* filler */
	/* 508 */	NULL, /* filler */
	/* 509 */	NULL, /* filler */
	/* 510 */	NULL, /* filler */
	/* 511 */	NULL, /* filler */
};
