/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.ImportContainer;
import org.eclipse.jdt.internal.core.ImportDeclaration;
import org.eclipse.jdt.internal.core.ImportDeclarationElementInfo;
import org.eclipse.jdt.internal.core.InitializerElementInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.PackageDeclaration;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.internal.core.SourceFieldElementInfo;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.eclipse.jdt.internal.core.SourceRefElementInfo;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.util.ReferenceInfoAdapter;

public class CompilationUnitStructureRequestor
extends ReferenceInfoAdapter
implements ISourceElementRequestor {
    protected ICompilationUnit unit;
    protected CompilationUnitElementInfo unitInfo;
    protected JavaElementInfo importContainerInfo = null;
    protected Map newElements;
    protected Stack infoStack;
    protected Stack handleStack;
    protected char[] sourceFileName = null;
    protected char[] packageName = null;
    protected int referenceCount = 0;
    protected boolean hasSyntaxErrors = false;
    protected Parser parser;
    protected static String[] NO_STRINGS = new String[0];
    protected static byte[] NO_BYTES = new byte[0];
    protected HashtableOfObject fieldRefCache;
    protected HashtableOfObject messageRefCache;
    protected HashtableOfObject typeRefCache;
    protected HashtableOfObject unknownRefCache;

    protected CompilationUnitStructureRequestor(ICompilationUnit unit, CompilationUnitElementInfo unitInfo, Map newElements) {
        this.unit = unit;
        this.unitInfo = unitInfo;
        this.newElements = newElements;
        this.sourceFileName = unit.getElementName().toCharArray();
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand, int modifiers) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        if (parentHandle.getElementType() != 5) {
            Assert.isTrue(false);
        }
        ICompilationUnit parentCU = (ICompilationUnit)((Object)parentHandle);
        ImportContainer importContainer = (ImportContainer)parentCU.getImportContainer();
        if (this.importContainerInfo == null) {
            this.importContainerInfo = new JavaElementInfo();
            this.importContainerInfo.setIsStructureKnown(true);
            parentInfo.addChild(importContainer);
            this.newElements.put(importContainer, this.importContainerInfo);
        }
        String importName = onDemand ? new String(name) + ".*" : new String(name);
        ImportDeclaration handle = new ImportDeclaration(importContainer, importName);
        this.resolveDuplicates(handle);
        ImportDeclarationElementInfo info = new ImportDeclarationElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        info.setFlags(modifiers);
        info.setName(name);
        info.setOnDemand(onDemand);
        this.importContainerInfo.addChild(handle);
        this.newElements.put(handle, info);
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        PackageDeclaration handle = null;
        this.packageName = name;
        if (parentHandle.getElementType() == 5) {
            handle = new PackageDeclaration((CompilationUnit)parentHandle, new String(name));
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceRefElementInfo info = new SourceRefElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
    }

    public void acceptProblem(IProblem problem) {
        if ((problem.getID() & 0x40000000) != 0) {
            this.hasSyntaxErrors = true;
        }
    }

    static String[] convertTypeNamesToSigs(char[][] typeNames) {
        if (typeNames == null) {
            return NO_STRINGS;
        }
        int n = typeNames.length;
        if (n == 0) {
            return NO_STRINGS;
        }
        String[] typeSigs = new String[n];
        for (int i = 0; i < n; ++i) {
            typeSigs[i] = Signature.createTypeSignature(typeNames[i], false);
        }
        return typeSigs;
    }

    public void enterClass(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[] superclass, char[][] superinterfaces) {
        this.enterType(declarationStart, modifiers, name, nameSourceStart, nameSourceEnd, superclass, superinterfaces);
    }

    public void enterCompilationUnit() {
        this.infoStack = new Stack();
        this.handleStack = new Stack();
        this.infoStack.push(this.unitInfo);
        this.handleStack.push(this.unit);
    }

    public void enterConstructor(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        this.enterMethod(declarationStart, modifiers, null, name, nameSourceStart, nameSourceEnd, parameterTypes, parameterNames, exceptionTypes, true);
    }

    public void enterField(int declarationStart, int modifiers, char[] type, char[] name, int nameSourceStart, int nameSourceEnd) {
        SourceTypeElementInfo parentInfo = (SourceTypeElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        SourceField handle = null;
        if (parentHandle.getElementType() == 7) {
            handle = new SourceField(parentHandle, new String(name));
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceFieldElementInfo info = new SourceFieldElementInfo();
        info.setName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setSourceRangeStart(declarationStart);
        info.setFlags(modifiers);
        info.setTypeName(type);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        IInitializer handle = null;
        if (parentHandle.getElementType() == 7) {
            handle = ((IType)((Object)parentHandle)).getInitializer(1);
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        InitializerElementInfo info = new InitializerElementInfo();
        info.setSourceRangeStart(declarationSourceStart);
        info.setFlags(modifiers);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void enterInterface(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] superinterfaces) {
        this.enterType(declarationStart, modifiers, name, nameSourceStart, nameSourceEnd, null, superinterfaces);
    }

    public void enterMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        this.enterMethod(declarationStart, modifiers, returnType, name, nameSourceStart, nameSourceEnd, parameterTypes, parameterNames, exceptionTypes, false);
    }

    protected void enterMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes, boolean isConstructor) {
        char[] cArray;
        SourceTypeElementInfo parentInfo = (SourceTypeElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        SourceMethod handle = null;
        if (parameterTypes == null) {
            parameterTypes = CharOperation.NO_CHAR_CHAR;
        }
        if (parameterNames == null) {
            parameterNames = CharOperation.NO_CHAR_CHAR;
        }
        if (exceptionTypes == null) {
            exceptionTypes = CharOperation.NO_CHAR_CHAR;
        }
        String[] parameterTypeSigs = CompilationUnitStructureRequestor.convertTypeNamesToSigs(parameterTypes);
        if (parentHandle.getElementType() == 7) {
            handle = new SourceMethod(parentHandle, new String(name), parameterTypeSigs);
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceMethodElementInfo info = new SourceMethodElementInfo();
        info.setSourceRangeStart(declarationStart);
        int flags = modifiers;
        info.setName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setConstructor(isConstructor);
        info.setFlags(flags);
        info.setArgumentNames(parameterNames);
        info.setArgumentTypeNames(parameterTypes);
        if (returnType == null) {
            char[] cArray2 = new char[4];
            cArray2[0] = 118;
            cArray2[1] = 111;
            cArray2[2] = 105;
            cArray = cArray2;
            cArray2[3] = 100;
        } else {
            cArray = returnType;
        }
        info.setReturnType(cArray);
        info.setExceptionTypeNames(exceptionTypes);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    protected void enterType(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[] superclass, char[][] superinterfaces) {
        JavaElementInfo parentInfo = (JavaElementInfo)this.infoStack.peek();
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        IType handle = null;
        String nameString = new String(name);
        switch (parentHandle.getElementType()) {
            case 5: {
                handle = ((ICompilationUnit)((Object)parentHandle)).getType(nameString);
                break;
            }
            case 7: {
                handle = ((IType)((Object)parentHandle)).getType(nameString);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                handle = ((IMember)((Object)parentHandle)).getType(nameString, 1);
                break;
            }
            default: {
                Assert.isTrue(false);
            }
        }
        this.resolveDuplicates(handle);
        SourceTypeElementInfo info = new SourceTypeElementInfo();
        info.setHandle(handle);
        info.setSourceRangeStart(declarationStart);
        info.setFlags(modifiers);
        info.setName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setSuperclassName(superclass);
        info.setSuperInterfaceNames(superinterfaces);
        info.setSourceFileName(this.sourceFileName);
        info.setPackageName(this.packageName);
        parentInfo.addChild(handle);
        this.newElements.put(handle, info);
        this.infoStack.push(info);
        this.handleStack.push(handle);
    }

    public void exitClass(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitCompilationUnit(int declarationEnd) {
        this.unitInfo.setSourceLength(declarationEnd + 1);
        this.unitInfo.setIsStructureKnown(!this.hasSyntaxErrors);
    }

    public void exitConstructor(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        int length;
        Object typeInfo;
        int flags;
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(declarationSourceEnd);
        if (initializationStart != -1 && (Flags.isStatic(flags = info.flags) && Flags.isFinal(flags) || (typeInfo = this.infoStack.peek()) instanceof SourceTypeElementInfo && Flags.isInterface(((SourceTypeElementInfo)typeInfo).flags)) && (length = declarationEnd - initializationStart) > 0) {
            char[] initializer = new char[length];
            System.arraycopy(this.parser.scanner.source, initializationStart, initializer, 0, length);
            info.initializationSource = initializer;
        }
        this.handleStack.pop();
    }

    public void exitInitializer(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    public void exitInterface(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void exitMember(int declarationEnd) {
        SourceRefElementInfo info = (SourceRefElementInfo)this.infoStack.pop();
        info.setSourceRangeEnd(declarationEnd);
        this.handleStack.pop();
    }

    public void exitMethod(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void resolveDuplicates(IJavaElement handle) {
        while (this.newElements.containsKey(handle)) {
            JavaElement h = (JavaElement)handle;
            ++h.occurrenceCount;
        }
    }
}

