/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.core.dom.rewrite.ListRewriteEvent;
import org.eclipse.jdt.internal.core.dom.rewrite.NodeRewriteEvent;
import org.eclipse.jdt.internal.core.dom.rewrite.RewriteEvent;
import org.eclipse.jdt.internal.core.dom.rewrite.RewriteEventStore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTRewriteClear;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public final class OldASTRewrite
extends ASTRewrite {
    private HashMap fChangedProperties;
    private boolean fHasASTModifications;
    private ASTNode fRootNode;

    public OldASTRewrite(ASTNode node) {
        super(node.getAST());
        this.fRootNode = node;
        this.fChangedProperties = new HashMap();
        this.fHasASTModifications = false;
        this.getRewriteEventStore().setNodePropertyMapper(new RewriteEventStore.INodePropertyMapper(){

            public Object getOriginalValue(ASTNode parent, StructuralPropertyDescriptor childProperty) {
                Object originalValue = parent.getStructuralProperty(childProperty);
                if (parent.getStartPosition() == -1) {
                    return originalValue;
                }
                if (originalValue instanceof List) {
                    List originalList = (List)originalValue;
                    ArrayList<ASTNode> fixedList = new ArrayList<ASTNode>(originalList.size());
                    for (int i = 0; i < originalList.size(); ++i) {
                        ASTNode curr = (ASTNode)originalList.get(i);
                        if (OldASTRewrite.this.isInserted(curr)) continue;
                        fixedList.add(curr);
                    }
                    return fixedList;
                }
                if (originalValue instanceof ASTNode && OldASTRewrite.this.isInserted((ASTNode)originalValue)) {
                    return null;
                }
                return originalValue;
            }
        });
    }

    public final void rewriteNode(TextBuffer textBuffer, TextEdit rootEdit) {
        try {
            TextEdit res = this.rewriteAST(textBuffer.getDocument(), null);
            rootEdit.addChildren(res.removeChildren());
        }
        catch (IllegalArgumentException e) {
            JavaPlugin.log(e);
        }
    }

    public TextEdit rewriteAST(IDocument document, Map options) {
        this.convertOldToNewEvents();
        return super.rewriteAST(document, options);
    }

    public ASTNode getRootNode() {
        return this.fRootNode;
    }

    private void convertOldToNewEvents() {
        HashSet processedListEvents = new HashSet();
        Iterator iter = this.fChangedProperties.keySet().iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            ASTInsert object = this.getChangeProperty(node);
            if (object == null || node.getParent().getStartPosition() == -1) continue;
            this.processChange(node, null, node, object.description, processedListEvents);
            if (!object.isBoundToPrevious) continue;
            this.getRewriteEventStore().setInsertBoundToPrevious(node);
        }
    }

    private void processChange(ASTNode nodeInAST, ASTNode originalNode, ASTNode newNode, TextEditGroup desc, Set processedListEvents) {
        ASTNode parent = nodeInAST.getParent();
        StructuralPropertyDescriptor childProperty = nodeInAST.getLocationInParent();
        if (childProperty.isChildListProperty()) {
            ListRewriteEvent event = this.getRewriteEventStore().getListEvent(parent, childProperty, true);
            if (processedListEvents.add(event)) {
                this.convertListChange(event, (List)parent.getStructuralProperty(childProperty));
            }
        } else {
            NodeRewriteEvent event = this.getRewriteEventStore().getNodeEvent(parent, childProperty, true);
            event.setNewValue((Object)newNode);
            this.getRewriteEventStore().setEventEditGroup((RewriteEvent)event, desc);
        }
    }

    private void convertListChange(ListRewriteEvent listEvent, List modifiedList) {
        for (int i = 0; i < modifiedList.size(); ++i) {
            ASTNode curr = (ASTNode)modifiedList.get(i);
            ASTInsert object = this.getChangeProperty(curr);
            if (object == null) continue;
            RewriteEvent event = listEvent.insert(curr, i);
            this.getRewriteEventStore().setEventEditGroup(event, object.description);
            if (!object.isBoundToPrevious) continue;
            this.getRewriteEventStore().setInsertBoundToPrevious(curr);
        }
    }

    private boolean isInsertBoundToPreviousByDefault(ASTNode node) {
        return node instanceof Statement || node instanceof FieldDeclaration;
    }

    public final void removeModifications() {
        if (this.fHasASTModifications) {
            this.getRootNode().accept((ASTVisitor)new ASTRewriteClear(this));
            this.fHasASTModifications = false;
        }
        this.fChangedProperties.clear();
        this.clearRewrite();
    }

    public boolean hasASTModifications() {
        return this.fHasASTModifications;
    }

    protected final void clearRewrite() {
        this.getRewriteEventStore().clear();
        this.getNodeStore().clear();
    }

    public final boolean isCollapsed(ASTNode node) {
        return this.getNodeStore().isCollapsed(node);
    }

    public final void markAsInserted(ASTNode node, TextEditGroup description) {
        Assert.isTrue(!this.isCollapsed(node), "Tries to insert a collapsed node");
        ASTInsert insert = new ASTInsert();
        insert.isBoundToPrevious = this.isInsertBoundToPreviousByDefault(node);
        insert.description = description;
        this.setChangeProperty(node, insert);
        this.fHasASTModifications = true;
        node.setSourceRange(-1, 0);
    }

    public final void markAsInserted(ASTNode node) {
        this.markAsInserted(node, null);
    }

    public final Block getCollapseTargetPlaceholder(Statement[] children) {
        Block res = this.getNodeStore().createCollapsePlaceholder();
        List statements = res.statements();
        for (int i = 0; i < children.length; ++i) {
            statements.add(children[i]);
        }
        return res;
    }

    public final void markAsTracked(ASTNode node, TextEditGroup editGroup) {
        if (this.getRewriteEventStore().getTrackedNodeData(node) != null) {
            throw new IllegalArgumentException("Node is already marked as tracked");
        }
        this.getRewriteEventStore().setTrackedNodeData(node, editGroup);
    }

    public final ASTNode collapseNodes(List list, int index, int length) {
        Assert.isTrue(index >= 0 && length > 0 && list.size() >= index + length, "Index or length out of bound");
        ASTNode firstNode = (ASTNode)list.get(index);
        ASTNode lastNode = (ASTNode)list.get(index + length - 1);
        this.validateIsInsideAST(firstNode);
        this.validateIsInsideAST(lastNode);
        Assert.isTrue(lastNode instanceof Statement, "Can only collapse statements");
        int startPos = firstNode.getStartPosition();
        int endPos = lastNode.getStartPosition() + lastNode.getLength();
        Block compoundNode = this.getNodeStore().createCollapsePlaceholder();
        List children = compoundNode.statements();
        compoundNode.setSourceRange(startPos, endPos - startPos);
        StructuralPropertyDescriptor childProperty = firstNode.getLocationInParent();
        ListRewriteEvent existingEvent = this.getRewriteEventStore().getListEvent(firstNode.getParent(), childProperty, false);
        if (existingEvent != null) {
            RewriteEvent[] origChildren = existingEvent.getChildren();
            Assert.isTrue(origChildren.length == list.size());
            RewriteEvent[] newChildren = new RewriteEvent[origChildren.length - length + 1];
            System.arraycopy(origChildren, 0, newChildren, 0, index);
            newChildren[index] = new NodeRewriteEvent((Object)compoundNode, (Object)compoundNode);
            System.arraycopy(origChildren, index + length, newChildren, index + 1, origChildren.length - index - length);
            this.getRewriteEventStore().addEvent(firstNode.getParent(), childProperty, (RewriteEvent)new ListRewriteEvent(newChildren));
            RewriteEvent[] newCollapsedChildren = new RewriteEvent[length];
            System.arraycopy(origChildren, index, newCollapsedChildren, 0, length);
            this.getRewriteEventStore().addEvent((ASTNode)compoundNode, (StructuralPropertyDescriptor)Block.STATEMENTS_PROPERTY, (RewriteEvent)new ListRewriteEvent(newCollapsedChildren));
        }
        for (int i = 0; i < length; ++i) {
            Object curr = list.remove(index);
            children.add(curr);
        }
        list.add(index, compoundNode);
        this.fHasASTModifications = true;
        return compoundNode;
    }

    private final void validateIsInsideAST(ASTNode node) {
        if (node.getStartPosition() == -1) {
            throw new IllegalArgumentException("Node is not an existing node");
        }
        if (node.getAST() != this.getAST()) {
            throw new IllegalArgumentException("Node is not inside the AST");
        }
    }

    public final boolean isInserted(ASTNode node) {
        return this.getChangeProperty(node) != null;
    }

    public boolean isRemoved(ASTNode node) {
        return this.getRewriteEventStore().getChangeKind(node) == 2;
    }

    public boolean isReplaced(ASTNode node) {
        return this.getRewriteEventStore().getChangeKind(node) == 4;
    }

    public final ASTNode getReplacingNode(ASTNode node) {
        RewriteEvent event = this.getRewriteEventStore().findEvent((Object)node, 2);
        if (event != null && event.getChangeKind() == 4) {
            return (ASTNode)event.getNewValue();
        }
        return null;
    }

    private final void setChangeProperty(ASTNode node, ASTInsert change) {
        this.fChangedProperties.put(node, change);
    }

    private final ASTInsert getChangeProperty(ASTNode node) {
        return (ASTInsert)this.fChangedProperties.get(node);
    }

    private static class ASTInsert {
        public TextEditGroup description;
        public boolean isBoundToPrevious;

        private ASTInsert() {
        }
    }
}

