/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.ui.cheatsheets.CheatSheetListener;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetEvent;

public class CheatSheetManager
implements ICheatSheetManager {
    private String cheatsheetID;
    private CheatSheetListener listener;
    private Hashtable dataTable = null;

    CheatSheetManager(CheatSheetElement element) {
        this.cheatsheetID = element.getID();
        this.listener = element.createListenerInstance();
    }

    public String getCheatSheetID() {
        return this.cheatsheetID;
    }

    void fireEvent(int eventType) {
        if (this.listener == null) {
            return;
        }
        CheatSheetEvent event = new CheatSheetEvent(eventType, this.cheatsheetID, this);
        this.listener.cheatSheetEvent(event);
    }

    public Map getData() {
        return this.dataTable;
    }

    public String getData(String key) {
        if (this.dataTable == null) {
            return null;
        }
        return (String)this.dataTable.get(key);
    }

    public String getVariableData(String variable) {
        String result = variable;
        if (variable != null && variable.startsWith("${") && variable.endsWith("}")) {
            result = variable.substring(2, variable.length() - 1);
            result = this.getData(result);
        }
        return result;
    }

    void setData(Hashtable data) {
        this.dataTable = data;
    }

    public void setData(String key, String data) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (data == null && this.dataTable != null) {
            this.dataTable.remove(key);
            return;
        }
        if (this.dataTable == null) {
            this.dataTable = new Hashtable(30);
        }
        this.dataTable.put(key, data);
    }
}

