/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class TreeDragUnderEffect
extends DragUnderEffect {
    private Tree tree;
    private int currentEffect = 0;
    private TreeItem dropSelection = null;
    private PaintListener paintListener;
    private TreeItem insertMark = null;
    private boolean insertBefore = false;
    private TreeItem scrollItem;
    private long scrollBeginTime;
    private static final int SCROLL_HYSTERESIS = 600;
    private TreeItem expandItem;
    private long expandBeginTime;
    private static final int EXPAND_HYSTERESIS = 1000;

    TreeDragUnderEffect(Tree tree) {
        this.tree = tree;
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (TreeDragUnderEffect.this.dropSelection == null || TreeDragUnderEffect.this.dropSelection.isDisposed()) {
                    return;
                }
                GC gc = e.gc;
                Color foreground = gc.getForeground();
                Display display = e.widget.getDisplay();
                gc.setForeground(display.getSystemColor(20));
                Rectangle bounds = TreeDragUnderEffect.this.dropSelection.getBounds();
                gc.drawRectangle(bounds.x + 1, bounds.y + 1, bounds.width - 3, bounds.height - 3);
                gc.setForeground(foreground);
            }
        };
    }

    void show(int effect, int x, int y) {
        effect = this.checkEffect(effect);
        TreeItem item = this.findItem(x, y);
        if (item == null) {
            effect = 0;
        }
        if (this.currentEffect == 0 && effect != 0) {
            this.tree.addPaintListener(this.paintListener);
        }
        this.scrollHover(effect, item, x, y);
        this.expandHover(effect, item, x, y);
        this.setDragUnderEffect(effect, item);
        if (this.currentEffect != 0 && effect == 0) {
            this.tree.removePaintListener(this.paintListener);
        }
        this.currentEffect = effect;
    }

    private int checkEffect(int effect) {
        int mask = 7;
        int bits = effect & mask;
        if (bits == 4 || bits == 2 || bits == 1) {
            return effect;
        }
        return effect & ~mask;
    }

    private TreeItem findItem(int x, int y) {
        Point pt;
        Point coordinates = new Point(x, y);
        coordinates = this.tree.toControl(coordinates);
        Rectangle area = this.tree.getClientArea();
        if (!area.contains(coordinates)) {
            return null;
        }
        TreeItem item = this.tree.getItem(coordinates);
        if (item != null) {
            return item;
        }
        for (int x1 = area.x; x1 < area.x + area.width; ++x1) {
            pt = new Point(x1, coordinates.y);
            item = this.tree.getItem(pt);
            if (item == null) continue;
            return item;
        }
        if (coordinates.y > area.y + area.height - this.tree.getItemHeight()) {
            int y1 = area.y + area.height - this.tree.getItemHeight();
            pt = new Point(coordinates.x, y1);
            item = this.tree.getItem(pt);
            if (item != null) {
                return item;
            }
            for (int x1 = area.x; x1 < area.x + area.width; ++x1) {
                pt = new Point(x1, y1);
                item = this.tree.getItem(pt);
                if (item == null) continue;
                return item;
            }
        }
        return null;
    }

    private void setDragUnderEffect(int effect, TreeItem item) {
        if ((effect & 1) != 0) {
            if ((this.currentEffect & 4) != 0 || (this.currentEffect & 2) != 0) {
                this.tree.setInsertMark(null, false);
            }
            this.setDropSelection(item);
            return;
        }
        if ((effect & 4) != 0 || (effect & 2) != 0) {
            if ((this.currentEffect & 1) != 0) {
                this.setDropSelection(null);
            }
            this.setInsertMark(item, (effect & 2) != 0);
            return;
        }
        if ((this.currentEffect & 4) != 0 || (this.currentEffect & 2) != 0) {
            this.tree.setInsertMark(null, false);
        }
        if ((this.currentEffect & 1) != 0) {
            this.setDropSelection(null);
        }
    }

    private void setDropSelection(TreeItem item) {
        Rectangle bounds;
        if (item == this.dropSelection) {
            return;
        }
        if (this.dropSelection != null && !this.dropSelection.isDisposed()) {
            bounds = this.dropSelection.getBounds();
            this.tree.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
        }
        this.dropSelection = item;
        if (this.dropSelection != null && !this.dropSelection.isDisposed()) {
            bounds = this.dropSelection.getBounds();
            this.tree.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
        }
    }

    private void setInsertMark(TreeItem item, boolean before) {
        if (item == this.insertMark && before == this.insertBefore) {
            return;
        }
        this.insertMark = item;
        this.insertBefore = before;
        this.tree.setInsertMark(item, before);
    }

    private void scrollHover(int effect, TreeItem item, int x, int y) {
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
            return;
        }
        if (this.scrollItem == item && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                this.scroll(item, x, y);
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
            return;
        }
        this.scrollBeginTime = System.currentTimeMillis() + 600L;
        this.scrollItem = item;
    }

    private void scroll(TreeItem item, int x, int y) {
        if (item == null) {
            return;
        }
        Point coordinates = new Point(x, y);
        coordinates = this.tree.toControl(coordinates);
        Rectangle area = this.tree.getClientArea();
        TreeItem showItem = null;
        int scroll_width = 2 * this.tree.getItemHeight();
        if (coordinates.y < area.y + scroll_width) {
            showItem = this.getPreviousVisibleItem(item);
        } else if (coordinates.y > area.y + area.height - scroll_width) {
            showItem = this.getNextVisibleItem(item, true);
        }
        if (showItem != null) {
            this.tree.showItem(showItem);
        }
    }

    private void expandHover(int effect, TreeItem item, int x, int y) {
        if ((effect & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandItem = null;
            return;
        }
        if (this.expandItem == item && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                this.expand(item, x, y);
                this.expandBeginTime = 0L;
                this.expandItem = null;
            }
            return;
        }
        this.expandBeginTime = System.currentTimeMillis() + 1000L;
        this.expandItem = item;
    }

    private void expand(TreeItem item, int x, int y) {
        if (item == null || item.getExpanded()) {
            return;
        }
        Event event = new Event();
        event.x = x;
        event.y = y;
        event.item = item;
        event.time = (int)System.currentTimeMillis();
        this.tree.notifyListeners(17, event);
        if (item.isDisposed()) {
            return;
        }
        item.setExpanded(true);
    }

    private TreeItem getNextVisibleItem(TreeItem item, boolean includeChildren) {
        if (includeChildren && item.getItemCount() > 0 && item.getExpanded()) {
            return item.getItems()[0];
        }
        TreeItem parent = item.getParentItem();
        TreeItem[] peers = parent != null ? parent.getItems() : this.tree.getItems();
        for (int i = 0; i < peers.length - 1; ++i) {
            if (peers[i] != item) continue;
            return peers[i + 1];
        }
        if (parent != null) {
            return this.getNextVisibleItem(parent, false);
        }
        return null;
    }

    private TreeItem getPreviousVisibleItem(TreeItem item) {
        TreeItem parent = item.getParentItem();
        TreeItem[] peers = parent != null ? parent.getItems() : this.tree.getItems();
        for (int i = peers.length - 1; i > 0; --i) {
            if (peers[i] != item) continue;
            TreeItem peer = peers[i - 1];
            if (!peer.getExpanded() || peer.getItemCount() == 0) {
                return peer;
            }
            TreeItem[] peerItems = peer.getItems();
            return peerItems[peerItems.length - 1];
        }
        return parent;
    }
}

