/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.Properties;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassInfo;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;

public class NLSSubstitution {
    public static final int EXTERNALIZED = 0;
    public static final int IGNORED = 1;
    public static final int INTERNALIZED = 2;
    public static final int DEFAULT = 0;
    public static final int STATE_COUNT = 3;
    private int fState;
    private String fKey;
    private String fValue;
    private int fInitialState;
    private String fInitialKey;
    private String fInitialValue;
    private NLSElement fNLSElement;
    private AccessorClassInfo fAccessorClassInfo;
    private String fNewAccessorClassName;
    private static String fPrefix = "";

    public NLSSubstitution(int state, String value, NLSElement element) {
        this.fNLSElement = element;
        this.fValue = value;
        this.fState = state;
        this.fInitialState = state;
        this.fInitialValue = value;
        Assert.isTrue(state == 0 || state == 1 || state == 2);
    }

    public NLSSubstitution(int state, String key, String value, NLSElement element, AccessorClassInfo accessorClassInfo) {
        this(state, value, element);
        if (state != 0) {
            throw new IllegalArgumentException("Set to INTERNALIZE/IGNORED State with different Constructor");
        }
        this.fKey = key;
        this.fInitialKey = key;
        this.fAccessorClassInfo = accessorClassInfo;
        this.fNewAccessorClassName = null;
    }

    public static int countItems(NLSSubstitution[] elems, int task) {
        Assert.isTrue(task == 0 || task == 1 || task == 2);
        int result = 0;
        for (int i = 0; i < elems.length; ++i) {
            if (elems[i].fState != task) continue;
            ++result;
        }
        return result;
    }

    public NLSElement getNLSElement() {
        return this.fNLSElement;
    }

    public String getKeyWithoutPrefix() {
        return this.fKey;
    }

    public String getKey() {
        if (this.fState == 0 && this.hasStateChanged()) {
            return fPrefix + this.fKey;
        }
        return this.fKey;
    }

    public void setKey(String key) {
        if (this.fState != 0) {
            throw new IllegalStateException("Must be in Externalized State !");
        }
        this.fKey = key;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public void setInitialValue(String value) {
        this.fInitialValue = value;
    }

    public String getValue() {
        return this.fValue;
    }

    public String getValueNonEmpty() {
        if (this.fValue == null) {
            return "";
        }
        return this.fValue;
    }

    public int getState() {
        return this.fState;
    }

    public void setState(int state) {
        this.fState = state;
    }

    public void setUpdatedAccessor(String accessorClassName) {
        this.fNewAccessorClassName = accessorClassName;
    }

    public String getUpdatedAccessor() {
        return this.fNewAccessorClassName;
    }

    public boolean hasStateChanged() {
        return this.fState != this.fInitialState;
    }

    public boolean isKeyRename() {
        return this.fInitialKey != null && !this.fInitialKey.equals(this.fKey);
    }

    public boolean isValueRename() {
        return this.fInitialValue != null && !this.fInitialValue.equals(this.fValue);
    }

    public boolean isAccessorRename() {
        return this.fAccessorClassInfo != null && this.fNewAccessorClassName != null && !this.fNewAccessorClassName.equals(this.fAccessorClassInfo.getName());
    }

    public boolean hasPropertyFileChange() {
        if (this.fInitialState != 0 && this.fState != 0) {
            return false;
        }
        if (this.fInitialState != this.fState) {
            return true;
        }
        if (this.fState == 0) {
            if (this.fInitialValue == null) {
                return true;
            }
            if (!this.fInitialValue.equals(this.fValue)) {
                return true;
            }
            if (!this.fInitialKey.equals(this.fKey)) {
                return true;
            }
        }
        return false;
    }

    public boolean hasSourceChange() {
        if (this.hasStateChanged()) {
            return true;
        }
        if (this.fState == 0) {
            if (!this.fInitialKey.equals(this.fKey)) {
                return true;
            }
            if (this.isAccessorRename()) {
                return true;
            }
        } else if (!this.fInitialValue.equals(this.fValue)) {
            return true;
        }
        return false;
    }

    public int getInitialState() {
        return this.fInitialState;
    }

    public String getInitialKey() {
        return this.fInitialKey;
    }

    public String getInitialValue() {
        return this.fInitialValue;
    }

    public AccessorClassInfo getAccessorClassInfo() {
        return this.fAccessorClassInfo;
    }

    public static void setPrefix(String prefix) {
        fPrefix = prefix;
    }

    public boolean isConflicting(NLSSubstitution[] substitutions) {
        if (this.fState == 0) {
            String currKey = this.getKey();
            String currValue = this.getValueNonEmpty();
            for (int i = 0; i < substitutions.length; ++i) {
                NLSSubstitution substitution = substitutions[i];
                if (substitution == this || substitution.getState() != 0 || !currKey.equals(substitution.getKey()) || currValue.equals(substitution.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public void generateKey(NLSSubstitution[] substitutions) {
        if (this.fState != 0 || this.fState == 0 && this.hasStateChanged()) {
            int i;
            int counter = 0;
            this.fKey = this.createKey(counter);
            block0: do {
                for (i = 0; i < substitutions.length; ++i) {
                    NLSSubstitution substitution = substitutions[i];
                    if (substitution == this || substitution.fState != 0 || !substitution.getKey().equals(this.getKey())) continue;
                    this.fKey = this.createKey(counter++);
                    continue block0;
                }
            } while (i != substitutions.length);
            return;
        }
    }

    public static void updateSubtitutions(NLSSubstitution[] substitutions, Properties props, String accessorClassName) {
        for (int i = 0; i < substitutions.length; ++i) {
            NLSSubstitution substitution = substitutions[i];
            if (substitution.getState() != 0 || substitution.hasStateChanged()) continue;
            substitution.setInitialValue(props.getProperty(substitution.getKey()));
            substitution.setUpdatedAccessor(accessorClassName);
        }
    }

    public void revert() {
        this.fState = this.fInitialState;
        this.fKey = this.fInitialKey;
        this.fValue = this.fInitialValue;
    }

    private String createKey(int counter) {
        return String.valueOf(counter);
    }
}

