/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTempRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameRefactoringWizard;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.IWorkbenchSite;

public class RenameTempAction
extends SelectionDispatchAction {
    private final CompilationUnitEditor fEditor;
    private static final String DIALOG_MESSAGE_TITLE = RefactoringMessages.getString("RenameTempAction.rename_Local_Variable");

    public RenameTempAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.getString("RenameTempAction.rename_Local_Variable"));
        this.fEditor = editor;
        this.setEnabled(this.fEditor != null && this.getCompilationUnit() != null);
    }

    private static RenameTempRefactoring createRefactoring(ICompilationUnit cunit, ITextSelection selection) {
        return RenameTempRefactoring.create(cunit, selection.getOffset(), selection.getLength());
    }

    private static RefactoringWizard createWizard(RenameTempRefactoring refactoring) {
        String message = RefactoringMessages.getString("RenameTempAction.choose_new_name");
        String wizardPageHelp = "org.eclipse.jdt.ui.rename_local_variable_wizard_page_context";
        String pageTitle = RefactoringMessages.getString("RenameTempAction.rename_Local_Variable");
        RenameRefactoringWizard result = new RenameRefactoringWizard(refactoring, pageTitle, message, null, wizardPageHelp);
        return result;
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            IJavaElement[] elements = selection.resolveElementAtOffset();
            if (elements.length != 1) {
                this.setEnabled(false);
            } else {
                this.setEnabled(RenameTempRefactoring.isAvailable(elements[0]));
            }
        }
        catch (CoreException e) {
            this.setEnabled(false);
        }
    }

    public boolean canRun(ITextSelection selection) {
        this.selectionChanged(selection);
        if (!this.isEnabled()) {
            return false;
        }
        if (this.getCompilationUnit() == null) {
            return false;
        }
        RenameTempRefactoring renameTempRefactoring = RenameTempAction.createRefactoring(this.getCompilationUnit(), selection);
        if (renameTempRefactoring == null) {
            return false;
        }
        try {
            return renameTempRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK();
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.getString("RenameTempAction.rename_Local_Variable"), RefactoringMessages.getString("RenameTempAction.exception"));
            return false;
        }
    }

    public void run(ITextSelection selection) {
        try {
            ICompilationUnit input = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
            if (!ActionUtil.isProcessable(this.getShell(), input)) {
                return;
            }
            RenameTempRefactoring refactoring = RenameTempAction.createRefactoring(input, selection);
            if (refactoring == null) {
                return;
            }
            new RefactoringStarter().activate(refactoring, RenameTempAction.createWizard(refactoring), this.getShell(), DIALOG_MESSAGE_TITLE, false);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), DIALOG_MESSAGE_TITLE, RefactoringMessages.getString("NewTextRefactoringAction.exception"));
        }
    }

    private ICompilationUnit getCompilationUnit() {
        return SelectionConverter.getInputAsCompilationUnit(this.fEditor);
    }
}

