/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.code.IntroduceParameterRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.IntroduceParameterWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class IntroduceParameterAction
extends SelectionDispatchAction {
    private final CompilationUnitEditor fEditor;
    private static final String DIALOG_MESSAGE_TITLE = RefactoringMessages.getString("IntroduceParameterAction.dialog_title");

    public IntroduceParameterAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.getString("IntroduceParameterAction.label"));
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.introduce_parameter_action");
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(ITextSelection selection) {
        return this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null;
    }

    public void selectionChanged(JavaTextSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private boolean canEnable(JavaTextSelection selection) {
        return selection.resolveInMethodBody() && IntroduceParameterRefactoring.isAvailable(selection.resolveSelectedNodes(), selection.resolveCoveringNode());
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            IntroduceParameterRefactoring refactoring = IntroduceParameterAction.createRefactoring(SelectionConverter.getInputAsCompilationUnit(this.fEditor), selection);
            if (refactoring == null) {
                return;
            }
            new RefactoringStarter().activate(refactoring, IntroduceParameterAction.createWizard(refactoring), this.getShell(), DIALOG_MESSAGE_TITLE, true);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, DIALOG_MESSAGE_TITLE, RefactoringMessages.getString("NewTextRefactoringAction.exception"));
        }
    }

    private static IntroduceParameterRefactoring createRefactoring(ICompilationUnit cunit, ITextSelection selection) {
        return IntroduceParameterRefactoring.create(cunit, selection.getOffset(), selection.getLength());
    }

    private static RefactoringWizard createWizard(IntroduceParameterRefactoring refactoring) {
        return new IntroduceParameterWizard(refactoring);
    }
}

