/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchManager;

public class Launch
extends PlatformObject
implements ILaunch,
IDisconnect,
ILaunchListener,
ILaunchConfigurationListener,
IDebugEventSetListener {
    private List fTargets = new ArrayList();
    private ILaunchConfiguration fConfiguration = null;
    private List fProcesses = new ArrayList();
    private ISourceLocator fLocator = null;
    private String fMode;
    private HashMap fAttributes;
    private boolean fSuppressChange = true;

    public Launch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        this.setLaunchConfiguration(launchConfiguration);
        this.setSourceLocator(locator);
        this.setLaunchMode(mode);
        this.fSuppressChange = false;
        this.getLaunchManager().addLaunchListener(this);
        this.getLaunchManager().addLaunchConfigurationListener(this);
        DebugPlugin.getDefault().addDebugEventListener(this);
    }

    public final boolean canTerminate() {
        List processes = this.getProcesses0();
        for (int i = 0; i < processes.size(); ++i) {
            IProcess process = (IProcess)processes.get(i);
            if (!process.canTerminate()) continue;
            return true;
        }
        List targets = this.getDebugTargets0();
        for (int i = 0; i < targets.size(); ++i) {
            IDebugTarget target = (IDebugTarget)targets.get(i);
            if (!target.canTerminate() && !target.canDisconnect()) continue;
            return true;
        }
        return false;
    }

    public final Object[] getChildren() {
        ArrayList children = new ArrayList(this.getDebugTargets0());
        children.addAll(this.getProcesses0());
        return children.toArray();
    }

    public final IDebugTarget getDebugTarget() {
        if (!this.getDebugTargets0().isEmpty()) {
            return (IDebugTarget)this.getDebugTargets0().get(0);
        }
        return null;
    }

    private void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.fConfiguration = configuration;
    }

    public final IProcess[] getProcesses() {
        return this.getProcesses0().toArray(new IProcess[this.getProcesses0().size()]);
    }

    protected List getProcesses0() {
        return this.fProcesses;
    }

    public final ISourceLocator getSourceLocator() {
        return this.fLocator;
    }

    public final void setSourceLocator(ISourceLocator sourceLocator) {
        this.fLocator = sourceLocator;
    }

    public final boolean isTerminated() {
        if (this.getProcesses0().isEmpty() && this.getDebugTargets0().isEmpty()) {
            return false;
        }
        Iterator processes = this.getProcesses0().iterator();
        while (processes.hasNext()) {
            IProcess process = (IProcess)processes.next();
            if (process.isTerminated()) continue;
            return false;
        }
        Iterator targets = this.getDebugTargets0().iterator();
        while (targets.hasNext()) {
            IDebugTarget target = (IDebugTarget)targets.next();
            if (target.isTerminated() || target.isDisconnected()) continue;
            return false;
        }
        return true;
    }

    public final void terminate() throws DebugException {
        MultiStatus status = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.getString("Launch.terminate_failed"), null);
        IProcess[] processes = this.getProcesses();
        for (int i = 0; i < processes.length; ++i) {
            IProcess process = processes[i];
            if (!process.canTerminate()) continue;
            try {
                process.terminate();
                continue;
            }
            catch (DebugException e) {
                status.merge(e.getStatus());
            }
        }
        IDebugTarget[] targets = this.getDebugTargets();
        for (int i = 0; i < targets.length; ++i) {
            IDebugTarget target = targets[i];
            if (target == null) continue;
            if (target.canTerminate()) {
                try {
                    target.terminate();
                }
                catch (DebugException e) {
                    status.merge(e.getStatus());
                }
                continue;
            }
            if (!target.canDisconnect()) continue;
            try {
                target.disconnect();
                continue;
            }
            catch (DebugException de) {
                status.merge(de.getStatus());
            }
        }
        if (status.isOK()) {
            return;
        }
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            throw new DebugException(children[0]);
        }
        throw new DebugException((IStatus)status);
    }

    public final String getLaunchMode() {
        return this.fMode;
    }

    private void setLaunchMode(String mode) {
        this.fMode = mode;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.fConfiguration;
    }

    public void setAttribute(String key, String value) {
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap(5);
        }
        this.fAttributes.put(key, value);
    }

    public String getAttribute(String key) {
        if (this.fAttributes == null) {
            return null;
        }
        return (String)this.fAttributes.get(key);
    }

    public IDebugTarget[] getDebugTargets() {
        return this.fTargets.toArray(new IDebugTarget[this.fTargets.size()]);
    }

    protected List getDebugTargets0() {
        return this.fTargets;
    }

    public final void addDebugTarget(IDebugTarget target) {
        if (target != null && !this.getDebugTargets0().contains(target)) {
            this.getDebugTargets0().add(target);
            this.fireChanged();
        }
    }

    public final void removeDebugTarget(IDebugTarget target) {
        if (target != null && this.getDebugTargets0().remove(target)) {
            this.fireChanged();
        }
    }

    public final void addProcess(IProcess process) {
        if (process != null && !this.getProcesses0().contains(process)) {
            this.getProcesses0().add(process);
            this.fireChanged();
        }
    }

    public final void removeProcess(IProcess process) {
        if (process != null && this.getProcesses0().remove(process)) {
            this.fireChanged();
        }
    }

    protected void addProcesses(IProcess[] processes) {
        if (processes != null) {
            for (int i = 0; i < processes.length; ++i) {
                this.addProcess(processes[i]);
                this.fireChanged();
            }
        }
    }

    protected void fireChanged() {
        if (!this.fSuppressChange) {
            ((LaunchManager)this.getLaunchManager()).fireUpdate(this, 2);
            ((LaunchManager)this.getLaunchManager()).fireUpdate(new ILaunch[]{this}, 2);
        }
    }

    protected void fireTerminate() {
        if (!this.fSuppressChange) {
            ((LaunchManager)this.getLaunchManager()).fireUpdate(this, 3);
            ((LaunchManager)this.getLaunchManager()).fireUpdate(new ILaunch[]{this}, 3);
        }
    }

    public boolean hasChildren() {
        return this.getProcesses0().size() > 0 || this.getDebugTargets0().size() > 0;
    }

    public boolean canDisconnect() {
        if (this.getDebugTargets0().size() == 1) {
            return this.getDebugTarget().canDisconnect();
        }
        return false;
    }

    public void disconnect() throws DebugException {
        if (this.getDebugTargets0().size() == 1) {
            this.getDebugTarget().disconnect();
        }
    }

    public boolean isDisconnected() {
        if (this.getDebugTargets0().size() == 1) {
            this.getDebugTarget().isDisconnected();
        }
        return false;
    }

    public void launchRemoved(ILaunch launch) {
        if (this.equals(launch)) {
            this.getLaunchManager().removeLaunchListener(this);
            this.getLaunchManager().removeLaunchConfigurationListener(this);
            DebugPlugin.getDefault().removeDebugEventListener(this);
        }
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        ILaunchConfiguration from = this.getLaunchManager().getMovedFrom(configuration);
        if (from != null && from.equals(this.getLaunchConfiguration())) {
            this.setLaunchConfiguration(configuration);
            this.fireChanged();
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        if (configuration.equals(this.getLaunchConfiguration()) && this.getLaunchManager().getMovedTo(configuration) == null) {
            this.setLaunchConfiguration(null);
            this.fireChanged();
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            DebugEvent event = events[i];
            if (event.getKind() != 8) continue;
            Object object = event.getSource();
            ILaunch launch = null;
            if (object instanceof IProcess) {
                launch = ((IProcess)object).getLaunch();
            } else if (object instanceof IDebugTarget) {
                launch = ((IDebugTarget)object).getLaunch();
            }
            if (!this.equals(launch) || !this.isTerminated()) continue;
            this.fireTerminate();
        }
    }
}

