/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.text.GotoMarkerAction;
import org.eclipse.search.internal.ui.text.GroupByKeyComputer;
import org.eclipse.search.internal.ui.text.TextSearchActionGroup;
import org.eclipse.search.internal.ui.text.TextSearchOperation;
import org.eclipse.search.internal.ui.util.FileLabelProvider;
import org.eclipse.search.ui.IActionGroupFactory;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.ui.actions.ActionGroup;

public class TextSearchResultCollector
implements ITextSearchResultCollector {
    private static final String MATCH = SearchMessages.getString("SearchResultCollector.match");
    private static final String MATCHES = SearchMessages.getString("SearchResultCollector.matches");
    private static final String DONE = SearchMessages.getString("SearchResultCollector.done");
    private IProgressMonitor fMonitor;
    private ISearchResultView fView;
    private TextSearchOperation fOperation;
    private int fMatchCount = 0;
    private Integer[] fMessageFormatArgs = new Integer[1];
    private long fLastUpdateTime;

    public IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    void setProgressMonitor(IProgressMonitor pm) {
        this.fMonitor = pm;
    }

    public void aboutToStart() throws CoreException {
        this.fView = SearchUI.getSearchResultView();
        this.fMatchCount = 0;
        this.fLastUpdateTime = 0L;
        if (this.fView != null) {
            this.fView.searchStarted(new TextSearchActionGroupFactory(), this.fOperation.getSingularLabel(), this.fOperation.getPluralLabelPattern(), this.fOperation.getImageDescriptor(), "org.eclipse.search.internal.ui.text.TextSearchPage", (ILabelProvider)new FileLabelProvider(2), (IAction)new GotoMarkerAction(), (IGroupByKeyComputer)new GroupByKeyComputer(), (IRunnableWithProgress)this.fOperation);
        }
    }

    public void accept(IResourceProxy proxy, String line, int start, int length, int lineNumber) throws CoreException {
        IResource resource = proxy.requestResource();
        IMarker marker = resource.createMarker("org.eclipse.search.searchmarker");
        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
        attributes.put("line", line);
        attributes.put("charStart", new Integer(start));
        attributes.put("charEnd", new Integer(start + length));
        attributes.put("lineNumber", new Integer(lineNumber));
        marker.setAttributes(attributes);
        String description = resource.getFullPath().lastSegment();
        if (description == null) {
            description = "";
        }
        this.fView.addMatch(description, resource, resource, marker);
        ++this.fMatchCount;
        if (!this.getProgressMonitor().isCanceled() && System.currentTimeMillis() - this.fLastUpdateTime > 1000L) {
            this.getProgressMonitor().subTask(this.getFormattedMatchesString(this.fMatchCount));
            this.fLastUpdateTime = System.currentTimeMillis();
        }
    }

    public void done() {
        if (!this.getProgressMonitor().isCanceled()) {
            String matchesString = this.getFormattedMatchesString(this.fMatchCount);
            this.getProgressMonitor().setTaskName(MessageFormat.format(DONE, matchesString));
        }
        if (this.fView != null) {
            this.fView.searchFinished();
        }
        this.fView = null;
        this.fMonitor = null;
    }

    void setOperation(TextSearchOperation operation) {
        this.fOperation = operation;
    }

    private String getFormattedMatchesString(int count) {
        if (this.fMatchCount == 1) {
            return MATCH;
        }
        this.fMessageFormatArgs[0] = new Integer(count);
        return MessageFormat.format(MATCHES, this.fMessageFormatArgs);
    }

    private static class TextSearchActionGroupFactory
    implements IActionGroupFactory {
        private TextSearchActionGroupFactory() {
        }

        public ActionGroup createActionGroup(ISearchResultView part) {
            return new TextSearchActionGroup(part);
        }
    }
}

