/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.model.ConfigurationActivityModel;

public class UpdateManagerLogWriter {
    private File logFile = null;
    private Writer log = null;
    private static final String CONFIGURATION = "!CONFIGURATION";
    private static final String ACTIVITY = "!ACTIVITY";
    private static final String SUCCESS = "success";
    private static final String FAILURE = "failure";
    private static final String FEATURE_INSTALL = "feature-install";
    private static final String FEATURE_REMOVE = "feature-remove";
    private static final String SITE_INSTALL = "site-install";
    private static final String SITE_REMOVE = "site-remove";
    private static final String UNCONFIGURE = "feature-disable";
    private static final String CONFIGURE = "feature-enable";
    private static final String REVERT = "revert";
    private static final String RECONCILIATION = "reconciliation";
    private static final String PRESERVED = "preserve-configuration";
    private static final String UNKNOWN = "unknown";
    private static final String LINE_SEPARATOR;

    public UpdateManagerLogWriter(File file) {
        this.logFile = file;
        UpdateCore.warn("UPDATE MANAGER LOG Location: " + file.getAbsolutePath());
        if (!file.exists()) {
            this.initLog();
        }
    }

    private void initLog() {
        try {
            IPlatformConfiguration runtimeConfig = ConfiguratorUtils.getCurrentPlatformConfiguration();
            IPlatformConfiguration.ISiteEntry[] sites = runtimeConfig.getConfiguredSites();
            IActivity[] activities = new ConfigurationActivity[sites.length];
            for (int i = 0; i < sites.length; ++i) {
                activities[i] = new ConfigurationActivity(3);
                activities[i].setLabel(Platform.asLocalURL((URL)sites[i].getURL()).toExternalForm());
                ((ConfigurationActivityModel)((Object)activities[i])).setDate(new Date());
                ((ConfigurationActivityModel)((Object)activities[i])).setStatus(0);
            }
            Date date = new Date(runtimeConfig.getChangeStamp());
            this.safeWriteConfiguration(date, activities);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLogFile() throws IOException {
        try {
            if (this.log != null) {
                this.log.flush();
                this.log.close();
            }
        }
        finally {
            this.log = null;
        }
    }

    public void log(IInstallConfiguration installConfig) {
        this.safeWriteConfiguration(installConfig.getCreationDate(), installConfig.getActivities());
    }

    private void openLogFile() {
        try {
            this.log = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile.getAbsolutePath(), true), "UTF-8"));
        }
        catch (IOException e) {
            this.log = this.logForStream(System.err);
        }
    }

    private String getFormattedDate(Date date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy kk:mm:ss.SS");
            return formatter.format(date);
        }
        catch (Exception exception) {
            return Long.toString(System.currentTimeMillis());
        }
    }

    private Writer logForStream(OutputStream output) {
        try {
            return new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return new BufferedWriter(new OutputStreamWriter(output));
        }
    }

    public synchronized void shutdown() {
        try {
            if (this.logFile != null) {
                this.closeLogFile();
                this.logFile = null;
            } else if (this.log != null) {
                Writer old = this.log;
                this.log = null;
                old.flush();
                old.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void safeWriteConfiguration(Date date, IActivity[] activities) {
        if (this.logFile != null) {
            this.openLogFile();
        }
        if (this.log == null) {
            this.log = this.logForStream(System.err);
        }
        try {
            block12: {
                try {
                    this.write(date, activities);
                    Object var4_3 = null;
                    if (this.logFile == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (this.logFile != null) {
                        this.closeLogFile();
                        throw throwable;
                    }
                    this.log.flush();
                    throw throwable;
                }
                this.closeLogFile();
                return;
            }
            this.log.flush();
            return;
        }
        catch (Exception e) {
            System.err.println("An exception occurred while writing to the update manager log:");
            e.printStackTrace(System.err);
            System.err.println("Logging to the console instead.");
            try {
                this.log = this.logForStream(System.err);
                this.write(date, activities);
                this.log.flush();
                return;
            }
            catch (Exception e2) {
                System.err.println("An exception occurred while logging to the console:");
                e2.printStackTrace(System.err);
                return;
            }
        }
        finally {
            this.log = null;
        }
    }

    private void write(Date date, IActivity[] activities) throws IOException {
        this.writeln();
        this.write(CONFIGURATION);
        this.writeSpace();
        this.write(String.valueOf(date.getTime()));
        this.writeSpace();
        this.write(date.toString());
        this.writeln();
        for (int i = 0; i < activities.length; ++i) {
            this.write(activities[i]);
        }
    }

    private void write(IActivity activity) throws IOException {
        this.write(ACTIVITY);
        this.writeSpace();
        this.write(String.valueOf(activity.getDate().getTime()));
        this.writeSpace();
        this.write(this.getFormattedDate(activity.getDate()));
        this.writeSpace();
        this.write(activity.getLabel());
        this.writeSpace();
        this.write(this.getAction(activity.getAction()));
        this.writeSpace();
        this.write(activity.getStatus() == 0 ? SUCCESS : FAILURE);
        this.writeln();
    }

    private String getAction(int i) {
        switch (i) {
            case 1: {
                return FEATURE_INSTALL;
            }
            case 2: {
                return FEATURE_REMOVE;
            }
            case 3: {
                return SITE_INSTALL;
            }
            case 4: {
                return SITE_REMOVE;
            }
            case 5: {
                return UNCONFIGURE;
            }
            case 6: {
                return CONFIGURE;
            }
            case 7: {
                return REVERT;
            }
            case 8: {
                return RECONCILIATION;
            }
            case 9: {
                return PRESERVED;
            }
        }
        return "unknown [" + i + "]";
    }

    private void writeln() throws IOException {
        this.write(LINE_SEPARATOR);
    }

    private void write(String message) throws IOException {
        if (message != null) {
            this.log.write(message);
        }
    }

    private void writeSpace() throws IOException {
        this.write(" ");
    }

    static {
        String s = System.getProperty("line.separator");
        LINE_SEPARATOR = s == null ? "\n" : s;
    }
}

