/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.ConfiguredFeatureAdapter;
import org.eclipse.update.operations.IUninstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class UninstallFeatureAction
extends Action {
    private ConfiguredFeatureAdapter adapter;

    public UninstallFeatureAction(String text) {
        super(text);
    }

    public void run() {
        try {
            IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
            if (status != null) {
                throw new CoreException(status);
            }
            if (this.adapter == null || !this.confirm(UpdateUI.getString("FeatureUninstallAction.uninstallQuestion"))) {
                return;
            }
            if (OperationsManager.getValidator().validateCurrentState() != null && !this.confirm(UpdateUI.getString("Actions.brokenConfigQuestion"))) {
                return;
            }
            IUninstallFeatureOperation uninstallOperation = OperationsManager.getOperationFactory().createUninstallOperation(this.adapter.getConfiguredSite(), this.adapter.getFeature(null));
            boolean restartNeeded = uninstallOperation.execute(null, null);
            UpdateUI.requestRestart(restartNeeded);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)UpdateUI.getActiveWorkbenchShell(), null, null, (IStatus)e.getStatus());
        }
        catch (InvocationTargetException e) {
            UpdateUtils.logException((Throwable)e.getTargetException());
        }
    }

    private boolean confirm(String message) {
        return MessageDialog.openConfirm((Shell)UpdateUI.getActiveWorkbenchShell(), (String)UpdateUI.getString("FeatureUninstallAction.dialogTitle"), (String)message);
    }

    public void setFeature(ConfiguredFeatureAdapter adapter) {
        this.adapter = adapter;
        this.setText(UpdateUI.getString("FeatureUninstallAction.uninstall"));
    }

    public boolean canUninstall() {
        if (this.adapter == null) {
            return false;
        }
        try {
            if (InstallRegistry.getInstance().get((Object)("feature_" + this.adapter.getFeature(null).getVersionedIdentifier())) == null) {
                return false;
            }
        }
        catch (CoreException e) {
            return false;
        }
        return true;
    }
}

