/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.misc;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.Category;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.registry.Capability;
import org.eclipse.ui.internal.ide.registry.CapabilityRegistry;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectCapabilitySelectionGroup {
    private static final String EMPTY_DESCRIPTION = "\n\n\n";
    private CapabilityRegistry registry;
    private Category[] initialCategories;
    private Capability[] initialCapabilities;
    private Capability[] disabledCapabilities;
    private boolean modified = false;
    private Text descriptionText;
    private CheckboxTableViewer checkboxViewer;
    private ICheckStateListener checkStateListener;
    private ArrayList visibleCapabilities = new ArrayList();
    private ArrayList checkedCapabilities = new ArrayList();
    private Collection disabledCaps;
    private HashMap dependents = new HashMap();
    private HashMap memberships = new HashMap();
    private Comparator categoryComparator = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object ob1, Object ob2) {
            Category c1 = (Category)((Object)ob1);
            Category c2 = (Category)((Object)ob2);
            return this.collator.compare(c1.getLabel(), c2.getLabel());
        }
    };
    private Comparator capabilityComparator = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object ob1, Object ob2) {
            Capability c1 = (Capability)((Object)ob1);
            Capability c2 = (Capability)((Object)ob2);
            return this.collator.compare(c1.getName(), c2.getName());
        }
    };

    public ProjectCapabilitySelectionGroup(Category[] categories, Capability[] capabilities, CapabilityRegistry registry) {
        this(categories, capabilities, null, registry);
    }

    public ProjectCapabilitySelectionGroup(Category[] categories, Capability[] capabilities, Capability[] disabledCapabilities, CapabilityRegistry registry) {
        this.initialCategories = categories;
        this.initialCapabilities = capabilities;
        this.disabledCapabilities = disabledCapabilities;
        this.registry = registry;
    }

    public Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite catComposite = new Composite(composite, 0);
        catComposite.setLayout((Layout)new GridLayout());
        catComposite.setLayoutData((Object)new GridData(1808));
        Label categoryLabel = new Label(catComposite, 16384);
        categoryLabel.setText(IDEWorkbenchMessages.getString("ProjectCapabilitySelectionGroup.categories"));
        GridData data = new GridData();
        data.verticalAlignment = 128;
        categoryLabel.setLayoutData((Object)data);
        categoryLabel.setFont(font);
        ListViewer listViewer = new ListViewer(catComposite);
        listViewer.getList().setLayoutData((Object)new GridData(1808));
        listViewer.getList().setFont(font);
        listViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        listViewer.setContentProvider(this.getContentProvider());
        listViewer.setInput((Object)this.getAvailableCategories());
        Composite capComposite = new Composite(composite, 0);
        capComposite.setLayout((Layout)new GridLayout());
        capComposite.setLayoutData((Object)new GridData(1808));
        Label capabilityLabel = new Label(capComposite, 16384);
        capabilityLabel.setText(IDEWorkbenchMessages.getString("ProjectCapabilitySelectionGroup.capabilities"));
        data = new GridData();
        data.verticalAlignment = 128;
        capabilityLabel.setLayoutData((Object)data);
        capabilityLabel.setFont(font);
        this.checkboxViewer = CheckboxTableViewer.newCheckList((Composite)capComposite, (int)2180);
        this.checkboxViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.checkboxViewer.getTable().setFont(font);
        this.checkboxViewer.setLabelProvider((IBaseLabelProvider)new CapabilityLabelProvider());
        this.checkboxViewer.setContentProvider(this.getContentProvider());
        this.checkboxViewer.setInput((Object)this.visibleCapabilities);
        Label descLabel = new Label(composite, 16384);
        descLabel.setText(IDEWorkbenchMessages.getString("ProjectCapabilitySelectionGroup.description"));
        data = new GridData();
        data.verticalAlignment = 128;
        data.horizontalSpan = 2;
        descLabel.setLayoutData((Object)data);
        descLabel.setFont(font);
        this.descriptionText = new Text(composite, 2626);
        this.descriptionText.setText(EMPTY_DESCRIPTION);
        this.descriptionText.setEditable(false);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        this.descriptionText.setLayoutData((Object)data);
        this.descriptionText.setFont(font);
        Label grayLabel = new Label(composite, 16384);
        grayLabel.setText(IDEWorkbenchMessages.getString("ProjectCapabilitySelectionGroup.grayItems"));
        data = new GridData();
        data.verticalAlignment = 128;
        data.horizontalSpan = 2;
        grayLabel.setLayoutData((Object)data);
        grayLabel.setFont(font);
        this.populateDependents();
        this.populateMemberships();
        this.checkboxViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectCapabilitySelectionGroup.this.updateDescription(event.getSelection());
            }
        });
        this.checkboxViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Capability cap = (Capability)((Object)event.getElement());
                if (event.getChecked()) {
                    ProjectCapabilitySelectionGroup.this.handleCapabilityChecked(cap);
                } else {
                    ProjectCapabilitySelectionGroup.this.handleCapabilityUnchecked(cap);
                }
                ProjectCapabilitySelectionGroup.this.checkboxViewer.setSelection((ISelection)new StructuredSelection((Object)cap));
            }
        });
        listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    ProjectCapabilitySelectionGroup.this.visibleCapabilities.clear();
                    Iterator iterator = sel.iterator();
                    while (iterator.hasNext()) {
                        Category cat = (Category)((Object)iterator.next());
                        ProjectCapabilitySelectionGroup.this.visibleCapabilities.addAll(cat.getElements());
                    }
                    Collections.sort(ProjectCapabilitySelectionGroup.this.visibleCapabilities, ProjectCapabilitySelectionGroup.this.capabilityComparator);
                    ProjectCapabilitySelectionGroup.this.checkboxViewer.refresh();
                    iterator = ProjectCapabilitySelectionGroup.this.visibleCapabilities.iterator();
                    while (iterator.hasNext()) {
                        Capability cap = (Capability)((Object)iterator.next());
                        if (ProjectCapabilitySelectionGroup.this.hasDependency(cap)) {
                            ProjectCapabilitySelectionGroup.this.checkboxViewer.setGrayed((Object)cap, true);
                        }
                        if (!ProjectCapabilitySelectionGroup.this.checkedCapabilities.contains((Object)cap)) continue;
                        ProjectCapabilitySelectionGroup.this.checkboxViewer.setChecked((Object)cap, true);
                    }
                    ProjectCapabilitySelectionGroup.this.updateDescription(ProjectCapabilitySelectionGroup.this.checkboxViewer.getSelection());
                }
            }
        });
        if (this.initialCapabilities != null) {
            this.checkedCapabilities.addAll(Arrays.asList(this.initialCapabilities));
        }
        if (this.initialCategories != null) {
            listViewer.setSelection((ISelection)new StructuredSelection((Object[])this.initialCategories));
        }
        return composite;
    }

    private void markCapabilityChecked(Capability target, Capability dependent) {
        if (!this.checkedCapabilities.contains((Object)target)) {
            this.checkedCapabilities.add(target);
        }
        this.checkboxViewer.setChecked((Object)target, true);
        if (target != dependent) {
            this.checkboxViewer.setGrayed((Object)target, true);
        }
        this.addDependency(target, dependent);
        String[] ids = this.registry.getMembershipSetIds(target);
        for (int j = 0; j < ids.length; ++j) {
            this.memberships.put(ids[j], target);
        }
    }

    private void markCapabilityUnchecked(Capability target) {
        this.checkedCapabilities.remove((Object)target);
        this.checkboxViewer.setChecked((Object)target, false);
        this.checkboxViewer.setGrayed((Object)target, false);
        this.dependents.remove((Object)target);
        String[] ids = this.registry.getMembershipSetIds(target);
        for (int j = 0; j < ids.length; ++j) {
            if (this.memberships.get(ids[j]) != target) continue;
            this.memberships.remove(ids[j]);
        }
    }

    private ArrayList getAvailableCategories() {
        ArrayList results = this.registry.getUsedCategories();
        Collections.sort(results, this.categoryComparator);
        if (this.registry.getMiscCategory() != null) {
            results.add(this.registry.getMiscCategory());
        }
        return results;
    }

    public boolean getCapabilitiesModified() {
        return this.modified;
    }

    private IContentProvider getContentProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof ArrayList) {
                    return ((ArrayList)parentElement).toArray();
                }
                return null;
            }
        };
    }

    private void capabilitiesModified() {
        this.modified = true;
    }

    private void addDependency(Capability target, Capability dependent) {
        ArrayList<Capability> descriptors = (ArrayList<Capability>)this.dependents.get((Object)target);
        if (descriptors == null) {
            descriptors = new ArrayList<Capability>();
            descriptors.add(dependent);
            this.dependents.put(target, descriptors);
        } else if (!descriptors.contains((Object)dependent)) {
            descriptors.add(dependent);
        }
    }

    private boolean hasDependency(Capability capability) {
        ArrayList descriptors = (ArrayList)this.dependents.get((Object)capability);
        if (descriptors == null) {
            return false;
        }
        return descriptors.size() != 1 || descriptors.get(0) != capability;
    }

    private boolean isDisabledCapability(Capability cap) {
        if (this.disabledCaps == null) {
            this.disabledCaps = this.disabledCapabilities == null ? new ArrayList(0) : Arrays.asList(this.disabledCapabilities);
        }
        return this.disabledCaps.contains((Object)cap);
    }

    private void populateDependents() {
        if (this.initialCapabilities == null) {
            return;
        }
        LinkedList<Capability> capabilities = new LinkedList<Capability>();
        capabilities.addAll(Arrays.asList(this.initialCapabilities));
        while (!capabilities.isEmpty()) {
            Capability target = (Capability)((Object)capabilities.removeFirst());
            this.addDependency(target, target);
            if (!this.registry.hasPrerequisites(target)) continue;
            String[] prereqIds = this.registry.getPrerequisiteIds(target);
            Capability[] prereqCapabilities = this.registry.findCapabilities(prereqIds);
            for (int i = 0; i < prereqCapabilities.length; ++i) {
                this.addDependency(prereqCapabilities[i], target);
                if (!this.registry.hasPrerequisites(prereqCapabilities[i])) continue;
                capabilities.addLast(prereqCapabilities[i]);
            }
        }
    }

    private void populateMemberships() {
        if (this.initialCapabilities == null) {
            return;
        }
        Iterator<Capability> iterator = Arrays.asList(this.initialCapabilities).iterator();
        while (iterator.hasNext()) {
            Capability cap = iterator.next();
            String[] ids = this.registry.getMembershipSetIds(cap);
            for (int j = 0; j < ids.length; ++j) {
                this.memberships.put(ids[j], cap);
            }
        }
    }

    private void handleCapabilityChecked(Capability capability) {
        if (this.isDisabledCapability(capability)) {
            MessageDialog.openWarning((Shell)this.checkboxViewer.getControl().getShell(), (String)IDEWorkbenchMessages.getString("ProjectCapabilitySelectionGroup.errorTitle"), (String)IDEWorkbenchMessages.format("ProjectCapabilitySelectionGroup.disabledCapability", new Object[]{capability.getName()}));
            this.checkboxViewer.setChecked((Object)capability, false);
            return;
        }
        if (!capability.isValid()) {
            MessageDialog.openWarning((Shell)this.checkboxViewer.getControl().getShell(), (String)IDEWorkbenchMessages.getString("ProjectCapabilitySelectionGroup.errorTitle"), (String)IDEWorkbenchMessages.format("ProjectCapabilitySelectionGroup.invalidCapability", new Object[]{capability.getName()}));
            this.checkboxViewer.setChecked((Object)capability, false);
            return;
        }
        String[] ids = this.registry.getMembershipSetIds(capability);
        for (int i = 0; i < ids.length; ++i) {
            Capability member = (Capability)((Object)this.memberships.get(ids[i]));
            if (member == null || member == capability) continue;
            MessageDialog.openWarning((Shell)this.checkboxViewer.getControl().getShell(), (String)IDEWorkbenchMessages.getString("ProjectCapabilitySelectionGroup.errorTitle"), (String)IDEWorkbenchMessages.format("ProjectCapabilitySelectionGroup.membershipConflict", new Object[]{capability.getName(), member.getName()}));
            this.checkboxViewer.setChecked((Object)capability, false);
            return;
        }
        if (this.registry.hasPrerequisites(capability)) {
            int i;
            Capability[] prereqCapabilities;
            String[] prereqIds;
            Capability target;
            LinkedList<Capability> capabilities = new LinkedList<Capability>();
            capabilities.addLast(capability);
            while (!capabilities.isEmpty()) {
                target = (Capability)((Object)capabilities.removeFirst());
                prereqIds = this.registry.getPrerequisiteIds(target);
                prereqCapabilities = this.registry.findCapabilities(prereqIds);
                for (i = 0; i < prereqCapabilities.length; ++i) {
                    if (prereqCapabilities[i] == null || this.isDisabledCapability(prereqCapabilities[i]) || !prereqCapabilities[i].isValid()) {
                        MessageDialog.openWarning((Shell)this.checkboxViewer.getControl().getShell(), (String)IDEWorkbenchMessages.getString("ProjectCapabilitySelectionGroup.errorTitle"), (String)IDEWorkbenchMessages.format("ProjectCapabilitySelectionGroup.missingPrereqs", new Object[]{capability.getName(), prereqIds[i]}));
                        this.checkboxViewer.setChecked((Object)capability, false);
                        return;
                    }
                    ids = this.registry.getMembershipSetIds(prereqCapabilities[i]);
                    for (int j = 0; j < ids.length; ++j) {
                        Capability member = (Capability)((Object)this.memberships.get(ids[j]));
                        if (member == null || member == prereqCapabilities[i]) continue;
                        MessageDialog.openWarning((Shell)this.checkboxViewer.getControl().getShell(), (String)IDEWorkbenchMessages.getString("ProjectCapabilitySelectionGroup.errorTitle"), (String)IDEWorkbenchMessages.format("ProjectCapabilitySelectionGroup.membershipPrereqConflict", new Object[]{capability.getName(), prereqCapabilities[i].getName(), member.getName()}));
                        this.checkboxViewer.setChecked((Object)capability, false);
                        return;
                    }
                    if (!this.registry.hasPrerequisites(prereqCapabilities[i])) continue;
                    capabilities.addLast(prereqCapabilities[i]);
                }
            }
            capabilities = new LinkedList();
            capabilities.addLast(capability);
            while (!capabilities.isEmpty()) {
                target = (Capability)((Object)capabilities.removeFirst());
                prereqIds = this.registry.getPrerequisiteIds(target);
                prereqCapabilities = this.registry.findCapabilities(prereqIds);
                for (i = 0; i < prereqCapabilities.length; ++i) {
                    this.markCapabilityChecked(prereqCapabilities[i], target);
                    if (!this.registry.hasPrerequisites(prereqCapabilities[i])) continue;
                    capabilities.addLast(prereqCapabilities[i]);
                }
            }
        }
        this.markCapabilityChecked(capability, capability);
        this.capabilitiesModified();
        this.notifyCheckStateListner();
    }

    private void handleCapabilityUnchecked(Capability capability) {
        ArrayList descriptors = (ArrayList)this.dependents.get((Object)capability);
        if (descriptors.size() == 1 && descriptors.get(0) == capability) {
            this.capabilitiesModified();
            this.markCapabilityUnchecked(capability);
            if (this.registry.hasPrerequisites(capability)) {
                LinkedList<Capability> capabilities = new LinkedList<Capability>();
                capabilities.addLast(capability);
                while (!capabilities.isEmpty()) {
                    Capability target = (Capability)((Object)capabilities.removeFirst());
                    String[] prereqIds = this.registry.getPrerequisiteIds(target);
                    Capability[] prereqCapabilities = this.registry.findCapabilities(prereqIds);
                    for (int i = 0; i < prereqCapabilities.length; ++i) {
                        Capability prereqCap = prereqCapabilities[i];
                        ArrayList prereqDependents = (ArrayList)this.dependents.get((Object)prereqCap);
                        prereqDependents.remove((Object)target);
                        if (prereqDependents.isEmpty()) {
                            this.markCapabilityUnchecked(prereqCap);
                            if (!this.registry.hasPrerequisites(prereqCap)) continue;
                            capabilities.addLast(prereqCap);
                            continue;
                        }
                        if (prereqDependents.size() != 1 || prereqDependents.get(0) != prereqCap) continue;
                        this.checkboxViewer.setGrayed((Object)prereqCap, false);
                    }
                }
            }
            this.notifyCheckStateListner();
        } else {
            this.checkboxViewer.setChecked((Object)capability, true);
            ArrayList descCopy = (ArrayList)descriptors.clone();
            descCopy.remove((Object)capability);
            if (descCopy.size() == 1) {
                Capability cap = (Capability)((Object)descCopy.get(0));
                MessageDialog.openWarning((Shell)this.checkboxViewer.getControl().getShell(), (String)IDEWorkbenchMessages.getString("ProjectCapabilitySelectionGroup.errorTitle"), (String)IDEWorkbenchMessages.format("ProjectCapabilitySelectionGroup.requiredPrereq", new Object[]{capability.getName(), cap.getName()}));
            } else {
                StringBuffer msg = new StringBuffer();
                Iterator iterator = descCopy.iterator();
                while (iterator.hasNext()) {
                    Capability cap = (Capability)((Object)iterator.next());
                    msg.append("\n    ");
                    msg.append(cap.getName());
                }
                MessageDialog.openWarning((Shell)this.checkboxViewer.getControl().getShell(), (String)IDEWorkbenchMessages.getString("ProjectCapabilitySelectionGroup.errorTitle"), (String)IDEWorkbenchMessages.format("ProjectCapabilitySelectionGroup.requiredPrereqs", new Object[]{capability.getName(), msg.toString()}));
            }
        }
    }

    public Capability[] getSelectedCapabilities() {
        Capability[] capabilities = new Capability[this.checkedCapabilities.size()];
        this.checkedCapabilities.toArray(capabilities);
        return capabilities;
    }

    public ICheckStateListener getCheckStateListener() {
        return this.checkStateListener;
    }

    public void setCheckStateListener(ICheckStateListener checkStateListener) {
        this.checkStateListener = checkStateListener;
    }

    private void notifyCheckStateListner() {
        if (this.checkStateListener != null) {
            this.checkStateListener.checkStateChanged(null);
        }
    }

    private void updateDescription(ISelection selection) {
        IStructuredSelection sel;
        Capability cap;
        String text = EMPTY_DESCRIPTION;
        if (selection instanceof IStructuredSelection && (cap = (Capability)((Object)(sel = (IStructuredSelection)selection).getFirstElement())) != null) {
            text = cap.getDescription();
        }
        this.descriptionText.setText(text);
    }

    class CapabilityLabelProvider
    extends LabelProvider {
        private Map imageTable;

        CapabilityLabelProvider() {
        }

        public void dispose() {
            if (this.imageTable != null) {
                Iterator iterator = this.imageTable.values().iterator();
                while (iterator.hasNext()) {
                    ((Image)iterator.next()).dispose();
                }
                this.imageTable = null;
            }
        }

        public Image getImage(Object element) {
            Image image;
            ImageDescriptor descriptor = ((Capability)((Object)element)).getIconDescriptor();
            if (descriptor == null) {
                return null;
            }
            if (this.imageTable == null) {
                this.imageTable = new Hashtable(40);
            }
            if ((image = (Image)this.imageTable.get(descriptor)) == null) {
                image = descriptor.createImage();
                this.imageTable.put(descriptor, image);
            }
            return image;
        }

        public String getText(Object element) {
            Capability cap = (Capability)((Object)element);
            String text = cap.getName();
            if (ProjectCapabilitySelectionGroup.this.isDisabledCapability(cap)) {
                text = IDEWorkbenchMessages.format("ProjectCapabilitySelectionGroup.disabledLabel", new Object[]{text});
            }
            return text;
        }
    }
}

