/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import org.eclipse.ant.internal.ui.editor.text.AntEditorProcInstrScanner;
import org.eclipse.ant.internal.ui.editor.text.AntEditorTagScanner;
import org.eclipse.ant.internal.ui.editor.text.MultilineDamagerRepairer;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.ColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractAntSourceViewerConfiguration
extends SourceViewerConfiguration {
    private AntEditorTagScanner tagScanner;
    private AntEditorProcInstrScanner instructionScanner;
    private MultilineDamagerRepairer damageRepairer;
    private TextAttribute xmlCommentAttribute;

    private AntEditorProcInstrScanner getDefaultScanner() {
        if (this.instructionScanner == null) {
            this.instructionScanner = new AntEditorProcInstrScanner();
        }
        return this.instructionScanner;
    }

    private AntEditorTagScanner getTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new AntEditorTagScanner();
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        MultilineDamagerRepairer dr = new MultilineDamagerRepairer((ITokenScanner)this.getDefaultScanner(), null);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new MultilineDamagerRepairer((ITokenScanner)this.getTagScanner(), null);
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        int style = 0;
        if (store.getBoolean("org.eclipse.ant.ui.commentsColor_bold")) {
            style |= 1;
        }
        if (store.getBoolean("org.eclipse.ant.ui.commentsColor_italic")) {
            style |= 2;
        }
        this.xmlCommentAttribute = new TextAttribute(AntUIPlugin.getPreferenceColor("org.eclipse.ant.ui.commentsColor"), null, style);
        this.damageRepairer = new MultilineDamagerRepairer(null, this.xmlCommentAttribute);
        reconciler.setDamager((IPresentationDamager)this.damageRepairer, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)this.damageRepairer, "__xml_comment");
        return reconciler;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.tagScanner == null) {
            return;
        }
        this.tagScanner.adaptToPreferenceChange(event);
        this.instructionScanner.adaptToPreferenceChange(event);
        String property = event.getProperty();
        if (property.startsWith("org.eclipse.ant.ui.commentsColor")) {
            if (property.endsWith("_bold")) {
                this.adaptToStyleChange(event, 1);
            } else if (property.endsWith("_italic")) {
                this.adaptToStyleChange(event, 2);
            } else {
                this.adaptToColorChange(event);
            }
            this.damageRepairer.setDefaultTextAttribute(this.xmlCommentAttribute);
        }
    }

    private void adaptToStyleChange(PropertyChangeEvent event, int styleAttribute) {
        boolean activeValue;
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        boolean bl = activeValue = (this.xmlCommentAttribute.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            this.xmlCommentAttribute = new TextAttribute(this.xmlCommentAttribute.getForeground(), this.xmlCommentAttribute.getBackground(), eventValue ? this.xmlCommentAttribute.getStyle() | styleAttribute : this.xmlCommentAttribute.getStyle() & ~styleAttribute);
        }
    }

    private void adaptToColorChange(PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            this.xmlCommentAttribute = new TextAttribute(ColorManager.getDefault().getColor(rgb), this.xmlCommentAttribute.getBackground(), this.xmlCommentAttribute.getStyle());
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag", "__xml_cdata"};
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return AntUIPlugin.getDefault().getPreferenceStore().getInt("tabWidth");
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.startsWith("org.eclipse.ant.ui.textColor") || property.startsWith("org.eclipse.ant.ui.processingInstructionsColor") || property.startsWith("org.eclipse.ant.ui.constantStringsColor") || property.startsWith("org.eclipse.ant.ui.tagsColor") || property.startsWith("org.eclipse.ant.ui.commentsColor");
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "___ant_partitioning";
    }
}

