/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ant.internal.ui.editor.model.AntElementNode;
import org.eclipse.ant.internal.ui.editor.outline.AntModel;
import org.eclipse.ant.internal.ui.editor.text.AntEditorDocumentProvider;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.views.actions.AntViewActionMessages;
import org.eclipse.ant.internal.ui.views.actions.EditorImageDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AntOpenWithMenu
extends ContributionItem {
    private IWorkbenchPage page;
    private IAdaptable file;
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private static final String SYSTEM_EDITOR_ID = "org.eclipse.ui.SystemEditor";
    private static Map imageCache = new Hashtable(11);
    private int fLine = -1;
    private int fColumn = -1;
    public static final String ID = "org.eclipse.ant.ui.AntOpenWithMenu";
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public AntOpenWithMenu(IWorkbenchPage page) {
        super(ID);
        this.page = page;
    }

    public void setFile(IAdaptable file) {
        this.file = file;
    }

    public void dispose() {
        super.dispose();
        Iterator iter = imageCache.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        imageCache.clear();
    }

    private Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        Image image = (Image)imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(this.getFileResource().getName()) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc.getId().equals(SYSTEM_EDITOR_ID)) {
            imageDesc = this.getSystemEditorImageDescriptor(this.getFileResource().getFileExtension());
        }
        return imageDesc;
    }

    private ImageDescriptor getSystemEditorImageDescriptor(String extension) {
        Program externalProgram = null;
        if (extension != null) {
            externalProgram = Program.findProgram((String)extension);
        }
        if (externalProgram == null) {
            return null;
        }
        return new EditorImageDescriptor(externalProgram);
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        AntOpenWithMenu.this.openEditor(descriptor);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void fill(Menu menu, int index) {
        IFile fileResource = this.getFileResource();
        if (fileResource == null) {
            return;
        }
        IEditorDescriptor defaultEditor = this.registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        IEditorDescriptor preferredEditor = IDE.getDefaultEditor((IFile)fileResource);
        IEditorDescriptor[] editors = this.registry.getEditors(fileResource.getName());
        Arrays.sort(editors, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((IEditorDescriptor)o1).getLabel();
                String s2 = ((IEditorDescriptor)o2).getLabel();
                return s1.compareToIgnoreCase(s2);
            }
        });
        IEditorDescriptor antEditor = this.registry.findEditor("org.eclipse.ant.internal.ui.editor.AntEditor");
        boolean defaultFound = false;
        boolean antFound = false;
        ArrayList<String> alreadyAddedEditors = new ArrayList<String>(editors.length);
        for (int i = 0; i < editors.length; ++i) {
            IEditorDescriptor editor = editors[i];
            if (alreadyAddedEditors.contains(editor.getId())) continue;
            this.createMenuItem(menu, editor, preferredEditor);
            if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                defaultFound = true;
            }
            if (antEditor != null && editor.getId().equals(antEditor.getId())) {
                antFound = true;
            }
            alreadyAddedEditors.add(editor.getId());
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!antFound && antEditor != null) {
            this.createMenuItem(menu, antEditor, preferredEditor);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createMenuItem(menu, defaultEditor, preferredEditor);
        }
        IEditorDescriptor descriptor = this.registry.findEditor("org.eclipse.ui.systemExternalEditor");
        this.createMenuItem(menu, descriptor, preferredEditor);
        this.createDefaultMenuItem(menu, fileResource);
    }

    private IFile getFileResource() {
        if (this.file instanceof IFile) {
            return (IFile)this.file;
        }
        IResource resource = (IResource)this.file.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = AntOpenWithMenu.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public boolean isDynamic() {
        return true;
    }

    private void openEditor(IEditorDescriptor editorDescriptor) {
        IEditorPart editorPart = null;
        IFile fileResource = this.getFileResource();
        try {
            editorPart = editorDescriptor == null ? this.page.openEditor((IEditorInput)new FileEditorInput(fileResource), "org.eclipse.ui.systemExternalEditor") : this.page.openEditor((IEditorInput)new FileEditorInput(fileResource), editorDescriptor.getId());
        }
        catch (PartInitException e) {
            AntUIPlugin.log(MessageFormat.format(AntViewActionMessages.getString("AntViewOpenWithMenu.Editor_failed"), fileResource.getLocation().toOSString()), e);
        }
        if (this.fLine == -1) {
            return;
        }
        if (editorPart instanceof ITextEditor) {
            ITextEditor editor = (ITextEditor)editorPart;
            int offset = this.getOffset(this.fLine, this.fColumn, editor);
            if (offset == -1) {
                return;
            }
            IDocumentProvider provider = editor.getDocumentProvider();
            if (provider instanceof AntEditorDocumentProvider) {
                AntModel model = ((AntEditorDocumentProvider)provider).getAntModel(editor.getEditorInput());
                AntElementNode node = model.getProjectNode().getNode(offset);
                editor.setHighlightRange(node.getOffset(), node.getLength(), true);
                editor.selectAndReveal(node.getOffset(), node.getSelectionLength());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOffset(int line, int column, ITextEditor editor) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        try {
            provider.connect((Object)input);
        }
        catch (CoreException e) {
            return -1;
        }
        try {
            IDocument document = provider.getDocument((Object)input);
            if (document != null) {
                if (column > -1) {
                    int n = document.getLineOffset(line - 1) + column - 1 - 2;
                    return n;
                }
                int n = document.getLineOffset(line - 1);
                return n;
            }
        }
        catch (BadLocationException e) {
        }
        finally {
            provider.disconnect((Object)input);
        }
        return -1;
    }

    private void createDefaultMenuItem(Menu menu, final IFile fileResource) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setSelection(IDE.getDefaultEditor((IFile)fileResource) == null);
        menuItem.setText(AntViewActionMessages.getString("AntViewOpenWithMenu.Default_Editor_4"));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        IDE.setDefaultEditor((IFile)fileResource, null);
                        try {
                            IDE.openEditor((IWorkbenchPage)AntOpenWithMenu.this.page, (IFile)fileResource, (boolean)true);
                            break;
                        }
                        catch (PartInitException e) {
                            AntUIPlugin.log(MessageFormat.format(AntViewActionMessages.getString("AntViewOpenWithMenu.Editor_failed"), fileResource.getLocation().toOSString()), e);
                        }
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void setExternalInfo(int line, int column) {
        this.fLine = line;
        this.fColumn = column;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

