/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddExceptionDialog
extends TypeSelectionDialog {
    private Button fCaughtButton;
    private Button fUncaughtButton;
    private Text fTextWidget;
    private IJavaExceptionBreakpoint[] fExisting;
    private Point fLocation;
    private Point fSize;
    public static final int CHECKED_EXCEPTION = 0;
    public static final int UNCHECKED_EXCEPTION = 1;
    public static final int NO_EXCEPTION = -1;
    private static final String DIALOG_SETTINGS = "AddExceptionDialog";
    private static final String SETTING_CAUGHT_CHECKED = "caughtChecked";
    private static final String SETTING_UNCAUGHT_CHECKED = "uncaughtChecked";

    public AddExceptionDialog(Shell parent, IRunnableContext context) {
        super(parent, context, 5, SearchEngine.createWorkspaceScope());
        this.setFilter(BreakpointMessages.getString("AddExceptionDialog.14"));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)IJavaDebugHelpContextIds.ADD_EXCEPTION_DIALOG);
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createExceptionArea(contents);
        return contents;
    }

    private void createExceptionArea(Composite contents) {
        IDialogSettings section = this.getDialogSettings();
        boolean c = section.getBoolean(SETTING_CAUGHT_CHECKED);
        boolean u = section.getBoolean(SETTING_UNCAUGHT_CHECKED);
        this.fCaughtButton = new Button(contents, 32);
        this.fCaughtButton.setLayoutData((Object)new GridData(768));
        this.fCaughtButton.setFont(contents.getFont());
        this.fCaughtButton.setText(BreakpointMessages.getString("AddExceptionDialog.15"));
        this.fCaughtButton.setSelection(c);
        this.fUncaughtButton = new Button(contents, 32);
        this.fUncaughtButton.setLayoutData((Object)new GridData(768));
        this.fUncaughtButton.setFont(contents.getFont());
        this.fUncaughtButton.setText(BreakpointMessages.getString("AddExceptionDialog.16"));
        this.fUncaughtButton.setSelection(u);
    }

    protected Text createFilterText(Composite parent) {
        this.fTextWidget = super.createFilterText(parent);
        return this.fTextWidget;
    }

    public void create() {
        super.create();
        this.fTextWidget.setSelection(0, 0);
    }

    protected boolean createBreakpoint() {
        TypeInfo typeRef = (TypeInfo)this.getLowerSelectedElement();
        IType type = null;
        try {
            type = typeRef.resolveType(SearchEngine.createWorkspaceScope());
        }
        catch (JavaModelException e) {
            this.updateStatus(e.getStatus());
            return false;
        }
        if (type == null) {
            this.updateStatus((IStatus)new StatusInfo(4, BreakpointMessages.getString("AddExceptionDialog.17")));
            return false;
        }
        int exType = AddExceptionDialog.getExceptionType(type);
        if (exType == -1) {
            this.updateStatus((IStatus)new StatusInfo(4, BreakpointMessages.getString("AddExceptionDialog.17")));
            return false;
        }
        HashMap attributes = new HashMap(10);
        BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)type);
        try {
            IJavaExceptionBreakpoint breakpoint = JDIDebugModel.createExceptionBreakpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)type), (String)type.getFullyQualifiedName(), (boolean)this.fCaughtButton.getSelection(), (boolean)this.fUncaughtButton.getSelection(), (exType == 0 ? 1 : 0) != 0, (boolean)true, attributes);
            ArrayList<IJavaExceptionBreakpoint> list = new ArrayList<IJavaExceptionBreakpoint>(1);
            list.add(breakpoint);
            this.setResult(list);
        }
        catch (CoreException e) {
            this.updateStatus(e.getStatus());
            return false;
        }
        return true;
    }

    protected boolean validateBreakpoint() {
        TypeInfo typeRef = (TypeInfo)this.getLowerSelectedElement();
        if (typeRef == null) {
            return false;
        }
        IType type = null;
        try {
            type = typeRef.resolveType(SearchEngine.createWorkspaceScope());
        }
        catch (JavaModelException e) {
            this.updateStatus(e.getStatus());
            return false;
        }
        if (type == null) {
            this.updateStatus((IStatus)new StatusInfo(4, BreakpointMessages.getString("AddExceptionDialog.17")));
            return false;
        }
        int exType = AddExceptionDialog.getExceptionType(type);
        if (exType == -1) {
            this.updateStatus((IStatus)new StatusInfo(4, BreakpointMessages.getString("AddExceptionDialog.17")));
            return false;
        }
        String name = type.getFullyQualifiedName();
        IJavaExceptionBreakpoint[] breakpoints = this.getExistingBreakpoints();
        for (int i = 0; i < breakpoints.length; ++i) {
            IJavaExceptionBreakpoint breakpoint = breakpoints[i];
            try {
                if (!breakpoint.getTypeName().equals(name)) continue;
                this.updateStatus((IStatus)new StatusInfo(1, BreakpointMessages.getString("AddExceptionDialog.21")));
                return false;
            }
            catch (CoreException e) {
                this.updateStatus(e.getStatus());
                return false;
            }
        }
        this.updateStatus((IStatus)new StatusInfo(0, null));
        return true;
    }

    public static int getExceptionType(final IType type) {
        final int[] exceptionType = new int[]{-1};
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                try {
                    ITypeHierarchy hierarchy = type.newSupertypeHierarchy(pm);
                    IType curr = type;
                    while (curr != null) {
                        String name = JavaModelUtil.getFullyQualifiedName((IType)curr);
                        if ("java.lang.Throwable".equals(name)) {
                            exceptionType[0] = 0;
                            return;
                        }
                        if ("java.lang.RuntimeException".equals(name) || "java.lang.Error".equals(name)) {
                            exceptionType[0] = 1;
                            return;
                        }
                        curr = hierarchy.getSuperclass(curr);
                    }
                }
                catch (JavaModelException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
        };
        try {
            context.run(false, false, runnable);
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            JDIDebugUIPlugin.log(e);
        }
        return exceptionType[0];
    }

    protected void okPressed() {
        if (this.createBreakpoint()) {
            super.okPressed();
        }
    }

    protected void updateOkState() {
        this.getButton(0).setEnabled(this.validateBreakpoint());
    }

    private void writeSettings() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        Point size = this.getShell().getSize();
        s.put("width", size.x);
        s.put("height", size.y);
        s.put(SETTING_CAUGHT_CHECKED, this.fCaughtButton.getSelection());
        s.put(SETTING_UNCAUGHT_CHECKED, this.fUncaughtButton.getSelection());
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings allSetttings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = allSetttings.getSection(DIALOG_SETTINGS);
        if (section == null) {
            section = allSetttings.addNewSection(DIALOG_SETTINGS);
            section.put(SETTING_CAUGHT_CHECKED, true);
            section.put(SETTING_UNCAUGHT_CHECKED, true);
        }
        return section;
    }

    private void readSettings() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.fLocation = new Point(x, y);
            int width = s.getInt("width");
            int height = s.getInt("height");
            this.fSize = new Point(width, height);
        }
        catch (NumberFormatException e) {
            this.fLocation = null;
            this.fSize = null;
        }
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        if (this.fSize != null) {
            result.x = Math.max(result.x, this.fSize.x);
            result.y = Math.max(result.y, this.fSize.y);
            Rectangle display = this.getShell().getDisplay().getClientArea();
            result.x = Math.min(result.x, display.width);
            result.y = Math.min(result.y, display.height);
        }
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point result = super.getInitialLocation(initialSize);
        if (this.fLocation != null) {
            int ye;
            result.x = this.fLocation.x;
            result.y = this.fLocation.y;
            Rectangle display = this.getShell().getDisplay().getClientArea();
            int xe = result.x + initialSize.x;
            if (xe > display.width) {
                result.x -= xe - display.width;
            }
            if ((ye = result.y + initialSize.y) > display.height) {
                result.y -= ye - display.height;
            }
        }
        return result;
    }

    public boolean close() {
        this.writeSettings();
        return super.close();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.readSettings();
        return control;
    }

    protected void computeResult() {
    }

    protected IJavaExceptionBreakpoint[] getExistingBreakpoints() {
        if (this.fExisting == null) {
            ArrayList<IBreakpoint> list = new ArrayList<IBreakpoint>();
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
            for (int i = 0; i < breakpoints.length; ++i) {
                IBreakpoint breakpoint = breakpoints[i];
                if (!(breakpoint instanceof IJavaExceptionBreakpoint)) continue;
                list.add(breakpoint);
            }
            this.fExisting = list.toArray(new IJavaExceptionBreakpoint[list.size()]);
        }
        return this.fExisting;
    }

    protected void handleDefaultSelected() {
        if (this.getButton(0).isEnabled()) {
            super.handleDefaultSelected();
        }
    }
}

