/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin.rows;

import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.plugin.rows.TextAttributeRow;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public abstract class ReferenceAttributeRow
extends TextAttributeRow {
    public ReferenceAttributeRow(IContextPart part, ISchemaAttribute att) {
        super(part, att);
    }

    protected void createLabel(Composite parent, FormToolkit toolkit) {
        Hyperlink link = toolkit.createHyperlink(parent, this.getPropertyLabel(), 0);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (!ReferenceAttributeRow.this.isReferenceModel()) {
                    ReferenceAttributeRow.this.openReference();
                }
            }
        });
        link.setToolTipText(this.getToolTipText());
    }

    protected boolean isReferenceModel() {
        return ((IPluginModelBase)this.part.getPage().getModel()).getInstallLocation() == null;
    }

    public void createContents(Composite parent, FormToolkit toolkit, int span) {
        super.createContents(parent, toolkit, span);
        Button button = toolkit.createButton(parent, PDEPlugin.getResourceString("ReferenceAttributeRow.browse"), 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ReferenceAttributeRow.this.isReferenceModel()) {
                    ReferenceAttributeRow.this.browse();
                }
            }
        });
        button.setEnabled(this.part.isEditable());
    }

    protected GridData createGridData(int span) {
        GridData gd = new GridData(768);
        gd.widthHint = 20;
        return gd;
    }

    protected abstract void openReference();

    protected abstract void browse();
}

