/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryAction;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;

public class ResetMemoryBlockAction
extends AbstractMemoryAction {
    private static final String PREFIX = "ResetMemoryBlockAction.";
    private static final String TITLE = "ResetMemoryBlockAction.title";
    private static final String TOOLTIP = "ResetMemoryBlockAction.tootip";
    private static final String FAILED_TO_RESET = "ResetMemoryBlockAction.Failed_to_Reset";
    private static final String FAILED_TO_RESET_TO_BASE_ADD = "ResetMemoryBlockAction.Failed_to_reset_to_base_address";

    public ResetMemoryBlockAction() {
        this.setText(DebugUIMessages.getString(TITLE));
        this.setToolTipText(DebugUIMessages.getString(TOOLTIP));
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_RESET_MEMORY"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_RESET_MEMORY"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_RESET_MEMORY"));
    }

    public void run() {
        try {
            IMemoryViewTab top = this.getViewTab();
            if (top != null) {
                top.resetAtBaseAddress();
            }
        }
        catch (DebugException e) {
            MemoryViewUtil.openError(DebugUIMessages.getString(FAILED_TO_RESET), DebugUIMessages.getString(FAILED_TO_RESET_TO_BASE_ADD), (Exception)((Object)e));
        }
    }

    IMemoryViewTab getViewTab() {
        return this.getTopViewTabFromView("org.eclipse.debug.ui.MemoryView");
    }
}

