/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableLayout
extends Layout {
    private List columns = new ArrayList();
    private boolean firstTime = true;

    public void addColumnData(ColumnLayoutData data) {
        this.columns.add(data);
    }

    public Point computeSize(Composite c, int wHint, int hHint, boolean flush) {
        if (wHint != -1 && hHint != -1) {
            return new Point(wHint, hHint);
        }
        Table table = (Table)c;
        table.setLayout(null);
        Point result = table.computeSize(wHint, hHint, flush);
        table.setLayout((Layout)this);
        int width = 0;
        int size = this.columns.size();
        for (int i = 0; i < size; ++i) {
            ColumnLayoutData col;
            ColumnLayoutData layoutData = (ColumnLayoutData)this.columns.get(i);
            if (layoutData instanceof ColumnPixelData) {
                col = (ColumnPixelData)layoutData;
                width += col.width;
                continue;
            }
            if (layoutData instanceof ColumnWeightData) {
                col = (ColumnWeightData)layoutData;
                width += ((ColumnWeightData)col).minimumWidth;
                continue;
            }
            Assert.isTrue(false, "Unknown column layout data");
        }
        if (width > result.x) {
            result.x = width;
        }
        return result;
    }

    public void layout(Composite c, boolean flush) {
        int i;
        if (!this.firstTime) {
            return;
        }
        Table table = (Table)c;
        int width = table.getClientArea().width;
        if (width <= 1) {
            return;
        }
        TableColumn[] tableColumns = table.getColumns();
        int size = Math.min(this.columns.size(), tableColumns.length);
        int[] widths = new int[size];
        int fixedWidth = 0;
        int numberOfWeightColumns = 0;
        int totalWeight = 0;
        for (i = 0; i < size; ++i) {
            ColumnLayoutData col = (ColumnLayoutData)this.columns.get(i);
            if (col instanceof ColumnPixelData) {
                int pixels;
                widths[i] = pixels = ((ColumnPixelData)col).width;
                fixedWidth += pixels;
                continue;
            }
            if (col instanceof ColumnWeightData) {
                ColumnWeightData cw = (ColumnWeightData)col;
                ++numberOfWeightColumns;
                int weight = cw.weight;
                totalWeight += weight;
                continue;
            }
            Assert.isTrue(false, "Unknown column layout data");
        }
        if (numberOfWeightColumns > 0) {
            int rest = width - fixedWidth;
            int totalDistributed = 0;
            for (int i2 = 0; i2 < size; ++i2) {
                int pixels;
                ColumnLayoutData col = (ColumnLayoutData)this.columns.get(i2);
                if (!(col instanceof ColumnWeightData)) continue;
                ColumnWeightData cw = (ColumnWeightData)col;
                int weight = cw.weight;
                int n = pixels = totalWeight == 0 ? 0 : weight * rest / totalWeight;
                if (pixels < cw.minimumWidth) {
                    pixels = cw.minimumWidth;
                }
                totalDistributed += pixels;
                widths[i2] = pixels;
            }
            int diff = rest - totalDistributed;
            int i3 = 0;
            while (diff > 0) {
                ColumnLayoutData col;
                if (i3 == size) {
                    i3 = 0;
                }
                if ((col = (ColumnLayoutData)this.columns.get(i3)) instanceof ColumnWeightData) {
                    int n = i3;
                    widths[n] = widths[n] + 1;
                    --diff;
                }
                ++i3;
            }
        }
        this.firstTime = false;
        for (i = 0; i < size; ++i) {
            tableColumns[i].setWidth(widths[i]);
        }
    }
}

