/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.EventDispatcher;
import org.eclipse.jdt.internal.debug.core.IJDIEventListener;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;

public abstract class JDIDebugElement
extends PlatformObject
implements IDebugElement,
IDisconnect {
    private static List fgJDIExceptions = new ArrayList(15);
    private JDIDebugTarget fDebugTarget;
    static /* synthetic */ Class class$com$sun$jdi$ClassNotPreparedException;
    static /* synthetic */ Class class$com$sun$jdi$InconsistentDebugInfoException;
    static /* synthetic */ Class class$com$sun$jdi$InternalException;
    static /* synthetic */ Class class$com$sun$jdi$InvalidCodeIndexException;
    static /* synthetic */ Class class$com$sun$jdi$InvalidLineNumberException;
    static /* synthetic */ Class class$com$sun$jdi$InvalidStackFrameException;
    static /* synthetic */ Class class$com$sun$jdi$NativeMethodException;
    static /* synthetic */ Class class$com$sun$jdi$ObjectCollectedException;
    static /* synthetic */ Class class$org$eclipse$jdi$TimeoutException;
    static /* synthetic */ Class class$com$sun$jdi$VMDisconnectedException;
    static /* synthetic */ Class class$com$sun$jdi$VMMismatchException;
    static /* synthetic */ Class class$com$sun$jdi$VMOutOfMemoryException;
    static /* synthetic */ Class class$com$sun$jdi$request$DuplicateRequestException;
    static /* synthetic */ Class class$com$sun$jdi$request$InvalidRequestStateException;
    static /* synthetic */ Class class$org$eclipse$jdi$hcr$OperationRefusedException;
    static /* synthetic */ Class class$org$eclipse$debug$core$model$IDebugElement;
    static /* synthetic */ Class class$org$eclipse$debug$core$model$IStepFilters;
    static /* synthetic */ Class class$org$eclipse$debug$core$model$IDebugTarget;

    public JDIDebugElement(JDIDebugTarget target) {
        this.setDebugTarget(target);
    }

    protected void logError(Exception e) {
        if (!((JDIDebugTarget)this.getDebugTarget()).isAvailable() && (e instanceof VMDisconnectedException || e instanceof CoreException && ((CoreException)((Object)e)).getStatus().getException() instanceof VMDisconnectedException)) {
            return;
        }
        JDIDebugPlugin.log(e);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == (class$org$eclipse$debug$core$model$IDebugElement == null ? (class$org$eclipse$debug$core$model$IDebugElement = JDIDebugElement.class$("org.eclipse.debug.core.model.IDebugElement")) : class$org$eclipse$debug$core$model$IDebugElement)) {
            return this;
        }
        if (adapter == (class$org$eclipse$debug$core$model$IStepFilters == null ? (class$org$eclipse$debug$core$model$IStepFilters = JDIDebugElement.class$("org.eclipse.debug.core.model.IStepFilters")) : class$org$eclipse$debug$core$model$IStepFilters)) {
            return this.getDebugTarget();
        }
        if (adapter == (class$org$eclipse$debug$core$model$IDebugTarget == null ? (class$org$eclipse$debug$core$model$IDebugTarget = JDIDebugElement.class$("org.eclipse.debug.core.model.IDebugTarget")) : class$org$eclipse$debug$core$model$IDebugTarget)) {
            return this.getDebugTarget();
        }
        return super.getAdapter(adapter);
    }

    public String getModelIdentifier() {
        return JDIDebugModel.getPluginIdentifier();
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    public void queueEvent(DebugEvent event) {
        EventDispatcher dispatcher = ((JDIDebugTarget)this.getDebugTarget()).getEventDispatcher();
        if (dispatcher != null) {
            dispatcher.queue(event);
        }
    }

    public void fireResumeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 1, detail));
    }

    public void fireSuspendEvent(int detail) {
        this.getJavaDebugTarget().incrementSuspendCount();
        this.fireEvent(new DebugEvent((Object)this, 2, detail));
    }

    public void queueSuspendEvent(int detail) {
        this.getJavaDebugTarget().incrementSuspendCount();
        this.queueEvent(new DebugEvent((Object)this, 2, detail));
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    public void fireChangeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 16, detail));
    }

    public void requestFailed(String message, Exception e) throws DebugException {
        this.requestFailed(message, e, 5012);
    }

    public void targetRequestFailed(String message, RuntimeException e) throws DebugException {
        if (e != null && !fgJDIExceptions.contains(e.getClass())) {
            throw e;
        }
        this.requestFailed(message, e, 5010);
    }

    public void requestFailed(String message, Throwable e, int code) throws DebugException {
        this.throwDebugException(message, code, e);
    }

    public void targetRequestFailed(String message, Throwable e) throws DebugException {
        this.throwDebugException(message, 5010, e);
    }

    public void jdiRequestFailed(String message, Throwable e) throws DebugException {
        this.throwDebugException(message, 5010, e);
    }

    public void notSupported(String message) throws DebugException {
        this.throwDebugException(message, 5011, null);
    }

    protected void throwDebugException(String message, int code, Throwable exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, JDIDebugModel.getPluginIdentifier(), code, message, exception));
    }

    public void internalError(RuntimeException e) {
        if (!fgJDIExceptions.contains(e.getClass())) {
            throw e;
        }
        this.logError(e);
    }

    protected void internalError(String message) {
        this.logError((Exception)((Object)new DebugException((IStatus)new Status(4, JDIDebugModel.getPluginIdentifier(), 5013, message, null))));
    }

    protected String getUnknownMessage() {
        return JDIDebugModelMessages.getString("JDIDebugElement.unknown");
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    protected JDIDebugTarget getJavaDebugTarget() {
        return this.fDebugTarget;
    }

    protected VirtualMachine getVM() {
        return ((JDIDebugTarget)this.getDebugTarget()).getVM();
    }

    public EventRequestManager getEventRequestManager() {
        VirtualMachine vm = this.getVM();
        if (vm == null) {
            return null;
        }
        return vm.eventRequestManager();
    }

    public void addJDIEventListener(IJDIEventListener listener, EventRequest request) {
        EventDispatcher dispatcher = ((JDIDebugTarget)this.getDebugTarget()).getEventDispatcher();
        if (dispatcher != null) {
            dispatcher.addJDIEventListener(listener, request);
        }
    }

    public void removeJDIEventListener(IJDIEventListener listener, EventRequest request) {
        EventDispatcher dispatcher = ((JDIDebugTarget)this.getDebugTarget()).getEventDispatcher();
        if (dispatcher != null) {
            dispatcher.removeJDIEventListener(listener, request);
        }
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    protected void setDebugTarget(JDIDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    protected void disconnected() {
        if (this.fDebugTarget != null) {
            this.fDebugTarget.disconnected();
        }
    }

    public void setRequestTimeout(int timeout) {
        VirtualMachine vm;
        if (this.supportsRequestTimeout() && (vm = this.getVM()) != null) {
            ((org.eclipse.jdi.VirtualMachine)((Object)vm)).setRequestTimeout(timeout);
        }
    }

    public int getRequestTimeout() {
        VirtualMachine vm;
        if (this.supportsRequestTimeout() && (vm = this.getVM()) != null) {
            return ((org.eclipse.jdi.VirtualMachine)((Object)vm)).getRequestTimeout();
        }
        return -1;
    }

    public boolean supportsRequestTimeout() {
        return this.getJavaDebugTarget().isAvailable() && this.getVM() instanceof org.eclipse.jdi.VirtualMachine;
    }

    public boolean canDisconnect() {
        return this.getDebugTarget().canDisconnect();
    }

    public void disconnect() throws DebugException {
        this.getDebugTarget().disconnect();
    }

    public boolean isDisconnected() {
        return this.getDebugTarget().isDisconnected();
    }

    public boolean isStepFiltersEnabled() {
        return this.getJavaDebugTarget().isStepFiltersEnabled();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        fgJDIExceptions.add(class$com$sun$jdi$ClassNotPreparedException == null ? (class$com$sun$jdi$ClassNotPreparedException = JDIDebugElement.class$("com.sun.jdi.ClassNotPreparedException")) : class$com$sun$jdi$ClassNotPreparedException);
        fgJDIExceptions.add(class$com$sun$jdi$InconsistentDebugInfoException == null ? (class$com$sun$jdi$InconsistentDebugInfoException = JDIDebugElement.class$("com.sun.jdi.InconsistentDebugInfoException")) : class$com$sun$jdi$InconsistentDebugInfoException);
        fgJDIExceptions.add(class$com$sun$jdi$InternalException == null ? (class$com$sun$jdi$InternalException = JDIDebugElement.class$("com.sun.jdi.InternalException")) : class$com$sun$jdi$InternalException);
        fgJDIExceptions.add(class$com$sun$jdi$InvalidCodeIndexException == null ? (class$com$sun$jdi$InvalidCodeIndexException = JDIDebugElement.class$("com.sun.jdi.InvalidCodeIndexException")) : class$com$sun$jdi$InvalidCodeIndexException);
        fgJDIExceptions.add(class$com$sun$jdi$InvalidLineNumberException == null ? (class$com$sun$jdi$InvalidLineNumberException = JDIDebugElement.class$("com.sun.jdi.InvalidLineNumberException")) : class$com$sun$jdi$InvalidLineNumberException);
        fgJDIExceptions.add(class$com$sun$jdi$InvalidStackFrameException == null ? (class$com$sun$jdi$InvalidStackFrameException = JDIDebugElement.class$("com.sun.jdi.InvalidStackFrameException")) : class$com$sun$jdi$InvalidStackFrameException);
        fgJDIExceptions.add(class$com$sun$jdi$NativeMethodException == null ? (class$com$sun$jdi$NativeMethodException = JDIDebugElement.class$("com.sun.jdi.NativeMethodException")) : class$com$sun$jdi$NativeMethodException);
        fgJDIExceptions.add(class$com$sun$jdi$ObjectCollectedException == null ? (class$com$sun$jdi$ObjectCollectedException = JDIDebugElement.class$("com.sun.jdi.ObjectCollectedException")) : class$com$sun$jdi$ObjectCollectedException);
        fgJDIExceptions.add(class$org$eclipse$jdi$TimeoutException == null ? (class$org$eclipse$jdi$TimeoutException = JDIDebugElement.class$("org.eclipse.jdi.TimeoutException")) : class$org$eclipse$jdi$TimeoutException);
        fgJDIExceptions.add(class$com$sun$jdi$VMDisconnectedException == null ? (class$com$sun$jdi$VMDisconnectedException = JDIDebugElement.class$("com.sun.jdi.VMDisconnectedException")) : class$com$sun$jdi$VMDisconnectedException);
        fgJDIExceptions.add(class$com$sun$jdi$VMMismatchException == null ? (class$com$sun$jdi$VMMismatchException = JDIDebugElement.class$("com.sun.jdi.VMMismatchException")) : class$com$sun$jdi$VMMismatchException);
        fgJDIExceptions.add(class$com$sun$jdi$VMOutOfMemoryException == null ? (class$com$sun$jdi$VMOutOfMemoryException = JDIDebugElement.class$("com.sun.jdi.VMOutOfMemoryException")) : class$com$sun$jdi$VMOutOfMemoryException);
        fgJDIExceptions.add(class$com$sun$jdi$request$DuplicateRequestException == null ? (class$com$sun$jdi$request$DuplicateRequestException = JDIDebugElement.class$("com.sun.jdi.request.DuplicateRequestException")) : class$com$sun$jdi$request$DuplicateRequestException);
        fgJDIExceptions.add(class$com$sun$jdi$request$InvalidRequestStateException == null ? (class$com$sun$jdi$request$InvalidRequestStateException = JDIDebugElement.class$("com.sun.jdi.request.InvalidRequestStateException")) : class$com$sun$jdi$request$InvalidRequestStateException);
        fgJDIExceptions.add(class$org$eclipse$jdi$hcr$OperationRefusedException == null ? (class$org$eclipse$jdi$hcr$OperationRefusedException = JDIDebugElement.class$("org.eclipse.jdi.hcr.OperationRefusedException")) : class$org$eclipse$jdi$hcr$OperationRefusedException);
    }
}

