/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.NameSet;
import org.eclipse.jdt.internal.core.builder.QualifiedNameSet;
import org.eclipse.jdt.internal.core.builder.StringSet;

public class ReferenceCollection {
    char[][][] qualifiedNameReferences;
    char[][] simpleNameReferences;
    static final char[][][] WellKnownQualifiedNames;
    static final char[][] WellKnownSimpleNames;
    static final char[][][] EmptyQualifiedNames;
    static final char[][] EmptySimpleNames;
    static final int MaxQualifiedNames = 7;
    static QualifiedNameSet[] InternedQualifiedNames;
    static final int MaxSimpleNames = 30;
    static NameSet[] InternedSimpleNames;

    protected ReferenceCollection(char[][][] qualifiedNameReferences, char[][] simpleNameReferences) {
        this.qualifiedNameReferences = ReferenceCollection.internQualifiedNames(qualifiedNameReferences);
        this.simpleNameReferences = ReferenceCollection.internSimpleNames(simpleNameReferences, true);
    }

    boolean includes(char[] simpleName) {
        int l = this.simpleNameReferences.length;
        for (int i = 0; i < l; ++i) {
            if (simpleName != this.simpleNameReferences[i]) continue;
            return true;
        }
        return false;
    }

    boolean includes(char[][] qualifiedName) {
        int l = this.qualifiedNameReferences.length;
        for (int i = 0; i < l; ++i) {
            if (qualifiedName != this.qualifiedNameReferences[i]) continue;
            return true;
        }
        return false;
    }

    boolean includes(char[][][] qualifiedNames, char[][] simpleNames) {
        if (simpleNames == null || qualifiedNames == null) {
            if (simpleNames == null && qualifiedNames == null) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("Found well known match");
                }
                return true;
            }
            if (qualifiedNames == null) {
                int l = simpleNames.length;
                for (int i = 0; i < l; ++i) {
                    if (!this.includes(simpleNames[i])) continue;
                    if (JavaBuilder.DEBUG) {
                        System.out.println("Found match in well known package to " + new String(simpleNames[i]));
                    }
                    return true;
                }
            } else {
                int l = qualifiedNames.length;
                for (int i = 0; i < l; ++i) {
                    char[][] qualifiedName = qualifiedNames[i];
                    if (!(qualifiedName.length == 1 ? this.includes(qualifiedName[0]) : this.includes(qualifiedName))) continue;
                    if (JavaBuilder.DEBUG) {
                        System.out.println("Found well known match in " + CharOperation.toString(qualifiedName));
                    }
                    return true;
                }
            }
        } else {
            int l = simpleNames.length;
            for (int i = 0; i < l; ++i) {
                if (!this.includes(simpleNames[i])) continue;
                int m = qualifiedNames.length;
                for (int j = 0; j < m; ++j) {
                    char[][] qualifiedName = qualifiedNames[j];
                    if (!(qualifiedName.length == 1 ? this.includes(qualifiedName[0]) : this.includes(qualifiedName))) continue;
                    if (JavaBuilder.DEBUG) {
                        System.out.println("Found match in " + CharOperation.toString(qualifiedName) + " to " + new String(simpleNames[i]));
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    static char[][][] internQualifiedNames(StringSet qualifiedStrings) {
        if (qualifiedStrings == null) {
            return EmptyQualifiedNames;
        }
        int length = qualifiedStrings.elementSize;
        if (length == 0) {
            return EmptyQualifiedNames;
        }
        char[][][] result = new char[length][][];
        String[] strings = qualifiedStrings.values;
        int l = strings.length;
        for (int i = 0; i < l; ++i) {
            if (strings[i] == null) continue;
            result[--length] = CharOperation.splitOn('/', strings[i].toCharArray());
        }
        return ReferenceCollection.internQualifiedNames(result);
    }

    static char[][][] internQualifiedNames(char[][][] qualifiedNames) {
        if (qualifiedNames == null) {
            return EmptyQualifiedNames;
        }
        int length = qualifiedNames.length;
        if (length == 0) {
            return EmptyQualifiedNames;
        }
        char[][][] keepers = new char[length][][];
        int index = 0;
        block0: for (int i = 0; i < length; ++i) {
            char[][] wellKnownName;
            char[][] qualifiedName = qualifiedNames[i];
            int qLength = qualifiedName.length;
            int m = WellKnownQualifiedNames.length;
            for (int j = 0; j < m && qLength <= (wellKnownName = WellKnownQualifiedNames[j]).length; ++j) {
                if (CharOperation.equals(qualifiedName, wellKnownName)) continue block0;
            }
            QualifiedNameSet internedNames = InternedQualifiedNames[qLength <= 7 ? qLength - 1 : 0];
            qualifiedName = ReferenceCollection.internSimpleNames(qualifiedName, false);
            keepers[index++] = internedNames.add(qualifiedName);
        }
        if (length > index) {
            if (length == 0) {
                return EmptyQualifiedNames;
            }
            char[][][] cArrayArray = keepers;
            keepers = new char[index][][];
            System.arraycopy(cArrayArray, 0, keepers, 0, index);
        }
        return keepers;
    }

    static char[][] internSimpleNames(StringSet simpleStrings) {
        if (simpleStrings == null) {
            return EmptySimpleNames;
        }
        int length = simpleStrings.elementSize;
        if (length == 0) {
            return EmptySimpleNames;
        }
        char[][] result = new char[length][];
        String[] strings = simpleStrings.values;
        int l = strings.length;
        for (int i = 0; i < l; ++i) {
            if (strings[i] == null) continue;
            result[--length] = strings[i].toCharArray();
        }
        return ReferenceCollection.internSimpleNames(result, true);
    }

    static char[][] internSimpleNames(char[][] simpleNames, boolean removeWellKnown) {
        if (simpleNames == null) {
            return EmptySimpleNames;
        }
        int length = simpleNames.length;
        if (length == 0) {
            return EmptySimpleNames;
        }
        char[][] keepers = new char[length][];
        int index = 0;
        block0: for (int i = 0; i < length; ++i) {
            char[] wellKnownName;
            char[] name = simpleNames[i];
            int sLength = name.length;
            int m = WellKnownSimpleNames.length;
            for (int j = 0; j < m && sLength <= (wellKnownName = WellKnownSimpleNames[j]).length; ++j) {
                if (!CharOperation.equals(name, wellKnownName)) continue;
                if (removeWellKnown) continue block0;
                keepers[index++] = WellKnownSimpleNames[j];
                continue block0;
            }
            NameSet internedNames = InternedSimpleNames[sLength < 30 ? sLength : 0];
            keepers[index++] = internedNames.add(name);
        }
        if (length > index) {
            if (index == 0) {
                return EmptySimpleNames;
            }
            char[][] cArrayArray = keepers;
            keepers = new char[index][];
            System.arraycopy(cArrayArray, 0, keepers, 0, index);
        }
        return keepers;
    }

    static {
        int i;
        WellKnownQualifiedNames = new char[][][]{TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION, TypeConstants.JAVA_LANG_THROWABLE, TypeConstants.JAVA_LANG_OBJECT, TypeConstants.JAVA_LANG, new char[][]{TypeConstants.JAVA}, new char[][]{{'o', 'r', 'g'}}, new char[][]{{'c', 'o', 'm'}}, CharOperation.NO_CHAR_CHAR};
        WellKnownSimpleNames = new char[][]{TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION[2], TypeConstants.JAVA_LANG_THROWABLE[2], TypeConstants.JAVA_LANG_OBJECT[2], TypeConstants.JAVA, TypeConstants.LANG, {'o', 'r', 'g'}, {'c', 'o', 'm'}};
        EmptyQualifiedNames = new char[0][][];
        EmptySimpleNames = CharOperation.NO_CHAR_CHAR;
        InternedQualifiedNames = new QualifiedNameSet[7];
        InternedSimpleNames = new NameSet[30];
        for (i = 0; i < 7; ++i) {
            ReferenceCollection.InternedQualifiedNames[i] = new QualifiedNameSet(37);
        }
        for (i = 0; i < 30; ++i) {
            ReferenceCollection.InternedSimpleNames[i] = new NameSet(37);
        }
    }
}

