/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Tag;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.TagAction;
import org.eclipse.team.internal.ccvs.ui.operations.ITagOperation;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.ui.IWorkbenchPart;

public class TagOperation
extends RepositoryProviderOperation
implements ITagOperation {
    private Set localOptions = new HashSet();
    private CVSTag tag;

    public TagOperation(IWorkbenchPart part, IResource[] resources) {
        super(part, resources);
    }

    public TagOperation(Shell shell, IResource[] resources) {
        super(null, resources);
    }

    public CVSTag getTag() {
        return this.tag;
    }

    public void setTag(CVSTag tag) {
        this.tag = tag;
    }

    protected void execute(CVSTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws CVSException, InterruptedException {
        IStatus status = this.tag(provider, resources, monitor);
        this.collectStatus(status);
    }

    private ICVSResource[] getCVSResources(IResource[] resources) {
        ICVSResource[] cvsResources = new ICVSResource[resources.length];
        for (int i = 0; i < cvsResources.length; ++i) {
            cvsResources[i] = CVSWorkspaceRoot.getCVSResourceFor((IResource)resources[i]);
        }
        return cvsResources;
    }

    protected String getErrorMessage(IStatus[] problems, int operationCount) {
        if (operationCount == 1) {
            return Policy.bind("TagAction.tagProblemsMessage");
        }
        return Policy.bind("TagAction.tagProblemsMessageMultiple", Integer.toString(operationCount - problems.length), Integer.toString(problems.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus tag(CVSTeamProvider provider, IResource[] resources, IProgressMonitor progress) throws CVSException {
        Command.LocalOption[] commandOptions = this.localOptions.toArray(new Command.LocalOption[this.localOptions.size()]);
        String[] arguments = this.getStringArguments(resources);
        CVSWorkspaceRoot root = provider.getCVSWorkspaceRoot();
        Session s = new Session(root.getRemoteLocation(), root.getLocalRoot());
        progress.beginTask(null, 100);
        try {
            s.open(Policy.subMonitorFor(progress, 20), true);
            IStatus iStatus = Command.TAG.execute(s, Command.NO_GLOBAL_OPTIONS, commandOptions, this.tag, arguments, null, Policy.subMonitorFor(progress, 80));
            return iStatus;
        }
        finally {
            s.close();
            progress.done();
        }
    }

    public void addLocalOption(Command.LocalOption option) {
        this.localOptions.add(option);
    }

    public void moveTag() {
        this.addLocalOption(Tag.FORCE_REASSIGNMENT);
    }

    public void recurse() {
        this.addLocalOption(Command.DO_NOT_RECURSE);
    }

    protected String getTaskName() {
        return Policy.bind("TagFromWorkspace.taskName");
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return Policy.bind("TagOperation.0", provider.getProject().getName());
    }

    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        super.execute(monitor);
        if (!this.errorsOccurred()) {
            try {
                TagAction.broadcastTagChange(this.getCVSResources(), this.getTag());
            }
            catch (InvocationTargetException e) {
                throw CVSException.wrapException((Exception)e);
            }
        }
    }
}

