/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.base.util.TString;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;

public class XMLGenerator {
    private File outFile = null;
    private PrintWriter out = null;
    public int pad = 0;
    private static final String[] invalidXML = new String[]{"&", ">", "<", "\"", "'"};
    private static final String[] escapedXML = new String[]{"&amp;", "&gt;", "&lt;", "&quot;", "&apos;"};

    public XMLGenerator(Writer writer) {
        this.out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public XMLGenerator(File outFile) {
        this.outFile = outFile;
        try {
            this.out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF8")), false);
            this.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        catch (IOException ioe) {
            HelpWebappPlugin.logError((String)HelpBaseResources.getString((String)"E014", (String)outFile.getAbsolutePath()), (Throwable)ioe);
        }
    }

    public static String xmlEscape(String cdata) {
        for (int i = 0; i < invalidXML.length; ++i) {
            cdata = TString.change((String)cdata, (String)invalidXML[i], (String)escapedXML[i]);
        }
        return cdata;
    }

    public void close() {
        this.out.flush();
        this.out.close();
        if (this.out.checkError() && this.outFile != null) {
            HelpWebappPlugin.logError((String)HelpBaseResources.getString((String)"E015", (String)this.outFile.getAbsolutePath()), null);
        }
        this.out = null;
    }

    public void print(Object o) {
        if (this.out != null) {
            this.out.print(o);
        }
    }

    public void println(Object o) {
        this.print(o);
        this.print("\n");
    }

    public void printPad() {
        for (int i = 0; i < this.pad; ++i) {
            this.print(" ");
        }
    }
}

