/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblyUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileForkInner;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBox;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileCircleStart;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileCircleStop;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDecorateIn;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDecorateOut;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.Sprite;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCompactFactory
implements FtileFactory {
    private final ISkinParam skinParam;
    private final Rose rose = new Rose();
    private final StringBounder stringBounder;

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public VCompactFactory(ISkinParam iSkinParam, StringBounder stringBounder) {
        this.skinParam = iSkinParam;
        this.stringBounder = stringBounder;
    }

    @Override
    public Ftile start(Swimlane swimlane) {
        HtmlColor htmlColor = this.rose.getHtmlColor(this.skinParam, ColorParam.activityStart);
        return new FtileCircleStart(this.shadowing(), htmlColor, swimlane);
    }

    @Override
    public Ftile stop(Swimlane swimlane) {
        HtmlColor htmlColor = this.rose.getHtmlColor(this.skinParam, ColorParam.activityEnd);
        return new FtileCircleStop(this.shadowing(), htmlColor, swimlane);
    }

    @Override
    public Ftile activity(Display display, HtmlColor htmlColor, Swimlane swimlane, BoxStyle boxStyle) {
        HtmlColor htmlColor2 = this.rose.getHtmlColor(this.skinParam, ColorParam.activityBorder);
        HtmlColor htmlColor3 = htmlColor == null ? this.rose.getHtmlColor(this.skinParam, ColorParam.activityBackground) : htmlColor;
        UFont uFont = this.skinParam.getFont(FontParam.ACTIVITY, null);
        HtmlColor htmlColor4 = this.rose.getHtmlColor(this.skinParam, ColorParam.activityArrow);
        return new FtileBox(this.shadowing(), display, htmlColor2, htmlColor3, uFont, htmlColor4, swimlane, boxStyle, this.skinParam);
    }

    @Override
    public Ftile addNote(Ftile ftile, Display display, NotePosition notePosition) {
        return ftile;
    }

    @Override
    public Ftile addUrl(Ftile ftile, Url url) {
        return ftile;
    }

    @Override
    public Ftile assembly(Ftile ftile, Ftile ftile2) {
        return FtileAssemblyUtils.assembly(ftile, ftile2);
    }

    @Override
    public Ftile repeat(Swimlane swimlane, Ftile ftile, Display display, Display display2, Display display3, HtmlColor htmlColor) {
        return ftile;
    }

    @Override
    public Ftile createWhile(Swimlane swimlane, Ftile ftile, Display display, Display display2, Display display3, LinkRendering linkRendering, HtmlColor htmlColor) {
        return ftile;
    }

    @Override
    public Ftile createIf(Swimlane swimlane, List<Branch> list, Branch branch) {
        ArrayList<Ftile> arrayList = new ArrayList<Ftile>();
        for (Branch branch2 : list) {
            arrayList.add(branch2.getFtile());
        }
        arrayList.add(branch.getFtile());
        return new FtileForkInner(arrayList);
    }

    @Override
    public Ftile createFork(List<Ftile> list) {
        return new FtileForkInner(list);
    }

    @Override
    public Ftile createSplit(List<Ftile> list) {
        return new FtileForkInner(list);
    }

    @Override
    public Ftile createGroup(Ftile ftile, Display display) {
        return ftile;
    }

    @Override
    public Ftile decorateIn(Ftile ftile, LinkRendering linkRendering) {
        return new FtileDecorateIn(ftile, linkRendering);
    }

    @Override
    public Ftile decorateOut(Ftile ftile, LinkRendering linkRendering) {
        return new FtileDecorateOut(ftile, linkRendering);
    }

    @Override
    public boolean shadowing() {
        return this.skinParam.shadowing();
    }

    @Override
    public Sprite getSprite(String string) {
        return this.skinParam.getSprite(string);
    }

    @Override
    public String getValue(String string) {
        return this.skinParam.getValue(string);
    }
}

