package App::InteractivePerlTutorial::Chapter::Sub::Basics;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Basics';
use constant EXERCISES => [
	{ statement => 'Write a program that contains a subroutine that reads two numbers and prints the greater number', input => "12\n57", check => sub { $_[0] eq '57' }, hint => 'Use the > and < operators', solution => <<'SOL' },
my ($x, $y);
sub printmax{
  if ($x > $y) {
    print $x;
  } else {
    print $y;
  }
}

($x, $y) = <>;
printmax;
SOL
];

1;
__DATA__

=encoding utf-8

=head1 Basics

In Perl you have built-in system functions like print and reverse, but you can also make I<subroutines>, which are user-defined functions.
Subroutines let you reuse a piece of code without having to write it again.

To define a subroutine you use B<sub>, followed by the name you want to give it and code in curly brackets.

  sub hello {
  	$x+=1;  #Global variable x
  	say "Hello world of subroutines - $x";
  }

You can put subroutine definitions anywhere in your program.

To invoke a subroutine, usually referred to as calling it, you write & followed by its name.

  &hello; # Says Hello world of subroutines - 1
  &hello; # Says Hello world of subroutines - 2
  &hello; # Says Hello world of subroutines - 3

A subroutine always gives a result back, even if you don't use it like in the example above.
That value is called the I<return value> is the result of the last evaluated expression in the subroutine.

  sub multiply_by_2{
  	$x * 2;  # That is the return value
  }

The subroutine takes the variable $x and returns x multiplied by 2.

  $x = 3;
  $y = &multiply_by_2; # y becomes 6

The last evaluated expression is not always the last statement. This subroutine returns the largest x if x>=10, or x*2 otherwise:

  sub this_subroutine{
  	if ($x >= 10){
  		x;
  	} else {
  		x * 2;
  	}
  }
