######################################################################
#
# 1157_sjis2004_by_utf8.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x00"],
        ["\x01",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x01"],
        ["\x02",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x02"],
        ["\x03",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x03"],
        ["\x04",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x04"],
        ["\x05",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x05"],
        ["\x06",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x06"],
        ["\x07",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x07"],
        ["\x08",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x08"],
        ["\x09",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x09"],
        ["\x0A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x0A"],
        ["\x0B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x0B"],
        ["\x0C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x0C"],
        ["\x0D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x0D"],
        ["\x0E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x0E"],
        ["\x0F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x0F"],
        ["\x10",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x10"],
        ["\x11",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x11"],
        ["\x12",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x12"],
        ["\x13",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x13"],
        ["\x14",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x14"],
        ["\x15",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x15"],
        ["\x16",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x16"],
        ["\x17",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x17"],
        ["\x18",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x18"],
        ["\x19",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x19"],
        ["\x1A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x1A"],
        ["\x1B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x1B"],
        ["\x1C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x1C"],
        ["\x1D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x1D"],
        ["\x1E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x1E"],
        ["\x1F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x1F"],
        ["\x20",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x20"],
        ["\x21",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x21"],
        ["\x22",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x22"],
        ["\x23",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x23"],
        ["\x24",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x24"],
        ["\x25",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x25"],
        ["\x26",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x26"],
        ["\x27",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x27"],
        ["\x28",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x28"],
        ["\x29",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x29"],
        ["\x2A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x2A"],
        ["\x2B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x2B"],
        ["\x2C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x2C"],
        ["\x2D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x2D"],
        ["\x2E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x2E"],
        ["\x2F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x2F"],
        ["\x30",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x30"],
        ["\x31",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x31"],
        ["\x32",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x32"],
        ["\x33",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x33"],
        ["\x34",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x34"],
        ["\x35",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x35"],
        ["\x36",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x36"],
        ["\x37",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x37"],
        ["\x38",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x38"],
        ["\x39",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x39"],
        ["\x3A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x3A"],
        ["\x3B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x3B"],
        ["\x3C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x3C"],
        ["\x3D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x3D"],
        ["\x3E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x3E"],
        ["\x3F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x3F"],
        ["\x40",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x40"],
        ["\x41",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x41"],
        ["\x42",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x42"],
        ["\x43",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x43"],
        ["\x44",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x44"],
        ["\x45",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x45"],
        ["\x46",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x46"],
        ["\x47",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x47"],
        ["\x48",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x48"],
        ["\x49",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x49"],
        ["\x4A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x4A"],
        ["\x4B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x4B"],
        ["\x4C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x4C"],
        ["\x4D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x4D"],
        ["\x4E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x4E"],
        ["\x4F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x4F"],
        ["\x50",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x50"],
        ["\x51",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x51"],
        ["\x52",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x52"],
        ["\x53",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x53"],
        ["\x54",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x54"],
        ["\x55",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x55"],
        ["\x56",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x56"],
        ["\x57",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x57"],
        ["\x58",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x58"],
        ["\x59",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x59"],
        ["\x5A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x5A"],
        ["\x5B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x5B"],
        ["\x5C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x5C"],
        ["\x5D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x5D"],
        ["\x5E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x5E"],
        ["\x5F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x5F"],
        ["\x60",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x60"],
        ["\x61",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x61"],
        ["\x62",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x62"],
        ["\x63",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x63"],
        ["\x64",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x64"],
        ["\x65",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x65"],
        ["\x66",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x66"],
        ["\x67",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x67"],
        ["\x68",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x68"],
        ["\x69",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x69"],
        ["\x6A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x6A"],
        ["\x6B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x6B"],
        ["\x6C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x6C"],
        ["\x6D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x6D"],
        ["\x6E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x6E"],
        ["\x6F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x6F"],
        ["\x70",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x70"],
        ["\x71",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x71"],
        ["\x72",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x72"],
        ["\x73",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x73"],
        ["\x74",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x74"],
        ["\x75",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x75"],
        ["\x76",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x76"],
        ["\x77",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x77"],
        ["\x78",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x78"],
        ["\x79",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x79"],
        ["\x7A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x7A"],
        ["\x7B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x7B"],
        ["\x7C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x7C"],
        ["\x7D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x7D"],
        ["\x7E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x7E"],
        ["\x7F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'S'},"\x7F"],
        ["\xEF\xBD\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1"],
        ["\xEF\xBD\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2"],
        ["\xEF\xBD\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3"],
        ["\xEF\xBD\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4"],
        ["\xEF\xBD\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5"],
        ["\xEF\xBD\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6"],
        ["\xEF\xBD\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7"],
        ["\xEF\xBD\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xA8"],
        ["\xEF\xBD\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xA9"],
        ["\xEF\xBD\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xAA"],
        ["\xEF\xBD\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xAB"],
        ["\xEF\xBD\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xAC"],
        ["\xEF\xBD\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xAD"],
        ["\xEF\xBD\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xAE"],
        ["\xEF\xBD\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF"],
        ["\xEF\xBD\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0"],
        ["\xEF\xBD\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1"],
        ["\xEF\xBD\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2"],
        ["\xEF\xBD\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3"],
        ["\xEF\xBD\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4"],
        ["\xEF\xBD\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5"],
        ["\xEF\xBD\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6"],
        ["\xEF\xBD\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7"],
        ["\xEF\xBD\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8"],
        ["\xEF\xBD\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9"],
        ["\xEF\xBD\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA"],
        ["\xEF\xBD\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB"],
        ["\xEF\xBD\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC"],
        ["\xEF\xBD\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD"],
        ["\xEF\xBD\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE"],
        ["\xEF\xBD\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF"],
        ["\xEF\xBE\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0"],
        ["\xEF\xBE\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1"],
        ["\xEF\xBE\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2"],
        ["\xEF\xBE\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3"],
        ["\xEF\xBE\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4"],
        ["\xEF\xBE\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5"],
        ["\xEF\xBE\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6"],
        ["\xEF\xBE\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7"],
        ["\xEF\xBE\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8"],
        ["\xEF\xBE\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9"],
        ["\xEF\xBE\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA"],
        ["\xEF\xBE\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB"],
        ["\xEF\xBE\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC"],
        ["\xEF\xBE\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD"],
        ["\xEF\xBE\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE"],
        ["\xEF\xBE\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF"],
        ["\xEF\xBE\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0"],
        ["\xEF\xBE\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1"],
        ["\xEF\xBE\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2"],
        ["\xEF\xBE\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3"],
        ["\xEF\xBE\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4"],
        ["\xEF\xBE\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5"],
        ["\xEF\xBE\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6"],
        ["\xEF\xBE\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7"],
        ["\xEF\xBE\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8"],
        ["\xEF\xBE\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9"],
        ["\xEF\xBE\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA"],
        ["\xEF\xBE\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB"],
        ["\xEF\xBE\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC"],
        ["\xEF\xBE\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD"],
        ["\xEF\xBE\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE"],
        ["\xEF\xBE\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF"],
        ["\xE3\x80\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x40"],
        ["\xE3\x80\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x41"],
        ["\xE3\x80\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x42"],
        ["\xEF\xBC\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x43"],
        ["\xEF\xBC\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x44"],
        ["\xE3\x83\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x45"],
        ["\xEF\xBC\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x46"],
        ["\xEF\xBC\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x47"],
        ["\xEF\xBC\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x48"],
        ["\xEF\xBC\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x49"],
        ["\xE3\x82\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x4A"],
        ["\xE3\x82\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x4B"],
        ["\xC2\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x4C"],
        ["\xEF\xBD\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x4D"],
        ["\xC2\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x4E"],
        ["\xEF\xBC\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x4F"],
        ["\xEF\xBF\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x50"],
        ["\xEF\xBC\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x51"],
        ["\xE3\x83\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x52"],
        ["\xE3\x83\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x53"],
        ["\xE3\x82\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x54"],
        ["\xE3\x82\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x55"],
        ["\xE3\x80\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x56"],
        ["\xE4\xBB\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x57"],
        ["\xE3\x80\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x58"],
        ["\xE3\x80\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x59"],
        ["\xE3\x80\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x5A"],
        ["\xE3\x83\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x5B"],
        ["\xE2\x80\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE2\x80\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x5D"],
        ["\xEF\xBC\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x5E"],
        ["\xEF\xBC\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE3\x80\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x60"],
        ["\xE2\x88\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xD2"],
        ["\xEF\xBD\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x62"],
        ["\xE2\x80\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x63"],
        ["\xE2\x80\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x64"],
        ["\xE2\x80\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x65"],
        ["\xE2\x80\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x66"],
        ["\xE2\x80\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x67"],
        ["\xE2\x80\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x68"],
        ["\xEF\xBC\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x69"],
        ["\xEF\xBC\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x6A"],
        ["\xE3\x80\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x6B"],
        ["\xE3\x80\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x6C"],
        ["\xEF\xBC\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x6D"],
        ["\xEF\xBC\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x6E"],
        ["\xEF\xBD\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x6F"],
        ["\xEF\xBD\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x70"],
        ["\xE3\x80\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x71"],
        ["\xE3\x80\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x72"],
        ["\xE3\x80\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x73"],
        ["\xE3\x80\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x74"],
        ["\xE3\x80\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x75"],
        ["\xE3\x80\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x76"],
        ["\xE3\x80\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x77"],
        ["\xE3\x80\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x78"],
        ["\xE3\x80\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x79"],
        ["\xE3\x80\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x7A"],
        ["\xEF\xBC\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x7B"],
        ["\xEF\xBC\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAF"],
        ["\xC2\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x7D"],
        ["\xC3\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x7E"],
        ["\xC3\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x80"],
        ["\xEF\xBC\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x81"],
        ["\xE2\x89\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x82"],
        ["\xEF\xBC\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x83"],
        ["\xEF\xBC\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x84"],
        ["\xE2\x89\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x85"],
        ["\xE2\x89\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x86"],
        ["\xE2\x88\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x87"],
        ["\xE2\x88\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x88"],
        ["\xE2\x99\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x89"],
        ["\xE2\x99\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x8A"],
        ["\xC2\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x8B"],
        ["\xE2\x80\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x8C"],
        ["\xE2\x80\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x8D"],
        ["\xE2\x84\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x8E"],
        ["\xEF\xBF\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x8F"],
        ["\xEF\xBC\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x90"],
        ["\xEF\xBF\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xEF\xBF\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xEF\xBC\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x93"],
        ["\xEF\xBC\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x94"],
        ["\xEF\xBC\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x95"],
        ["\xEF\xBC\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x96"],
        ["\xEF\xBC\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x97"],
        ["\xC2\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x98"],
        ["\xE2\x98\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x99"],
        ["\xE2\x98\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x9A"],
        ["\xE2\x97\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x9B"],
        ["\xE2\x97\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x9C"],
        ["\xE2\x97\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x9D"],
        ["\xE2\x97\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x9E"],
        ["\xE2\x97\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x9F"],
        ["\xE2\x96\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA0"],
        ["\xE2\x96\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA1"],
        ["\xE2\x96\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA2"],
        ["\xE2\x96\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA3"],
        ["\xE2\x96\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA4"],
        ["\xE2\x96\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA5"],
        ["\xE2\x80\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA6"],
        ["\xE3\x80\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA7"],
        ["\xE2\x86\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA8"],
        ["\xE2\x86\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA9"],
        ["\xE2\x86\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAA"],
        ["\xE2\x86\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAB"],
        ["\xE3\x80\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE2\x88\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xB8"],
        ["\xE2\x88\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xB9"],
        ["\xE2\x8A\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xBA"],
        ["\xE2\x8A\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xBB"],
        ["\xE2\x8A\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xBC"],
        ["\xE2\x8A\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xBD"],
        ["\xE2\x88\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xBE"],
        ["\xE2\x88\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xBF"],
        ["\xE2\x88\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xC8"],
        ["\xE2\x88\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xC9"],
        ["\xEF\xBF\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE2\x87\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xCB"],
        ["\xE2\x87\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xCC"],
        ["\xE2\x88\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xCD"],
        ["\xE2\x88\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xCE"],
        ["\xE2\x88\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xDA"],
        ["\xE2\x8A\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xDB"],
        ["\xE2\x8C\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xDC"],
        ["\xE2\x88\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xDD"],
        ["\xE2\x88\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xDE"],
        ["\xE2\x89\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xDF"],
        ["\xE2\x89\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE0"],
        ["\xE2\x89\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE1"],
        ["\xE2\x89\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE2"],
        ["\xE2\x88\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE3"],
        ["\xE2\x88\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE4"],
        ["\xE2\x88\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE5"],
        ["\xE2\x88\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE6"],
        ["\xE2\x88\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE7"],
        ["\xE2\x88\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE8"],
        ["\xE2\x84\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF0"],
        ["\xE2\x80\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF1"],
        ["\xE2\x99\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF2"],
        ["\xE2\x99\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF3"],
        ["\xE2\x99\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF4"],
        ["\xE2\x80\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF5"],
        ["\xE2\x80\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF6"],
        ["\xC2\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF7"],
        ["\xE2\x97\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xFC"],
        ["\xEF\xBC\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x4F"],
        ["\xEF\xBC\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x50"],
        ["\xEF\xBC\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x51"],
        ["\xEF\xBC\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x52"],
        ["\xEF\xBC\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x53"],
        ["\xEF\xBC\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x54"],
        ["\xEF\xBC\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x55"],
        ["\xEF\xBC\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x56"],
        ["\xEF\xBC\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x57"],
        ["\xEF\xBC\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x58"],
        ["\xEF\xBC\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x60"],
        ["\xEF\xBC\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x61"],
        ["\xEF\xBC\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x62"],
        ["\xEF\xBC\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x63"],
        ["\xEF\xBC\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x64"],
        ["\xEF\xBC\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x65"],
        ["\xEF\xBC\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x66"],
        ["\xEF\xBC\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x67"],
        ["\xEF\xBC\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x68"],
        ["\xEF\xBC\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x69"],
        ["\xEF\xBC\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x6A"],
        ["\xEF\xBC\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x6B"],
        ["\xEF\xBC\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x6C"],
        ["\xEF\xBC\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x6D"],
        ["\xEF\xBC\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x6E"],
        ["\xEF\xBC\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x6F"],
        ["\xEF\xBC\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x70"],
        ["\xEF\xBC\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x71"],
        ["\xEF\xBC\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x72"],
        ["\xEF\xBC\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x73"],
        ["\xEF\xBC\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x74"],
        ["\xEF\xBC\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x75"],
        ["\xEF\xBC\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x76"],
        ["\xEF\xBC\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x77"],
        ["\xEF\xBC\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x78"],
        ["\xEF\xBC\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x79"],
        ["\xEF\xBD\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x81"],
        ["\xEF\xBD\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x82"],
        ["\xEF\xBD\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x83"],
        ["\xEF\xBD\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x84"],
        ["\xEF\xBD\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x85"],
        ["\xEF\xBD\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x86"],
        ["\xEF\xBD\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x87"],
        ["\xEF\xBD\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x88"],
        ["\xEF\xBD\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x89"],
        ["\xEF\xBD\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x8A"],
        ["\xEF\xBD\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x8B"],
        ["\xEF\xBD\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x8C"],
        ["\xEF\xBD\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x8D"],
        ["\xEF\xBD\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x8E"],
        ["\xEF\xBD\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x8F"],
        ["\xEF\xBD\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x90"],
        ["\xEF\xBD\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x91"],
        ["\xEF\xBD\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x92"],
        ["\xEF\xBD\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x93"],
        ["\xEF\xBD\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x94"],
        ["\xEF\xBD\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x95"],
        ["\xEF\xBD\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x96"],
        ["\xEF\xBD\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x97"],
        ["\xEF\xBD\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x98"],
        ["\xEF\xBD\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x99"],
        ["\xEF\xBD\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x9A"],
        ["\xE3\x81\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x9F"],
        ["\xE3\x81\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA0"],
        ["\xE3\x81\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA1"],
        ["\xE3\x81\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA2"],
        ["\xE3\x81\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA3"],
        ["\xE3\x81\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA4"],
        ["\xE3\x81\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA5"],
        ["\xE3\x81\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA6"],
        ["\xE3\x81\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA7"],
        ["\xE3\x81\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA8"],
        ["\xE3\x81\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA9"],
        ["\xE3\x81\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xAA"],
        ["\xE3\x81\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xAB"],
        ["\xE3\x81\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xAC"],
        ["\xE3\x81\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xAD"],
        ["\xE3\x81\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xAE"],
        ["\xE3\x81\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xAF"],
        ["\xE3\x81\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB0"],
        ["\xE3\x81\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB1"],
        ["\xE3\x81\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB2"],
        ["\xE3\x81\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB3"],
        ["\xE3\x81\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB4"],
        ["\xE3\x81\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB5"],
        ["\xE3\x81\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB6"],
        ["\xE3\x81\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB7"],
        ["\xE3\x81\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB8"],
        ["\xE3\x81\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB9"],
        ["\xE3\x81\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xBA"],
        ["\xE3\x81\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xBB"],
        ["\xE3\x81\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xBC"],
        ["\xE3\x81\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xBD"],
        ["\xE3\x81\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xBE"],
        ["\xE3\x81\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xBF"],
        ["\xE3\x81\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC0"],
        ["\xE3\x81\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC1"],
        ["\xE3\x81\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC2"],
        ["\xE3\x81\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC3"],
        ["\xE3\x81\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC4"],
        ["\xE3\x81\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC5"],
        ["\xE3\x81\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC6"],
        ["\xE3\x81\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC7"],
        ["\xE3\x81\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC8"],
        ["\xE3\x81\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC9"],
        ["\xE3\x81\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xCA"],
        ["\xE3\x81\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xCB"],
        ["\xE3\x81\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xCC"],
        ["\xE3\x81\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xCD"],
        ["\xE3\x81\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xCE"],
        ["\xE3\x81\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xCF"],
        ["\xE3\x81\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD0"],
        ["\xE3\x81\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD1"],
        ["\xE3\x81\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD2"],
        ["\xE3\x81\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD3"],
        ["\xE3\x81\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD4"],
        ["\xE3\x81\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD5"],
        ["\xE3\x81\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD6"],
        ["\xE3\x81\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD7"],
        ["\xE3\x81\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD8"],
        ["\xE3\x81\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD9"],
        ["\xE3\x81\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xDA"],
        ["\xE3\x81\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xDB"],
        ["\xE3\x81\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xDC"],
        ["\xE3\x81\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xDD"],
        ["\xE3\x82\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xDE"],
        ["\xE3\x82\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xDF"],
        ["\xE3\x82\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE0"],
        ["\xE3\x82\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE1"],
        ["\xE3\x82\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE2"],
        ["\xE3\x82\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE3"],
        ["\xE3\x82\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE4"],
        ["\xE3\x82\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE5"],
        ["\xE3\x82\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE6"],
        ["\xE3\x82\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE7"],
        ["\xE3\x82\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE8"],
        ["\xE3\x82\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE9"],
        ["\xE3\x82\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xEA"],
        ["\xE3\x82\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xEB"],
        ["\xE3\x82\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xEC"],
        ["\xE3\x82\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xED"],
        ["\xE3\x82\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xEE"],
        ["\xE3\x82\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xEF"],
        ["\xE3\x82\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xF0"],
        ["\xE3\x82\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xF1"],
        ["\xE3\x82\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x40"],
        ["\xE3\x82\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x41"],
        ["\xE3\x82\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x42"],
        ["\xE3\x82\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x43"],
        ["\xE3\x82\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x44"],
        ["\xE3\x82\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x45"],
        ["\xE3\x82\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x46"],
        ["\xE3\x82\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x47"],
        ["\xE3\x82\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x48"],
        ["\xE3\x82\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x49"],
        ["\xE3\x82\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x4A"],
        ["\xE3\x82\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x4B"],
        ["\xE3\x82\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x4C"],
        ["\xE3\x82\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x4D"],
        ["\xE3\x82\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x4E"],
        ["\xE3\x82\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x4F"],
        ["\xE3\x82\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x50"],
        ["\xE3\x82\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x51"],
        ["\xE3\x82\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x52"],
        ["\xE3\x82\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x53"],
        ["\xE3\x82\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x54"],
        ["\xE3\x82\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x55"],
        ["\xE3\x82\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x56"],
        ["\xE3\x82\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x57"],
        ["\xE3\x82\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x58"],
        ["\xE3\x82\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x59"],
        ["\xE3\x82\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x5A"],
        ["\xE3\x82\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x5B"],
        ["\xE3\x82\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x5C"],
        ["\xE3\x82\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x5D"],
        ["\xE3\x82\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x5E"],
        ["\xE3\x83\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x5F"],
        ["\xE3\x83\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x60"],
        ["\xE3\x83\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x61"],
        ["\xE3\x83\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x62"],
        ["\xE3\x83\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x63"],
        ["\xE3\x83\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x64"],
        ["\xE3\x83\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x65"],
        ["\xE3\x83\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x66"],
        ["\xE3\x83\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x67"],
        ["\xE3\x83\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x68"],
        ["\xE3\x83\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x69"],
        ["\xE3\x83\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x6A"],
        ["\xE3\x83\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x6B"],
        ["\xE3\x83\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x6C"],
        ["\xE3\x83\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x6D"],
        ["\xE3\x83\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x6E"],
        ["\xE3\x83\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x6F"],
        ["\xE3\x83\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x70"],
        ["\xE3\x83\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x71"],
        ["\xE3\x83\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x72"],
        ["\xE3\x83\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x73"],
        ["\xE3\x83\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x74"],
        ["\xE3\x83\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x75"],
        ["\xE3\x83\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x76"],
        ["\xE3\x83\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x77"],
        ["\xE3\x83\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x78"],
        ["\xE3\x83\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x79"],
        ["\xE3\x83\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x7A"],
        ["\xE3\x83\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x7B"],
        ["\xE3\x83\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x7C"],
        ["\xE3\x83\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x7D"],
        ["\xE3\x83\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x7E"],
        ["\xE3\x83\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x80"],
        ["\xE3\x83\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x81"],
        ["\xE3\x83\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x82"],
        ["\xE3\x83\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x83"],
        ["\xE3\x83\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x84"],
        ["\xE3\x83\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x85"],
        ["\xE3\x83\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x86"],
        ["\xE3\x83\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x87"],
        ["\xE3\x83\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x88"],
        ["\xE3\x83\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x89"],
        ["\xE3\x83\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x8A"],
        ["\xE3\x83\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x8B"],
        ["\xE3\x83\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x8C"],
        ["\xE3\x83\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x8D"],
        ["\xE3\x83\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x8E"],
        ["\xE3\x83\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x8F"],
        ["\xE3\x83\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x90"],
        ["\xE3\x83\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x91"],
        ["\xE3\x83\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x92"],
        ["\xE3\x83\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x93"],
        ["\xE3\x83\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x94"],
        ["\xE3\x83\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x95"],
        ["\xE3\x83\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x96"],
        ["\xCE\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x9F"],
        ["\xCE\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA0"],
        ["\xCE\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA1"],
        ["\xCE\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA2"],
        ["\xCE\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA3"],
        ["\xCE\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA4"],
        ["\xCE\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA5"],
        ["\xCE\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA6"],
        ["\xCE\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA7"],
        ["\xCE\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA8"],
        ["\xCE\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA9"],
        ["\xCE\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xAA"],
        ["\xCE\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xAB"],
        ["\xCE\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xAC"],
        ["\xCE\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xAD"],
        ["\xCE\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xAE"],
        ["\xCE\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xAF"],
        ["\xCE\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB0"],
        ["\xCE\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB1"],
        ["\xCE\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB2"],
        ["\xCE\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB3"],
        ["\xCE\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB4"],
        ["\xCE\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB5"],
        ["\xCE\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB6"],
        ["\xCE\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xBF"],
        ["\xCE\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC0"],
        ["\xCE\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC1"],
        ["\xCE\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC2"],
        ["\xCE\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC3"],
        ["\xCE\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC4"],
        ["\xCE\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC5"],
        ["\xCE\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC6"],
        ["\xCE\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC7"],
        ["\xCE\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC8"],
        ["\xCE\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC9"],
        ["\xCE\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xCA"],
        ["\xCE\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xCB"],
        ["\xCE\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xCC"],
        ["\xCE\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xCD"],
        ["\xCF\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xCE"],
        ["\xCF\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xCF"],
        ["\xCF\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD0"],
        ["\xCF\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD1"],
        ["\xCF\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD2"],
        ["\xCF\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD3"],
        ["\xCF\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD4"],
        ["\xCF\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD5"],
        ["\xCF\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD6"],
        ["\xD0\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x40"],
        ["\xD0\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x41"],
        ["\xD0\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x42"],
        ["\xD0\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x43"],
        ["\xD0\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x44"],
        ["\xD0\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x45"],
        ["\xD0\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x46"],
        ["\xD0\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x47"],
        ["\xD0\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x48"],
        ["\xD0\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x49"],
        ["\xD0\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x4A"],
        ["\xD0\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x4B"],
        ["\xD0\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x4C"],
        ["\xD0\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x4D"],
        ["\xD0\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x4E"],
        ["\xD0\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x4F"],
        ["\xD0\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x50"],
        ["\xD0\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x51"],
        ["\xD0\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x52"],
        ["\xD0\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x53"],
        ["\xD0\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x54"],
        ["\xD0\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x55"],
        ["\xD0\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x56"],
        ["\xD0\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x57"],
        ["\xD0\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x58"],
        ["\xD0\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x59"],
        ["\xD0\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x5A"],
        ["\xD0\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x5B"],
        ["\xD0\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x5C"],
        ["\xD0\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x5D"],
        ["\xD0\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x5E"],
        ["\xD0\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x5F"],
        ["\xD0\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x60"],
        ["\xD0\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x70"],
        ["\xD0\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x71"],
        ["\xD0\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x72"],
        ["\xD0\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x73"],
        ["\xD0\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x74"],
        ["\xD0\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x75"],
        ["\xD1\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x76"],
        ["\xD0\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x77"],
        ["\xD0\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x78"],
        ["\xD0\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x79"],
        ["\xD0\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x7A"],
        ["\xD0\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x7B"],
        ["\xD0\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x7C"],
        ["\xD0\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x7D"],
        ["\xD0\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x7E"],
        ["\xD0\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x80"],
        ["\xD0\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x81"],
        ["\xD1\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x82"],
        ["\xD1\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x83"],
        ["\xD1\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x84"],
        ["\xD1\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x85"],
        ["\xD1\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x86"],
        ["\xD1\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x87"],
        ["\xD1\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x88"],
        ["\xD1\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x89"],
        ["\xD1\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x8A"],
        ["\xD1\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x8B"],
        ["\xD1\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x8C"],
        ["\xD1\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x8D"],
        ["\xD1\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x8E"],
        ["\xD1\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x8F"],
        ["\xD1\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x90"],
        ["\xD1\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x91"],
        ["\xE2\x94\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x9F"],
        ["\xE2\x94\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA0"],
        ["\xE2\x94\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA1"],
        ["\xE2\x94\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA2"],
        ["\xE2\x94\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA3"],
        ["\xE2\x94\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA4"],
        ["\xE2\x94\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA5"],
        ["\xE2\x94\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA6"],
        ["\xE2\x94\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA7"],
        ["\xE2\x94\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA8"],
        ["\xE2\x94\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA9"],
        ["\xE2\x94\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xAA"],
        ["\xE2\x94\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xAB"],
        ["\xE2\x94\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xAC"],
        ["\xE2\x94\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xAD"],
        ["\xE2\x94\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xAE"],
        ["\xE2\x94\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xAF"],
        ["\xE2\x94\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB0"],
        ["\xE2\x94\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB1"],
        ["\xE2\x94\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB2"],
        ["\xE2\x94\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB3"],
        ["\xE2\x95\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB4"],
        ["\xE2\x94\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB5"],
        ["\xE2\x94\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB6"],
        ["\xE2\x94\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB7"],
        ["\xE2\x94\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB8"],
        ["\xE2\x94\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB9"],
        ["\xE2\x94\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xBA"],
        ["\xE2\x94\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xBB"],
        ["\xE2\x94\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xBC"],
        ["\xE2\x94\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xBD"],
        ["\xE2\x95\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xBE"],
        ["\xE2\x91\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x40"],
        ["\xE2\x91\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x41"],
        ["\xE2\x91\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x42"],
        ["\xE2\x91\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x43"],
        ["\xE2\x91\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x44"],
        ["\xE2\x91\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x45"],
        ["\xE2\x91\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x46"],
        ["\xE2\x91\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x47"],
        ["\xE2\x91\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x48"],
        ["\xE2\x91\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x49"],
        ["\xE2\x91\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x4A"],
        ["\xE2\x91\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x4B"],
        ["\xE2\x91\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x4C"],
        ["\xE2\x91\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x4D"],
        ["\xE2\x91\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x4E"],
        ["\xE2\x91\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x4F"],
        ["\xE2\x91\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x50"],
        ["\xE2\x91\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x51"],
        ["\xE2\x91\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x52"],
        ["\xE2\x91\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x53"],
        ["\xE2\x85\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x54"],
        ["\xE2\x85\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x55"],
        ["\xE2\x85\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x56"],
        ["\xE2\x85\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x57"],
        ["\xE2\x85\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x58"],
        ["\xE2\x85\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x59"],
        ["\xE2\x85\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x5A"],
        ["\xE2\x85\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x5B"],
        ["\xE2\x85\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x5C"],
        ["\xE2\x85\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x5D"],
        ["\xE3\x8D\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x5F"],
        ["\xE3\x8C\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x60"],
        ["\xE3\x8C\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x61"],
        ["\xE3\x8D\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x62"],
        ["\xE3\x8C\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x63"],
        ["\xE3\x8C\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x64"],
        ["\xE3\x8C\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x65"],
        ["\xE3\x8C\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x66"],
        ["\xE3\x8D\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x67"],
        ["\xE3\x8D\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x68"],
        ["\xE3\x8C\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x69"],
        ["\xE3\x8C\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x6A"],
        ["\xE3\x8C\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x6B"],
        ["\xE3\x8C\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x6C"],
        ["\xE3\x8D\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x6D"],
        ["\xE3\x8C\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x6E"],
        ["\xE3\x8E\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x6F"],
        ["\xE3\x8E\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x70"],
        ["\xE3\x8E\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x71"],
        ["\xE3\x8E\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x72"],
        ["\xE3\x8E\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x73"],
        ["\xE3\x8F\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x74"],
        ["\xE3\x8E\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x75"],
        ["\xE3\x8D\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x7E"],
        ["\xE3\x80\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x80"],
        ["\xE3\x80\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x81"],
        ["\xE2\x84\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x82"],
        ["\xE3\x8F\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x83"],
        ["\xE2\x84\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x84"],
        ["\xE3\x8A\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x85"],
        ["\xE3\x8A\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x86"],
        ["\xE3\x8A\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x87"],
        ["\xE3\x8A\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x88"],
        ["\xE3\x8A\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x89"],
        ["\xE3\x88\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x8A"],
        ["\xE3\x88\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x8B"],
        ["\xE3\x88\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x8C"],
        ["\xE3\x8D\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x8D"],
        ["\xE3\x8D\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x8E"],
        ["\xE3\x8D\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x8F"],
        ["\xE2\x88\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x93"],
        ["\xE2\x88\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE2\x88\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x98"],
        ["\xE2\x8A\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x99"],
        ["\xE4\xBA\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x9F"],
        ["\xE5\x94\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA0"],
        ["\xE5\xA8\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA1"],
        ["\xE9\x98\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA2"],
        ["\xE5\x93\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA3"],
        ["\xE6\x84\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA4"],
        ["\xE6\x8C\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA5"],
        ["\xE5\xA7\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA6"],
        ["\xE9\x80\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA7"],
        ["\xE8\x91\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA8"],
        ["\xE8\x8C\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA9"],
        ["\xE7\xA9\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xAA"],
        ["\xE6\x82\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xAB"],
        ["\xE6\x8F\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xAC"],
        ["\xE6\xB8\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xAD"],
        ["\xE6\x97\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xAE"],
        ["\xE8\x91\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xAF"],
        ["\xE8\x8A\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB0"],
        ["\xE9\xAF\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB1"],
        ["\xE6\xA2\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB2"],
        ["\xE5\x9C\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB3"],
        ["\xE6\x96\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB4"],
        ["\xE6\x89\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB5"],
        ["\xE5\xAE\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB6"],
        ["\xE5\xA7\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB7"],
        ["\xE8\x99\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB8"],
        ["\xE9\xA3\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB9"],
        ["\xE7\xB5\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xBA"],
        ["\xE7\xB6\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xBB"],
        ["\xE9\xAE\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xBC"],
        ["\xE6\x88\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xBD"],
        ["\xE7\xB2\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xBE"],
        ["\xE8\xA2\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xBF"],
        ["\xE5\xAE\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC0"],
        ["\xE5\xBA\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC1"],
        ["\xE6\x8C\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC2"],
        ["\xE6\x9A\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC3"],
        ["\xE6\xA1\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC4"],
        ["\xE9\x97\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC5"],
        ["\xE9\x9E\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC6"],
        ["\xE6\x9D\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC7"],
        ["\xE4\xBB\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC8"],
        ["\xE4\xBC\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC9"],
        ["\xE4\xBD\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xCA"],
        ["\xE4\xBE\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xCB"],
        ["\xE5\x81\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xCC"],
        ["\xE5\x9B\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xCD"],
        ["\xE5\xA4\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xCE"],
        ["\xE5\xA7\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xCF"],
        ["\xE5\xA8\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD0"],
        ["\xE5\xB0\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD1"],
        ["\xE6\x83\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD2"],
        ["\xE6\x84\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD3"],
        ["\xE6\x85\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD4"],
        ["\xE6\x98\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD5"],
        ["\xE6\xA4\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD6"],
        ["\xE7\x82\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD7"],
        ["\xE7\x95\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD8"],
        ["\xE7\x95\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD9"],
        ["\xE7\xA7\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xDA"],
        ["\xE7\xB6\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xDB"],
        ["\xE7\xB7\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xDC"],
        ["\xE8\x83\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xDD"],
        ["\xE8\x90\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xDE"],
        ["\xE8\xA1\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xDF"],
        ["\xE8\xAC\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE0"],
        ["\xE9\x81\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE1"],
        ["\xE9\x81\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE2"],
        ["\xE5\x8C\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE3"],
        ["\xE4\xBA\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE4"],
        ["\xE4\xBA\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE5"],
        ["\xE5\x9F\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE6"],
        ["\xE8\x82\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE7"],
        ["\xE9\x83\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE8"],
        ["\xE7\xA3\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE9"],
        ["\xE4\xB8\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xEA"],
        ["\xE5\xA3\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xEB"],
        ["\xE6\xBA\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xEC"],
        ["\xE9\x80\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xED"],
        ["\xE7\xA8\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xEE"],
        ["\xE8\x8C\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xEF"],
        ["\xE8\x8A\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF0"],
        ["\xE9\xB0\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF1"],
        ["\xE5\x85\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF2"],
        ["\xE5\x8D\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF3"],
        ["\xE5\x92\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF4"],
        ["\xE5\x93\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF5"],
        ["\xE5\x9B\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF6"],
        ["\xE5\xA7\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF7"],
        ["\xE5\xBC\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF8"],
        ["\xE9\xA3\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF9"],
        ["\xE6\xB7\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xFA"],
        ["\xE8\x83\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xFB"],
        ["\xE8\x94\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xFC"],
        ["\xE9\x99\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x40"],
        ["\xE9\x99\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x41"],
        ["\xE9\x9A\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x42"],
        ["\xE9\x9F\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x43"],
        ["\xE5\x90\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x44"],
        ["\xE5\x8F\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x45"],
        ["\xE5\xAE\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x46"],
        ["\xE7\x83\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x47"],
        ["\xE7\xBE\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x48"],
        ["\xE8\xBF\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x49"],
        ["\xE9\x9B\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x4A"],
        ["\xE5\x8D\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x4B"],
        ["\xE9\xB5\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x4C"],
        ["\xE7\xAA\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x4D"],
        ["\xE4\xB8\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x4E"],
        ["\xE7\xA2\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x4F"],
        ["\xE8\x87\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x50"],
        ["\xE6\xB8\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x51"],
        ["\xE5\x98\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x52"],
        ["\xE5\x94\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x53"],
        ["\xE6\xAC\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x54"],
        ["\xE8\x94\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x55"],
        ["\xE9\xB0\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x56"],
        ["\xE5\xA7\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x57"],
        ["\xE5\x8E\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x58"],
        ["\xE6\xB5\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x59"],
        ["\xE7\x93\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x5A"],
        ["\xE9\x96\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x5B"],
        ["\xE5\x99\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x5C"],
        ["\xE4\xBA\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x5D"],
        ["\xE9\x81\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x5E"],
        ["\xE9\x9B\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x5F"],
        ["\xE8\x8D\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x60"],
        ["\xE9\xA4\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x61"],
        ["\xE5\x8F\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x62"],
        ["\xE5\x96\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x63"],
        ["\xE5\xAC\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x64"],
        ["\xE5\xBD\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x65"],
        ["\xE6\x98\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x66"],
        ["\xE6\x9B\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x67"],
        ["\xE6\xA0\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x68"],
        ["\xE6\xB0\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x69"],
        ["\xE6\xB3\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x6A"],
        ["\xE6\xB4\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x6B"],
        ["\xE7\x91\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x6C"],
        ["\xE7\x9B\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x6D"],
        ["\xE7\xA9\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x6E"],
        ["\xE9\xA0\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x6F"],
        ["\xE8\x8B\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x70"],
        ["\xE8\xA1\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x71"],
        ["\xE8\xA9\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x72"],
        ["\xE9\x8B\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x73"],
        ["\xE6\xB6\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x74"],
        ["\xE7\x96\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x75"],
        ["\xE7\x9B\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x76"],
        ["\xE9\xA7\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x77"],
        ["\xE6\x82\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x78"],
        ["\xE8\xAC\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x79"],
        ["\xE8\xB6\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x7A"],
        ["\xE9\x96\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x7B"],
        ["\xE6\xA6\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x7C"],
        ["\xE5\x8E\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x7D"],
        ["\xE5\x86\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x7E"],
        ["\xE5\x9C\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x80"],
        ["\xE5\xA0\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x81"],
        ["\xE5\xA5\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x82"],
        ["\xE5\xAE\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x83"],
        ["\xE5\xBB\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x84"],
        ["\xE6\x80\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x85"],
        ["\xE6\x8E\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x86"],
        ["\xE6\x8F\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x87"],
        ["\xE6\xB2\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x88"],
        ["\xE6\xBC\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x89"],
        ["\xE7\x82\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x8A"],
        ["\xE7\x84\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x8B"],
        ["\xE7\x85\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x8C"],
        ["\xE7\x87\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x8D"],
        ["\xE7\x8C\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x8E"],
        ["\xE7\xB8\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x8F"],
        ["\xE8\x89\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x90"],
        ["\xE8\x8B\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x91"],
        ["\xE8\x96\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x92"],
        ["\xE9\x81\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x93"],
        ["\xE9\x89\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x94"],
        ["\xE9\xB4\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x95"],
        ["\xE5\xA1\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x96"],
        ["\xE6\x96\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x97"],
        ["\xE6\xB1\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x98"],
        ["\xE7\x94\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x99"],
        ["\xE5\x87\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x9A"],
        ["\xE5\xA4\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x9B"],
        ["\xE5\xA5\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x9C"],
        ["\xE5\xBE\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x9D"],
        ["\xE5\xBF\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x9E"],
        ["\xE6\x8A\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x9F"],
        ["\xE6\x97\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA0"],
        ["\xE6\xA8\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA1"],
        ["\xE6\xAC\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA2"],
        ["\xE6\xAE\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA3"],
        ["\xE7\x8E\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA4"],
        ["\xE7\xBF\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA5"],
        ["\xE8\xA5\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA6"],
        ["\xE9\xB4\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA7"],
        ["\xE9\xB4\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA8"],
        ["\xE9\xBB\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA9"],
        ["\xE5\xB2\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xAA"],
        ["\xE6\xB2\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xAB"],
        ["\xE8\x8D\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xAC"],
        ["\xE5\x84\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xAD"],
        ["\xE5\xB1\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xAE"],
        ["\xE6\x86\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xAF"],
        ["\xE8\x87\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB0"],
        ["\xE6\xA1\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB1"],
        ["\xE7\x89\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB2"],
        ["\xE4\xB9\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB3"],
        ["\xE4\xBF\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB4"],
        ["\xE5\x8D\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB5"],
        ["\xE6\x81\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB6"],
        ["\xE6\xB8\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB7"],
        ["\xE7\xA9\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB8"],
        ["\xE9\x9F\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB9"],
        ["\xE4\xB8\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xBA"],
        ["\xE5\x8C\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xBB"],
        ["\xE4\xBB\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xBC"],
        ["\xE4\xBD\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xBD"],
        ["\xE4\xBC\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xBE"],
        ["\xE4\xBE\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xBF"],
        ["\xE4\xBD\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC0"],
        ["\xE5\x8A\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC1"],
        ["\xE5\x8F\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC2"],
        ["\xE5\x98\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC3"],
        ["\xE5\xA4\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC4"],
        ["\xE5\xAB\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC5"],
        ["\xE5\xAE\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC6"],
        ["\xE5\xAF\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC7"],
        ["\xE7\xA7\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC8"],
        ["\xE6\x9A\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC9"],
        ["\xE6\x9E\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xCA"],
        ["\xE6\x9E\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xCB"],
        ["\xE6\xAD\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xCC"],
        ["\xE6\xB2\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xCD"],
        ["\xE7\x81\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xCE"],
        ["\xE7\x8F\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xCF"],
        ["\xE7\xA6\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD0"],
        ["\xE7\xA6\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD1"],
        ["\xE7\xA8\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD2"],
        ["\xE7\xAE\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD3"],
        ["\xE8\x8A\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD4"],
        ["\xE8\x8B\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD5"],
        ["\xE8\x8C\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD6"],
        ["\xE8\x8D\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD7"],
        ["\xE8\x8F\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD8"],
        ["\xE8\x8F\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD9"],
        ["\xE8\x9D\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xDA"],
        ["\xE8\xAA\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xDB"],
        ["\xE5\x98\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xDC"],
        ["\xE8\xB2\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xDD"],
        ["\xE8\xBF\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xDE"],
        ["\xE9\x81\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xDF"],
        ["\xE9\x9C\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE0"],
        ["\xE8\x9A\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE1"],
        ["\xE4\xBF\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE2"],
        ["\xE5\xB3\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE3"],
        ["\xE6\x88\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE4"],
        ["\xE7\x89\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE5"],
        ["\xE7\x94\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE6"],
        ["\xE8\x87\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE7"],
        ["\xE8\x8A\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE8"],
        ["\xE8\x9B\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE9"],
        ["\xE8\xB3\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xEA"],
        ["\xE9\x9B\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xEB"],
        ["\xE9\xA4\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xEC"],
        ["\xE9\xA7\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xED"],
        ["\xE4\xBB\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xEE"],
        ["\xE4\xBC\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xEF"],
        ["\xE8\xA7\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF0"],
        ["\xE5\x9B\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF1"],
        ["\xE5\xA1\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF2"],
        ["\xE5\xA3\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF3"],
        ["\xE5\xBB\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF4"],
        ["\xE5\xBF\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF5"],
        ["\xE6\x80\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF6"],
        ["\xE6\x82\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF7"],
        ["\xE6\x81\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF8"],
        ["\xE6\x87\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF9"],
        ["\xE6\x88\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xFA"],
        ["\xE6\x8B\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xFB"],
        ["\xE6\x94\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xFC"],
        ["\xE9\xAD\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x40"],
        ["\xE6\x99\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x41"],
        ["\xE6\xA2\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x42"],
        ["\xE6\xB5\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x43"],
        ["\xE7\x81\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x44"],
        ["\xE7\x95\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x45"],
        ["\xE7\x9A\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x46"],
        ["\xE7\xB5\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x47"],
        ["\xE8\x8A\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x48"],
        ["\xE8\x9F\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x49"],
        ["\xE9\x96\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x4A"],
        ["\xE9\x9A\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x4B"],
        ["\xE8\xB2\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x4C"],
        ["\xE5\x87\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x4D"],
        ["\xE5\x8A\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x4E"],
        ["\xE5\xA4\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x4F"],
        ["\xE5\x92\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x50"],
        ["\xE5\xAE\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x51"],
        ["\xE5\xB4\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x52"],
        ["\xE6\x85\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x53"],
        ["\xE6\xA6\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x54"],
        ["\xE6\xB6\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x55"],
        ["\xE7\xA2\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x56"],
        ["\xE8\x93\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x57"],
        ["\xE8\xA1\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x58"],
        ["\xE8\xA9\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x59"],
        ["\xE9\x8E\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x5A"],
        ["\xE9\xAA\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x5B"],
        ["\xE6\xB5\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x5C"],
        ["\xE9\xA6\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x5D"],
        ["\xE8\x9B\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x5E"],
        ["\xE5\x9E\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x5F"],
        ["\xE6\x9F\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x60"],
        ["\xE8\x9B\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x61"],
        ["\xE9\x88\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x62"],
        ["\xE5\x8A\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x63"],
        ["\xE5\x9A\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x64"],
        ["\xE5\x90\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x65"],
        ["\xE5\xBB\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x66"],
        ["\xE6\x8B\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x67"],
        ["\xE6\x92\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x68"],
        ["\xE6\xA0\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x69"],
        ["\xE6\xA0\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x6A"],
        ["\xE6\xAE\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x6B"],
        ["\xE7\x8D\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x6C"],
        ["\xE7\xA2\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x6D"],
        ["\xE7\xA9\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x6E"],
        ["\xE8\xA6\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x6F"],
        ["\xE8\xA7\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x70"],
        ["\xE8\xB5\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x71"],
        ["\xE8\xBC\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x72"],
        ["\xE9\x83\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x73"],
        ["\xE9\x96\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x74"],
        ["\xE9\x9A\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x75"],
        ["\xE9\x9D\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x76"],
        ["\xE5\xAD\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x77"],
        ["\xE5\xB2\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x78"],
        ["\xE6\xA5\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x79"],
        ["\xE9\xA1\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x7A"],
        ["\xE9\xA1\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x7B"],
        ["\xE6\x8E\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x7C"],
        ["\xE7\xAC\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x7D"],
        ["\xE6\xA8\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x7E"],
        ["\xE6\xA9\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x80"],
        ["\xE6\xA2\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x81"],
        ["\xE9\xB0\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x82"],
        ["\xE6\xBD\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x83"],
        ["\xE5\x89\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x84"],
        ["\xE5\x96\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x85"],
        ["\xE6\x81\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x86"],
        ["\xE6\x8B\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x87"],
        ["\xE6\xB4\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x88"],
        ["\xE6\xB8\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x89"],
        ["\xE6\xBB\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x8A"],
        ["\xE8\x91\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x8B"],
        ["\xE8\xA4\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x8C"],
        ["\xE8\xBD\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x8D"],
        ["\xE4\xB8\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x8E"],
        ["\xE9\xB0\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x8F"],
        ["\xE5\x8F\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x90"],
        ["\xE6\xA4\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x91"],
        ["\xE6\xA8\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x92"],
        ["\xE9\x9E\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x93"],
        ["\xE6\xA0\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x94"],
        ["\xE5\x85\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x95"],
        ["\xE7\xAB\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x96"],
        ["\xE8\x92\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x97"],
        ["\xE9\x87\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x98"],
        ["\xE9\x8E\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x99"],
        ["\xE5\x99\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x9A"],
        ["\xE9\xB4\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x9B"],
        ["\xE6\xA0\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x9C"],
        ["\xE8\x8C\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x9D"],
        ["\xE8\x90\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x9E"],
        ["\xE7\xB2\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x9F"],
        ["\xE5\x88\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA0"],
        ["\xE8\x8B\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA1"],
        ["\xE7\x93\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA2"],
        ["\xE4\xB9\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA3"],
        ["\xE4\xBE\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA4"],
        ["\xE5\x86\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA5"],
        ["\xE5\xAF\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA6"],
        ["\xE5\x88\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA7"],
        ["\xE5\x8B\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA8"],
        ["\xE5\x8B\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA9"],
        ["\xE5\xB7\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xAA"],
        ["\xE5\x96\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xAB"],
        ["\xE5\xA0\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xAC"],
        ["\xE5\xA7\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xAD"],
        ["\xE5\xAE\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xAE"],
        ["\xE5\xAE\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xAF"],
        ["\xE5\xAF\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB0"],
        ["\xE5\xB9\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB1"],
        ["\xE5\xB9\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB2"],
        ["\xE6\x82\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB3"],
        ["\xE6\x84\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB4"],
        ["\xE6\x85\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB5"],
        ["\xE6\x86\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB6"],
        ["\xE6\x8F\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB7"],
        ["\xE6\x95\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB8"],
        ["\xE6\x9F\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB9"],
        ["\xE6\xA1\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xBA"],
        ["\xE6\xA3\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xBB"],
        ["\xE6\xAC\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xBC"],
        ["\xE6\xAD\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xBD"],
        ["\xE6\xB1\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xBE"],
        ["\xE6\xBC\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xBF"],
        ["\xE6\xBE\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC0"],
        ["\xE6\xBD\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC1"],
        ["\xE7\x92\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC2"],
        ["\xE7\x94\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC3"],
        ["\xE7\x9B\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC4"],
        ["\xE7\x9C\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC5"],
        ["\xE7\xAB\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC6"],
        ["\xE7\xAE\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC7"],
        ["\xE7\xB0\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC8"],
        ["\xE7\xB7\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC9"],
        ["\xE7\xBC\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xCA"],
        ["\xE7\xBF\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xCB"],
        ["\xE8\x82\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xCC"],
        ["\xE8\x89\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xCD"],
        ["\xE8\x8E\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xCE"],
        ["\xE8\xA6\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xCF"],
        ["\xE8\xAB\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD0"],
        ["\xE8\xB2\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD1"],
        ["\xE9\x82\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD2"],
        ["\xE9\x91\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD3"],
        ["\xE9\x96\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD4"],
        ["\xE9\x96\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD5"],
        ["\xE9\x96\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD6"],
        ["\xE9\x99\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD7"],
        ["\xE9\x9F\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD8"],
        ["\xE9\xA4\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD9"],
        ["\xE8\x88\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xDA"],
        ["\xE4\xB8\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xDB"],
        ["\xE5\x90\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xDC"],
        ["\xE5\xB2\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xDD"],
        ["\xE5\xB7\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xDE"],
        ["\xE7\x8E\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xDF"],
        ["\xE7\x99\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE0"],
        ["\xE7\x9C\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE1"],
        ["\xE5\xB2\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE2"],
        ["\xE7\xBF\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE3"],
        ["\xE8\xB4\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE4"],
        ["\xE9\x9B\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE5"],
        ["\xE9\xA0\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE6"],
        ["\xE9\xA1\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE7"],
        ["\xE9\xA1\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE8"],
        ["\xE4\xBC\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE9"],
        ["\xE4\xBC\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xEA"],
        ["\xE5\x8D\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xEB"],
        ["\xE5\x96\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xEC"],
        ["\xE5\x99\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xED"],
        ["\xE5\x9F\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xEE"],
        ["\xE5\xA5\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xEF"],
        ["\xE5\xAC\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF0"],
        ["\xE5\xAF\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF1"],
        ["\xE5\xB2\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF2"],
        ["\xE5\xB8\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF3"],
        ["\xE5\xB9\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF4"],
        ["\xE5\xBF\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF5"],
        ["\xE6\x8F\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF6"],
        ["\xE6\x9C\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF7"],
        ["\xE6\x97\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF8"],
        ["\xE6\x97\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF9"],
        ["\xE6\x9C\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xFA"],
        ["\xE6\xA3\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xFB"],
        ["\xE6\xA3\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xFC"],
        ["\xE6\xA9\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x40"],
        ["\xE5\xB8\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x41"],
        ["\xE6\xAF\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x42"],
        ["\xE6\xB0\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x43"],
        ["\xE6\xB1\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x44"],
        ["\xE7\x95\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x45"],
        ["\xE7\xA5\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x46"],
        ["\xE5\xAD\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x47"],
        ["\xE7\xA8\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x48"],
        ["\xE7\xB4\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x49"],
        ["\xE5\xBE\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x4A"],
        ["\xE8\xA6\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x4B"],
        ["\xE8\xA8\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x4C"],
        ["\xE8\xB2\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x4D"],
        ["\xE8\xB5\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x4E"],
        ["\xE8\xBB\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x4F"],
        ["\xE8\xBC\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x50"],
        ["\xE9\xA3\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x51"],
        ["\xE9\xA8\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x52"],
        ["\xE9\xAC\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x53"],
        ["\xE4\xBA\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x54"],
        ["\xE5\x81\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x55"],
        ["\xE5\x84\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x56"],
        ["\xE5\xA6\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x57"],
        ["\xE5\xAE\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x58"],
        ["\xE6\x88\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x59"],
        ["\xE6\x8A\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x5A"],
        ["\xE6\x93\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x5B"],
        ["\xE6\xAC\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x5C"],
        ["\xE7\x8A\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x5D"],
        ["\xE7\x96\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x5E"],
        ["\xE7\xA5\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x5F"],
        ["\xE7\xBE\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x60"],
        ["\xE8\x9F\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x61"],
        ["\xE8\xAA\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x62"],
        ["\xE8\xAD\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x63"],
        ["\xE6\x8E\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x64"],
        ["\xE8\x8F\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x65"],
        ["\xE9\x9E\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x66"],
        ["\xE5\x90\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x67"],
        ["\xE5\x90\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x68"],
        ["\xE5\x96\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x69"],
        ["\xE6\xA1\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x6A"],
        ["\xE6\xA9\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x6B"],
        ["\xE8\xA9\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x6C"],
        ["\xE7\xA0\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x6D"],
        ["\xE6\x9D\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x6E"],
        ["\xE9\xBB\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x6F"],
        ["\xE5\x8D\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x70"],
        ["\xE5\xAE\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x71"],
        ["\xE8\x84\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x72"],
        ["\xE8\x99\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x73"],
        ["\xE9\x80\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x74"],
        ["\xE4\xB8\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x75"],
        ["\xE4\xB9\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x76"],
        ["\xE4\xBB\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x77"],
        ["\xE4\xBC\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x78"],
        ["\xE5\x8F\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x79"],
        ["\xE5\x90\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x7A"],
        ["\xE5\xAE\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x7B"],
        ["\xE5\xBC\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x7C"],
        ["\xE6\x80\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x7D"],
        ["\xE6\x95\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x7E"],
        ["\xE6\x9C\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x80"],
        ["\xE6\xB1\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x81"],
        ["\xE6\xB1\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x82"],
        ["\xE6\xB3\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x83"],
        ["\xE7\x81\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x84"],
        ["\xE7\x90\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x85"],
        ["\xE7\xA9\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x86"],
        ["\xE7\xAA\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x87"],
        ["\xE7\xAC\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x88"],
        ["\xE7\xB4\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x89"],
        ["\xE7\xB3\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x8A"],
        ["\xE7\xB5\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x8B"],
        ["\xE6\x97\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x8C"],
        ["\xE7\x89\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x8D"],
        ["\xE5\x8E\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x8E"],
        ["\xE5\xB1\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x8F"],
        ["\xE5\xB7\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x90"],
        ["\xE6\x8B\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x91"],
        ["\xE6\x8B\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x92"],
        ["\xE6\x8C\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x93"],
        ["\xE6\xB8\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x94"],
        ["\xE8\x99\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x95"],
        ["\xE8\xA8\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x96"],
        ["\xE8\xB7\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x97"],
        ["\xE9\x8B\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x98"],
        ["\xE6\xBC\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x99"],
        ["\xE7\xA6\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x9A"],
        ["\xE9\xAD\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x9B"],
        ["\xE4\xBA\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x9C"],
        ["\xE4\xBA\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x9D"],
        ["\xE4\xBA\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x9E"],
        ["\xE4\xBE\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x9F"],
        ["\xE4\xBE\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA0"],
        ["\xE5\x83\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA1"],
        ["\xE5\x85\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA2"],
        ["\xE7\xAB\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA3"],
        ["\xE5\x85\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA4"],
        ["\xE5\x87\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA5"],
        ["\xE5\x8D\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA6"],
        ["\xE5\x8C\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA7"],
        ["\xE5\x8D\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA8"],
        ["\xE5\x8F\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA9"],
        ["\xE5\x96\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xAA"],
        ["\xE5\xA2\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xAB"],
        ["\xE5\xB3\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xAC"],
        ["\xE5\xBC\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xAD"],
        ["\xE5\xBD\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xAE"],
        ["\xE6\x80\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xAF"],
        ["\xE6\x81\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB0"],
        ["\xE6\x81\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB1"],
        ["\xE6\x8C\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB2"],
        ["\xE6\x95\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB3"],
        ["\xE6\xA9\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB4"],
        ["\xE6\xB3\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB5"],
        ["\xE7\x8B\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB6"],
        ["\xE7\x8B\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB7"],
        ["\xE7\x9F\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB8"],
        ["\xE8\x83\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB9"],
        ["\xE8\x84\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xBA"],
        ["\xE8\x88\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xBB"],
        ["\xE8\x95\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xBC"],
        ["\xE9\x83\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xBD"],
        ["\xE9\x8F\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xBE"],
        ["\xE9\x9F\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xBF"],
        ["\xE9\xA5\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC0"],
        ["\xE9\xA9\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC1"],
        ["\xE4\xBB\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC2"],
        ["\xE5\x87\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC3"],
        ["\xE5\xB0\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC4"],
        ["\xE6\x9A\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC5"],
        ["\xE6\xA5\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC6"],
        ["\xE5\xB1\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC7"],
        ["\xE6\x9B\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC8"],
        ["\xE6\xA5\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC9"],
        ["\xE7\x8E\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xCA"],
        ["\xE6\xA1\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xCB"],
        ["\xE7\xB2\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xCC"],
        ["\xE5\x83\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xCD"],
        ["\xE5\x8B\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xCE"],
        ["\xE5\x9D\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xCF"],
        ["\xE5\xB7\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD0"],
        ["\xE9\x8C\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD1"],
        ["\xE6\x96\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD2"],
        ["\xE6\xAC\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD3"],
        ["\xE6\xAC\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD4"],
        ["\xE7\x90\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD5"],
        ["\xE7\xA6\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD6"],
        ["\xE7\xA6\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD7"],
        ["\xE7\xAD\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD8"],
        ["\xE7\xB7\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD9"],
        ["\xE8\x8A\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xDA"],
        ["\xE8\x8F\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xDB"],
        ["\xE8\xA1\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xDC"],
        ["\xE8\xA5\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xDD"],
        ["\xE8\xAC\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xDE"],
        ["\xE8\xBF\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xDF"],
        ["\xE9\x87\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE0"],
        ["\xE5\x90\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE1"],
        ["\xE9\x8A\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE2"],
        ["\xE4\xB9\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE3"],
        ["\xE5\x80\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE4"],
        ["\xE5\x8F\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE5"],
        ["\xE5\x8C\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE6"],
        ["\xE7\x8B\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE7"],
        ["\xE7\x8E\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE8"],
        ["\xE7\x9F\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE9"],
        ["\xE8\x8B\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xEA"],
        ["\xE8\xBA\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xEB"],
        ["\xE9\xA7\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xEC"],
        ["\xE9\xA7\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xED"],
        ["\xE9\xA7\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xEE"],
        ["\xE5\x85\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xEF"],
        ["\xE6\x84\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF0"],
        ["\xE8\x99\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF1"],
        ["\xE5\x96\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF2"],
        ["\xE7\xA9\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF3"],
        ["\xE5\x81\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF4"],
        ["\xE5\xAF\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF5"],
        ["\xE9\x81\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF6"],
        ["\xE9\x9A\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF7"],
        ["\xE4\xB8\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF8"],
        ["\xE6\xAB\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF9"],
        ["\xE9\x87\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xFA"],
        ["\xE5\xB1\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xFB"],
        ["\xE5\xB1\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xFC"],
        ["\xE6\x8E\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x40"],
        ["\xE7\xAA\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x41"],
        ["\xE6\xB2\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x42"],
        ["\xE9\x9D\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x43"],
        ["\xE8\xBD\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x44"],
        ["\xE7\xAA\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x45"],
        ["\xE7\x86\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x46"],
        ["\xE9\x9A\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x47"],
        ["\xE7\xB2\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x48"],
        ["\xE6\xA0\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x49"],
        ["\xE7\xB9\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x4A"],
        ["\xE6\xA1\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x4B"],
        ["\xE9\x8D\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x4C"],
        ["\xE5\x8B\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x4D"],
        ["\xE5\x90\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x4E"],
        ["\xE8\x96\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x4F"],
        ["\xE8\xA8\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x50"],
        ["\xE7\xBE\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x51"],
        ["\xE8\xBB\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x52"],
        ["\xE9\x83\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x53"],
        ["\xE5\x8D\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x54"],
        ["\xE8\xA2\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x55"],
        ["\xE7\xA5\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x56"],
        ["\xE4\xBF\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x57"],
        ["\xE5\x82\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x58"],
        ["\xE5\x88\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x59"],
        ["\xE5\x85\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x5A"],
        ["\xE5\x95\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x5B"],
        ["\xE5\x9C\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x5C"],
        ["\xE7\x8F\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x5D"],
        ["\xE5\x9E\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x5E"],
        ["\xE5\xA5\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x5F"],
        ["\xE5\xBD\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x60"],
        ["\xE5\xBE\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x61"],
        ["\xE6\x81\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x62"],
        ["\xE6\x85\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x63"],
        ["\xE6\x85\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x64"],
        ["\xE6\x86\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x65"],
        ["\xE6\x8E\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x66"],
        ["\xE6\x90\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x67"],
        ["\xE6\x95\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x68"],
        ["\xE6\x99\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x69"],
        ["\xE6\xA1\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x6A"],
        ["\xE6\xB8\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x6B"],
        ["\xE7\x95\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x6C"],
        ["\xE7\xA8\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x6D"],
        ["\xE7\xB3\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x6E"],
        ["\xE7\xB5\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x6F"],
        ["\xE7\xB6\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x70"],
        ["\xE7\xB9\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x71"],
        ["\xE7\xBD\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x72"],
        ["\xE8\x8C\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x73"],
        ["\xE8\x8D\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x74"],
        ["\xE8\x9B\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x75"],
        ["\xE8\xA8\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x76"],
        ["\xE8\xA9\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x77"],
        ["\xE8\xAD\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x78"],
        ["\xE8\xBB\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x79"],
        ["\xE9\xA0\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x7A"],
        ["\xE9\xB6\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x7B"],
        ["\xE8\x8A\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x7C"],
        ["\xE8\xBF\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x7D"],
        ["\xE9\xAF\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x7E"],
        ["\xE5\x8A\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x80"],
        ["\xE6\x88\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x81"],
        ["\xE6\x92\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x82"],
        ["\xE6\xBF\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x83"],
        ["\xE9\x9A\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x84"],
        ["\xE6\xA1\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x85"],
        ["\xE5\x82\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x86"],
        ["\xE6\xAC\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x87"],
        ["\xE6\xB1\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x88"],
        ["\xE6\xBD\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x89"],
        ["\xE7\xA9\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x8A"],
        ["\xE7\xB5\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x8B"],
        ["\xE8\xA1\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x8C"],
        ["\xE8\xA8\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x8D"],
        ["\xE6\x9C\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x8E"],
        ["\xE4\xBB\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x8F"],
        ["\xE5\x80\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x90"],
        ["\xE5\x80\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x91"],
        ["\xE5\x81\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x92"],
        ["\xE5\x85\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x93"],
        ["\xE5\x88\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x94"],
        ["\xE5\x89\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x95"],
        ["\xE5\x96\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x96"],
        ["\xE5\x9C\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x97"],
        ["\xE5\xA0\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x98"],
        ["\xE5\xAB\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x99"],
        ["\xE5\xBB\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x9A"],
        ["\xE6\x86\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x9B"],
        ["\xE6\x87\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x9C"],
        ["\xE6\x8B\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x9D"],
        ["\xE6\x8D\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x9E"],
        ["\xE6\xA4\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x9F"],
        ["\xE6\xA8\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA0"],
        ["\xE7\x89\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA1"],
        ["\xE7\x8A\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA2"],
        ["\xE7\x8C\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA3"],
        ["\xE7\xA0\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA4"],
        ["\xE7\xA1\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA5"],
        ["\xE7\xB5\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA6"],
        ["\xE7\x9C\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA7"],
        ["\xE8\x82\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA8"],
        ["\xE8\xA6\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA9"],
        ["\xE8\xAC\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xAA"],
        ["\xE8\xB3\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xAB"],
        ["\xE8\xBB\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xAC"],
        ["\xE9\x81\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xAD"],
        ["\xE9\x8D\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xAE"],
        ["\xE9\x99\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xAF"],
        ["\xE9\xA1\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB0"],
        ["\xE9\xA8\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB1"],
        ["\xE9\xB9\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB2"],
        ["\xE5\x85\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB3"],
        ["\xE5\x8E\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB4"],
        ["\xE5\x8E\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB5"],
        ["\xE5\xB9\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB6"],
        ["\xE5\xBC\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB7"],
        ["\xE6\xB8\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB8"],
        ["\xE6\xBA\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB9"],
        ["\xE7\x8E\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xBA"],
        ["\xE7\x8F\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xBB"],
        ["\xE7\xB5\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xBC"],
        ["\xE8\x88\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xBD"],
        ["\xE8\xA8\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xBE"],
        ["\xE8\xAB\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xBF"],
        ["\xE9\x99\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC0"],
        ["\xE4\xB9\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC1"],
        ["\xE5\x80\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC2"],
        ["\xE5\x8F\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC3"],
        ["\xE5\x91\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC4"],
        ["\xE5\x9B\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC5"],
        ["\xE5\xA7\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC6"],
        ["\xE5\xAD\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC7"],
        ["\xE5\xB7\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC8"],
        ["\xE5\xBA\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC9"],
        ["\xE5\xBC\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xCA"],
        ["\xE6\x88\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xCB"],
        ["\xE6\x95\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xCC"],
        ["\xE6\x9E\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xCD"],
        ["\xE6\xB9\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xCE"],
        ["\xE7\x8B\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xCF"],
        ["\xE7\xB3\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD0"],
        ["\xE8\xA2\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD1"],
        ["\xE8\x82\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD2"],
        ["\xE8\x83\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD3"],
        ["\xE8\x8F\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD4"],
        ["\xE8\x99\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD5"],
        ["\xE8\xAA\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD6"],
        ["\xE8\xB7\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD7"],
        ["\xE9\x88\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD8"],
        ["\xE9\x9B\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD9"],
        ["\xE9\xA1\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xDA"],
        ["\xE9\xBC\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xDB"],
        ["\xE4\xBA\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xDC"],
        ["\xE4\xBA\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xDD"],
        ["\xE4\xBC\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xDE"],
        ["\xE5\x8D\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xDF"],
        ["\xE5\x91\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE0"],
        ["\xE5\x90\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE1"],
        ["\xE5\xA8\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE2"],
        ["\xE5\xBE\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE3"],
        ["\xE5\xBE\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE4"],
        ["\xE6\x82\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE5"],
        ["\xE6\xA2\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE6"],
        ["\xE6\xAA\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE7"],
        ["\xE7\x91\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE8"],
        ["\xE7\xA2\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE9"],
        ["\xE8\xAA\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xEA"],
        ["\xE8\xAA\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xEB"],
        ["\xE8\xAD\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xEC"],
        ["\xE9\x86\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xED"],
        ["\xE4\xB9\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xEE"],
        ["\xE9\xAF\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xEF"],
        ["\xE4\xBA\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF0"],
        ["\xE4\xBD\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF1"],
        ["\xE4\xBE\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF2"],
        ["\xE5\x80\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF3"],
        ["\xE5\x80\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF4"],
        ["\xE5\x85\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF5"],
        ["\xE5\x85\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF6"],
        ["\xE5\x8A\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF7"],
        ["\xE5\x8A\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF8"],
        ["\xE5\x8B\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF9"],
        ["\xE5\x8E\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xFA"],
        ["\xE5\x8F\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xFB"],
        ["\xE5\x90\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xFC"],
        ["\xE5\x90\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x40"],
        ["\xE5\x96\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x41"],
        ["\xE5\x9D\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x42"],
        ["\xE5\x9E\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x43"],
        ["\xE5\xA5\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x44"],
        ["\xE5\xAD\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x45"],
        ["\xE5\xAD\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x46"],
        ["\xE5\xAE\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x47"],
        ["\xE5\xB7\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x48"],
        ["\xE5\xB7\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x49"],
        ["\xE5\xB7\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x4A"],
        ["\xE5\xB9\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x4B"],
        ["\xE5\xBA\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x4C"],
        ["\xE5\xBA\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x4D"],
        ["\xE5\xBA\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x4E"],
        ["\xE5\xBC\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x4F"],
        ["\xE6\x81\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x50"],
        ["\xE6\x85\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x51"],
        ["\xE6\x8A\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x52"],
        ["\xE6\x8B\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x53"],
        ["\xE6\x8E\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x54"],
        ["\xE6\x94\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x55"],
        ["\xE6\x98\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x56"],
        ["\xE6\x99\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x57"],
        ["\xE6\x9B\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x58"],
        ["\xE6\x9D\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x59"],
        ["\xE6\xA0\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x5A"],
        ["\xE6\xA2\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x5B"],
        ["\xE6\xA7\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x5C"],
        ["\xE6\xB1\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x5D"],
        ["\xE6\xB4\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x5E"],
        ["\xE6\xB5\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x5F"],
        ["\xE6\xB8\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x60"],
        ["\xE6\xBA\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x61"],
        ["\xE7\x94\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x62"],
        ["\xE7\x9A\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x63"],
        ["\xE7\xA1\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x64"],
        ["\xE7\xA8\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x65"],
        ["\xE7\xB3\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x66"],
        ["\xE7\xB4\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x67"],
        ["\xE7\xB4\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x68"],
        ["\xE7\xB5\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x69"],
        ["\xE7\xB6\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x6A"],
        ["\xE8\x80\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x6B"],
        ["\xE8\x80\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x6C"],
        ["\xE8\x82\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x6D"],
        ["\xE8\x82\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x6E"],
        ["\xE8\x85\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x6F"],
        ["\xE8\x86\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x70"],
        ["\xE8\x88\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x71"],
        ["\xE8\x8D\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x72"],
        ["\xE8\xA1\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x73"],
        ["\xE8\xA1\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x74"],
        ["\xE8\xAC\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x75"],
        ["\xE8\xB2\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x76"],
        ["\xE8\xB3\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x77"],
        ["\xE9\x83\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x78"],
        ["\xE9\x85\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x79"],
        ["\xE9\x89\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x7A"],
        ["\xE7\xA0\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x7B"],
        ["\xE9\x8B\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x7C"],
        ["\xE9\x96\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x7D"],
        ["\xE9\x99\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x7E"],
        ["\xE9\xA0\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x80"],
        ["\xE9\xA6\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x81"],
        ["\xE9\xAB\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x82"],
        ["\xE9\xB4\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x83"],
        ["\xE5\x89\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x84"],
        ["\xE5\x8A\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x85"],
        ["\xE5\x8F\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x86"],
        ["\xE5\x90\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x87"],
        ["\xE5\xA3\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x88"],
        ["\xE6\x8B\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x89"],
        ["\xE6\xBF\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x8A"],
        ["\xE8\xB1\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x8B"],
        ["\xE8\xBD\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x8C"],
        ["\xE9\xBA\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x8D"],
        ["\xE5\x85\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x8E"],
        ["\xE5\x88\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x8F"],
        ["\xE5\x91\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x90"],
        ["\xE5\x9B\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x91"],
        ["\xE7\xA9\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x92"],
        ["\xE9\x85\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x93"],
        ["\xE9\xB5\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x94"],
        ["\xE9\xBB\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x95"],
        ["\xE7\x8D\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x96"],
        ["\xE6\xBC\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x97"],
        ["\xE8\x85\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x98"],
        ["\xE7\x94\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x99"],
        ["\xE5\xBF\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x9A"],
        ["\xE6\x83\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x9B"],
        ["\xE9\xAA\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x9C"],
        ["\xE7\x8B\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x9D"],
        ["\xE8\xBE\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x9E"],
        ["\xE6\xAD\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x9F"],
        ["\xE9\xA0\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA0"],
        ["\xE4\xBB\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA1"],
        ["\xE5\x9B\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA2"],
        ["\xE5\x9D\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA3"],
        ["\xE5\xA2\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA4"],
        ["\xE5\xA9\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA5"],
        ["\xE6\x81\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA6"],
        ["\xE6\x87\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA7"],
        ["\xE6\x98\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA8"],
        ["\xE6\x98\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA9"],
        ["\xE6\xA0\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xAA"],
        ["\xE6\xA2\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xAB"],
        ["\xE6\xB7\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xAC"],
        ["\xE7\x97\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xAD"],
        ["\xE7\xB4\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xAE"],
        ["\xE8\x89\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xAF"],
        ["\xE9\xAD\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB0"],
        ["\xE4\xBA\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB1"],
        ["\xE4\xBD\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB2"],
        ["\xE5\x8F\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB3"],
        ["\xE5\x94\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB4"],
        ["\xE5\xB5\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB5"],
        ["\xE5\xB7\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB6"],
        ["\xE5\xB7\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB7"],
        ["\xE6\x9F\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB8"],
        ["\xE6\xB2\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB9"],
        ["\xE7\x91\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xBA"],
        ["\xE7\xA0\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xBB"],
        ["\xE8\xA9\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xBC"],
        ["\xE9\x8E\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xBD"],
        ["\xE8\xA3\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xBE"],
        ["\xE5\x9D\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xBF"],
        ["\xE5\xBA\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC0"],
        ["\xE6\x8C\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC1"],
        ["\xE5\x82\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC2"],
        ["\xE5\x82\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC3"],
        ["\xE5\x86\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC4"],
        ["\xE6\x9C\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC5"],
        ["\xE5\x93\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC6"],
        ["\xE5\xA1\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC7"],
        ["\xE5\xA6\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC8"],
        ["\xE5\xAE\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC9"],
        ["\xE5\xBD\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xCA"],
        ["\xE6\x89\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xCB"],
        ["\xE6\x8E\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xCC"],
        ["\xE6\xA0\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xCD"],
        ["\xE6\xAD\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xCE"],
        ["\xE6\xB8\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xCF"],
        ["\xE7\x81\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD0"],
        ["\xE9\x87\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD1"],
        ["\xE7\x8A\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD2"],
        ["\xE7\xA0\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD3"],
        ["\xE7\xA0\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD4"],
        ["\xE7\xA5\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD5"],
        ["\xE6\x96\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD6"],
        ["\xE7\xB4\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD7"],
        ["\xE8\x8F\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD8"],
        ["\xE8\xA3\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD9"],
        ["\xE8\xBC\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xDA"],
        ["\xE9\x9A\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xDB"],
        ["\xE5\x89\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xDC"],
        ["\xE5\x9C\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xDD"],
        ["\xE6\x9D\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xDE"],
        ["\xE7\xBD\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xDF"],
        ["\xE8\xB2\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE0"],
        ["\xE5\x86\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE1"],
        ["\xE5\x9D\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE2"],
        ["\xE9\x98\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE3"],
        ["\xE5\xA0\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE4"],
        ["\xE6\xA6\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE5"],
        ["\xE8\x82\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE6"],
        ["\xE5\x92\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE7"],
        ["\xE5\xB4\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE8"],
        ["\xE5\x9F\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE9"],
        ["\xE7\xA2\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xEA"],
        ["\xE9\xB7\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xEB"],
        ["\xE4\xBD\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xEC"],
        ["\xE5\x89\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xED"],
        ["\xE5\x92\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xEE"],
        ["\xE6\x90\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xEF"],
        ["\xE6\x98\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF0"],
        ["\xE6\x9C\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF1"],
        ["\xE6\x9F\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF2"],
        ["\xE7\xAA\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF3"],
        ["\xE7\xAD\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF4"],
        ["\xE7\xB4\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF5"],
        ["\xE9\x8C\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF6"],
        ["\xE6\xA1\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF7"],
        ["\xE9\xAE\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF8"],
        ["\xE7\xAC\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF9"],
        ["\xE5\x8C\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xFA"],
        ["\xE5\x86\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xFB"],
        ["\xE5\x88\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xFC"],
        ["\xE5\xAF\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x40"],
        ["\xE6\x8B\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x41"],
        ["\xE6\x92\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x42"],
        ["\xE6\x93\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x43"],
        ["\xE6\x9C\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x44"],
        ["\xE6\xAE\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x45"],
        ["\xE8\x96\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x46"],
        ["\xE9\x9B\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x47"],
        ["\xE7\x9A\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x48"],
        ["\xE9\xAF\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x49"],
        ["\xE6\x8D\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x4A"],
        ["\xE9\x8C\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x4B"],
        ["\xE9\xAE\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x4C"],
        ["\xE7\x9A\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x4D"],
        ["\xE6\x99\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x4E"],
        ["\xE4\xB8\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x4F"],
        ["\xE5\x82\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x50"],
        ["\xE5\x8F\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x51"],
        ["\xE5\xB1\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x52"],
        ["\xE6\x83\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x53"],
        ["\xE6\x92\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x54"],
        ["\xE6\x95\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x55"],
        ["\xE6\xA1\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x56"],
        ["\xE7\x87\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x57"],
        ["\xE7\x8F\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x58"],
        ["\xE7\x94\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x59"],
        ["\xE7\xAE\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x5A"],
        ["\xE7\xBA\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x5B"],
        ["\xE8\x9A\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x5C"],
        ["\xE8\xAE\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x5D"],
        ["\xE8\xB3\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x5E"],
        ["\xE9\x85\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x5F"],
        ["\xE9\xA4\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x60"],
        ["\xE6\x96\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x61"],
        ["\xE6\x9A\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x62"],
        ["\xE6\xAE\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x63"],
        ["\xE4\xBB\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x64"],
        ["\xE4\xBB\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x65"],
        ["\xE4\xBC\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x66"],
        ["\xE4\xBD\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x67"],
        ["\xE5\x88\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x68"],
        ["\xE5\x8F\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x69"],
        ["\xE5\x8F\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x6A"],
        ["\xE5\x97\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x6B"],
        ["\xE5\x9B\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x6C"],
        ["\xE5\xA3\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x6D"],
        ["\xE5\xA7\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x6E"],
        ["\xE5\xA7\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x6F"],
        ["\xE5\xA7\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x70"],
        ["\xE5\xAD\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x71"],
        ["\xE5\xB1\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x72"],
        ["\xE5\xB8\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x73"],
        ["\xE5\xB8\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x74"],
        ["\xE5\xBF\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x75"],
        ["\xE6\x80\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x76"],
        ["\xE6\x8C\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x77"],
        ["\xE6\x94\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x78"],
        ["\xE5\xAD\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x79"],
        ["\xE6\x96\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x7A"],
        ["\xE6\x96\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x7B"],
        ["\xE6\x97\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x7C"],
        ["\xE6\x9E\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x7D"],
        ["\xE6\xAD\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x7E"],
        ["\xE6\xAD\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x80"],
        ["\xE6\xB0\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x81"],
        ["\xE7\x8D\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x82"],
        ["\xE7\xA5\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x83"],
        ["\xE7\xA7\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x84"],
        ["\xE7\xB3\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x85"],
        ["\xE7\xB4\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x86"],
        ["\xE7\xB4\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x87"],
        ["\xE8\x82\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x88"],
        ["\xE8\x84\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x89"],
        ["\xE8\x87\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x8A"],
        ["\xE8\xA6\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x8B"],
        ["\xE8\xA9\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x8C"],
        ["\xE8\xA9\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x8D"],
        ["\xE8\xA9\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x8E"],
        ["\xE8\xAA\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x8F"],
        ["\xE8\xAB\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x90"],
        ["\xE8\xB3\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x91"],
        ["\xE8\xB3\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x92"],
        ["\xE9\x9B\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x93"],
        ["\xE9\xA3\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x94"],
        ["\xE6\xAD\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x95"],
        ["\xE4\xBA\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x96"],
        ["\xE4\xBC\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x97"],
        ["\xE4\xBE\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x98"],
        ["\xE5\x85\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x99"],
        ["\xE5\xAD\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x9A"],
        ["\xE5\xAF\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x9B"],
        ["\xE6\x85\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x9C"],
        ["\xE6\x8C\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x9D"],
        ["\xE6\x99\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x9E"],
        ["\xE6\xAC\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x9F"],
        ["\xE6\xBB\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA0"],
        ["\xE6\xB2\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA1"],
        ["\xE7\x88\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA2"],
        ["\xE7\x92\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA3"],
        ["\xE7\x97\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA4"],
        ["\xE7\xA3\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA5"],
        ["\xE7\xA4\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA6"],
        ["\xE8\x80\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA7"],
        ["\xE8\x80\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA8"],
        ["\xE8\x87\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA9"],
        ["\xE8\x92\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xAA"],
        ["\xE8\xBE\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xAB"],
        ["\xE6\xB1\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xAC"],
        ["\xE9\xB9\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xAD"],
        ["\xE5\xBC\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xAE"],
        ["\xE8\xAD\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xAF"],
        ["\xE9\xB4\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB0"],
        ["\xE7\xAB\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB1"],
        ["\xE8\xBB\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB2"],
        ["\xE5\xAE\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB3"],
        ["\xE9\x9B\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB4"],
        ["\xE4\xB8\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB5"],
        ["\xE5\x8F\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB6"],
        ["\xE5\x9F\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB7"],
        ["\xE5\xA4\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB8"],
        ["\xE5\xAB\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB9"],
        ["\xE5\xAE\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xBA"],
        ["\xE6\x82\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xBB"],
        ["\xE6\xB9\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xBC"],
        ["\xE6\xBC\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xBD"],
        ["\xE7\x96\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xBE"],
        ["\xE8\xB3\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xBF"],
        ["\xE5\xAE\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC0"],
        ["\xE8\x94\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC1"],
        ["\xE7\xAF\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC2"],
        ["\xE5\x81\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC3"],
        ["\xE6\x9F\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC4"],
        ["\xE8\x8A\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC5"],
        ["\xE5\xB1\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC6"],
        ["\xE8\x95\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC7"],
        ["\xE7\xB8\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC8"],
        ["\xE8\x88\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC9"],
        ["\xE5\x86\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xCA"],
        ["\xE5\xB0\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xCB"],
        ["\xE6\x8D\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xCC"],
        ["\xE8\xB5\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xCD"],
        ["\xE6\x96\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xCE"],
        ["\xE7\x85\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xCF"],
        ["\xE7\xA4\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD0"],
        ["\xE7\xB4\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD1"],
        ["\xE8\x80\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD2"],
        ["\xE8\xAC\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD3"],
        ["\xE8\xBB\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD4"],
        ["\xE9\x81\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD5"],
        ["\xE8\x9B\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD6"],
        ["\xE9\x82\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD7"],
        ["\xE5\x80\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD8"],
        ["\xE5\x8B\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD9"],
        ["\xE5\xB0\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xDA"],
        ["\xE6\x9D\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xDB"],
        ["\xE7\x81\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xDC"],
        ["\xE7\x88\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xDD"],
        ["\xE9\x85\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xDE"],
        ["\xE9\x87\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xDF"],
        ["\xE9\x8C\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE0"],
        ["\xE8\x8B\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE1"],
        ["\xE5\xAF\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE2"],
        ["\xE5\xBC\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE3"],
        ["\xE6\x83\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE4"],
        ["\xE4\xB8\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE5"],
        ["\xE5\x8F\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE6"],
        ["\xE5\xAE\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE7"],
        ["\xE6\x89\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE8"],
        ["\xE6\x9C\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE9"],
        ["\xE6\xAE\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xEA"],
        ["\xE7\x8B\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xEB"],
        ["\xE7\x8F\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xEC"],
        ["\xE7\xA8\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xED"],
        ["\xE8\x85\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xEE"],
        ["\xE8\xB6\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xEF"],
        ["\xE9\x85\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF0"],
        ["\xE9\xA6\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF1"],
        ["\xE5\x84\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF2"],
        ["\xE5\x8F\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF3"],
        ["\xE5\x91\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF4"],
        ["\xE5\xAF\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF5"],
        ["\xE6\x8E\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF6"],
        ["\xE6\xA8\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF7"],
        ["\xE7\xB6\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF8"],
        ["\xE9\x9C\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF9"],
        ["\xE5\x9B\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xFA"],
        ["\xE5\x8F\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xFB"],
        ["\xE5\x91\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xFC"],
        ["\xE5\xAE\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x40"],
        ["\xE5\xB0\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x41"],
        ["\xE5\xB7\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x42"],
        ["\xE4\xBF\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x43"],
        ["\xE6\x84\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x44"],
        ["\xE6\x8B\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x45"],
        ["\xE6\xB4\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x46"],
        ["\xE7\xA7\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x47"],
        ["\xE7\xA7\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x48"],
        ["\xE7\xB5\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x49"],
        ["\xE7\xB9\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x4A"],
        ["\xE7\xBF\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x4B"],
        ["\xE8\x87\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x4C"],
        ["\xE8\x88\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x4D"],
        ["\xE8\x92\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x4E"],
        ["\xE8\xA1\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x4F"],
        ["\xE8\xA5\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x50"],
        ["\xE8\xAE\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x51"],
        ["\xE8\xB9\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x52"],
        ["\xE8\xBC\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x53"],
        ["\xE9\x80\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x54"],
        ["\xE9\x85\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x55"],
        ["\xE9\x85\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x56"],
        ["\xE9\x9B\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x57"],
        ["\xE9\x86\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x58"],
        ["\xE4\xBB\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x59"],
        ["\xE4\xBD\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x5A"],
        ["\xE5\x85\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x5B"],
        ["\xE5\x8D\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x5C"],
        ["\xE5\xBE\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x5D"],
        ["\xE6\x88\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x5E"],
        ["\xE6\x9F\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x5F"],
        ["\xE6\xB1\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x60"],
        ["\xE6\xB8\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x61"],
        ["\xE7\x8D\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x62"],
        ["\xE7\xB8\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x63"],
        ["\xE9\x87\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x64"],
        ["\xE9\x8A\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x65"],
        ["\xE5\x8F\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x66"],
        ["\xE5\xA4\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x67"],
        ["\xE5\xAE\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x68"],
        ["\xE6\xB7\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x69"],
        ["\xE7\xA5\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x6A"],
        ["\xE7\xB8\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x6B"],
        ["\xE7\xB2\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x6C"],
        ["\xE5\xA1\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x6D"],
        ["\xE7\x86\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x6E"],
        ["\xE5\x87\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x6F"],
        ["\xE8\xA1\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x70"],
        ["\xE8\xBF\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x71"],
        ["\xE4\xBF\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x72"],
        ["\xE5\xB3\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x73"],
        ["\xE6\x98\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x74"],
        ["\xE7\x9E\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x75"],
        ["\xE7\xAB\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x76"],
        ["\xE8\x88\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x77"],
        ["\xE9\xA7\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x78"],
        ["\xE5\x87\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x79"],
        ["\xE5\xBE\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x7A"],
        ["\xE6\x97\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x7B"],
        ["\xE6\xA5\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x7C"],
        ["\xE6\xAE\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x7D"],
        ["\xE6\xB7\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x7E"],
        ["\xE6\xBA\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x80"],
        ["\xE6\xBD\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x81"],
        ["\xE7\x9B\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x82"],
        ["\xE7\xB4\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x83"],
        ["\xE5\xB7\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x84"],
        ["\xE9\x81\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x85"],
        ["\xE9\x86\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x86"],
        ["\xE9\xA0\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x87"],
        ["\xE5\x87\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x88"],
        ["\xE5\x88\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x89"],
        ["\xE6\x89\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x8A"],
        ["\xE6\x9A\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x8B"],
        ["\xE6\x9B\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x8C"],
        ["\xE6\xB8\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x8D"],
        ["\xE5\xBA\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x8E"],
        ["\xE7\xB7\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x8F"],
        ["\xE7\xBD\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x90"],
        ["\xE6\x9B\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x91"],
        ["\xE8\x96\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x92"],
        ["\xE8\x97\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x93"],
        ["\xE8\xAB\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x94"],
        ["\xE5\x8A\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x95"],
        ["\xE5\x8F\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x96"],
        ["\xE5\xA5\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x97"],
        ["\xE5\xBA\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x98"],
        ["\xE5\xBE\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x99"],
        ["\xE6\x81\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x9A"],
        ["\xE9\x8B\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x9B"],
        ["\xE9\x99\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x9C"],
        ["\xE5\x82\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x9D"],
        ["\xE5\x84\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x9E"],
        ["\xE5\x8B\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x9F"],
        ["\xE5\x8C\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA0"],
        ["\xE5\x8D\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA1"],
        ["\xE5\x8F\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA2"],
        ["\xE5\x93\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA3"],
        ["\xE5\x95\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA4"],
        ["\xE5\x94\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA5"],
        ["\xE5\x98\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA6"],
        ["\xE5\xA5\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA7"],
        ["\xE5\xA6\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA8"],
        ["\xE5\xA8\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA9"],
        ["\xE5\xAE\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xAA"],
        ["\xE5\xB0\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xAB"],
        ["\xE5\xB0\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xAC"],
        ["\xE5\xB0\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xAD"],
        ["\xE5\xB0\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xAE"],
        ["\xE5\xBA\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xAF"],
        ["\xE5\xBA\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB0"],
        ["\xE5\xBB\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB1"],
        ["\xE5\xBD\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB2"],
        ["\xE6\x89\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB3"],
        ["\xE6\x8A\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB4"],
        ["\xE6\x8B\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB5"],
        ["\xE6\x8E\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB6"],
        ["\xE6\x8D\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB7"],
        ["\xE6\x98\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB8"],
        ["\xE6\x98\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB9"],
        ["\xE6\x98\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xBA"],
        ["\xE6\x99\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xBB"],
        ["\xE6\x9D\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xBC"],
        ["\xE6\xA2\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xBD"],
        ["\xE6\xA8\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xBE"],
        ["\xE6\xA8\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xBF"],
        ["\xE6\xB2\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC0"],
        ["\xE6\xB6\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC1"],
        ["\xE6\xB8\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC2"],
        ["\xE6\xB9\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC3"],
        ["\xE7\x84\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC4"],
        ["\xE7\x84\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC5"],
        ["\xE7\x85\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC6"],
        ["\xE7\x97\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC7"],
        ["\xE7\x9C\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC8"],
        ["\xE7\xA1\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC9"],
        ["\xE7\xA4\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xCA"],
        ["\xE7\xA5\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xCB"],
        ["\xE7\xA7\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xCC"],
        ["\xE7\xAB\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xCD"],
        ["\xE7\xAC\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xCE"],
        ["\xE7\xB2\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xCF"],
        ["\xE7\xB4\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD0"],
        ["\xE8\x82\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD1"],
        ["\xE8\x8F\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD2"],
        ["\xE8\x92\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD3"],
        ["\xE8\x95\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD4"],
        ["\xE8\xA1\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD5"],
        ["\xE8\xA3\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD6"],
        ["\xE8\xA8\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD7"],
        ["\xE8\xA8\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD8"],
        ["\xE8\xA9\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD9"],
        ["\xE8\xA9\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xDA"],
        ["\xE8\xB1\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xDB"],
        ["\xE8\xB3\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xDC"],
        ["\xE9\x86\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xDD"],
        ["\xE9\x89\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xDE"],
        ["\xE9\x8D\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xDF"],
        ["\xE9\x90\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE0"],
        ["\xE9\x9A\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE1"],
        ["\xE9\x9E\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE2"],
        ["\xE4\xB8\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE3"],
        ["\xE4\xB8\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE4"],
        ["\xE4\xB8\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE5"],
        ["\xE4\xB9\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE6"],
        ["\xE5\x86\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE7"],
        ["\xE5\x89\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE8"],
        ["\xE5\x9F\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE9"],
        ["\xE5\xA0\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xEA"],
        ["\xE5\xA3\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xEB"],
        ["\xE5\xAC\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xEC"],
        ["\xE5\xB8\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xED"],
        ["\xE6\x83\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xEE"],
        ["\xE6\x93\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xEF"],
        ["\xE6\x9D\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF0"],
        ["\xE6\x9D\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF1"],
        ["\xE6\xB5\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF2"],
        ["\xE7\x8A\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF3"],
        ["\xE7\x95\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF4"],
        ["\xE7\xA9\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF5"],
        ["\xE8\x92\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF6"],
        ["\xE8\xAD\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF7"],
        ["\xE9\x86\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF8"],
        ["\xE9\x8C\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF9"],
        ["\xE5\x98\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xFA"],
        ["\xE5\x9F\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xFB"],
        ["\xE9\xA3\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xFC"],
        ["\xE6\x8B\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x40"],
        ["\xE6\xA4\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x41"],
        ["\xE6\xAE\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x42"],
        ["\xE7\x87\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x43"],
        ["\xE7\xB9\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x44"],
        ["\xE8\x81\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x45"],
        ["\xE8\x89\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x46"],
        ["\xE8\xA7\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x47"],
        ["\xE9\xA3\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x48"],
        ["\xE8\x9D\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x49"],
        ["\xE8\xBE\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x4A"],
        ["\xE5\xB0\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x4B"],
        ["\xE4\xBC\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x4C"],
        ["\xE4\xBF\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x4D"],
        ["\xE4\xBE\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x4E"],
        ["\xE5\x94\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x4F"],
        ["\xE5\xA8\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x50"],
        ["\xE5\xAF\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x51"],
        ["\xE5\xAF\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x52"],
        ["\xE5\xBF\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x53"],
        ["\xE6\x85\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x54"],
        ["\xE6\x8C\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x55"],
        ["\xE6\x96\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x56"],
        ["\xE6\x99\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x57"],
        ["\xE6\xA3\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x58"],
        ["\xE6\xA6\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x59"],
        ["\xE6\xB5\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x5A"],
        ["\xE6\xB7\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x5B"],
        ["\xE7\x94\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x5C"],
        ["\xE7\x96\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x5D"],
        ["\xE7\x9C\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x5E"],
        ["\xE7\xA5\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x5F"],
        ["\xE7\xA7\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x60"],
        ["\xE7\xB4\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x61"],
        ["\xE8\x87\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x62"],
        ["\xE8\x8A\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x63"],
        ["\xE8\x96\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x64"],
        ["\xE8\xA6\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x65"],
        ["\xE8\xA8\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x66"],
        ["\xE8\xBA\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x67"],
        ["\xE8\xBE\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x68"],
        ["\xE9\x80\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x69"],
        ["\xE9\x87\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x6A"],
        ["\xE9\x9C\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x6B"],
        ["\xE4\xBA\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x6C"],
        ["\xE4\xBB\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x6D"],
        ["\xE5\x88\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x6E"],
        ["\xE5\xA1\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x6F"],
        ["\xE5\xA3\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x70"],
        ["\xE5\xB0\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x71"],
        ["\xE7\x94\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x72"],
        ["\xE5\xB0\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x73"],
        ["\xE8\x85\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x74"],
        ["\xE8\xA8\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x75"],
        ["\xE8\xBF\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x76"],
        ["\xE9\x99\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x77"],
        ["\xE9\x9D\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x78"],
        ["\xE7\xAC\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x79"],
        ["\xE8\xAB\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x7A"],
        ["\xE9\xA0\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x7B"],
        ["\xE9\x85\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x7C"],
        ["\xE5\x9B\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x7D"],
        ["\xE5\x8E\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x7E"],
        ["\xE9\x80\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x80"],
        ["\xE5\x90\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x81"],
        ["\xE5\x9E\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x82"],
        ["\xE5\xB8\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x83"],
        ["\xE6\x8E\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x84"],
        ["\xE6\xB0\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x85"],
        ["\xE7\x82\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x86"],
        ["\xE7\x9D\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x87"],
        ["\xE7\xB2\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x88"],
        ["\xE7\xBF\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x89"],
        ["\xE8\xA1\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x8A"],
        ["\xE9\x81\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x8B"],
        ["\xE9\x85\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x8C"],
        ["\xE9\x8C\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x8D"],
        ["\xE9\x8C\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x8E"],
        ["\xE9\x9A\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x8F"],
        ["\xE7\x91\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x90"],
        ["\xE9\xAB\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x91"],
        ["\xE5\xB4\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x92"],
        ["\xE5\xB5\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x93"],
        ["\xE6\x95\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x94"],
        ["\xE6\x9E\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x95"],
        ["\xE8\xB6\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x96"],
        ["\xE9\x9B\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x97"],
        ["\xE6\x8D\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x98"],
        ["\xE6\x9D\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x99"],
        ["\xE6\xA4\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x9A"],
        ["\xE8\x8F\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x9B"],
        ["\xE9\xA0\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x9C"],
        ["\xE9\x9B\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x9D"],
        ["\xE8\xA3\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x9E"],
        ["\xE6\xBE\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x9F"],
        ["\xE6\x91\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA0"],
        ["\xE5\xAF\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA1"],
        ["\xE4\xB8\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA2"],
        ["\xE7\x80\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA3"],
        ["\xE7\x95\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA4"],
        ["\xE6\x98\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA5"],
        ["\xE5\x87\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA6"],
        ["\xE5\x88\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA7"],
        ["\xE5\x8B\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA8"],
        ["\xE5\xA7\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA9"],
        ["\xE5\xBE\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xAA"],
        ["\xE6\x80\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xAB"],
        ["\xE6\x88\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xAC"],
        ["\xE6\x94\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xAD"],
        ["\xE6\x95\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xAE"],
        ["\xE6\x98\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xAF"],
        ["\xE6\x99\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB0"],
        ["\xE6\xA3\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB1"],
        ["\xE6\xA0\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB2"],
        ["\xE6\xAD\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB3"],
        ["\xE6\xB8\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB4"],
        ["\xE7\x89\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB5"],
        ["\xE7\x94\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB6"],
        ["\xE7\x9B\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB7"],
        ["\xE7\xB2\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB8"],
        ["\xE8\x81\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB9"],
        ["\xE5\xA3\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xBA"],
        ["\xE8\xA3\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xBB"],
        ["\xE8\xA5\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xBC"],
        ["\xE8\xAA\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xBD"],
        ["\xE8\xAA\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xBE"],
        ["\xE8\xAB\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xBF"],
        ["\xE9\x80\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC0"],
        ["\xE9\x86\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC1"],
        ["\xE9\x9D\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC2"],
        ["\xE9\x9D\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC3"],
        ["\xE6\x96\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC4"],
        ["\xE7\xA8\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC5"],
        ["\xE8\x84\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC6"],
        ["\xE9\x9A\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC7"],
        ["\xE5\xB8\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC8"],
        ["\xE6\x83\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC9"],
        ["\xE6\x88\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xCA"],
        ["\xE6\x96\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xCB"],
        ["\xE6\x98\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xCC"],
        ["\xE6\x9E\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xCD"],
        ["\xE7\x9F\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xCE"],
        ["\xE7\xA9\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xCF"],
        ["\xE7\xB1\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD0"],
        ["\xE7\xB8\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD1"],
        ["\xE8\x84\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD2"],
        ["\xE8\xB2\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD3"],
        ["\xE8\xB5\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD4"],
        ["\xE8\xB7\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD5"],
        ["\xE8\xB9\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD6"],
        ["\xE7\xA2\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD7"],
        ["\xE5\x88\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD8"],
        ["\xE6\x8B\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD9"],
        ["\xE6\x8E\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xDA"],
        ["\xE6\x91\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xDB"],
        ["\xE6\x8A\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xDC"],
        ["\xE8\xA8\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xDD"],
        ["\xE7\xAA\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xDE"],
        ["\xE7\xAF\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xDF"],
        ["\xE8\xAA\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE0"],
        ["\xE9\x9B\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE1"],
        ["\xE7\xB5\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE2"],
        ["\xE8\x88\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE3"],
        ["\xE8\x9D\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE4"],
        ["\xE4\xBB\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE5"],
        ["\xE5\x85\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE6"],
        ["\xE5\x8D\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE7"],
        ["\xE5\x8D\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE8"],
        ["\xE5\xAE\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE9"],
        ["\xE5\xB0\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xEA"],
        ["\xE5\xB0\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xEB"],
        ["\xE5\xB7\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xEC"],
        ["\xE6\x88\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xED"],
        ["\xE6\x89\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xEE"],
        ["\xE6\x92\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xEF"],
        ["\xE6\xA0\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF0"],
        ["\xE6\xA0\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF1"],
        ["\xE6\xB3\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF2"],
        ["\xE6\xB5\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF3"],
        ["\xE6\xB4\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF4"],
        ["\xE6\x9F\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF5"],
        ["\xE6\xBD\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF6"],
        ["\xE7\x85\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF7"],
        ["\xE7\x85\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF8"],
        ["\xE6\x97\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF9"],
        ["\xE7\xA9\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xFA"],
        ["\xE7\xAE\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xFB"],
        ["\xE7\xB7\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xFC"],
        ["\xE7\xB9\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x40"],
        ["\xE7\xBE\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x41"],
        ["\xE8\x85\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x42"],
        ["\xE8\x88\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x43"],
        ["\xE8\x88\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x44"],
        ["\xE8\x96\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x45"],
        ["\xE8\xA9\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x46"],
        ["\xE8\xB3\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x47"],
        ["\xE8\xB7\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x48"],
        ["\xE9\x81\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x49"],
        ["\xE9\x81\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x4A"],
        ["\xE9\x8A\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x4B"],
        ["\xE9\x8A\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x4C"],
        ["\xE9\x96\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x4D"],
        ["\xE9\xAE\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x4E"],
        ["\xE5\x89\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x4F"],
        ["\xE5\x96\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x50"],
        ["\xE6\xBC\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x51"],
        ["\xE7\x84\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x52"],
        ["\xE5\x85\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x53"],
        ["\xE7\xA6\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x54"],
        ["\xE7\xB9\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x55"],
        ["\xE8\x86\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x56"],
        ["\xE7\xB3\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x57"],
        ["\xE5\x99\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x58"],
        ["\xE5\xA1\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x59"],
        ["\xE5\xB2\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x5A"],
        ["\xE6\x8E\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x5B"],
        ["\xE6\x9B\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x5C"],
        ["\xE6\x9B\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x5D"],
        ["\xE6\xA5\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x5E"],
        ["\xE7\x8B\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x5F"],
        ["\xE7\x96\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x60"],
        ["\xE7\x96\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x61"],
        ["\xE7\xA4\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x62"],
        ["\xE7\xA5\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x63"],
        ["\xE7\xA7\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x64"],
        ["\xE7\xB2\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x65"],
        ["\xE7\xB4\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x66"],
        ["\xE7\xB5\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x67"],
        ["\xE8\x98\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x68"],
        ["\xE8\xA8\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x69"],
        ["\xE9\x98\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x6A"],
        ["\xE9\x81\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x6B"],
        ["\xE9\xBC\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x6C"],
        ["\xE5\x83\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x6D"],
        ["\xE5\x89\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x6E"],
        ["\xE5\x8F\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x6F"],
        ["\xE5\x8F\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x70"],
        ["\xE5\x80\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x71"],
        ["\xE5\x96\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x72"],
        ["\xE5\xA3\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x73"],
        ["\xE5\xA5\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x74"],
        ["\xE7\x88\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x75"],
        ["\xE5\xAE\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x76"],
        ["\xE5\xB1\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x77"],
        ["\xE5\x8C\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x78"],
        ["\xE6\x83\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x79"],
        ["\xE6\x83\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x7A"],
        ["\xE6\x8D\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x7B"],
        ["\xE6\x8E\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x7C"],
        ["\xE6\x8C\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x7D"],
        ["\xE6\x8E\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x7E"],
        ["\xE6\x93\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x80"],
        ["\xE6\x97\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x81"],
        ["\xE6\x9B\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x82"],
        ["\xE5\xB7\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x83"],
        ["\xE6\xA7\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x84"],
        ["\xE6\xA7\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x85"],
        ["\xE6\xBC\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x86"],
        ["\xE7\x87\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x87"],
        ["\xE4\xBA\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x88"],
        ["\xE7\x97\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x89"],
        ["\xE7\x9B\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x8A"],
        ["\xE7\xAA\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x8B"],
        ["\xE7\xB3\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x8C"],
        ["\xE7\xB7\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x8D"],
        ["\xE7\xB6\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x8E"],
        ["\xE8\x81\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x8F"],
        ["\xE8\x8D\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x90"],
        ["\xE8\x8D\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x91"],
        ["\xE8\x91\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x92"],
        ["\xE8\x92\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x93"],
        ["\xE8\x97\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x94"],
        ["\xE8\xA3\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x95"],
        ["\xE8\xB5\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x96"],
        ["\xE9\x80\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x97"],
        ["\xE9\x81\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x98"],
        ["\xE9\x8E\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x99"],
        ["\xE9\x9C\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x9A"],
        ["\xE9\xA8\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x9B"],
        ["\xE5\x83\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x9C"],
        ["\xE5\xA2\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x9D"],
        ["\xE6\x86\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x9E"],
        ["\xE8\x87\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x9F"],
        ["\xE8\x94\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA0"],
        ["\xE8\xB4\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA1"],
        ["\xE9\x80\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA2"],
        ["\xE4\xBF\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA3"],
        ["\xE5\x81\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA4"],
        ["\xE5\x89\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA5"],
        ["\xE5\x8D\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA6"],
        ["\xE6\x81\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA7"],
        ["\xE6\x8D\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA8"],
        ["\xE6\x9D\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA9"],
        ["\xE6\xB8\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xAA"],
        ["\xE8\xB6\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xAB"],
        ["\xE9\x80\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xAC"],
        ["\xE4\xBF\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xAD"],
        ["\xE5\xB1\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xAE"],
        ["\xE8\xB3\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xAF"],
        ["\xE6\x97\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB0"],
        ["\xE7\xB6\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB1"],
        ["\xE5\x8D\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB2"],
        ["\xE8\xA2\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB3"],
        ["\xE5\x85\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB4"],
        ["\xE6\x8F\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB5"],
        ["\xE5\xAD\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB6"],
        ["\xE5\xAD\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB7"],
        ["\xE5\xB0\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB8"],
        ["\xE6\x90\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB9"],
        ["\xE6\x9D\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xBA"],
        ["\xE9\x81\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xBB"],
        ["\xE4\xBB\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xBC"],
        ["\xE5\xA4\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xBD"],
        ["\xE5\xA4\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xBE"],
        ["\xE6\xB1\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xBF"],
        ["\xE8\xA9\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC0"],
        ["\xE5\x94\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC1"],
        ["\xE5\xA0\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC2"],
        ["\xE5\xA6\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC3"],
        ["\xE6\x83\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC4"],
        ["\xE6\x89\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC5"],
        ["\xE6\x9F\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC6"],
        ["\xE8\x88\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC7"],
        ["\xE6\xA5\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC8"],
        ["\xE9\x99\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC9"],
        ["\xE9\xA7\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xCA"],
        ["\xE9\xA8\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xCB"],
        ["\xE4\xBD\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xCC"],
        ["\xE5\xA0\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xCD"],
        ["\xE5\xAF\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xCE"],
        ["\xE8\x80\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xCF"],
        ["\xE5\xB2\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD0"],
        ["\xE5\xB8\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD1"],
        ["\xE5\xBE\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD2"],
        ["\xE6\x80\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD3"],
        ["\xE6\x85\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD4"],
        ["\xE6\x88\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD5"],
        ["\xE6\x9B\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD6"],
        ["\xE6\xB3\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD7"],
        ["\xE6\xBB\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD8"],
        ["\xE8\x83\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD9"],
        ["\xE8\x85\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xDA"],
        ["\xE8\x8B\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xDB"],
        ["\xE8\xA2\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xDC"],
        ["\xE8\xB2\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xDD"],
        ["\xE9\x80\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xDE"],
        ["\xE9\x80\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xDF"],
        ["\xE9\x9A\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE0"],
        ["\xE9\xBB\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE1"],
        ["\xE9\xAF\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE2"],
        ["\xE4\xBB\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE3"],
        ["\xE5\x8F\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE4"],
        ["\xE5\xA4\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE5"],
        ["\xE7\xAC\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE6"],
        ["\xE9\x86\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE7"],
        ["\xE9\xA1\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE8"],
        ["\xE9\xB7\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE9"],
        ["\xE6\xBB\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xEA"],
        ["\xE7\x80\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xEB"],
        ["\xE5\x8D\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xEC"],
        ["\xE5\x95\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xED"],
        ["\xE5\xAE\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xEE"],
        ["\xE6\x89\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xEF"],
        ["\xE6\x8A\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF0"],
        ["\xE6\x8B\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF1"],
        ["\xE6\xB2\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF2"],
        ["\xE6\xBF\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF3"],
        ["\xE7\x90\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF4"],
        ["\xE8\xA8\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF5"],
        ["\xE9\x90\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF6"],
        ["\xE6\xBF\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF7"],
        ["\xE8\xAB\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF8"],
        ["\xE8\x8C\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF9"],
        ["\xE5\x87\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xFA"],
        ["\xE8\x9B\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xFB"],
        ["\xE5\x8F\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xFC"],
        ["\xE5\x8F\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x40"],
        ["\xE4\xBD\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x41"],
        ["\xE9\x81\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x42"],
        ["\xE8\xBE\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x43"],
        ["\xE5\xA5\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x44"],
        ["\xE8\x84\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x45"],
        ["\xE5\xB7\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x46"],
        ["\xE7\xAB\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x47"],
        ["\xE8\xBE\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x48"],
        ["\xE6\xA3\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x49"],
        ["\xE8\xB0\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x4A"],
        ["\xE7\x8B\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x4B"],
        ["\xE9\xB1\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x4C"],
        ["\xE6\xA8\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x4D"],
        ["\xE8\xAA\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x4E"],
        ["\xE4\xB8\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x4F"],
        ["\xE5\x8D\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x50"],
        ["\xE5\x98\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x51"],
        ["\xE5\x9D\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x52"],
        ["\xE6\x8B\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x53"],
        ["\xE6\x8E\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x54"],
        ["\xE6\x97\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x55"],
        ["\xE6\xAD\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x56"],
        ["\xE6\xB7\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x57"],
        ["\xE6\xB9\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x58"],
        ["\xE7\x82\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x59"],
        ["\xE7\x9F\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x5A"],
        ["\xE7\xAB\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x5B"],
        ["\xE7\xAE\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x5C"],
        ["\xE7\xB6\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x5D"],
        ["\xE8\x80\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x5E"],
        ["\xE8\x83\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x5F"],
        ["\xE8\x9B\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x60"],
        ["\xE8\xAA\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x61"],
        ["\xE9\x8D\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x62"],
        ["\xE5\x9B\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x63"],
        ["\xE5\xA3\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x64"],
        ["\xE5\xBC\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x65"],
        ["\xE6\x96\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x66"],
        ["\xE6\x9A\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x67"],
        ["\xE6\xAA\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x68"],
        ["\xE6\xAE\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x69"],
        ["\xE7\x94\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x6A"],
        ["\xE8\xAB\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x6B"],
        ["\xE5\x80\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x6C"],
        ["\xE7\x9F\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x6D"],
        ["\xE5\x9C\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x6E"],
        ["\xE5\xBC\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x6F"],
        ["\xE6\x81\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x70"],
        ["\xE6\x99\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x71"],
        ["\xE6\xB1\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x72"],
        ["\xE7\x97\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x73"],
        ["\xE7\xA8\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x74"],
        ["\xE7\xBD\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x75"],
        ["\xE8\x87\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x76"],
        ["\xE8\x9C\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x77"],
        ["\xE9\x81\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x78"],
        ["\xE9\xA6\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x79"],
        ["\xE7\xAF\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x7A"],
        ["\xE7\x95\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x7B"],
        ["\xE7\xAB\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x7C"],
        ["\xE7\xAD\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x7D"],
        ["\xE8\x93\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x7E"],
        ["\xE9\x80\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x80"],
        ["\xE7\xA7\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x81"],
        ["\xE7\xAA\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x82"],
        ["\xE8\x8C\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x83"],
        ["\xE5\xAB\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x84"],
        ["\xE7\x9D\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x85"],
        ["\xE4\xB8\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x86"],
        ["\xE4\xBB\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x87"],
        ["\xE5\xAE\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x88"],
        ["\xE5\xBF\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x89"],
        ["\xE6\x8A\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x8A"],
        ["\xE6\x98\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x8B"],
        ["\xE6\x9F\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x8C"],
        ["\xE6\xB3\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x8D"],
        ["\xE8\x99\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x8E"],
        ["\xE8\xA1\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x8F"],
        ["\xE8\xA8\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x90"],
        ["\xE9\x85\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x91"],
        ["\xE9\x8B\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x92"],
        ["\xE9\xA7\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x93"],
        ["\xE6\xA8\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x94"],
        ["\xE7\x80\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x95"],
        ["\xE7\x8C\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x96"],
        ["\xE8\x8B\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x97"],
        ["\xE8\x91\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x98"],
        ["\xE8\xB2\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x99"],
        ["\xE4\xB8\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x9A"],
        ["\xE5\x85\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x9B"],
        ["\xE5\x87\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x9C"],
        ["\xE5\x96\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x9D"],
        ["\xE5\xAF\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x9E"],
        ["\xE5\xB8\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x9F"],
        ["\xE5\xB8\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA0"],
        ["\xE5\xBA\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA1"],
        ["\xE5\xBC\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA2"],
        ["\xE5\xBC\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA3"],
        ["\xE5\xBD\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA4"],
        ["\xE5\xBE\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA5"],
        ["\xE6\x87\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA6"],
        ["\xE6\x8C\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA7"],
        ["\xE6\x9A\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA8"],
        ["\xE6\x9C\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA9"],
        ["\xE6\xBD\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xAA"],
        ["\xE7\x89\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xAB"],
        ["\xE7\x94\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xAC"],
        ["\xE7\x9C\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xAD"],
        ["\xE8\x81\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xAE"],
        ["\xE8\x84\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xAF"],
        ["\xE8\x85\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB0"],
        ["\xE8\x9D\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB1"],
        ["\xE8\xAA\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB2"],
        ["\xE8\xAB\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB3"],
        ["\xE8\xB6\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB4"],
        ["\xE8\xB7\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB5"],
        ["\xE9\x8A\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB6"],
        ["\xE9\x95\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB7"],
        ["\xE9\xA0\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB8"],
        ["\xE9\xB3\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB9"],
        ["\xE5\x8B\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xBA"],
        ["\xE6\x8D\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xBB"],
        ["\xE7\x9B\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xBC"],
        ["\xE6\x9C\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xBD"],
        ["\xE6\xB2\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xBE"],
        ["\xE7\x8F\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xBF"],
        ["\xE8\xB3\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC0"],
        ["\xE9\x8E\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC1"],
        ["\xE9\x99\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC2"],
        ["\xE6\xB4\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC3"],
        ["\xE5\xA2\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC4"],
        ["\xE6\xA4\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC5"],
        ["\xE6\xA7\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC6"],
        ["\xE8\xBF\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC7"],
        ["\xE9\x8E\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC8"],
        ["\xE7\x97\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC9"],
        ["\xE9\x80\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xCA"],
        ["\xE5\xA1\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xCB"],
        ["\xE6\xA0\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xCC"],
        ["\xE6\x8E\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xCD"],
        ["\xE6\xA7\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xCE"],
        ["\xE4\xBD\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xCF"],
        ["\xE6\xBC\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD0"],
        ["\xE6\x9F\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD1"],
        ["\xE8\xBE\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD2"],
        ["\xE8\x94\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD3"],
        ["\xE7\xB6\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD4"],
        ["\xE9\x8D\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD5"],
        ["\xE6\xA4\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD6"],
        ["\xE6\xBD\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD7"],
        ["\xE5\x9D\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD8"],
        ["\xE5\xA3\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD9"],
        ["\xE5\xAC\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xDA"],
        ["\xE7\xB4\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xDB"],
        ["\xE7\x88\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xDC"],
        ["\xE5\x90\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xDD"],
        ["\xE9\x87\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xDE"],
        ["\xE9\xB6\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xDF"],
        ["\xE4\xBA\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE0"],
        ["\xE4\xBD\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE1"],
        ["\xE5\x81\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE2"],
        ["\xE5\x81\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE3"],
        ["\xE5\x89\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE4"],
        ["\xE8\xB2\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE5"],
        ["\xE5\x91\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE6"],
        ["\xE5\xA0\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE7"],
        ["\xE5\xAE\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE8"],
        ["\xE5\xB8\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE9"],
        ["\xE5\xBA\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xEA"],
        ["\xE5\xBA\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xEB"],
        ["\xE5\xBB\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xEC"],
        ["\xE5\xBC\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xED"],
        ["\xE6\x82\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xEE"],
        ["\xE6\x8A\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xEF"],
        ["\xE6\x8C\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF0"],
        ["\xE6\x8F\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF1"],
        ["\xE6\xA2\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF2"],
        ["\xE6\xB1\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF3"],
        ["\xE7\xA2\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF4"],
        ["\xE7\xA6\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF5"],
        ["\xE7\xA8\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF6"],
        ["\xE7\xB7\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF7"],
        ["\xE8\x89\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF8"],
        ["\xE8\xA8\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF9"],
        ["\xE8\xAB\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xFA"],
        ["\xE8\xB9\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xFB"],
        ["\xE9\x80\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xFC"],
        ["\xE9\x82\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x40"],
        ["\xE9\x84\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x41"],
        ["\xE9\x87\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x42"],
        ["\xE9\xBC\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x43"],
        ["\xE6\xB3\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x44"],
        ["\xE6\x91\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x45"],
        ["\xE6\x93\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x46"],
        ["\xE6\x95\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x47"],
        ["\xE6\xBB\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x48"],
        ["\xE7\x9A\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x49"],
        ["\xE7\xAC\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x4A"],
        ["\xE9\x81\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x4B"],
        ["\xE9\x8F\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x4C"],
        ["\xE6\xBA\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x4D"],
        ["\xE5\x93\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x4E"],
        ["\xE5\xBE\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x4F"],
        ["\xE6\x92\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x50"],
        ["\xE8\xBD\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x51"],
        ["\xE8\xBF\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x52"],
        ["\xE9\x89\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x53"],
        ["\xE5\x85\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x54"],
        ["\xE5\xA1\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x55"],
        ["\xE5\xA4\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x56"],
        ["\xE5\xB1\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x57"],
        ["\xE5\xBA\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x58"],
        ["\xE6\xB7\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x59"],
        ["\xE7\xBA\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x5A"],
        ["\xE7\x94\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x5B"],
        ["\xE8\xB2\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x5C"],
        ["\xE8\xBB\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x5D"],
        ["\xE9\xA1\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x5E"],
        ["\xE7\x82\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x5F"],
        ["\xE4\xBC\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x60"],
        ["\xE6\xAE\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x61"],
        ["\xE6\xBE\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x62"],
        ["\xE7\x94\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x63"],
        ["\xE9\x9B\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x64"],
        ["\xE5\x85\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x65"],
        ["\xE5\x90\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x66"],
        ["\xE5\xA0\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x67"],
        ["\xE5\xA1\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x68"],
        ["\xE5\xA6\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x69"],
        ["\xE5\xB1\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x6A"],
        ["\xE5\xBE\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x6B"],
        ["\xE6\x96\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x6C"],
        ["\xE6\x9D\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x6D"],
        ["\xE6\xB8\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x6E"],
        ["\xE7\x99\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x6F"],
        ["\xE8\x8F\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x70"],
        ["\xE8\xB3\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x71"],
        ["\xE9\x80\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x72"],
        ["\xE9\x83\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x73"],
        ["\xE9\x8D\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x74"],
        ["\xE7\xA0\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x75"],
        ["\xE7\xA0\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x76"],
        ["\xE5\x8A\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x77"],
        ["\xE5\xBA\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x78"],
        ["\xE5\x9C\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x79"],
        ["\xE5\xA5\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x7A"],
        ["\xE6\x80\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x7B"],
        ["\xE5\x80\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x7C"],
        ["\xE5\x85\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x7D"],
        ["\xE5\x86\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x7E"],
        ["\xE5\x87\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x80"],
        ["\xE5\x88\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x81"],
        ["\xE5\x94\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x82"],
        ["\xE5\xA1\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x83"],
        ["\xE5\xA1\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x84"],
        ["\xE5\xA5\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x85"],
        ["\xE5\xAE\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x86"],
        ["\xE5\xB3\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x87"],
        ["\xE5\xB6\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x88"],
        ["\xE6\x82\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x89"],
        ["\xE6\x8A\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x8A"],
        ["\xE6\x90\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x8B"],
        ["\xE6\x9D\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x8C"],
        ["\xE6\xA1\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x8D"],
        ["\xE6\xA2\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x8E"],
        ["\xE6\xA3\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x8F"],
        ["\xE7\x9B\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x90"],
        ["\xE6\xB7\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x91"],
        ["\xE6\xB9\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x92"],
        ["\xE6\xB6\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x93"],
        ["\xE7\x81\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x94"],
        ["\xE7\x87\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x95"],
        ["\xE5\xBD\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x96"],
        ["\xE7\x97\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x97"],
        ["\xE7\xA5\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x98"],
        ["\xE7\xAD\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x99"],
        ["\xE7\xAD\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x9A"],
        ["\xE7\xAD\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x9B"],
        ["\xE7\xB3\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x9C"],
        ["\xE7\xB5\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x9D"],
        ["\xE5\x88\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x9E"],
        ["\xE8\x91\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x9F"],
        ["\xE8\x95\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA0"],
        ["\xE8\x97\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA1"],
        ["\xE8\xA8\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA2"],
        ["\xE8\xAC\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA3"],
        ["\xE8\xB1\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA4"],
        ["\xE8\xB8\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA5"],
        ["\xE9\x80\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA6"],
        ["\xE9\x80\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA7"],
        ["\xE9\x90\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA8"],
        ["\xE9\x99\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA9"],
        ["\xE9\xA0\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xAA"],
        ["\xE9\xA8\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xAB"],
        ["\xE9\x97\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xAC"],
        ["\xE5\x83\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xAD"],
        ["\xE5\x8B\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xAE"],
        ["\xE5\x90\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xAF"],
        ["\xE5\xA0\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB0"],
        ["\xE5\xB0\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB1"],
        ["\xE6\x86\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB2"],
        ["\xE6\x92\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB3"],
        ["\xE6\xB4\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB4"],
        ["\xE7\x9E\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB5"],
        ["\xE7\xAB\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB6"],
        ["\xE8\x83\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB7"],
        ["\xE8\x90\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB8"],
        ["\xE9\x81\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB9"],
        ["\xE9\x8A\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xBA"],
        ["\xE5\xB3\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xBB"],
        ["\xE9\xB4\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xBC"],
        ["\xE5\x8C\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xBD"],
        ["\xE5\xBE\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xBE"],
        ["\xE5\xBE\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xBF"],
        ["\xE6\xB6\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC0"],
        ["\xE7\x89\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC1"],
        ["\xE7\x9D\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC2"],
        ["\xE7\xA6\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC3"],
        ["\xE7\xAF\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC4"],
        ["\xE6\xAF\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC5"],
        ["\xE7\x8B\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC6"],
        ["\xE8\xAA\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC7"],
        ["\xE6\xA0\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC8"],
        ["\xE6\xA9\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC9"],
        ["\xE5\x87\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xCA"],
        ["\xE7\xAA\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xCB"],
        ["\xE6\xA4\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xCC"],
        ["\xE5\xB1\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xCD"],
        ["\xE9\xB3\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xCE"],
        ["\xE8\x8B\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xCF"],
        ["\xE5\xAF\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD0"],
        ["\xE9\x85\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD1"],
        ["\xE7\x80\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD2"],
        ["\xE5\x99\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD3"],
        ["\xE5\xB1\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD4"],
        ["\xE6\x83\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD5"],
        ["\xE6\x95\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD6"],
        ["\xE6\xB2\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD7"],
        ["\xE8\xB1\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD8"],
        ["\xE9\x81\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD9"],
        ["\xE9\xA0\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xDA"],
        ["\xE5\x91\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xDB"],
        ["\xE6\x9B\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xDC"],
        ["\xE9\x88\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xDD"],
        ["\xE5\xA5\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xDE"],
        ["\xE9\x82\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xDF"],
        ["\xE5\x86\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE0"],
        ["\xE4\xB9\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE1"],
        ["\xE5\x87\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE2"],
        ["\xE8\x96\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE3"],
        ["\xE8\xAC\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE4"],
        ["\xE7\x81\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE5"],
        ["\xE6\x8D\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE6"],
        ["\xE9\x8D\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE7"],
        ["\xE6\xA5\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE8"],
        ["\xE9\xA6\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE9"],
        ["\xE7\xB8\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xEA"],
        ["\xE7\x95\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xEB"],
        ["\xE5\x8D\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xEC"],
        ["\xE6\xA5\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xED"],
        ["\xE8\xBB\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xEE"],
        ["\xE9\x9B\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xEF"],
        ["\xE6\xB1\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF0"],
        ["\xE4\xBA\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF1"],
        ["\xE5\xB0\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF2"],
        ["\xE5\xBC\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF3"],
        ["\xE8\xBF\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF4"],
        ["\xE5\x8C\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF5"],
        ["\xE8\xB3\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF6"],
        ["\xE8\x82\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF7"],
        ["\xE8\x99\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF8"],
        ["\xE5\xBB\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF9"],
        ["\xE6\x97\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xFA"],
        ["\xE4\xB9\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xFB"],
        ["\xE5\x85\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xFC"],
        ["\xE5\xA6\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x40"],
        ["\xE5\xB0\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x41"],
        ["\xE9\x9F\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x42"],
        ["\xE4\xBB\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x43"],
        ["\xE5\xA6\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x44"],
        ["\xE5\xBF\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x45"],
        ["\xE8\xAA\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x46"],
        ["\xE6\xBF\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x47"],
        ["\xE7\xA6\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x48"],
        ["\xE7\xA5\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x49"],
        ["\xE5\xAF\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x4A"],
        ["\xE8\x91\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x4B"],
        ["\xE7\x8C\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x4C"],
        ["\xE7\x86\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x4D"],
        ["\xE5\xB9\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x4E"],
        ["\xE5\xBF\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x4F"],
        ["\xE6\x8D\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x50"],
        ["\xE6\x92\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x51"],
        ["\xE7\x87\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x52"],
        ["\xE7\xB2\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x53"],
        ["\xE4\xB9\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x54"],
        ["\xE5\xBB\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x55"],
        ["\xE4\xB9\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x56"],
        ["\xE5\x9F\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x57"],
        ["\xE5\x9A\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x58"],
        ["\xE6\x82\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x59"],
        ["\xE6\xBF\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x5A"],
        ["\xE7\xB4\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x5B"],
        ["\xE8\x83\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x5C"],
        ["\xE8\x84\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x5D"],
        ["\xE8\x86\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x5E"],
        ["\xE8\xBE\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x5F"],
        ["\xE8\xA6\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x60"],
        ["\xE8\x9A\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x61"],
        ["\xE5\xB7\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x62"],
        ["\xE6\x8A\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x63"],
        ["\xE6\x92\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x64"],
        ["\xE8\xA6\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x65"],
        ["\xE6\x9D\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x66"],
        ["\xE6\xB3\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x67"],
        ["\xE6\xB4\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x68"],
        ["\xE7\x90\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x69"],
        ["\xE7\xA0\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x6A"],
        ["\xE5\xA9\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x6B"],
        ["\xE7\xBD\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x6C"],
        ["\xE8\x8A\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x6D"],
        ["\xE9\xA6\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x6E"],
        ["\xE4\xBF\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x6F"],
        ["\xE5\xBB\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x70"],
        ["\xE6\x8B\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x71"],
        ["\xE6\x8E\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x72"],
        ["\xE6\x95\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x73"],
        ["\xE6\x9D\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x74"],
        ["\xE7\x9B\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x75"],
        ["\xE7\x89\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x76"],
        ["\xE8\x83\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x77"],
        ["\xE8\x82\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x78"],
        ["\xE8\xBC\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x79"],
        ["\xE9\x85\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x7A"],
        ["\xE5\x80\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x7B"],
        ["\xE5\x9F\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x7C"],
        ["\xE5\xAA\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x7D"],
        ["\xE6\xA2\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x7E"],
        ["\xE6\xA5\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x80"],
        ["\xE7\x85\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x81"],
        ["\xE7\x8B\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x82"],
        ["\xE8\xB2\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x83"],
        ["\xE5\xA3\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x84"],
        ["\xE8\xB3\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x85"],
        ["\xE9\x99\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x86"],
        ["\xE9\x80\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x87"],
        ["\xE8\x9D\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x88"],
        ["\xE7\xA7\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x89"],
        ["\xE7\x9F\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x8A"],
        ["\xE8\x90\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x8B"],
        ["\xE4\xBC\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x8C"],
        ["\xE5\x89\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x8D"],
        ["\xE5\x8D\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x8E"],
        ["\xE6\x8B\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x8F"],
        ["\xE6\x9F\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x90"],
        ["\xE6\xB3\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x91"],
        ["\xE7\x99\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x92"],
        ["\xE7\xAE\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x93"],
        ["\xE7\xB2\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x94"],
        ["\xE8\x88\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x95"],
        ["\xE8\x96\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x96"],
        ["\xE8\xBF\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x97"],
        ["\xE6\x9B\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x98"],
        ["\xE6\xBC\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x99"],
        ["\xE7\x88\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x9A"],
        ["\xE7\xB8\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x9B"],
        ["\xE8\x8E\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x9C"],
        ["\xE9\xA7\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x9D"],
        ["\xE9\xBA\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x9E"],
        ["\xE5\x87\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x9F"],
        ["\xE7\xAE\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA0"],
        ["\xE7\xA1\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA1"],
        ["\xE7\xAE\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA2"],
        ["\xE8\x82\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA3"],
        ["\xE7\xAD\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA4"],
        ["\xE6\xAB\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA5"],
        ["\xE5\xB9\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA6"],
        ["\xE8\x82\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA7"],
        ["\xE7\x95\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA8"],
        ["\xE7\x95\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA9"],
        ["\xE5\x85\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xAA"],
        ["\xE9\x89\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xAB"],
        ["\xE6\xBA\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xAC"],
        ["\xE7\x99\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xAD"],
        ["\xE9\x86\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xAE"],
        ["\xE9\xAB\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xAF"],
        ["\xE4\xBC\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB0"],
        ["\xE7\xBD\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB1"],
        ["\xE6\x8A\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB2"],
        ["\xE7\xAD\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB3"],
        ["\xE9\x96\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB4"],
        ["\xE9\xB3\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB5"],
        ["\xE5\x99\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB6"],
        ["\xE5\xA1\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB7"],
        ["\xE8\x9B\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB8"],
        ["\xE9\x9A\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB9"],
        ["\xE4\xBC\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xBA"],
        ["\xE5\x88\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xBB"],
        ["\xE5\x8D\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xBC"],
        ["\xE5\x8F\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xBD"],
        ["\xE5\x8F\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xBE"],
        ["\xE5\xB8\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xBF"],
        ["\xE6\x90\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC0"],
        ["\xE6\x96\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC1"],
        ["\xE6\x9D\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC2"],
        ["\xE6\xB0\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC3"],
        ["\xE6\xB1\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC4"],
        ["\xE7\x89\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC5"],
        ["\xE7\x8A\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC6"],
        ["\xE7\x8F\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC7"],
        ["\xE7\x95\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC8"],
        ["\xE7\xB9\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC9"],
        ["\xE8\x88\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xCA"],
        ["\xE8\x97\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xCB"],
        ["\xE8\xB2\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xCC"],
        ["\xE7\xAF\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xCD"],
        ["\xE9\x87\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xCE"],
        ["\xE7\x85\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xCF"],
        ["\xE9\xA0\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD0"],
        ["\xE9\xA3\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD1"],
        ["\xE6\x8C\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD2"],
        ["\xE6\x99\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD3"],
        ["\xE7\x95\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD4"],
        ["\xE7\x9B\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD5"],
        ["\xE7\xA3\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD6"],
        ["\xE8\x95\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD7"],
        ["\xE8\x9B\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD8"],
        ["\xE5\x8C\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD9"],
        ["\xE5\x8D\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xDA"],
        ["\xE5\x90\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xDB"],
        ["\xE5\xA6\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xDC"],
        ["\xE5\xBA\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xDD"],
        ["\xE5\xBD\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xDE"],
        ["\xE6\x82\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xDF"],
        ["\xE6\x89\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE0"],
        ["\xE6\x89\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE1"],
        ["\xE6\x8A\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE2"],
        ["\xE6\x96\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE3"],
        ["\xE6\xAF\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE4"],
        ["\xE6\xB3\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE5"],
        ["\xE7\x96\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE6"],
        ["\xE7\x9A\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE7"],
        ["\xE7\xA2\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE8"],
        ["\xE7\xA7\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE9"],
        ["\xE7\xB7\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xEA"],
        ["\xE7\xBD\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xEB"],
        ["\xE8\x82\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xEC"],
        ["\xE8\xA2\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xED"],
        ["\xE8\xAA\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xEE"],
        ["\xE8\xB2\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xEF"],
        ["\xE9\x81\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF0"],
        ["\xE9\x9D\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF1"],
        ["\xE9\xA3\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF2"],
        ["\xE6\xA8\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF3"],
        ["\xE7\xB0\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF4"],
        ["\xE5\x82\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF5"],
        ["\xE5\xB0\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF6"],
        ["\xE5\xBE\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF7"],
        ["\xE6\x9E\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF8"],
        ["\xE6\xAF\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF9"],
        ["\xE7\x90\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xFA"],
        ["\xE7\x9C\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xFB"],
        ["\xE7\xBE\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xFC"],
        ["\xE9\xBC\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x40"],
        ["\xE6\x9F\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x41"],
        ["\xE7\xA8\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x42"],
        ["\xE5\x8C\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x43"],
        ["\xE7\x96\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x44"],
        ["\xE9\xAB\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x45"],
        ["\xE5\xBD\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x46"],
        ["\xE8\x86\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x47"],
        ["\xE8\x8F\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x48"],
        ["\xE8\x82\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x49"],
        ["\xE5\xBC\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x4A"],
        ["\xE5\xBF\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x4B"],
        ["\xE7\x95\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x4C"],
        ["\xE7\xAD\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x4D"],
        ["\xE9\x80\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x4E"],
        ["\xE6\xA1\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x4F"],
        ["\xE5\xA7\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x50"],
        ["\xE5\xAA\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x51"],
        ["\xE7\xB4\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x52"],
        ["\xE7\x99\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x53"],
        ["\xE8\xAC\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x54"],
        ["\xE4\xBF\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x55"],
        ["\xE5\xBD\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x56"],
        ["\xE6\xA8\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x57"],
        ["\xE6\xB0\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x58"],
        ["\xE6\xBC\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x59"],
        ["\xE7\x93\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x5A"],
        ["\xE7\xA5\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x5B"],
        ["\xE8\xA1\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x5C"],
        ["\xE8\xA9\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x5D"],
        ["\xE8\xB1\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x5E"],
        ["\xE5\xBB\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x5F"],
        ["\xE6\x8F\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x60"],
        ["\xE7\x97\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x61"],
        ["\xE7\xA7\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x62"],
        ["\xE8\x8B\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x63"],
        ["\xE9\x8C\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x64"],
        ["\xE9\x8B\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x65"],
        ["\xE8\x92\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x66"],
        ["\xE8\x9B\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x67"],
        ["\xE9\xB0\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x68"],
        ["\xE5\x93\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x69"],
        ["\xE5\xBD\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x6A"],
        ["\xE6\x96\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x6B"],
        ["\xE6\xB5\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x6C"],
        ["\xE7\x80\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x6D"],
        ["\xE8\xB2\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x6E"],
        ["\xE8\xB3\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x6F"],
        ["\xE9\xA0\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x70"],
        ["\xE6\x95\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x71"],
        ["\xE7\x93\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x72"],
        ["\xE4\xB8\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x73"],
        ["\xE4\xBB\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x74"],
        ["\xE5\x9F\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x75"],
        ["\xE5\xA4\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x76"],
        ["\xE5\xA9\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x77"],
        ["\xE5\xAF\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x78"],
        ["\xE5\x86\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x79"],
        ["\xE5\xB8\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x7A"],
        ["\xE5\xBA\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x7B"],
        ["\xE6\x80\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x7C"],
        ["\xE6\x89\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x7D"],
        ["\xE6\x95\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x7E"],
        ["\xE6\x96\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x80"],
        ["\xE6\x99\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x81"],
        ["\xE6\xB5\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x82"],
        ["\xE7\x88\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x83"],
        ["\xE7\xAC\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x84"],
        ["\xE8\x85\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x85"],
        ["\xE8\x86\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x86"],
        ["\xE8\x8A\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x87"],
        ["\xE8\xAD\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x88"],
        ["\xE8\xB2\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x89"],
        ["\xE8\xB3\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x8A"],
        ["\xE8\xB5\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x8B"],
        ["\xE9\x98\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x8C"],
        ["\xE9\x99\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x8D"],
        ["\xE4\xBE\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x8E"],
        ["\xE6\x92\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x8F"],
        ["\xE6\xAD\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x90"],
        ["\xE8\x88\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x91"],
        ["\xE8\x91\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x92"],
        ["\xE8\x95\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x93"],
        ["\xE9\x83\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x94"],
        ["\xE5\xB0\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x95"],
        ["\xE6\xA5\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x96"],
        ["\xE9\xA2\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x97"],
        ["\xE8\x91\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x98"],
        ["\xE8\x95\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x99"],
        ["\xE4\xBC\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x9A"],
        ["\xE5\x89\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x9B"],
        ["\xE5\xBE\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x9C"],
        ["\xE5\xB9\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x9D"],
        ["\xE6\x9C\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x9E"],
        ["\xE7\xA6\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x9F"],
        ["\xE8\x85\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA0"],
        ["\xE8\xA4\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA1"],
        ["\xE8\xA6\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA2"],
        ["\xE6\xB7\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA3"],
        ["\xE5\xBC\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA4"],
        ["\xE6\x89\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA5"],
        ["\xE6\xB2\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA6"],
        ["\xE4\xBB\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA7"],
        ["\xE7\x89\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA8"],
        ["\xE9\xAE\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA9"],
        ["\xE5\x88\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xAA"],
        ["\xE5\x90\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xAB"],
        ["\xE5\x99\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xAC"],
        ["\xE5\xA2\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xAD"],
        ["\xE6\x86\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xAE"],
        ["\xE6\x89\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xAF"],
        ["\xE7\x84\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB0"],
        ["\xE5\xA5\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB1"],
        ["\xE7\xB2\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB2"],
        ["\xE7\xB3\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB3"],
        ["\xE7\xB4\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB4"],
        ["\xE9\x9B\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB5"],
        ["\xE6\x96\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB6"],
        ["\xE8\x81\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB7"],
        ["\xE4\xB8\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB8"],
        ["\xE4\xBD\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB9"],
        ["\xE5\x85\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xBA"],
        ["\xE5\xA1\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xBB"],
        ["\xE5\xB9\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xBC"],
        ["\xE5\xB9\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xBD"],
        ["\xE5\xBC\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xBE"],
        ["\xE6\x9F\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xBF"],
        ["\xE4\xB8\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC0"],
        ["\xE8\x94\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC1"],
        ["\xE9\x96\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC2"],
        ["\xE9\x99\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC3"],
        ["\xE7\xB1\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC4"],
        ["\xE9\xA0\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC5"],
        ["\xE5\x83\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC6"],
        ["\xE5\xA3\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC7"],
        ["\xE7\x99\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC8"],
        ["\xE7\xA2\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC9"],
        ["\xE5\x88\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xCA"],
        ["\xE7\x9E\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xCB"],
        ["\xE8\x94\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xCC"],
        ["\xE7\xAE\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xCD"],
        ["\xE5\x81\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xCE"],
        ["\xE5\xA4\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xCF"],
        ["\xE7\x89\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD0"],
        ["\xE7\xAF\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD1"],
        ["\xE7\xB7\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD2"],
        ["\xE8\xBE\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD3"],
        ["\xE8\xBF\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD4"],
        ["\xE9\x81\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD5"],
        ["\xE4\xBE\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD6"],
        ["\xE5\x8B\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD7"],
        ["\xE5\xA8\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD8"],
        ["\xE5\xBC\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD9"],
        ["\xE9\x9E\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xDA"],
        ["\xE4\xBF\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xDB"],
        ["\xE8\x88\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xDC"],
        ["\xE9\x8B\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xDD"],
        ["\xE5\x9C\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xDE"],
        ["\xE6\x8D\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xDF"],
        ["\xE6\xAD\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE0"],
        ["\xE7\x94\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE1"],
        ["\xE8\xA3\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE2"],
        ["\xE8\xBC\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE3"],
        ["\xE7\xA9\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE4"],
        ["\xE5\x8B\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE5"],
        ["\xE5\xA2\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE6"],
        ["\xE6\x85\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE7"],
        ["\xE6\x88\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE8"],
        ["\xE6\x9A\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE9"],
        ["\xE6\xAF\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xEA"],
        ["\xE7\xB0\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xEB"],
        ["\xE8\x8F\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xEC"],
        ["\xE5\x80\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xED"],
        ["\xE4\xBF\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xEE"],
        ["\xE5\x8C\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xEF"],
        ["\xE5\x91\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF0"],
        ["\xE5\xA0\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF1"],
        ["\xE5\xA5\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF2"],
        ["\xE5\xAE\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF3"],
        ["\xE5\xB3\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF4"],
        ["\xE5\xB3\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF5"],
        ["\xE5\xB4\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF6"],
        ["\xE5\xBA\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF7"],
        ["\xE6\x8A\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF8"],
        ["\xE6\x8D\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF9"],
        ["\xE6\x94\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xFA"],
        ["\xE6\x96\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xFB"],
        ["\xE6\x9C\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xFC"],
        ["\xE6\xB3\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x40"],
        ["\xE6\xB3\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x41"],
        ["\xE7\x83\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x42"],
        ["\xE7\xA0\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x43"],
        ["\xE7\xB8\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x44"],
        ["\xE8\x83\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x45"],
        ["\xE8\x8A\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x46"],
        ["\xE8\x90\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x47"],
        ["\xE8\x93\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x48"],
        ["\xE8\x9C\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x49"],
        ["\xE8\xA4\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x4A"],
        ["\xE8\xA8\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x4B"],
        ["\xE8\xB1\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x4C"],
        ["\xE9\x82\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x4D"],
        ["\xE9\x8B\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x4E"],
        ["\xE9\xA3\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x4F"],
        ["\xE9\xB3\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x50"],
        ["\xE9\xB5\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x51"],
        ["\xE4\xB9\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x52"],
        ["\xE4\xBA\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x53"],
        ["\xE5\x82\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x54"],
        ["\xE5\x89\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x55"],
        ["\xE5\x9D\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x56"],
        ["\xE5\xA6\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x57"],
        ["\xE5\xB8\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x58"],
        ["\xE5\xBF\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x59"],
        ["\xE5\xBF\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x5A"],
        ["\xE6\x88\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x5B"],
        ["\xE6\x9A\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x5C"],
        ["\xE6\x9C\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x5D"],
        ["\xE6\x9F\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x5E"],
        ["\xE6\xA3\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x5F"],
        ["\xE5\x86\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x60"],
        ["\xE7\xB4\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x61"],
        ["\xE8\x82\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x62"],
        ["\xE8\x86\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x63"],
        ["\xE8\xAC\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x64"],
        ["\xE8\xB2\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x65"],
        ["\xE8\xB2\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x66"],
        ["\xE9\x89\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x67"],
        ["\xE9\x98\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x68"],
        ["\xE5\x90\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x69"],
        ["\xE9\xA0\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x6A"],
        ["\xE5\x8C\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x6B"],
        ["\xE5\x83\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x6C"],
        ["\xE5\x8D\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x6D"],
        ["\xE5\xA2\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x6E"],
        ["\xE6\x92\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x6F"],
        ["\xE6\x9C\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x70"],
        ["\xE7\x89\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x71"],
        ["\xE7\x9D\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x72"],
        ["\xE7\xA9\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x73"],
        ["\xE9\x87\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x74"],
        ["\xE5\x8B\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x75"],
        ["\xE6\xB2\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x76"],
        ["\xE6\xAE\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x77"],
        ["\xE5\xA0\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x78"],
        ["\xE5\xB9\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x79"],
        ["\xE5\xA5\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x7A"],
        ["\xE6\x9C\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x7B"],
        ["\xE7\xBF\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x7C"],
        ["\xE5\x87\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x7D"],
        ["\xE7\x9B\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x7E"],
        ["\xE6\x91\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x80"],
        ["\xE7\xA3\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x81"],
        ["\xE9\xAD\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x82"],
        ["\xE9\xBA\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x83"],
        ["\xE5\x9F\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x84"],
        ["\xE5\xA6\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x85"],
        ["\xE6\x98\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x86"],
        ["\xE6\x9E\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x87"],
        ["\xE6\xAF\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x88"],
        ["\xE5\x93\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x89"],
        ["\xE6\xA7\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x8A"],
        ["\xE5\xB9\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x8B"],
        ["\xE8\x86\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x8C"],
        ["\xE6\x9E\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x8D"],
        ["\xE9\xAE\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x8E"],
        ["\xE6\x9F\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x8F"],
        ["\xE9\xB1\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x90"],
        ["\xE6\xA1\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x91"],
        ["\xE4\xBA\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x92"],
        ["\xE4\xBF\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x93"],
        ["\xE5\x8F\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x94"],
        ["\xE6\x8A\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x95"],
        ["\xE6\x9C\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x96"],
        ["\xE6\xB2\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x97"],
        ["\xE8\xBF\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x98"],
        ["\xE4\xBE\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x99"],
        ["\xE7\xB9\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x9A"],
        ["\xE9\xBA\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x9B"],
        ["\xE4\xB8\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x9C"],
        ["\xE6\x85\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x9D"],
        ["\xE6\xBA\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x9E"],
        ["\xE6\xBC\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x9F"],
        ["\xE8\x94\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA0"],
        ["\xE5\x91\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA1"],
        ["\xE6\x9C\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA2"],
        ["\xE9\xAD\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA3"],
        ["\xE5\xB7\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA4"],
        ["\xE7\xAE\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA5"],
        ["\xE5\xB2\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA6"],
        ["\xE5\xAF\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA7"],
        ["\xE8\x9C\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA8"],
        ["\xE6\xB9\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA9"],
        ["\xE8\x93\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xAA"],
        ["\xE7\xA8\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xAB"],
        ["\xE8\x84\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xAC"],
        ["\xE5\xA6\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xAD"],
        ["\xE7\xB2\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xAE"],
        ["\xE6\xB0\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xAF"],
        ["\xE7\x9C\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB0"],
        ["\xE5\x8B\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB1"],
        ["\xE5\xA4\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB2"],
        ["\xE7\x84\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB3"],
        ["\xE7\x89\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB4"],
        ["\xE7\x9F\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB5"],
        ["\xE9\x9C\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB6"],
        ["\xE9\xB5\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB7"],
        ["\xE6\xA4\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB8"],
        ["\xE5\xA9\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB9"],
        ["\xE5\xA8\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xBA"],
        ["\xE5\x86\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xBB"],
        ["\xE5\x90\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xBC"],
        ["\xE5\x91\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xBD"],
        ["\xE6\x98\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xBE"],
        ["\xE7\x9B\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xBF"],
        ["\xE8\xBF\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC0"],
        ["\xE9\x8A\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC1"],
        ["\xE9\xB3\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC2"],
        ["\xE5\xA7\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC3"],
        ["\xE7\x89\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC4"],
        ["\xE6\xBB\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC5"],
        ["\xE5\x85\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC6"],
        ["\xE6\xA3\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC7"],
        ["\xE7\xB6\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC8"],
        ["\xE7\xB7\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC9"],
        ["\xE9\x9D\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xCA"],
        ["\xE9\xBA\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xCB"],
        ["\xE6\x91\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xCC"],
        ["\xE6\xA8\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xCD"],
        ["\xE8\x8C\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xCE"],
        ["\xE5\xA6\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xCF"],
        ["\xE5\xAD\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD0"],
        ["\xE6\xAF\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD1"],
        ["\xE7\x8C\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD2"],
        ["\xE7\x9B\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD3"],
        ["\xE7\xB6\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD4"],
        ["\xE8\x80\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD5"],
        ["\xE8\x92\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD6"],
        ["\xE5\x84\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD7"],
        ["\xE6\x9C\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD8"],
        ["\xE9\xBB\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD9"],
        ["\xE7\x9B\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xDA"],
        ["\xE6\x9D\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xDB"],
        ["\xE5\x8B\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xDC"],
        ["\xE9\xA4\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xDD"],
        ["\xE5\xB0\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xDE"],
        ["\xE6\x88\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xDF"],
        ["\xE7\xB1\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE0"],
        ["\xE8\xB2\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE1"],
        ["\xE5\x95\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE2"],
        ["\xE6\x82\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE3"],
        ["\xE7\xB4\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE4"],
        ["\xE9\x96\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE5"],
        ["\xE5\x8C\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE6"],
        ["\xE4\xB9\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE7"],
        ["\xE5\x86\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE8"],
        ["\xE5\xA4\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE9"],
        ["\xE7\x88\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xEA"],
        ["\xE8\x80\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xEB"],
        ["\xE9\x87\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xEC"],
        ["\xE5\xBC\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xED"],
        ["\xE7\x9F\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xEE"],
        ["\xE5\x8E\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xEF"],
        ["\xE5\xBD\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF0"],
        ["\xE7\xB4\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF1"],
        ["\xE8\x96\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF2"],
        ["\xE8\xA8\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF3"],
        ["\xE8\xBA\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF4"],
        ["\xE9\x9D\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF5"],
        ["\xE6\x9F\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF6"],
        ["\xE8\x96\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF7"],
        ["\xE9\x91\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF8"],
        ["\xE6\x84\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF9"],
        ["\xE6\x84\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xFA"],
        ["\xE6\xB2\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xFB"],
        ["\xE7\x99\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xFC"],
        ["\xE8\xAB\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x40"],
        ["\xE8\xBC\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x41"],
        ["\xE5\x94\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x42"],
        ["\xE4\xBD\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x43"],
        ["\xE5\x84\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x44"],
        ["\xE5\x8B\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x45"],
        ["\xE5\x8F\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x46"],
        ["\xE5\xAE\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x47"],
        ["\xE5\xB9\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x48"],
        ["\xE6\x82\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x49"],
        ["\xE6\x86\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x4A"],
        ["\xE6\x8F\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x4B"],
        ["\xE6\x9C\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x4C"],
        ["\xE6\x9F\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x4D"],
        ["\xE6\xB9\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x4E"],
        ["\xE6\xB6\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x4F"],
        ["\xE7\x8C\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x50"],
        ["\xE7\x8C\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x51"],
        ["\xE7\x94\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x52"],
        ["\xE7\xA5\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x53"],
        ["\xE8\xA3\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x54"],
        ["\xE8\xAA\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x55"],
        ["\xE9\x81\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x56"],
        ["\xE9\x82\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x57"],
        ["\xE9\x83\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x58"],
        ["\xE9\x9B\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x59"],
        ["\xE8\x9E\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x5A"],
        ["\xE5\xA4\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x5B"],
        ["\xE4\xBA\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x5C"],
        ["\xE4\xBD\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x5D"],
        ["\xE4\xB8\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x5E"],
        ["\xE8\xAA\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x5F"],
        ["\xE8\xBC\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x60"],
        ["\xE9\xA0\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x61"],
        ["\xE5\x82\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x62"],
        ["\xE5\xB9\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x63"],
        ["\xE5\xA6\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x64"],
        ["\xE5\xAE\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x65"],
        ["\xE5\xBA\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x66"],
        ["\xE6\x8F\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x67"],
        ["\xE6\x8F\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x68"],
        ["\xE6\x93\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x69"],
        ["\xE6\x9B\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x6A"],
        ["\xE6\xA5\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x6B"],
        ["\xE6\xA7\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x6C"],
        ["\xE6\xB4\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x6D"],
        ["\xE6\xBA\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x6E"],
        ["\xE7\x86\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x6F"],
        ["\xE7\x94\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x70"],
        ["\xE7\xAA\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x71"],
        ["\xE7\xBE\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x72"],
        ["\xE8\x80\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x73"],
        ["\xE8\x91\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x74"],
        ["\xE8\x93\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x75"],
        ["\xE8\xA6\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x76"],
        ["\xE8\xAC\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x77"],
        ["\xE8\xB8\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x78"],
        ["\xE9\x81\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x79"],
        ["\xE9\x99\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x7A"],
        ["\xE9\xA4\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x7B"],
        ["\xE6\x85\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x7C"],
        ["\xE6\x8A\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x7D"],
        ["\xE6\xAC\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x7E"],
        ["\xE6\xB2\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x80"],
        ["\xE6\xB5\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x81"],
        ["\xE7\xBF\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x82"],
        ["\xE7\xBF\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x83"],
        ["\xE6\xB7\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x84"],
        ["\xE7\xBE\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x85"],
        ["\xE8\x9E\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x86"],
        ["\xE8\xA3\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x87"],
        ["\xE6\x9D\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x88"],
        ["\xE8\x8E\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x89"],
        ["\xE9\xA0\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x8A"],
        ["\xE9\x9B\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x8B"],
        ["\xE6\xB4\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x8C"],
        ["\xE7\xB5\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x8D"],
        ["\xE8\x90\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x8E"],
        ["\xE9\x85\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x8F"],
        ["\xE4\xB9\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x90"],
        ["\xE5\x8D\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x91"],
        ["\xE5\xB5\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x92"],
        ["\xE6\xAC\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x93"],
        ["\xE6\xBF\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x94"],
        ["\xE8\x97\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x95"],
        ["\xE8\x98\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x96"],
        ["\xE8\xA6\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x97"],
        ["\xE5\x88\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x98"],
        ["\xE5\x90\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x99"],
        ["\xE5\xB1\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x9A"],
        ["\xE6\x9D\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x9B"],
        ["\xE6\xA2\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x9C"],
        ["\xE7\x90\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x9D"],
        ["\xE7\x92\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x9E"],
        ["\xE7\x97\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x9F"],
        ["\xE8\xA3\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA0"],
        ["\xE8\xA3\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA1"],
        ["\xE9\x87\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA2"],
        ["\xE9\x9B\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA3"],
        ["\xE9\x99\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA4"],
        ["\xE5\xBE\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA5"],
        ["\xE7\x8E\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA6"],
        ["\xE7\xAB\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA7"],
        ["\xE8\x91\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA8"],
        ["\xE6\x8E\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA9"],
        ["\xE7\x95\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xAA"],
        ["\xE5\x8A\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xAB"],
        ["\xE6\xB5\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xAC"],
        ["\xE6\xBA\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xAD"],
        ["\xE7\x90\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xAE"],
        ["\xE7\x95\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xAF"],
        ["\xE7\xA1\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB0"],
        ["\xE7\xB2\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB1"],
        ["\xE9\x9A\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB2"],
        ["\xE7\xAB\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB3"],
        ["\xE9\xBE\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB4"],
        ["\xE4\xBE\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB5"],
        ["\xE6\x85\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB6"],
        ["\xE6\x97\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB7"],
        ["\xE8\x99\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB8"],
        ["\xE4\xBA\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB9"],
        ["\xE4\xBA\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xBA"],
        ["\xE5\x83\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xBB"],
        ["\xE4\xB8\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xBC"],
        ["\xE5\x87\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xBD"],
        ["\xE5\xAF\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xBE"],
        ["\xE6\x96\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xBF"],
        ["\xE6\xA2\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC0"],
        ["\xE6\xB6\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC1"],
        ["\xE7\x8C\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC2"],
        ["\xE7\x99\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC3"],
        ["\xE7\x9E\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC4"],
        ["\xE7\xA8\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC5"],
        ["\xE7\xB3\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC6"],
        ["\xE8\x89\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC7"],
        ["\xE8\xAB\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC8"],
        ["\xE9\x81\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC9"],
        ["\xE9\x87\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xCA"],
        ["\xE9\x99\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xCB"],
        ["\xE9\xA0\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xCC"],
        ["\xE5\x8A\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xCD"],
        ["\xE7\xB7\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xCE"],
        ["\xE5\x80\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xCF"],
        ["\xE5\x8E\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD0"],
        ["\xE6\x9E\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD1"],
        ["\xE6\xB7\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD2"],
        ["\xE7\x87\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD3"],
        ["\xE7\x90\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD4"],
        ["\xE8\x87\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD5"],
        ["\xE8\xBC\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD6"],
        ["\xE9\x9A\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD7"],
        ["\xE9\xB1\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD8"],
        ["\xE9\xBA\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD9"],
        ["\xE7\x91\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xDA"],
        ["\xE5\xA1\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xDB"],
        ["\xE6\xB6\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xDC"],
        ["\xE7\xB4\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xDD"],
        ["\xE9\xA1\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xDE"],
        ["\xE4\xBB\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xDF"],
        ["\xE4\xBC\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE0"],
        ["\xE4\xBE\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE1"],
        ["\xE5\x86\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE2"],
        ["\xE5\x8A\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE3"],
        ["\xE5\xB6\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE4"],
        ["\xE6\x80\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE5"],
        ["\xE7\x8E\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE6"],
        ["\xE7\xA4\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE7"],
        ["\xE8\x8B\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE8"],
        ["\xE9\x88\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE9"],
        ["\xE9\x9A\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xEA"],
        ["\xE9\x9B\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xEB"],
        ["\xE9\x9C\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xEC"],
        ["\xE9\xBA\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xED"],
        ["\xE9\xBD\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xEE"],
        ["\xE6\x9A\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xEF"],
        ["\xE6\xAD\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF0"],
        ["\xE5\x88\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF1"],
        ["\xE5\x8A\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF2"],
        ["\xE7\x83\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF3"],
        ["\xE8\xA3\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF4"],
        ["\xE5\xBB\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF5"],
        ["\xE6\x81\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF6"],
        ["\xE6\x86\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF7"],
        ["\xE6\xBC\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF8"],
        ["\xE7\x85\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF9"],
        ["\xE7\xB0\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xFA"],
        ["\xE7\xB7\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xFB"],
        ["\xE8\x81\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xFC"],
        ["\xE8\x93\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x40"],
        ["\xE9\x80\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x41"],
        ["\xE9\x8C\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x42"],
        ["\xE5\x91\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x43"],
        ["\xE9\xAD\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x44"],
        ["\xE6\xAB\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x45"],
        ["\xE7\x82\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x46"],
        ["\xE8\xB3\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x47"],
        ["\xE8\xB7\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x48"],
        ["\xE9\x9C\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x49"],
        ["\xE5\x8A\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x4A"],
        ["\xE5\xA9\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x4B"],
        ["\xE5\xBB\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x4C"],
        ["\xE5\xBC\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x4D"],
        ["\xE6\x9C\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x4E"],
        ["\xE6\xA5\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x4F"],
        ["\xE6\xA6\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x50"],
        ["\xE6\xB5\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x51"],
        ["\xE6\xBC\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x52"],
        ["\xE7\x89\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x53"],
        ["\xE7\x8B\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x54"],
        ["\xE7\xAF\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x55"],
        ["\xE8\x80\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x56"],
        ["\xE8\x81\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x57"],
        ["\xE8\x9D\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x58"],
        ["\xE9\x83\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x59"],
        ["\xE5\x85\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x5A"],
        ["\xE9\xBA\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x5B"],
        ["\xE7\xA6\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x5C"],
        ["\xE8\x82\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x5D"],
        ["\xE9\x8C\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x5E"],
        ["\xE8\xAB\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x5F"],
        ["\xE5\x80\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x60"],
        ["\xE5\x92\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x61"],
        ["\xE8\xA9\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x62"],
        ["\xE6\xAD\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x63"],
        ["\xE8\xB3\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x64"],
        ["\xE8\x84\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x65"],
        ["\xE6\x83\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x66"],
        ["\xE6\x9E\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x67"],
        ["\xE9\xB7\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x68"],
        ["\xE4\xBA\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x69"],
        ["\xE4\xBA\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x6A"],
        ["\xE9\xB0\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x6B"],
        ["\xE8\xA9\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x6C"],
        ["\xE8\x97\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x6D"],
        ["\xE8\x95\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x6E"],
        ["\xE6\xA4\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x6F"],
        ["\xE6\xB9\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x70"],
        ["\xE7\xA2\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x71"],
        ["\xE8\x85\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x72"],
        ["\xE5\xBC\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x9F"],
        ["\xE4\xB8\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA0"],
        ["\xE4\xB8\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA1"],
        ["\xE4\xB8\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA2"],
        ["\xE4\xB8\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA3"],
        ["\xE4\xB8\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA4"],
        ["\xE4\xB8\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA5"],
        ["\xE4\xB8\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA6"],
        ["\xE4\xB9\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA7"],
        ["\xE4\xB9\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA8"],
        ["\xE4\xB9\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA9"],
        ["\xE4\xBA\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xAA"],
        ["\xE4\xBA\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xAB"],
        ["\xE8\xB1\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xAC"],
        ["\xE4\xBA\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xAD"],
        ["\xE8\x88\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xAE"],
        ["\xE5\xBC\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xAF"],
        ["\xE4\xBA\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB0"],
        ["\xE4\xBA\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB1"],
        ["\xE4\xBA\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB2"],
        ["\xE4\xBA\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB3"],
        ["\xE4\xBA\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB4"],
        ["\xE4\xBA\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB5"],
        ["\xE4\xBA\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB6"],
        ["\xE4\xBA\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB7"],
        ["\xE4\xBB\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB8"],
        ["\xE4\xBB\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB9"],
        ["\xE4\xBB\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xBA"],
        ["\xE4\xBB\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xBB"],
        ["\xE4\xBB\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xBC"],
        ["\xE4\xBB\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xBD"],
        ["\xE4\xBB\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xBE"],
        ["\xE4\xBB\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xBF"],
        ["\xE4\xBB\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC0"],
        ["\xE4\xBB\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC1"],
        ["\xE4\xBC\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC2"],
        ["\xE4\xBD\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC3"],
        ["\xE4\xBC\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC4"],
        ["\xE4\xBD\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC5"],
        ["\xE4\xBD\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC6"],
        ["\xE4\xBD\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC7"],
        ["\xE4\xBD\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC8"],
        ["\xE4\xBD\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC9"],
        ["\xE4\xBE\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xCA"],
        ["\xE4\xBE\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xCB"],
        ["\xE4\xBE\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xCC"],
        ["\xE4\xBD\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xCD"],
        ["\xE4\xBD\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xCE"],
        ["\xE4\xBD\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xCF"],
        ["\xE4\xBE\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD0"],
        ["\xE4\xBD\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD1"],
        ["\xE4\xBE\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD2"],
        ["\xE4\xBE\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD3"],
        ["\xE5\x84\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD4"],
        ["\xE4\xBF\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD5"],
        ["\xE4\xBF\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD6"],
        ["\xE4\xBF\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD7"],
        ["\xE4\xBF\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD8"],
        ["\xE4\xBF\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD9"],
        ["\xE4\xBF\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xDA"],
        ["\xE4\xBF\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xDB"],
        ["\xE4\xBF\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xDC"],
        ["\xE4\xBF\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xDD"],
        ["\xE4\xBF\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xDE"],
        ["\xE5\x80\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xDF"],
        ["\xE5\x80\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE0"],
        ["\xE5\x80\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE1"],
        ["\xE5\x80\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE2"],
        ["\xE5\x80\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE3"],
        ["\xE5\x80\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE4"],
        ["\xE4\xBC\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE5"],
        ["\xE4\xBF\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE6"],
        ["\xE5\x80\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE7"],
        ["\xE5\x80\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE8"],
        ["\xE5\x80\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE9"],
        ["\xE4\xBF\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xEA"],
        ["\xE4\xBF\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xEB"],
        ["\xE5\x80\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xEC"],
        ["\xE5\x80\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xED"],
        ["\xE5\x81\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xEE"],
        ["\xE5\x81\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xEF"],
        ["\xE6\x9C\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF0"],
        ["\xE5\x81\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF1"],
        ["\xE5\x81\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF2"],
        ["\xE5\x81\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF3"],
        ["\xE5\x81\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF4"],
        ["\xE5\x81\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF5"],
        ["\xE5\x81\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF6"],
        ["\xE5\x81\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF7"],
        ["\xE5\x82\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF8"],
        ["\xE5\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF9"],
        ["\xE5\x82\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xFA"],
        ["\xE5\x82\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xFB"],
        ["\xE5\x82\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xFC"],
        ["\xE5\x83\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x40"],
        ["\xE5\x83\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x41"],
        ["\xE5\x82\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x42"],
        ["\xE5\x83\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x43"],
        ["\xE5\x83\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x44"],
        ["\xE5\x83\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x45"],
        ["\xE5\x83\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x46"],
        ["\xE5\x83\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x47"],
        ["\xE5\x83\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x48"],
        ["\xE5\x83\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x49"],
        ["\xE5\x83\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x4A"],
        ["\xE5\x83\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x4B"],
        ["\xE5\x84\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x4C"],
        ["\xE5\x84\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x4D"],
        ["\xE5\x84\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x4E"],
        ["\xE5\x84\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x4F"],
        ["\xE5\x84\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x50"],
        ["\xE5\x84\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x51"],
        ["\xE5\x84\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x52"],
        ["\xE5\x84\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x53"],
        ["\xE5\x84\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x54"],
        ["\xE5\x84\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x55"],
        ["\xE5\x84\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x56"],
        ["\xE5\x84\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x57"],
        ["\xE5\x84\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x58"],
        ["\xE5\x85\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x59"],
        ["\xE5\x85\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x5A"],
        ["\xE5\x85\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x5B"],
        ["\xE5\x85\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x5C"],
        ["\xE5\x85\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x5D"],
        ["\xE7\xAB\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x5E"],
        ["\xE5\x85\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x5F"],
        ["\xE5\x85\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x60"],
        ["\xE5\x85\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x61"],
        ["\xE5\x86\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x62"],
        ["\xE5\x86\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x63"],
        ["\xE5\x9B\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x64"],
        ["\xE5\x86\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x65"],
        ["\xE5\x86\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x66"],
        ["\xE5\x86\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x67"],
        ["\xE5\x86\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x68"],
        ["\xE5\x86\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x69"],
        ["\xE5\x86\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x6A"],
        ["\xE5\x86\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x6B"],
        ["\xE5\x86\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x6C"],
        ["\xE5\x86\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x6D"],
        ["\xE5\x86\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x6E"],
        ["\xE5\x86\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x6F"],
        ["\xE5\x86\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x70"],
        ["\xE5\x86\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x71"],
        ["\xE5\x86\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x72"],
        ["\xE5\x86\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x73"],
        ["\xE5\x86\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x74"],
        ["\xE5\x86\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x75"],
        ["\xE5\x86\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x76"],
        ["\xE5\x86\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x77"],
        ["\xE5\x87\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x78"],
        ["\xE5\x87\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x79"],
        ["\xE5\x87\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x7A"],
        ["\xE5\x87\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x7B"],
        ["\xE8\x99\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x7C"],
        ["\xE5\x87\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x7D"],
        ["\xE5\x87\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x7E"],
        ["\xE5\x87\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x80"],
        ["\xE5\x87\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x81"],
        ["\xE5\x87\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x82"],
        ["\xE5\x88\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x83"],
        ["\xE5\x88\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x84"],
        ["\xE5\x88\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x85"],
        ["\xE5\x88\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x86"],
        ["\xE5\x88\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x87"],
        ["\xE5\x88\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x88"],
        ["\xE5\x88\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x89"],
        ["\xE5\x88\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x8A"],
        ["\xE5\x88\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x8B"],
        ["\xE5\x89\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x8C"],
        ["\xE5\x89\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x8D"],
        ["\xE5\x89\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x8E"],
        ["\xE5\x89\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x8F"],
        ["\xE5\x89\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x90"],
        ["\xE5\x89\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x91"],
        ["\xE5\x89\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x92"],
        ["\xE5\x89\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x93"],
        ["\xE5\x89\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x94"],
        ["\xE5\x89\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x95"],
        ["\xE5\x89\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x96"],
        ["\xE5\x89\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x97"],
        ["\xE5\x8A\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x98"],
        ["\xE5\x8A\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x99"],
        ["\xE5\x8A\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x9A"],
        ["\xE5\x89\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x9B"],
        ["\xE5\x8A\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x9C"],
        ["\xE5\x8A\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x9D"],
        ["\xE8\xBE\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x9E"],
        ["\xE8\xBE\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x9F"],
        ["\xE5\x8A\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA0"],
        ["\xE5\x8A\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA1"],
        ["\xE5\x8A\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA2"],
        ["\xE5\x8A\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA3"],
        ["\xE5\x8B\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA4"],
        ["\xE5\x8B\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA5"],
        ["\xE5\x8B\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA6"],
        ["\xE5\x8B\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA7"],
        ["\xE5\x8B\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA8"],
        ["\xE5\x8B\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA9"],
        ["\xE9\xA3\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xAA"],
        ["\xE5\x8B\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xAB"],
        ["\xE5\x8B\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xAC"],
        ["\xE5\x8B\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xAD"],
        ["\xE5\x8B\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xAE"],
        ["\xE5\x8B\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xAF"],
        ["\xE5\x8C\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB0"],
        ["\xE5\x8C\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB1"],
        ["\xE7\x94\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB2"],
        ["\xE5\x8C\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB3"],
        ["\xE5\x8C\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB4"],
        ["\xE5\x8C\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB5"],
        ["\xE5\x8C\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB6"],
        ["\xE5\x8C\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB7"],
        ["\xE5\x8C\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB8"],
        ["\xE5\x8C\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB9"],
        ["\xE5\x8C\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xBA"],
        ["\xE5\x8C\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xBB"],
        ["\xE5\x8C\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xBC"],
        ["\xE5\x8D\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xBD"],
        ["\xE5\x8D\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xBE"],
        ["\xE5\x8D\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xBF"],
        ["\xE4\xB8\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC0"],
        ["\xE5\x8D\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC1"],
        ["\xE5\x8D\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC2"],
        ["\xE5\x87\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC3"],
        ["\xE5\x8D\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC4"],
        ["\xE5\x8D\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC5"],
        ["\xE5\x8D\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC6"],
        ["\xE5\xA4\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC7"],
        ["\xE5\x8D\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC8"],
        ["\xE5\x8D\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC9"],
        ["\xE5\x8E\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xCA"],
        ["\xE5\x8E\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xCB"],
        ["\xE5\x8E\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xCC"],
        ["\xE5\x8E\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xCD"],
        ["\xE5\x8E\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xCE"],
        ["\xE5\x8E\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xCF"],
        ["\xE5\x8E\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD0"],
        ["\xE5\x8E\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD1"],
        ["\xE5\x8F\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD2"],
        ["\xE7\xB0\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD3"],
        ["\xE9\x9B\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD4"],
        ["\xE5\x8F\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD5"],
        ["\xE6\x9B\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD6"],
        ["\xE7\x87\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD7"],
        ["\xE5\x8F\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD8"],
        ["\xE5\x8F\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD9"],
        ["\xE5\x8F\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xDA"],
        ["\xE5\x8F\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xDB"],
        ["\xE5\x90\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xDC"],
        ["\xE5\x90\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xDD"],
        ["\xE5\x91\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xDE"],
        ["\xE5\x90\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xDF"],
        ["\xE5\x90\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE0"],
        ["\xE5\x90\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE1"],
        ["\xE5\x90\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE2"],
        ["\xE5\x90\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE3"],
        ["\xE5\x90\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE4"],
        ["\xE5\x90\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE5"],
        ["\xE5\x91\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE6"],
        ["\xE5\x92\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE7"],
        ["\xE5\x91\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE8"],
        ["\xE5\x92\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE9"],
        ["\xE5\x91\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xEA"],
        ["\xE5\x91\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xEB"],
        ["\xE5\x91\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xEC"],
        ["\xE5\x91\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xED"],
        ["\xE5\x92\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xEE"],
        ["\xE5\x91\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xEF"],
        ["\xE5\x92\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF0"],
        ["\xE5\x91\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF1"],
        ["\xE5\x92\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF2"],
        ["\xE5\x92\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF3"],
        ["\xE5\x92\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF4"],
        ["\xE5\x93\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF5"],
        ["\xE5\x92\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF6"],
        ["\xE5\x92\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF7"],
        ["\xE5\x92\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF8"],
        ["\xE5\x92\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF9"],
        ["\xE5\x93\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xFA"],
        ["\xE5\x93\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xFB"],
        ["\xE5\x92\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xFC"],
        ["\xE5\x92\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x40"],
        ["\xE5\x93\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x41"],
        ["\xE5\x92\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x42"],
        ["\xE5\x92\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x43"],
        ["\xE5\x92\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x44"],
        ["\xE5\x93\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x45"],
        ["\xE5\x93\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x46"],
        ["\xE5\x93\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x47"],
        ["\xE5\x94\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x48"],
        ["\xE5\x94\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x49"],
        ["\xE5\x93\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x4A"],
        ["\xE5\x93\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x4B"],
        ["\xE5\x93\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x4C"],
        ["\xE5\x93\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x4D"],
        ["\xE5\x93\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x4E"],
        ["\xE5\x94\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x4F"],
        ["\xE5\x95\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x50"],
        ["\xE5\x95\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x51"],
        ["\xE5\x95\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x52"],
        ["\xE5\x94\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x53"],
        ["\xE5\x95\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x54"],
        ["\xE5\x95\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x55"],
        ["\xE5\x95\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x56"],
        ["\xE5\x95\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x57"],
        ["\xE5\x94\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x58"],
        ["\xE5\x94\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x59"],
        ["\xE5\x95\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x5A"],
        ["\xE5\x96\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x5B"],
        ["\xE5\x96\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x5C"],
        ["\xE5\x92\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x5D"],
        ["\xE5\x96\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x5E"],
        ["\xE5\x96\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x5F"],
        ["\xE5\x95\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x60"],
        ["\xE5\x95\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x61"],
        ["\xE5\x96\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x62"],
        ["\xE5\x96\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x63"],
        ["\xE5\x96\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x64"],
        ["\xE5\x95\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x65"],
        ["\xE5\x96\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x66"],
        ["\xE5\x96\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x67"],
        ["\xE5\x96\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x68"],
        ["\xE5\x96\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x69"],
        ["\xE5\x97\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x6A"],
        ["\xE5\x97\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x6B"],
        ["\xE5\x97\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x6C"],
        ["\xE5\x97\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x6D"],
        ["\xE5\x97\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x6E"],
        ["\xE5\x97\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x6F"],
        ["\xE5\x97\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x70"],
        ["\xE5\x98\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x71"],
        ["\xE5\x97\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x72"],
        ["\xE5\x98\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x73"],
        ["\xE5\x97\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x74"],
        ["\xE5\x97\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x75"],
        ["\xE5\x98\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x76"],
        ["\xE5\x97\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x77"],
        ["\xE5\x99\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x78"],
        ["\xE5\x99\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x79"],
        ["\xE7\x87\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x7A"],
        ["\xE5\x98\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x7B"],
        ["\xE5\x98\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x7C"],
        ["\xE5\x98\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x7D"],
        ["\xE5\x98\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x7E"],
        ["\xE5\x99\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x80"],
        ["\xE5\x99\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x81"],
        ["\xE5\x98\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x82"],
        ["\xE5\x99\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x83"],
        ["\xE5\x99\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x84"],
        ["\xE5\x9A\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x85"],
        ["\xE5\x9A\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x86"],
        ["\xE5\x9A\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x87"],
        ["\xE5\x9A\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x88"],
        ["\xE5\x9A\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x89"],
        ["\xE5\x9A\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x8A"],
        ["\xE5\x9A\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x8B"],
        ["\xE5\x9A\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x8C"],
        ["\xE5\x9A\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x8D"],
        ["\xE5\x9A\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x8E"],
        ["\xE5\x9B\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x8F"],
        ["\xE5\x9A\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x90"],
        ["\xE5\x9B\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x91"],
        ["\xE5\x9B\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x92"],
        ["\xE5\x9B\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x93"],
        ["\xE5\x9B\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x94"],
        ["\xE5\x9B\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x95"],
        ["\xE5\x9B\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x96"],
        ["\xE5\x9B\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x97"],
        ["\xE5\x9B\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x98"],
        ["\xE5\x9B\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x99"],
        ["\xE5\x9B\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x9A"],
        ["\xE5\x9C\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x9B"],
        ["\xE5\x9B\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x9C"],
        ["\xE5\x9C\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x9D"],
        ["\xE5\x9C\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x9E"],
        ["\xE5\x9C\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x9F"],
        ["\xE5\x9C\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA0"],
        ["\xE5\x9C\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA1"],
        ["\xE5\x9C\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA2"],
        ["\xE5\x9C\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA3"],
        ["\xE5\x9C\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA4"],
        ["\xE5\x97\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA5"],
        ["\xE5\x9C\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA6"],
        ["\xE5\x9C\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA7"],
        ["\xE5\x9C\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA8"],
        ["\xE5\x9C\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA9"],
        ["\xE5\x9D\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xAA"],
        ["\xE5\x9C\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xAB"],
        ["\xE5\x9D\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xAC"],
        ["\xE5\x9D\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xAD"],
        ["\xE5\x9D\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xAE"],
        ["\xE5\x9F\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xAF"],
        ["\xE5\x9E\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB0"],
        ["\xE5\x9D\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB1"],
        ["\xE5\x9D\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB2"],
        ["\xE5\x9E\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB3"],
        ["\xE5\x9E\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB4"],
        ["\xE5\x9E\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB5"],
        ["\xE5\x9E\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB6"],
        ["\xE5\x9E\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB7"],
        ["\xE5\x9E\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB8"],
        ["\xE5\x9E\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB9"],
        ["\xE5\x9F\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xBA"],
        ["\xE5\x9F\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xBB"],
        ["\xE5\x9F\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xBC"],
        ["\xE5\x9F\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xBD"],
        ["\xE5\x9F\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xBE"],
        ["\xE5\xA0\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xBF"],
        ["\xE5\x9F\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC0"],
        ["\xE5\x9F\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC1"],
        ["\xE5\xA0\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC2"],
        ["\xE5\xA0\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC3"],
        ["\xE5\xA0\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC4"],
        ["\xE5\xA1\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC5"],
        ["\xE5\xA0\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC6"],
        ["\xE5\xA1\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC7"],
        ["\xE5\xA1\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC8"],
        ["\xE5\xA1\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC9"],
        ["\xE6\xAF\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xCA"],
        ["\xE5\xA1\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xCB"],
        ["\xE5\xA0\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xCC"],
        ["\xE5\xA1\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xCD"],
        ["\xE5\xA2\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xCE"],
        ["\xE5\xA2\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xCF"],
        ["\xE5\xA2\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD0"],
        ["\xE5\xA2\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD1"],
        ["\xE5\xA2\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD2"],
        ["\xE5\xA3\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD3"],
        ["\xE5\xA2\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD4"],
        ["\xE5\xA2\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD5"],
        ["\xE5\xA2\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD6"],
        ["\xE5\xA3\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD7"],
        ["\xE5\xA3\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD8"],
        ["\xE5\xA3\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD9"],
        ["\xE5\xA3\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xDA"],
        ["\xE5\xA3\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xDB"],
        ["\xE5\xA3\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xDC"],
        ["\xE5\xA3\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xDD"],
        ["\xE5\xA3\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xDE"],
        ["\xE5\xA3\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xDF"],
        ["\xE5\xA3\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE0"],
        ["\xE5\xA3\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE1"],
        ["\xE5\xA3\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE2"],
        ["\xE5\xA3\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE3"],
        ["\xE5\xA3\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE4"],
        ["\xE5\xA3\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE5"],
        ["\xE5\xA3\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE6"],
        ["\xE5\xA4\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE7"],
        ["\xE5\xA4\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE8"],
        ["\xE5\xA4\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE9"],
        ["\xE5\xA4\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xEA"],
        ["\xE6\xA2\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xEB"],
        ["\xE5\xA4\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xEC"],
        ["\xE5\xA4\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xED"],
        ["\xE5\xA4\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xEE"],
        ["\xE5\xA4\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xEF"],
        ["\xE5\xA4\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF0"],
        ["\xE5\xA4\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF1"],
        ["\xE7\xAB\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF2"],
        ["\xE5\xA5\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF3"],
        ["\xE5\xA5\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF4"],
        ["\xE5\xA5\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF5"],
        ["\xE5\xA5\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF6"],
        ["\xE5\xA5\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF7"],
        ["\xE5\xA5\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF8"],
        ["\xE5\xA5\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF9"],
        ["\xE5\xA5\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xFA"],
        ["\xE5\xA5\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xFB"],
        ["\xE5\xA5\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xFC"],
        ["\xE5\xA5\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x40"],
        ["\xE5\xA6\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x41"],
        ["\xE5\xA6\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x42"],
        ["\xE4\xBD\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x43"],
        ["\xE4\xBE\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x44"],
        ["\xE5\xA6\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x45"],
        ["\xE5\xA6\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x46"],
        ["\xE5\xA7\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x47"],
        ["\xE5\xA7\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x48"],
        ["\xE5\xA7\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x49"],
        ["\xE5\xA6\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x4A"],
        ["\xE5\xA7\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x4B"],
        ["\xE5\xA7\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x4C"],
        ["\xE5\xA8\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x4D"],
        ["\xE5\xA8\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x4E"],
        ["\xE5\xA8\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x4F"],
        ["\xE5\xA8\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x50"],
        ["\xE5\xA8\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x51"],
        ["\xE5\xA8\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x52"],
        ["\xE5\xA9\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x53"],
        ["\xE5\xA9\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x54"],
        ["\xE5\xA9\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x55"],
        ["\xE5\xA8\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x56"],
        ["\xE5\xA8\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x57"],
        ["\xE5\xA9\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x58"],
        ["\xE5\xA9\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x59"],
        ["\xE5\xAA\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x5A"],
        ["\xE5\xAA\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x5B"],
        ["\xE5\xAA\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x5C"],
        ["\xE5\xAB\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x5D"],
        ["\xE5\xAB\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x5E"],
        ["\xE5\xAA\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x5F"],
        ["\xE5\xAB\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x60"],
        ["\xE5\xAB\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x61"],
        ["\xE5\xAB\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x62"],
        ["\xE5\xAB\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x63"],
        ["\xE5\xAB\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x64"],
        ["\xE5\xAB\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x65"],
        ["\xE5\xAB\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x66"],
        ["\xE5\xAC\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x67"],
        ["\xE5\xAC\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x68"],
        ["\xE5\xAC\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x69"],
        ["\xE5\xAC\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x6A"],
        ["\xE5\xAB\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x6B"],
        ["\xE5\xAC\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x6C"],
        ["\xE5\xAC\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x6D"],
        ["\xE5\xAC\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x6E"],
        ["\xE5\xAD\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x6F"],
        ["\xE5\xAD\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x70"],
        ["\xE5\xAD\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x71"],
        ["\xE5\xAD\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x72"],
        ["\xE5\xAD\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x73"],
        ["\xE5\xAD\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x74"],
        ["\xE5\xAD\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x75"],
        ["\xE5\xAD\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x76"],
        ["\xE5\xAD\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x77"],
        ["\xE5\xAD\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x78"],
        ["\xE5\xAD\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x79"],
        ["\xE5\xAD\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x7A"],
        ["\xE5\xAD\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x7B"],
        ["\xE6\x96\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x7C"],
        ["\xE5\xAD\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x7D"],
        ["\xE5\xAE\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x7E"],
        ["\xE5\xAE\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x80"],
        ["\xE5\xAE\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x81"],
        ["\xE5\xAE\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x82"],
        ["\xE5\xAF\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x83"],
        ["\xE5\xAF\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x84"],
        ["\xE5\xAF\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x85"],
        ["\xE5\xAF\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x86"],
        ["\xE5\xAF\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x87"],
        ["\xE5\xAF\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x88"],
        ["\xE5\xAF\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x89"],
        ["\xE5\xAF\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x8A"],
        ["\xE5\xAF\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x8B"],
        ["\xE5\xAF\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x8C"],
        ["\xE5\xAF\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x8D"],
        ["\xE5\xAF\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x8E"],
        ["\xE5\xAF\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x8F"],
        ["\xE5\xAF\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x90"],
        ["\xE5\xB0\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x91"],
        ["\xE5\xB0\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x92"],
        ["\xE5\xB0\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x93"],
        ["\xE5\xB0\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x94"],
        ["\xE5\xB0\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x95"],
        ["\xE5\xB0\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x96"],
        ["\xE5\xB0\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x97"],
        ["\xE5\xB0\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x98"],
        ["\xE5\xB0\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x99"],
        ["\xE5\xB0\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x9A"],
        ["\xE5\xB1\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x9B"],
        ["\xE5\xB1\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x9C"],
        ["\xE5\xB1\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x9D"],
        ["\xE5\xB1\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x9E"],
        ["\xE5\xB1\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x9F"],
        ["\xE5\xB1\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA0"],
        ["\xE5\xAD\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA1"],
        ["\xE5\xB1\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA2"],
        ["\xE5\xB1\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA3"],
        ["\xE4\xB9\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA4"],
        ["\xE5\xB1\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA5"],
        ["\xE5\xB1\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA6"],
        ["\xE5\xB2\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA7"],
        ["\xE5\xB2\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA8"],
        ["\xE5\xB2\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA9"],
        ["\xE5\xA6\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xAA"],
        ["\xE5\xB2\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xAB"],
        ["\xE5\xB2\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xAC"],
        ["\xE5\xB2\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xAD"],
        ["\xE5\xB2\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xAE"],
        ["\xE5\xB2\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xAF"],
        ["\xE5\xB3\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB0"],
        ["\xE5\xB2\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB1"],
        ["\xE5\xB3\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB2"],
        ["\xE5\xB3\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB3"],
        ["\xE5\xB3\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB4"],
        ["\xE5\xB3\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB5"],
        ["\xE5\xB3\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB6"],
        ["\xE5\xB3\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB7"],
        ["\xE5\xB6\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB8"],
        ["\xE5\xB3\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB9"],
        ["\xE5\xB4\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xBA"],
        ["\xE5\xB4\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xBB"],
        ["\xE5\xB4\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xBC"],
        ["\xE5\xB5\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xBD"],
        ["\xE5\xB4\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xBE"],
        ["\xE5\xB4\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xBF"],
        ["\xE5\xB4\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC0"],
        ["\xE5\xB4\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC1"],
        ["\xE5\xB4\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC2"],
        ["\xE5\xB4\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC3"],
        ["\xE5\xB4\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC4"],
        ["\xE5\xB4\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC5"],
        ["\xE5\xB5\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC6"],
        ["\xE5\xB5\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC7"],
        ["\xE5\xB5\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC8"],
        ["\xE5\xB5\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC9"],
        ["\xE5\xB5\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xCA"],
        ["\xE5\xB5\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xCB"],
        ["\xE5\xB5\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xCC"],
        ["\xE5\xB6\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xCD"],
        ["\xE5\xB6\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xCE"],
        ["\xE5\xB6\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xCF"],
        ["\xE5\xB6\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD0"],
        ["\xE5\xB6\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD1"],
        ["\xE5\xB6\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD2"],
        ["\xE5\xB6\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD3"],
        ["\xE5\xB6\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD4"],
        ["\xE5\xB6\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD5"],
        ["\xE5\xB6\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD6"],
        ["\xE5\xB6\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD7"],
        ["\xE5\xB7\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD8"],
        ["\xE5\xB7\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD9"],
        ["\xE5\xB7\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xDA"],
        ["\xE5\xB7\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xDB"],
        ["\xE5\xB7\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xDC"],
        ["\xE5\xB7\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xDD"],
        ["\xE5\xB7\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xDE"],
        ["\xE5\xB7\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xDF"],
        ["\xE5\xB7\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE0"],
        ["\xE5\xB8\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE1"],
        ["\xE5\xB8\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE2"],
        ["\xE5\xB8\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE3"],
        ["\xE5\xB8\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE4"],
        ["\xE5\xB8\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE5"],
        ["\xE5\xB8\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE6"],
        ["\xE5\xB8\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE7"],
        ["\xE5\xB9\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE8"],
        ["\xE5\xB9\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE9"],
        ["\xE5\xB9\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xEA"],
        ["\xE5\xB9\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xEB"],
        ["\xE5\xB9\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xEC"],
        ["\xE5\xB9\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xED"],
        ["\xE5\xB9\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xEE"],
        ["\xE5\xB9\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xEF"],
        ["\xE5\xB9\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF0"],
        ["\xE5\xB9\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF1"],
        ["\xE5\xB9\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF2"],
        ["\xE5\xB9\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF3"],
        ["\xE5\xB9\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF4"],
        ["\xE9\xBA\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF5"],
        ["\xE5\xB9\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF6"],
        ["\xE5\xBA\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF7"],
        ["\xE5\xBB\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF8"],
        ["\xE5\xBB\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF9"],
        ["\xE5\xBB\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xFA"],
        ["\xE5\xBB\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xFB"],
        ["\xE5\xBB\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xFC"],
        ["\xE5\xBB\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x40"],
        ["\xE5\xBB\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x41"],
        ["\xE5\xBB\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x42"],
        ["\xE5\xBB\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x43"],
        ["\xE5\xBB\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x44"],
        ["\xE5\xBB\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x45"],
        ["\xE5\xBB\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x46"],
        ["\xE5\xBB\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x47"],
        ["\xE5\xBB\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x48"],
        ["\xE5\xBB\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x49"],
        ["\xE5\xBB\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x4A"],
        ["\xE5\xBB\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x4B"],
        ["\xE5\xBB\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x4C"],
        ["\xE5\xBB\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x4D"],
        ["\xE5\xBB\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x4E"],
        ["\xE5\xBB\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x4F"],
        ["\xE5\xBC\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x50"],
        ["\xE5\xBC\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x51"],
        ["\xE5\xBD\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x52"],
        ["\xE5\xBD\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x53"],
        ["\xE5\xBC\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x54"],
        ["\xE5\xBC\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x55"],
        ["\xE5\xBC\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x56"],
        ["\xE5\xBC\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x57"],
        ["\xE5\xBC\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x58"],
        ["\xE5\xBC\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x59"],
        ["\xE5\xBD\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x5B"],
        ["\xE5\xBD\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x5C"],
        ["\xE5\xBD\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x5D"],
        ["\xE5\xBC\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x5E"],
        ["\xE5\xBD\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x5F"],
        ["\xE5\xBD\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x60"],
        ["\xE5\xBD\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x61"],
        ["\xE5\xBD\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x62"],
        ["\xE5\xBD\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x63"],
        ["\xE5\xBD\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x64"],
        ["\xE5\xBD\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x65"],
        ["\xE5\xBD\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x66"],
        ["\xE5\xBE\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x67"],
        ["\xE5\xBE\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x68"],
        ["\xE5\xBD\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x69"],
        ["\xE5\xBE\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x6A"],
        ["\xE5\xBE\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x6B"],
        ["\xE5\xBE\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x6C"],
        ["\xE5\xBE\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x6D"],
        ["\xE5\xBE\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x6E"],
        ["\xE5\xBE\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x6F"],
        ["\xE5\xBE\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x70"],
        ["\xE5\xBE\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x71"],
        ["\xE5\xBE\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x72"],
        ["\xE5\xBE\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x73"],
        ["\xE5\xBE\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x74"],
        ["\xE5\xBF\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x75"],
        ["\xE5\xBF\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x76"],
        ["\xE5\xBF\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x77"],
        ["\xE5\xBF\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x78"],
        ["\xE5\xBF\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x79"],
        ["\xE5\xBF\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x7A"],
        ["\xE6\x82\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x7B"],
        ["\xE5\xBF\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x7C"],
        ["\xE6\x80\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x7D"],
        ["\xE6\x81\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x7E"],
        ["\xE6\x80\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x80"],
        ["\xE6\x80\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x81"],
        ["\xE6\x80\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x82"],
        ["\xE6\x80\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x83"],
        ["\xE6\x80\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x84"],
        ["\xE6\x80\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x85"],
        ["\xE6\x80\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x86"],
        ["\xE6\x80\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x87"],
        ["\xE6\x80\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x88"],
        ["\xE6\x80\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x89"],
        ["\xE6\x80\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x8A"],
        ["\xE6\x81\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x8B"],
        ["\xE6\x81\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x8C"],
        ["\xE6\x81\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x8D"],
        ["\xE6\x81\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x8E"],
        ["\xE6\x81\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x8F"],
        ["\xE6\x81\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x90"],
        ["\xE6\x81\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x91"],
        ["\xE6\x81\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x92"],
        ["\xE6\x81\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x93"],
        ["\xE6\x81\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x94"],
        ["\xE6\x81\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x95"],
        ["\xE6\x81\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x96"],
        ["\xE6\x81\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x97"],
        ["\xE6\x81\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x98"],
        ["\xE6\x81\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x99"],
        ["\xE6\x82\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x9A"],
        ["\xE6\x82\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x9B"],
        ["\xE6\x83\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x9C"],
        ["\xE6\x82\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x9D"],
        ["\xE6\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x9E"],
        ["\xE6\x82\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x9F"],
        ["\xE6\x82\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA0"],
        ["\xE6\x82\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA1"],
        ["\xE6\x82\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA2"],
        ["\xE6\x82\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA3"],
        ["\xE6\x82\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA4"],
        ["\xE6\x82\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA5"],
        ["\xE6\x83\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA6"],
        ["\xE6\x82\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA7"],
        ["\xE6\x83\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA8"],
        ["\xE6\x83\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA9"],
        ["\xE6\x82\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xAA"],
        ["\xE5\xBF\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xAB"],
        ["\xE6\x82\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xAC"],
        ["\xE6\x83\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xAD"],
        ["\xE6\x82\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xAE"],
        ["\xE6\x83\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xAF"],
        ["\xE6\x85\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB0"],
        ["\xE6\x84\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB1"],
        ["\xE6\x84\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB2"],
        ["\xE6\x83\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB3"],
        ["\xE6\x83\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB4"],
        ["\xE6\x84\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB5"],
        ["\xE6\x83\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB6"],
        ["\xE6\x83\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB7"],
        ["\xE6\x84\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB8"],
        ["\xE6\x84\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB9"],
        ["\xE6\x83\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xBA"],
        ["\xE6\x83\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xBB"],
        ["\xE6\x84\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xBC"],
        ["\xE6\x84\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xBD"],
        ["\xE6\x85\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xBE"],
        ["\xE6\x84\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xBF"],
        ["\xE6\x84\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC0"],
        ["\xE6\x84\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC1"],
        ["\xE6\x85\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC2"],
        ["\xE6\x84\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC3"],
        ["\xE6\x84\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC4"],
        ["\xE6\x84\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC5"],
        ["\xE6\x84\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC6"],
        ["\xE6\x84\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC7"],
        ["\xE6\x85\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC8"],
        ["\xE6\x85\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC9"],
        ["\xE6\x85\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xCA"],
        ["\xE6\x85\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xCB"],
        ["\xE6\x85\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xCC"],
        ["\xE6\x85\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xCD"],
        ["\xE6\x85\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xCE"],
        ["\xE6\x85\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xCF"],
        ["\xE6\x85\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD0"],
        ["\xE6\x85\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD1"],
        ["\xE6\x85\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD2"],
        ["\xE6\x85\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD3"],
        ["\xE6\x85\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD4"],
        ["\xE6\x85\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD5"],
        ["\xE6\x85\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD6"],
        ["\xE6\x85\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD7"],
        ["\xE6\x86\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD8"],
        ["\xE6\x86\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD9"],
        ["\xE6\x86\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xDA"],
        ["\xE6\x86\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xDB"],
        ["\xE6\x86\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xDC"],
        ["\xE6\x86\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xDD"],
        ["\xE6\x86\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xDE"],
        ["\xE6\x86\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xDF"],
        ["\xE6\x86\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE0"],
        ["\xE6\x86\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE1"],
        ["\xE6\x87\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE2"],
        ["\xE6\x87\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE3"],
        ["\xE6\x87\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE4"],
        ["\xE6\x87\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE5"],
        ["\xE6\x87\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE6"],
        ["\xE6\x87\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE7"],
        ["\xE6\x87\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE8"],
        ["\xE6\x86\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE9"],
        ["\xE6\x87\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xEA"],
        ["\xE7\xBD\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xEB"],
        ["\xE6\x87\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xEC"],
        ["\xE6\x87\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xED"],
        ["\xE6\x87\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xEE"],
        ["\xE6\x87\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xEF"],
        ["\xE6\x87\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF0"],
        ["\xE6\x87\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF1"],
        ["\xE6\x87\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF2"],
        ["\xE6\x87\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF3"],
        ["\xE6\x87\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF4"],
        ["\xE6\x87\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF5"],
        ["\xE6\x88\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF6"],
        ["\xE6\x88\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF7"],
        ["\xE6\x88\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF8"],
        ["\xE6\x88\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF9"],
        ["\xE6\x88\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xFA"],
        ["\xE6\x88\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xFB"],
        ["\xE6\x88\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xFC"],
        ["\xE6\x88\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x40"],
        ["\xE6\x88\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x41"],
        ["\xE6\x88\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x42"],
        ["\xE6\x88\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x43"],
        ["\xE6\x88\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x44"],
        ["\xE6\x88\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x45"],
        ["\xE6\x88\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x46"],
        ["\xE6\x89\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x47"],
        ["\xE6\x89\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x48"],
        ["\xE6\x89\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x49"],
        ["\xE6\x89\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x4A"],
        ["\xE6\x89\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x4B"],
        ["\xE6\x89\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x4C"],
        ["\xE6\x89\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x4D"],
        ["\xE6\x89\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x4E"],
        ["\xE6\x8A\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x4F"],
        ["\xE6\x8A\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x50"],
        ["\xE6\x89\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x51"],
        ["\xE6\x8A\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x52"],
        ["\xE6\x8A\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x53"],
        ["\xE6\x8A\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x54"],
        ["\xE6\x8B\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x55"],
        ["\xE6\x8A\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x56"],
        ["\xE6\x8A\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x57"],
        ["\xE6\x8B\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x58"],
        ["\xE6\x8B\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x59"],
        ["\xE6\x8A\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x5A"],
        ["\xE6\x8B\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x5B"],
        ["\xE6\x8B\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x5C"],
        ["\xE6\x8B\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x5D"],
        ["\xE6\x93\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x5E"],
        ["\xE6\x8B\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x5F"],
        ["\xE6\x8B\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x60"],
        ["\xE6\x8B\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x61"],
        ["\xE6\x8B\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x62"],
        ["\xE6\x8B\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x63"],
        ["\xE6\x8B\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x64"],
        ["\xE6\x8A\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x65"],
        ["\xE6\x8B\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x66"],
        ["\xE6\x8C\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x67"],
        ["\xE6\x8B\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x68"],
        ["\xE6\x8B\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x69"],
        ["\xE6\x8C\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x6A"],
        ["\xE6\x8C\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x6B"],
        ["\xE6\x8C\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x6C"],
        ["\xE6\x8B\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x6D"],
        ["\xE6\x8B\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x6E"],
        ["\xE6\x8D\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x6F"],
        ["\xE6\x8C\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x70"],
        ["\xE6\x8D\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x71"],
        ["\xE6\x90\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x72"],
        ["\xE6\x8D\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x73"],
        ["\xE6\x8E\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x74"],
        ["\xE6\x8E\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x75"],
        ["\xE6\x8E\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x76"],
        ["\xE6\x8E\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x77"],
        ["\xE6\x8D\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x78"],
        ["\xE6\x8E\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x79"],
        ["\xE6\x8E\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x7A"],
        ["\xE6\x8E\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x7B"],
        ["\xE6\x8E\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x7C"],
        ["\xE6\x8E\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x7D"],
        ["\xE6\x8D\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x7E"],
        ["\xE6\x8D\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x80"],
        ["\xE6\x8E\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x81"],
        ["\xE6\x8F\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x82"],
        ["\xE6\x8F\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x83"],
        ["\xE6\x8F\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x84"],
        ["\xE6\x8F\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x85"],
        ["\xE6\x8F\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x86"],
        ["\xE6\x8F\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x87"],
        ["\xE6\x8F\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x88"],
        ["\xE6\x8F\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x89"],
        ["\xE6\x90\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x8A"],
        ["\xE6\x90\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x8B"],
        ["\xE6\x90\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x8C"],
        ["\xE6\x90\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x8D"],
        ["\xE6\x90\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x8E"],
        ["\xE6\x90\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x8F"],
        ["\xE6\x94\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x90"],
        ["\xE6\x90\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x91"],
        ["\xE6\x90\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x92"],
        ["\xE6\x90\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x93"],
        ["\xE6\x91\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x94"],
        ["\xE6\x91\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x95"],
        ["\xE6\x91\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x96"],
        ["\xE6\x91\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x97"],
        ["\xE6\x94\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x98"],
        ["\xE6\x92\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x99"],
        ["\xE6\x92\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x9A"],
        ["\xE6\x92\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x9B"],
        ["\xE6\x92\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x9C"],
        ["\xE6\x92\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x9D"],
        ["\xE6\x92\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x9E"],
        ["\xE6\x93\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x9F"],
        ["\xE6\x93\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA0"],
        ["\xE6\x93\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA1"],
        ["\xE6\x93\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA2"],
        ["\xE6\x92\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA3"],
        ["\xE6\x93\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA4"],
        ["\xE6\x93\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA5"],
        ["\xE6\x93\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA6"],
        ["\xE6\x93\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA7"],
        ["\xE8\x88\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA8"],
        ["\xE6\x93\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA9"],
        ["\xE6\x93\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xAA"],
        ["\xE6\x8A\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xAB"],
        ["\xE6\x93\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xAC"],
        ["\xE6\x93\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xAD"],
        ["\xE6\x94\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xAE"],
        ["\xE6\x93\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xAF"],
        ["\xE6\x93\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB0"],
        ["\xE6\x93\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB1"],
        ["\xE6\x93\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB2"],
        ["\xE6\x94\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB3"],
        ["\xE6\x93\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB4"],
        ["\xE6\x94\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB5"],
        ["\xE6\x94\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB6"],
        ["\xE6\x94\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB7"],
        ["\xE6\x94\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB8"],
        ["\xE6\x94\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB9"],
        ["\xE6\x94\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xBA"],
        ["\xE6\x94\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xBB"],
        ["\xE6\x94\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xBC"],
        ["\xE6\x94\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xBD"],
        ["\xE6\x94\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xBE"],
        ["\xE6\x94\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xBF"],
        ["\xE7\x95\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC0"],
        ["\xE6\x95\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC1"],
        ["\xE6\x95\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC2"],
        ["\xE6\x95\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC3"],
        ["\xE6\x95\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC4"],
        ["\xE6\x95\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC5"],
        ["\xE6\x95\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC6"],
        ["\xE6\x95\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC7"],
        ["\xE6\x95\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC8"],
        ["\xE6\x95\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC9"],
        ["\xE6\x96\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xCA"],
        ["\xE6\x96\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xCB"],
        ["\xE8\xAE\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xCC"],
        ["\xE6\x96\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xCD"],
        ["\xE6\x96\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xCE"],
        ["\xE6\x96\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xCF"],
        ["\xE6\x96\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD0"],
        ["\xE6\x97\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD1"],
        ["\xE6\x97\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD2"],
        ["\xE6\x97\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD3"],
        ["\xE6\x97\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD4"],
        ["\xE6\x97\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD5"],
        ["\xE6\x97\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD6"],
        ["\xE6\x97\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD7"],
        ["\xE6\x97\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD8"],
        ["\xE6\x97\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD9"],
        ["\xE6\x97\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xDA"],
        ["\xE6\x97\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xDB"],
        ["\xE6\x9D\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xDC"],
        ["\xE6\x98\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xDD"],
        ["\xE6\x98\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xDE"],
        ["\xE6\x97\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xDF"],
        ["\xE6\x9D\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE0"],
        ["\xE6\x98\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE1"],
        ["\xE6\x98\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE2"],
        ["\xE6\x98\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE3"],
        ["\xE6\x98\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE4"],
        ["\xE6\x99\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE5"],
        ["\xE6\x99\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE6"],
        ["\xE6\x99\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE7"],
        ["\xE6\x99\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE8"],
        ["\xE6\x99\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE9"],
        ["\xE6\x99\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xEA"],
        ["\xE6\x99\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xEB"],
        ["\xE6\x99\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xEC"],
        ["\xE6\x99\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xED"],
        ["\xE6\x99\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xEE"],
        ["\xE6\x99\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xEF"],
        ["\xE6\x99\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF0"],
        ["\xE6\x9A\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF1"],
        ["\xE6\x9A\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF2"],
        ["\xE6\x9A\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF3"],
        ["\xE6\x9A\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF4"],
        ["\xE6\x9A\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF5"],
        ["\xE6\x9A\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF6"],
        ["\xE6\x9A\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF7"],
        ["\xE6\x9B\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF8"],
        ["\xE6\x9A\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF9"],
        ["\xE6\x9B\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xFA"],
        ["\xE6\x9A\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xFB"],
        ["\xE6\x9A\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xFC"],
        ["\xE6\x9B\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x40"],
        ["\xE6\x9A\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x41"],
        ["\xE6\x9B\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x42"],
        ["\xE6\x9B\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x43"],
        ["\xE6\x9B\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x44"],
        ["\xE6\x98\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x45"],
        ["\xE6\x9B\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x46"],
        ["\xE6\x9B\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x47"],
        ["\xE6\x9B\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x48"],
        ["\xE6\x9B\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x49"],
        ["\xE6\x9B\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x4A"],
        ["\xE6\x9C\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x4B"],
        ["\xE6\x9C\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x4C"],
        ["\xE6\x9C\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x4D"],
        ["\xE6\x9C\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x4E"],
        ["\xE6\x9C\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x4F"],
        ["\xE9\x9C\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x50"],
        ["\xE6\x9C\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x51"],
        ["\xE6\x9C\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x52"],
        ["\xE6\x9C\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x53"],
        ["\xE6\x9D\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x54"],
        ["\xE6\x9C\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x55"],
        ["\xE6\x9C\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x56"],
        ["\xE6\x9D\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x57"],
        ["\xE6\x9D\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x58"],
        ["\xE6\x9D\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x59"],
        ["\xE6\x9D\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x5A"],
        ["\xE6\x9D\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x5B"],
        ["\xE6\x9D\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x5C"],
        ["\xE6\x9E\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x5D"],
        ["\xE6\x9D\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x5E"],
        ["\xE6\x9E\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x5F"],
        ["\xE6\x9D\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x60"],
        ["\xE6\x9D\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x61"],
        ["\xE6\x9E\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x62"],
        ["\xE6\x9E\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x63"],
        ["\xE6\x9E\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x64"],
        ["\xE6\x9E\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x65"],
        ["\xE6\x9E\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x66"],
        ["\xE6\x9E\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x67"],
        ["\xE6\x9F\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x68"],
        ["\xE6\x9E\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x69"],
        ["\xE6\x9F\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x6A"],
        ["\xE6\x9E\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x6B"],
        ["\xE6\x9F\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x6C"],
        ["\xE6\x9E\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x6D"],
        ["\xE6\x9F\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x6E"],
        ["\xE6\x9F\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x6F"],
        ["\xE6\x9F\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x70"],
        ["\xE6\x9F\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x71"],
        ["\xE6\x9F\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x72"],
        ["\xE6\x9E\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x73"],
        ["\xE6\x9F\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x74"],
        ["\xE6\x9F\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x75"],
        ["\xE6\x9F\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x76"],
        ["\xE6\xAA\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x77"],
        ["\xE6\xA0\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x78"],
        ["\xE6\xA1\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x79"],
        ["\xE6\xA0\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x7A"],
        ["\xE6\xA1\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x7B"],
        ["\xE6\xA1\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x7C"],
        ["\xE6\xA0\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x7D"],
        ["\xE6\xA1\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x7E"],
        ["\xE6\xA2\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x80"],
        ["\xE6\xA0\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x81"],
        ["\xE6\xA1\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x82"],
        ["\xE6\xA1\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x83"],
        ["\xE6\xA1\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x84"],
        ["\xE6\xA1\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x85"],
        ["\xE6\xA2\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x86"],
        ["\xE6\xA2\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x87"],
        ["\xE6\xA2\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x88"],
        ["\xE6\xA2\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x89"],
        ["\xE6\xA2\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x8A"],
        ["\xE6\xA2\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x8B"],
        ["\xE6\xA2\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x8C"],
        ["\xE6\xAA\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x8D"],
        ["\xE6\xA2\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x8E"],
        ["\xE6\xA1\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x8F"],
        ["\xE6\xA2\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x90"],
        ["\xE6\xA2\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x91"],
        ["\xE6\xA2\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x92"],
        ["\xE6\xA4\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x93"],
        ["\xE6\xA2\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x94"],
        ["\xE6\xA1\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x95"],
        ["\xE6\xA4\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x96"],
        ["\xE6\xA3\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x97"],
        ["\xE6\xA4\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x98"],
        ["\xE6\xA3\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x99"],
        ["\xE6\xA4\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x9A"],
        ["\xE6\xA4\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x9B"],
        ["\xE6\xA3\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x9C"],
        ["\xE6\xA4\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x9D"],
        ["\xE6\xA3\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x9E"],
        ["\xE6\xA3\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x9F"],
        ["\xE6\xA3\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA0"],
        ["\xE6\xA3\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA1"],
        ["\xE6\xA4\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA2"],
        ["\xE6\xA4\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA3"],
        ["\xE6\xA4\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA4"],
        ["\xE6\xA3\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA5"],
        ["\xE6\xA3\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA6"],
        ["\xE6\xA4\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA7"],
        ["\xE6\xA3\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA8"],
        ["\xE6\xA3\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA9"],
        ["\xE6\xA3\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xAA"],
        ["\xE6\xA4\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xAB"],
        ["\xE6\xA4\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xAC"],
        ["\xE6\xA4\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xAD"],
        ["\xE6\xA4\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xAE"],
        ["\xE6\xA4\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xAF"],
        ["\xE6\xA3\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB0"],
        ["\xE6\xA5\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB1"],
        ["\xE6\xA5\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB2"],
        ["\xE6\xA5\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB3"],
        ["\xE6\xA5\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB4"],
        ["\xE6\xA5\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB5"],
        ["\xE6\xA5\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB6"],
        ["\xE6\xA5\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB7"],
        ["\xE6\xA5\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB8"],
        ["\xE6\xA4\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB9"],
        ["\xE6\xA5\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xBA"],
        ["\xE6\xA4\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xBB"],
        ["\xE6\xA5\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xBC"],
        ["\xE6\xA4\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xBD"],
        ["\xE6\xA5\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xBE"],
        ["\xE6\xA5\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xBF"],
        ["\xE6\xA5\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC0"],
        ["\xE6\xA6\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC1"],
        ["\xE6\xA5\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC2"],
        ["\xE6\xA6\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC3"],
        ["\xE6\xA6\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC4"],
        ["\xE6\xA7\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC5"],
        ["\xE6\xA6\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC6"],
        ["\xE6\xA7\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC7"],
        ["\xE6\xA7\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC8"],
        ["\xE6\xA6\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC9"],
        ["\xE6\xA7\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xCA"],
        ["\xE5\xAF\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xCB"],
        ["\xE6\xA7\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xCC"],
        ["\xE6\xA7\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xCD"],
        ["\xE6\xA6\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xCE"],
        ["\xE6\xA7\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xCF"],
        ["\xE6\xA6\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD0"],
        ["\xE6\xA8\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD1"],
        ["\xE6\xA6\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD2"],
        ["\xE6\xA6\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD3"],
        ["\xE6\xA6\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD4"],
        ["\xE6\xA6\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD5"],
        ["\xE6\xA6\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD6"],
        ["\xE6\xA7\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD7"],
        ["\xE6\xA7\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD8"],
        ["\xE6\xA8\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD9"],
        ["\xE6\xA8\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xDA"],
        ["\xE6\xA7\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xDB"],
        ["\xE6\xAC\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xDC"],
        ["\xE6\xA7\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xDD"],
        ["\xE6\xA7\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xDE"],
        ["\xE6\xA7\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xDF"],
        ["\xE6\xA8\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE0"],
        ["\xE6\xA6\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE1"],
        ["\xE6\xA8\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE2"],
        ["\xE6\xA7\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE3"],
        ["\xE6\xA8\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE4"],
        ["\xE6\xA7\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE5"],
        ["\xE6\xA8\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE6"],
        ["\xE6\xA8\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE7"],
        ["\xE6\xAB\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE8"],
        ["\xE6\xA8\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE9"],
        ["\xE6\xA8\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xEA"],
        ["\xE6\xA9\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xEB"],
        ["\xE6\xA8\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xEC"],
        ["\xE6\xA9\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xED"],
        ["\xE6\xA8\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xEE"],
        ["\xE6\xA9\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xEF"],
        ["\xE6\xA9\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF0"],
        ["\xE6\xA9\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF1"],
        ["\xE6\xA9\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF2"],
        ["\xE6\xA9\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF3"],
        ["\xE6\xA9\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF4"],
        ["\xE6\xA8\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF5"],
        ["\xE6\xA8\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF6"],
        ["\xE6\xAA\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF7"],
        ["\xE6\xAA\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF8"],
        ["\xE6\xAA\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF9"],
        ["\xE6\xAA\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xFA"],
        ["\xE6\xAA\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xFB"],
        ["\xE6\xAA\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xFC"],
        ["\xE6\xAA\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x40"],
        ["\xE8\x98\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x41"],
        ["\xE6\xAA\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x42"],
        ["\xE6\xAB\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x43"],
        ["\xE6\xAB\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x44"],
        ["\xE6\xAA\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x45"],
        ["\xE6\xAA\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x46"],
        ["\xE6\xAA\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x47"],
        ["\xE6\xAB\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x48"],
        ["\xE6\xAB\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x49"],
        ["\xE6\xAB\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x4A"],
        ["\xE6\xAA\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x4B"],
        ["\xE6\xAB\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x4C"],
        ["\xE6\xAB\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x4D"],
        ["\xE6\xAB\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x4E"],
        ["\xE6\xAC\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x4F"],
        ["\xE8\x98\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x50"],
        ["\xE6\xAB\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x51"],
        ["\xE6\xAC\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x52"],
        ["\xE6\xAC\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x53"],
        ["\xE9\xAC\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x54"],
        ["\xE6\xAC\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x55"],
        ["\xE6\xAC\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x56"],
        ["\xE6\xAC\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x57"],
        ["\xE7\x9B\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x58"],
        ["\xE6\xAC\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x59"],
        ["\xE9\xA3\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x5A"],
        ["\xE6\xAD\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x5B"],
        ["\xE6\xAD\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x5C"],
        ["\xE6\xAD\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x5D"],
        ["\xE6\xAD\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x5E"],
        ["\xE6\xAD\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x5F"],
        ["\xE6\xAD\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x60"],
        ["\xE6\xAD\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x61"],
        ["\xE6\xAD\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x62"],
        ["\xE6\xAD\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x63"],
        ["\xE6\xAD\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x64"],
        ["\xE6\xAD\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x65"],
        ["\xE6\xAD\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x66"],
        ["\xE6\xAE\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x67"],
        ["\xE6\xAE\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x68"],
        ["\xE6\xAE\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x69"],
        ["\xE6\xAE\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x6A"],
        ["\xE6\xAE\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x6B"],
        ["\xE6\xAE\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x6C"],
        ["\xE6\xAE\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x6D"],
        ["\xE6\xAE\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x6E"],
        ["\xE6\xAE\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x6F"],
        ["\xE6\xAE\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x70"],
        ["\xE6\xAE\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x71"],
        ["\xE6\xAE\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x72"],
        ["\xE6\xAE\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x73"],
        ["\xE6\xAE\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x74"],
        ["\xE6\xAE\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x75"],
        ["\xE6\xAE\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x76"],
        ["\xE6\xAF\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x77"],
        ["\xE6\xAF\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x78"],
        ["\xE6\xAF\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x79"],
        ["\xE6\xAF\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x7A"],
        ["\xE6\xAF\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x7B"],
        ["\xE6\xAF\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x7C"],
        ["\xE6\xAF\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x7D"],
        ["\xE6\xAF\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x7E"],
        ["\xE9\xBA\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x80"],
        ["\xE6\xB0\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x81"],
        ["\xE6\xB0\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x82"],
        ["\xE6\xB0\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x83"],
        ["\xE6\xB0\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x84"],
        ["\xE6\xB0\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x85"],
        ["\xE6\xB0\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x86"],
        ["\xE6\xB1\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x87"],
        ["\xE6\xB1\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x88"],
        ["\xE6\xB1\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x89"],
        ["\xE6\xB1\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x8A"],
        ["\xE6\xB2\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x8B"],
        ["\xE6\xB2\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x8C"],
        ["\xE6\xB2\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x8D"],
        ["\xE6\xB2\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x8E"],
        ["\xE6\xB2\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x8F"],
        ["\xE6\xB1\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x90"],
        ["\xE6\xB1\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x91"],
        ["\xE6\xB1\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x92"],
        ["\xE6\xB2\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x93"],
        ["\xE6\xB2\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x94"],
        ["\xE6\xB3\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x95"],
        ["\xE6\xB3\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x96"],
        ["\xE6\xB3\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x97"],
        ["\xE6\xB2\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x98"],
        ["\xE6\xB3\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x99"],
        ["\xE6\xB3\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x9A"],
        ["\xE6\xB3\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x9B"],
        ["\xE6\xB2\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x9C"],
        ["\xE6\xB2\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x9D"],
        ["\xE6\xB2\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x9E"],
        ["\xE6\xB2\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x9F"],
        ["\xE6\xB3\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA0"],
        ["\xE6\xB3\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA1"],
        ["\xE6\xB3\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA2"],
        ["\xE6\xB3\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA3"],
        ["\xE6\xB4\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA4"],
        ["\xE8\xA1\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA5"],
        ["\xE6\xB4\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA6"],
        ["\xE6\xB4\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA7"],
        ["\xE6\xB4\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA8"],
        ["\xE6\xB4\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA9"],
        ["\xE6\xB4\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAA"],
        ["\xE6\xB4\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAB"],
        ["\xE6\xB4\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAC"],
        ["\xE6\xB4\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAD"],
        ["\xE6\xB4\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAE"],
        ["\xE6\xB5\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAF"],
        ["\xE6\xB6\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB0"],
        ["\xE6\xB5\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB1"],
        ["\xE6\xB5\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB2"],
        ["\xE6\xB5\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB3"],
        ["\xE6\xB5\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB4"],
        ["\xE6\xB6\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB5"],
        ["\xE6\xB6\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB6"],
        ["\xE6\xBF\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB7"],
        ["\xE6\xB6\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB8"],
        ["\xE6\xB7\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB9"],
        ["\xE6\xB8\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xBA"],
        ["\xE6\xB8\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xBB"],
        ["\xE6\xB6\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xBC"],
        ["\xE6\xB7\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xBD"],
        ["\xE6\xB7\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xBE"],
        ["\xE6\xB6\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xBF"],
        ["\xE6\xB7\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC0"],
        ["\xE6\xB7\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC1"],
        ["\xE6\xB7\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC2"],
        ["\xE6\xB7\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC3"],
        ["\xE6\xB7\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC4"],
        ["\xE6\xB7\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC5"],
        ["\xE6\xB7\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC6"],
        ["\xE6\xB7\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC7"],
        ["\xE6\xB7\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC8"],
        ["\xE6\xB7\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC9"],
        ["\xE6\xB7\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCA"],
        ["\xE6\xB7\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCB"],
        ["\xE6\xB7\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCC"],
        ["\xE6\xB8\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCD"],
        ["\xE6\xB9\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCE"],
        ["\xE6\xB8\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCF"],
        ["\xE6\xB8\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD0"],
        ["\xE6\xB9\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD1"],
        ["\xE6\xB9\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD2"],
        ["\xE6\xB8\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD3"],
        ["\xE6\xB8\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD4"],
        ["\xE6\xB9\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD5"],
        ["\xE6\xB8\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD6"],
        ["\xE6\xB9\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD7"],
        ["\xE6\xB9\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD8"],
        ["\xE6\xB8\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD9"],
        ["\xE6\xB9\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xDA"],
        ["\xE6\xB8\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xDB"],
        ["\xE6\xB9\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xDC"],
        ["\xE6\xB8\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xDD"],
        ["\xE6\xBB\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xDE"],
        ["\xE6\xB8\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xDF"],
        ["\xE6\xB8\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE0"],
        ["\xE6\xBA\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE1"],
        ["\xE6\xBA\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE2"],
        ["\xE6\xBA\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE3"],
        ["\xE6\xBB\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE4"],
        ["\xE6\xBA\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE5"],
        ["\xE6\xBB\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE6"],
        ["\xE6\xBA\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE7"],
        ["\xE6\xBA\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE8"],
        ["\xE6\xBB\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE9"],
        ["\xE6\xBA\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xEA"],
        ["\xE6\xBB\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xEB"],
        ["\xE6\xBB\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xEC"],
        ["\xE6\xBA\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xED"],
        ["\xE6\xBA\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xEE"],
        ["\xE6\xBB\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xEF"],
        ["\xE6\xBA\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF0"],
        ["\xE6\xBD\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF1"],
        ["\xE6\xBC\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF2"],
        ["\xE7\x81\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF3"],
        ["\xE6\xBB\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF4"],
        ["\xE6\xBB\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF5"],
        ["\xE6\xBB\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF6"],
        ["\xE6\xBC\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF7"],
        ["\xE6\xBB\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF8"],
        ["\xE6\xBC\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF9"],
        ["\xE6\xBB\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xFA"],
        ["\xE6\xBC\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xFB"],
        ["\xE6\xBB\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xFC"],
        ["\xE6\xBC\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x40"],
        ["\xE6\xBC\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x41"],
        ["\xE6\xBB\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x42"],
        ["\xE6\xBE\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x43"],
        ["\xE6\xBD\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x44"],
        ["\xE6\xBD\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x45"],
        ["\xE6\xBE\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x46"],
        ["\xE6\xBE\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x47"],
        ["\xE6\xBD\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x48"],
        ["\xE6\xBD\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x49"],
        ["\xE6\xBF\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x4A"],
        ["\xE6\xBD\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x4B"],
        ["\xE6\xBE\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x4C"],
        ["\xE6\xBD\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x4D"],
        ["\xE6\xBD\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x4E"],
        ["\xE6\xBE\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x4F"],
        ["\xE6\xBE\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x50"],
        ["\xE6\xBF\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x51"],
        ["\xE6\xBD\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x52"],
        ["\xE6\xBE\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x53"],
        ["\xE6\xBE\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x54"],
        ["\xE6\xBE\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x55"],
        ["\xE6\xBE\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x56"],
        ["\xE6\xBE\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x57"],
        ["\xE6\xBF\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x58"],
        ["\xE6\xBE\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x59"],
        ["\xE6\xBF\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x5A"],
        ["\xE6\xBF\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x5B"],
        ["\xE6\xBF\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x5C"],
        ["\xE6\xBF\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x5D"],
        ["\xE6\xBF\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x5E"],
        ["\xE6\xBF\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x5F"],
        ["\xE6\xBF\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x60"],
        ["\xE6\xBF\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x61"],
        ["\xE7\x80\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x62"],
        ["\xE7\x80\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x63"],
        ["\xE6\xBF\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x64"],
        ["\xE7\x80\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x65"],
        ["\xE7\x80\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x66"],
        ["\xE7\x80\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x67"],
        ["\xE6\xBF\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x68"],
        ["\xE7\x80\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x69"],
        ["\xE7\x80\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x6A"],
        ["\xE6\xBD\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x6B"],
        ["\xE7\x80\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x6C"],
        ["\xE7\x80\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x6D"],
        ["\xE7\x80\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x6E"],
        ["\xE7\x80\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x6F"],
        ["\xE7\x80\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x70"],
        ["\xE7\x80\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x71"],
        ["\xE7\x81\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x72"],
        ["\xE7\x81\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x73"],
        ["\xE7\x82\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x74"],
        ["\xE7\x82\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x75"],
        ["\xE7\x82\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x76"],
        ["\xE7\x83\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x77"],
        ["\xE7\x82\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x78"],
        ["\xE7\x82\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x79"],
        ["\xE7\x82\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x7A"],
        ["\xE7\x82\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x7B"],
        ["\xE7\x83\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x7C"],
        ["\xE7\x83\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x7D"],
        ["\xE7\x83\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x7E"],
        ["\xE7\x83\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x80"],
        ["\xE7\x84\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x81"],
        ["\xE7\x83\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x82"],
        ["\xE7\x84\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x83"],
        ["\xE7\x84\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x84"],
        ["\xE7\x85\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x85"],
        ["\xE7\x85\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x86"],
        ["\xE7\x86\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x87"],
        ["\xE7\x85\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x88"],
        ["\xE7\x85\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x89"],
        ["\xE7\x85\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x8A"],
        ["\xE7\x85\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x8B"],
        ["\xE7\x85\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x8C"],
        ["\xE7\x86\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x8D"],
        ["\xE7\x87\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x8E"],
        ["\xE7\x86\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x8F"],
        ["\xE7\x86\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x90"],
        ["\xE7\x86\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x91"],
        ["\xE7\x86\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x92"],
        ["\xE7\x87\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x93"],
        ["\xE7\x86\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x94"],
        ["\xE7\x86\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x95"],
        ["\xE7\x87\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x96"],
        ["\xE7\x87\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x97"],
        ["\xE7\x87\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x98"],
        ["\xE7\x87\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x99"],
        ["\xE7\x87\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x9A"],
        ["\xE7\x87\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x9B"],
        ["\xE7\x87\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x9C"],
        ["\xE7\x87\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x9D"],
        ["\xE7\x87\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x9E"],
        ["\xE7\x87\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x9F"],
        ["\xE7\x87\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA0"],
        ["\xE7\x88\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\xE7\x88\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\xE7\x88\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\xE7\x88\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\xE7\x88\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\xE7\x88\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\xE7\x88\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\xE7\x88\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\xE7\x88\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\xE7\x88\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\xE7\x88\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\xE7\x89\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xE7\x89\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\xE7\x89\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\xE7\x89\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\xE7\x89\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\xE7\x89\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\xE7\x8A\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\xE7\x8A\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\xE7\x8A\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\xE7\x8A\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\xE7\x8A\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\xE7\x8A\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\xE7\x8A\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\xE7\x8A\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\xE7\x8A\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\xE7\x8B\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\xE7\x8B\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\xE7\x8B\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\xE7\x8B\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\xE7\x8B\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\xE7\x8B\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\xE7\x8B\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\xE7\x8B\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\xE7\x8B\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\xE7\x8B\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\xE5\x80\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\xE7\x8C\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\xE7\x8C\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xE7\x8C\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xE7\x8C\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\xE7\x8C\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\xE7\x8C\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\xE7\x8C\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\xE7\x8C\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\xE7\x8C\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\xE7\x8C\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\xE7\x8D\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\xE7\x8D\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\xE9\xBB\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\xE7\x8D\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\xE7\x8D\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\xE7\x8D\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\xE7\x8D\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\xE7\x8D\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\xE7\x8D\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\xE7\x8D\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\xE7\x8D\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\xE7\x8F\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\xE7\x8E\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\xE7\x8F\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\xE7\x8E\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\xE7\x8F\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\xE7\x8F\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\xE7\x8F\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\xE7\x8F\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\xE7\x92\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\xE7\x90\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\xE7\x91\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\xE7\x90\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\xE7\x8F\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\xE7\x90\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\xE7\x90\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\xE7\x91\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\xE7\x90\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\xE7\x91\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\xE7\x91\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\xE7\x91\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\xE7\x91\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\xE7\x91\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\xE7\x91\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xE7\x91\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\xE7\x91\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\xE7\x91\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\xE7\x91\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xE7\x92\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\xE7\x92\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xE7\x92\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xE7\x93\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xE7\x93\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\xE7\x93\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\xE7\x8F\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\xE7\x93\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x40"],
        ["\xE7\x93\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x41"],
        ["\xE7\x93\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x42"],
        ["\xE7\x93\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x43"],
        ["\xE7\x93\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x44"],
        ["\xE7\x93\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x45"],
        ["\xE7\x93\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x46"],
        ["\xE7\x93\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x47"],
        ["\xE7\x93\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x48"],
        ["\xE7\x93\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x49"],
        ["\xE7\x94\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x4A"],
        ["\xE7\x94\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x4B"],
        ["\xE7\x94\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x4C"],
        ["\xE7\x94\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x4D"],
        ["\xE7\x94\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x4E"],
        ["\xE7\x94\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x4F"],
        ["\xE7\x94\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x50"],
        ["\xE7\x94\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x51"],
        ["\xE7\x94\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x52"],
        ["\xE7\x94\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x53"],
        ["\xE7\x94\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x54"],
        ["\xE7\x94\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x55"],
        ["\xE7\x95\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x56"],
        ["\xE7\x95\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x57"],
        ["\xE7\x95\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x58"],
        ["\xE7\x95\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x59"],
        ["\xE7\x95\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x5A"],
        ["\xE7\x95\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x5B"],
        ["\xE7\x95\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x5C"],
        ["\xE7\x95\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x5D"],
        ["\xE7\x95\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x5E"],
        ["\xE7\x95\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x5F"],
        ["\xE7\x95\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x60"],
        ["\xE7\x95\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x61"],
        ["\xE7\x95\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x62"],
        ["\xE7\x95\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x63"],
        ["\xE7\x96\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x64"],
        ["\xE7\x96\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x65"],
        ["\xE7\x95\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x66"],
        ["\xE7\x96\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x67"],
        ["\xE7\x96\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x68"],
        ["\xE7\x96\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x69"],
        ["\xE7\x96\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x6A"],
        ["\xE7\x96\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x6B"],
        ["\xE7\x96\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x6C"],
        ["\xE7\x96\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x6D"],
        ["\xE7\x96\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x6E"],
        ["\xE7\x97\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x6F"],
        ["\xE7\x96\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x70"],
        ["\xE7\x97\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x71"],
        ["\xE7\x96\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x72"],
        ["\xE7\x96\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x73"],
        ["\xE7\x96\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x74"],
        ["\xE7\x96\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x75"],
        ["\xE7\x96\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x76"],
        ["\xE7\x97\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x77"],
        ["\xE7\x97\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x78"],
        ["\xE7\x97\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x79"],
        ["\xE7\x97\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x7A"],
        ["\xE7\x97\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x7B"],
        ["\xE7\x97\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x7C"],
        ["\xE7\x97\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x7D"],
        ["\xE7\x97\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x7E"],
        ["\xE7\x97\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x80"],
        ["\xE7\x98\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x81"],
        ["\xE7\x97\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x82"],
        ["\xE7\x97\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x83"],
        ["\xE7\x97\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x84"],
        ["\xE7\x97\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x85"],
        ["\xE7\x98\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x86"],
        ["\xE7\x98\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x87"],
        ["\xE7\x98\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x88"],
        ["\xE7\x98\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x89"],
        ["\xE7\x98\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x8A"],
        ["\xE7\x98\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x8B"],
        ["\xE7\x98\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x8C"],
        ["\xE7\x98\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x8D"],
        ["\xE7\x98\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x8E"],
        ["\xE7\x98\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x8F"],
        ["\xE7\x98\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x90"],
        ["\xE7\x98\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x91"],
        ["\xE7\x99\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x92"],
        ["\xE7\x99\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x93"],
        ["\xE7\x99\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x94"],
        ["\xE7\x99\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x95"],
        ["\xE7\x99\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x96"],
        ["\xE7\x99\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x97"],
        ["\xE7\x99\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x98"],
        ["\xE7\x99\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x99"],
        ["\xE7\x99\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x9A"],
        ["\xE7\x99\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x9B"],
        ["\xE7\x99\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x9C"],
        ["\xE7\x99\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x9D"],
        ["\xE7\x99\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x9E"],
        ["\xE7\x99\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x9F"],
        ["\xE7\x99\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA0"],
        ["\xE7\x99\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\xE7\x99\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\xE7\x9A\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\xE7\x9A\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\xE7\x9A\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\xE7\x9A\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\xE7\x9A\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\xE7\x9A\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\xE7\x9A\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\xE7\x9A\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\xE7\x9A\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\xE7\x9A\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\xE7\x9A\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\xE7\x9A\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\xE7\x9A\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\xE7\x9A\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\xE7\x9B\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\xE7\x9B\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\xE7\x9B\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\xE7\x9B\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\xE7\x9B\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\xE7\x9B\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\xE7\x9B\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\xE7\x9B\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\xE7\x9B\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\xE8\x98\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\xE7\x9B\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\xE7\x9C\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\xE7\x9C\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\xE7\x9C\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\xE7\x9C\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\xE7\x9C\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\xE7\x9C\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\xE7\x9C\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\xE7\x9C\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\xE7\x9C\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\xE7\x9C\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\xE7\x9C\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\xE7\x9D\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\xE7\x9D\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\xE7\x9D\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\xE7\x9D\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\xE7\x9D\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\xE7\x9D\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\xE7\x9D\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\xE7\x9D\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\xE7\x9D\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\xE7\x9E\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\xE7\x9E\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\xE7\x9E\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\xE7\x9E\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\xE7\x9E\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\xE7\x9E\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\xE7\x9E\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\xE7\x9E\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\xE7\x9E\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\xE7\x9E\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\xE7\x9E\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\xE7\x9E\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\xE7\x9F\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\xE7\x9F\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\xE7\x9F\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\xE7\x9F\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\xE7\x9F\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\xE7\x9F\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\xE7\x9F\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\xE7\x9F\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\xE7\xA0\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\xE7\xA0\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\xE7\xA4\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\xE7\xA0\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\xE7\xA4\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\xE7\xA1\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\xE7\xA2\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\xE7\xA1\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\xE7\xA2\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\xE7\xA1\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\xE7\xA2\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\xE7\xA2\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\xE7\xA2\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\xE7\xA2\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\xE7\xA2\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\xE7\xA2\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\xE7\xA3\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\xE7\xA3\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\xE7\xA3\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\xE7\xA3\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\xE7\xA2\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\xE7\xA2\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\xE7\xA3\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\xE7\xA3\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\xE7\xA3\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\xE7\xA3\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x40"],
        ["\xE7\xA3\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x41"],
        ["\xE7\xA3\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x42"],
        ["\xE7\xA3\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x43"],
        ["\xE7\xA4\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x44"],
        ["\xE7\xA4\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x45"],
        ["\xE7\xA4\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x46"],
        ["\xE7\xA4\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x47"],
        ["\xE7\xA4\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x48"],
        ["\xE7\xA4\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x49"],
        ["\xE7\xA5\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x4A"],
        ["\xE7\xA5\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x4B"],
        ["\xE7\xA5\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x4C"],
        ["\xE7\xA5\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x4D"],
        ["\xE7\xA5\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x4E"],
        ["\xE7\xA5\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x4F"],
        ["\xE7\xA5\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x50"],
        ["\xE7\xA5\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x51"],
        ["\xE7\xA5\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x52"],
        ["\xE7\xA6\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x53"],
        ["\xE7\xA6\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x54"],
        ["\xE7\xA6\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x55"],
        ["\xE9\xBD\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x56"],
        ["\xE7\xA6\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x57"],
        ["\xE7\xA6\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x58"],
        ["\xE7\xA6\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x59"],
        ["\xE7\xA6\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x5A"],
        ["\xE7\xA6\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x5B"],
        ["\xE7\xA7\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x5C"],
        ["\xE7\xA7\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x5D"],
        ["\xE7\xA7\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x5E"],
        ["\xE7\xA7\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x5F"],
        ["\xE7\xA7\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x60"],
        ["\xE7\xA7\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x61"],
        ["\xE7\xA8\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x62"],
        ["\xE7\xA8\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x63"],
        ["\xE7\xA8\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x64"],
        ["\xE7\xA8\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x65"],
        ["\xE7\xA8\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x66"],
        ["\xE7\xA8\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x67"],
        ["\xE7\xA6\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x68"],
        ["\xE7\xA8\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x69"],
        ["\xE7\xA8\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x6A"],
        ["\xE7\xA8\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x6B"],
        ["\xE7\xA8\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x6C"],
        ["\xE7\xA9\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x6D"],
        ["\xE7\xA9\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x6E"],
        ["\xE7\xA9\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x6F"],
        ["\xE7\xA9\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],
        ["\xE7\xA9\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],
        ["\xE7\xA9\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],
        ["\xE9\xBE\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],
        ["\xE7\xA9\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],
        ["\xE7\xA9\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],
        ["\xE7\xA9\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],
        ["\xE7\xAA\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],
        ["\xE7\xAA\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],
        ["\xE7\xAA\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],
        ["\xE7\xAA\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],
        ["\xE7\xAA\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],
        ["\xE7\xAA\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\xE7\xAB\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],
        ["\xE7\xAA\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],
        ["\xE7\xAA\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],
        ["\xE7\xAB\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x81"],
        ["\xE7\xAB\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x82"],
        ["\xE7\xAA\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x83"],
        ["\xE9\x82\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x84"],
        ["\xE7\xAB\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x85"],
        ["\xE7\xAB\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x86"],
        ["\xE7\xAB\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x87"],
        ["\xE7\xAB\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x88"],
        ["\xE7\xAB\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x89"],
        ["\xE7\xAB\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A"],
        ["\xE7\xAB\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B"],
        ["\xE7\xAB\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C"],
        ["\xE7\xAB\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x8D"],
        ["\xE7\xAB\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x8E"],
        ["\xE7\xAB\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F"],
        ["\xE7\xAB\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x90"],
        ["\xE7\xAB\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x91"],
        ["\xE7\xAB\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x92"],
        ["\xE7\xAC\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x93"],
        ["\xE7\xAC\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x94"],
        ["\xE7\xAC\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x95"],
        ["\xE7\xAC\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x96"],
        ["\xE7\xAC\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x97"],
        ["\xE7\xAC\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x98"],
        ["\xE7\xAC\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x99"],
        ["\xE7\xAC\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x9A"],
        ["\xE7\xAC\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x9B"],
        ["\xE7\xAC\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x9C"],
        ["\xE7\xAC\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D"],
        ["\xE7\xAD\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x9E"],
        ["\xE7\xAD\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x9F"],
        ["\xE7\xAC\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA0"],
        ["\xE7\xAD\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\xE7\xAC\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\xE7\xAD\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\xE7\xAD\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\xE7\xAD\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\xE7\xAD\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\xE7\xAD\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\xE7\xAD\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\xE7\xAD\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\xE7\xAD\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\xE7\xAD\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\xE7\xAD\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\xE7\xAE\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\xE7\xAE\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\xE7\xAE\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\xE7\xAE\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\xE7\xAE\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\xE7\xAE\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\xE7\xAE\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\xE7\xAE\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\xE7\xAE\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\xE7\xAD\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\xE7\xAE\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\xE7\xAF\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\xE7\xAF\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\xE7\xAF\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\xE7\xAF\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\xE7\xAE\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\xE7\xAF\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\xE7\xAF\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\xE7\xAF\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\xE7\xB0\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\xE7\xB0\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\xE7\xAF\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\xE7\xAF\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\xE7\xB1\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\xE7\xB0\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\xE7\xB0\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\xE7\xB0\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\xE7\xAF\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\xE7\xAF\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\xE7\xB0\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\xE7\xB0\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\xE7\xAF\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\xE7\xB0\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\xE7\xB0\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\xE7\xB0\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\xE7\xB0\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\xE7\xB0\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\xE7\xB0\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\xE7\xB0\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\xE7\xB1\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\xE7\xB1\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\xE7\xB1\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\xE7\xB1\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\xE7\xB1\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\xE7\xB1\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\xE7\xB1\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\xE7\xB1\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\xE7\xB1\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\xE7\xB1\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\xE7\xB1\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\xE7\xB1\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\xE7\xB1\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xE7\xB2\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\xE7\xB2\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xE7\xB2\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xE7\xB2\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xE7\xB2\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xE7\xB2\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xE7\xB2\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xE7\xB2\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xE7\xB2\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xE7\xB2\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\xE7\xB2\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\xE7\xB2\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\xE7\xB2\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\xE7\xB2\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\xE7\xB3\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\xE7\xB3\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xE7\xB3\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xE7\xB3\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xE7\xB3\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xE7\xB3\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xE7\xB3\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xE9\xAC\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xE7\xB3\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xE7\xB3\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xE7\xB3\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xE7\xB3\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\xE7\xB3\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\xE7\xB4\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\xE7\xB4\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x40"],
        ["\xE7\xB4\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x41"],
        ["\xE7\xB4\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x42"],
        ["\xE7\xB4\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x43"],
        ["\xE7\xB5\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x44"],
        ["\xE7\xB5\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x45"],
        ["\xE7\xB4\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x46"],
        ["\xE7\xB4\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x47"],
        ["\xE7\xB4\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x48"],
        ["\xE7\xB4\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x49"],
        ["\xE7\xB5\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4A"],
        ["\xE7\xB5\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4B"],
        ["\xE7\xB5\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4C"],
        ["\xE7\xB5\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4D"],
        ["\xE7\xB5\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4E"],
        ["\xE7\xB5\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4F"],
        ["\xE7\xB5\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x50"],
        ["\xE7\xB5\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x51"],
        ["\xE7\xB5\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x52"],
        ["\xE7\xB6\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x53"],
        ["\xE7\xB6\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x54"],
        ["\xE7\xB5\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x55"],
        ["\xE7\xB6\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x56"],
        ["\xE7\xB5\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x57"],
        ["\xE7\xB6\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x58"],
        ["\xE7\xB6\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x59"],
        ["\xE7\xB6\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x5A"],
        ["\xE7\xB6\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x5B"],
        ["\xE7\xB6\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x5C"],
        ["\xE7\xB7\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x5D"],
        ["\xE7\xB6\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x5E"],
        ["\xE7\xB6\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x5F"],
        ["\xE7\xB8\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x60"],
        ["\xE7\xB6\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x61"],
        ["\xE7\xB6\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x62"],
        ["\xE7\xB7\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x63"],
        ["\xE7\xB6\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x64"],
        ["\xE7\xB6\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x65"],
        ["\xE7\xB6\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x66"],
        ["\xE7\xB7\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x67"],
        ["\xE7\xB7\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x68"],
        ["\xE7\xB7\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x69"],
        ["\xE7\xB7\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x6A"],
        ["\xE7\xB7\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x6B"],
        ["\xE7\xB7\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x6C"],
        ["\xE7\xB7\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x6D"],
        ["\xE7\xB8\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x6E"],
        ["\xE7\xB8\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x6F"],
        ["\xE7\xB8\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x70"],
        ["\xE7\xB8\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x71"],
        ["\xE7\xB8\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x72"],
        ["\xE7\xB8\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x73"],
        ["\xE7\xB8\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x74"],
        ["\xE7\xB8\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x75"],
        ["\xE7\xB8\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x76"],
        ["\xE7\xB8\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x77"],
        ["\xE7\xB9\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],
        ["\xE7\xB9\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x79"],
        ["\xE7\xB8\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x7A"],
        ["\xE7\xB8\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x7B"],
        ["\xE7\xB8\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x7C"],
        ["\xE7\xB9\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x7D"],
        ["\xE7\xB8\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x7E"],
        ["\xE7\xB8\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x80"],
        ["\xE7\xB8\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x81"],
        ["\xE7\xB9\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x82"],
        ["\xE7\xB9\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x83"],
        ["\xE7\xB9\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x84"],
        ["\xE7\xB9\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x85"],
        ["\xE7\xB9\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x86"],
        ["\xE7\xB9\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x87"],
        ["\xE7\xB9\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x88"],
        ["\xE7\xB9\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x89"],
        ["\xE7\xB9\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A"],
        ["\xE7\xB9\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B"],
        ["\xE7\xB9\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C"],
        ["\xE7\xBA\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D"],
        ["\xE7\xB7\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E"],
        ["\xE7\xB9\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F"],
        ["\xE8\xBE\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x90"],
        ["\xE7\xB9\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x91"],
        ["\xE7\xBA\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x92"],
        ["\xE7\xBA\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x93"],
        ["\xE7\xBA\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x94"],
        ["\xE7\xBA\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x95"],
        ["\xE7\xBA\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x96"],
        ["\xE7\xBA\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x97"],
        ["\xE7\xBA\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x98"],
        ["\xE7\xBA\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x99"],
        ["\xE7\xBA\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x9A"],
        ["\xE7\xBA\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x9B"],
        ["\xE7\xBA\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x9C"],
        ["\xE7\xBC\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D"],
        ["\xE7\xBC\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x9E"],
        ["\xE7\xBD\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F"],
        ["\xE7\xBD\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0"],
        ["\xE7\xBD\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\xE7\xBD\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\xE7\xBD\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\xE7\xBD\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\xE7\xBD\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\xE7\xBD\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\xE7\xBD\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\xE7\xBD\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\xE7\xBD\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\xE7\xBD\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\xE7\xBD\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\xE7\xBD\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\xE7\xBD\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\xE7\xBE\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\xE7\xBE\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\xE7\xBE\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\xE7\xBE\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\xE7\xBE\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\xE7\xBE\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\xE7\xBE\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\xE7\xBE\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\xE7\xBE\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\xE7\xBE\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\xE7\xBE\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\xE7\xBE\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\xE7\xBE\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\xE7\xBE\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\xE7\xBE\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\xE7\xBE\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\xE7\xBE\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\xE8\xAD\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\xE7\xBF\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\xE7\xBF\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\xE7\xBF\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\xE7\xBF\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\xE7\xBF\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\xE7\xBF\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\xE7\xBF\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\xE7\xBF\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\xE7\xBF\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\xE7\xBF\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\xE9\xA3\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\xE8\x80\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\xE8\x80\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\xE8\x80\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\xE8\x80\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\xE8\x80\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\xE8\x80\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\xE8\x80\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\xE8\x80\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\xE8\x80\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\xE8\x80\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\xE8\x80\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\xE8\x81\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\xE8\x81\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\xE8\x81\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\xE8\x81\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\xE8\x81\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\xE8\x81\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\xE8\x81\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\xE8\x81\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\xE8\x81\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\xE8\x81\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\xE8\x81\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\xE8\x81\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\xE8\x81\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\xE8\x81\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\xE8\x81\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xE8\x82\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xE8\x82\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\xE8\x82\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\xE8\x82\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\xE8\x82\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\xE8\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\xE8\x82\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\xE5\x86\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\xE8\x82\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\xE8\x83\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\xE8\x83\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\xE8\x83\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\xE8\x83\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\xE8\x83\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\xE8\x83\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xE8\x83\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\xE8\x84\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\xE8\x83\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\xE8\x83\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xE8\x84\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xE8\x84\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xE8\x84\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\xE8\x84\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\xE8\x85\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\xE9\x9A\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x40"],
        ["\xE8\x85\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x41"],
        ["\xE8\x84\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x42"],
        ["\xE8\x85\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x43"],
        ["\xE8\x85\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x44"],
        ["\xE8\x83\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x45"],
        ["\xE8\x85\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x46"],
        ["\xE8\x85\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x47"],
        ["\xE8\x85\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x48"],
        ["\xE8\x85\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x49"],
        ["\xE8\x85\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x4A"],
        ["\xE8\x86\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x4B"],
        ["\xE8\x86\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x4C"],
        ["\xE8\x86\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x4D"],
        ["\xE8\x86\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x4E"],
        ["\xE8\x86\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x4F"],
        ["\xE8\x86\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],
        ["\xE8\x86\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x51"],
        ["\xE8\x86\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x52"],
        ["\xE8\x86\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x53"],
        ["\xE8\x85\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x54"],
        ["\xE8\x86\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x55"],
        ["\xE8\x86\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x56"],
        ["\xE8\x86\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x57"],
        ["\xE8\x86\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x58"],
        ["\xE8\x86\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x59"],
        ["\xE8\x86\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x5A"],
        ["\xE8\x86\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x5B"],
        ["\xE8\x87\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x5C"],
        ["\xE8\x87\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x5D"],
        ["\xE8\x86\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x5E"],
        ["\xE8\x87\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x5F"],
        ["\xE8\x87\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x60"],
        ["\xE8\x87\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x61"],
        ["\xE8\x87\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x62"],
        ["\xE8\x87\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x63"],
        ["\xE8\x87\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x64"],
        ["\xE8\x87\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x65"],
        ["\xE8\x87\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x66"],
        ["\xE8\x87\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x67"],
        ["\xE8\x87\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x68"],
        ["\xE8\x87\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],
        ["\xE8\x87\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x6A"],
        ["\xE8\x87\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x6B"],
        ["\xE8\x88\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x6C"],
        ["\xE8\x88\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x6D"],
        ["\xE8\x88\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x6E"],
        ["\xE8\x88\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x6F"],
        ["\xE8\x88\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x70"],
        ["\xE8\x88\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x71"],
        ["\xE8\x88\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x72"],
        ["\xE8\x88\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x73"],
        ["\xE8\x88\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x74"],
        ["\xE8\x88\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x75"],
        ["\xE8\x88\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x76"],
        ["\xE8\x88\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x77"],
        ["\xE8\x89\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x78"],
        ["\xE8\x89\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x79"],
        ["\xE8\x89\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x7A"],
        ["\xE8\x89\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x7B"],
        ["\xE8\x89\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x7C"],
        ["\xE8\x89\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x7D"],
        ["\xE8\x89\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x7E"],
        ["\xE8\x89\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x80"],
        ["\xE8\x89\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x81"],
        ["\xE8\x89\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x82"],
        ["\xE8\x89\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x83"],
        ["\xE8\x88\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x84"],
        ["\xE8\x89\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x85"],
        ["\xE8\x89\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x86"],
        ["\xE8\x89\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x87"],
        ["\xE8\x89\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x88"],
        ["\xE8\x8A\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x89"],
        ["\xE8\x8A\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x8A"],
        ["\xE8\x8A\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B"],
        ["\xE8\x8A\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x8C"],
        ["\xE8\x8A\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x8D"],
        ["\xE8\x8A\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x8E"],
        ["\xE8\x8B\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x8F"],
        ["\xE8\x8B\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x90"],
        ["\xE8\x8B\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x91"],
        ["\xE8\x8B\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x92"],
        ["\xE8\x8B\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x93"],
        ["\xE8\x8B\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x94"],
        ["\xE8\x8B\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x95"],
        ["\xE8\x8E\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x96"],
        ["\xE8\x8C\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x97"],
        ["\xE8\x8B\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x98"],
        ["\xE8\x8B\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x99"],
        ["\xE8\x8B\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x9A"],
        ["\xE8\x8C\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x9B"],
        ["\xE8\x8B\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x9C"],
        ["\xE8\x8C\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x9D"],
        ["\xE8\x8B\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x9E"],
        ["\xE8\x8C\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x9F"],
        ["\xE8\x8C\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA0"],
        ["\xE8\x8C\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\xE8\x8C\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\xE8\x8C\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\xE8\x8D\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\xE8\x8C\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\xE8\x8D\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\xE8\x8D\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\xE8\x8C\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\xE8\x8C\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\xE8\x8C\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\xE8\x8C\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\xE8\x8E\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\xE8\x8E\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\xE8\x8E\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\xE8\x8E\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\xE8\x8E\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\xE8\x8E\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\xE8\x8C\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\xE8\x8E\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\xE8\x8E\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\xE8\x8E\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\xE8\x8D\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\xE8\x8E\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\xE8\x8D\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\xE8\x8D\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\xE8\x8E\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\xE8\x8E\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\xE8\x8E\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\xE8\x8F\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\xE8\x90\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\xE8\x8F\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\xE8\x8F\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xE8\x8F\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xE8\x90\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xE8\x8F\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xE8\x90\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xE8\x8F\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xE8\x8F\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xE8\x90\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xE8\x8F\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xE8\x8F\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xE8\x90\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\xE8\x90\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\xE8\x90\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\xE8\x8E\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\xE8\x90\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\xE8\x94\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\xE8\x8F\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\xE8\x91\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\xE8\x90\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\xE8\x90\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\xE8\x95\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\xE8\x92\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\xE8\x91\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\xE8\x91\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\xE8\x92\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\xE8\x91\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\xE8\x92\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\xE8\x91\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\xE8\x91\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\xE8\x90\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\xE8\x91\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\xE8\x91\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\xE8\x90\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\xE8\x93\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\xE8\x91\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\xE8\x92\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\xE8\x92\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\xE8\x92\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\xE8\x93\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\xE8\x93\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\xE8\x92\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\xE8\x93\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\xE8\x93\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\xE8\x93\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\xE8\x93\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\xE8\x93\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\xE8\x92\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\xE8\x94\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\xE8\x93\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\xE8\x93\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\xE8\x94\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\xE8\x94\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\xE8\x94\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\xE8\x94\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\xE8\x94\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\xE8\x94\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\xE8\x93\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\xE8\x95\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\xE8\x95\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\xE8\x95\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\xE8\x95\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\xE8\x95\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x40"],
        ["\xE8\x98\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x41"],
        ["\xE8\x95\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x42"],
        ["\xE8\x95\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x43"],
        ["\xE8\x96\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x44"],
        ["\xE8\x96\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x45"],
        ["\xE8\x96\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x46"],
        ["\xE8\x96\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x47"],
        ["\xE8\x96\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x48"],
        ["\xE8\x96\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x49"],
        ["\xE8\x95\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x4A"],
        ["\xE8\x96\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x4B"],
        ["\xE8\x96\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x4C"],
        ["\xE8\x97\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x4D"],
        ["\xE8\x96\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x4E"],
        ["\xE8\x96\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x4F"],
        ["\xE8\x95\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x50"],
        ["\xE8\x95\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x51"],
        ["\xE8\x96\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x52"],
        ["\xE8\x97\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x53"],
        ["\xE8\x96\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x54"],
        ["\xE8\x97\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x55"],
        ["\xE8\x96\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x56"],
        ["\xE8\x97\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x57"],
        ["\xE8\x97\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x58"],
        ["\xE8\x97\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x59"],
        ["\xE8\x97\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x5A"],
        ["\xE8\x97\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x5B"],
        ["\xE8\x97\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x5C"],
        ["\xE8\x98\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x5D"],
        ["\xE8\x98\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x5E"],
        ["\xE8\x98\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x5F"],
        ["\xE8\x97\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x60"],
        ["\xE8\x97\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x61"],
        ["\xE8\x98\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x62"],
        ["\xE8\x98\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x63"],
        ["\xE8\x98\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x64"],
        ["\xE8\x98\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x65"],
        ["\xE8\x98\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x66"],
        ["\xE8\x99\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x67"],
        ["\xE4\xB9\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x68"],
        ["\xE8\x99\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x69"],
        ["\xE8\x99\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x6A"],
        ["\xE8\x99\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x6B"],
        ["\xE8\x99\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x6C"],
        ["\xE8\x9A\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x6D"],
        ["\xE8\x9A\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x6E"],
        ["\xE8\x9A\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x6F"],
        ["\xE8\x9A\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x70"],
        ["\xE8\x9A\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x71"],
        ["\xE8\x9A\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x72"],
        ["\xE8\x9A\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x73"],
        ["\xE8\x9A\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x74"],
        ["\xE8\x9B\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x75"],
        ["\xE8\x9B\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x76"],
        ["\xE8\x9A\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x77"],
        ["\xE8\x9B\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x78"],
        ["\xE8\xA0\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x79"],
        ["\xE8\x9A\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x7A"],
        ["\xE8\x9B\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x7B"],
        ["\xE8\x9B\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x7C"],
        ["\xE8\x9B\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x7D"],
        ["\xE8\x9B\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x7E"],
        ["\xE8\x9B\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x80"],
        ["\xE8\x9B\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x81"],
        ["\xE8\x9B\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x82"],
        ["\xE8\x9C\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x83"],
        ["\xE8\x9C\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x84"],
        ["\xE8\x9C\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x85"],
        ["\xE8\x9C\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x86"],
        ["\xE8\x9C\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x87"],
        ["\xE8\x9B\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x88"],
        ["\xE8\x9C\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x89"],
        ["\xE8\x9C\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A"],
        ["\xE8\x9C\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B"],
        ["\xE8\x9B\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C"],
        ["\xE8\x9C\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D"],
        ["\xE8\x9C\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E"],
        ["\xE8\x9C\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F"],
        ["\xE8\x9C\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x90"],
        ["\xE8\x9C\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x91"],
        ["\xE8\x9C\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x92"],
        ["\xE8\x9C\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x93"],
        ["\xE8\x9C\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x94"],
        ["\xE8\x9D\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x95"],
        ["\xE8\x9D\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x96"],
        ["\xE8\x9D\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x97"],
        ["\xE8\x9D\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x98"],
        ["\xE8\x9D\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x99"],
        ["\xE8\x9D\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A"],
        ["\xE8\x9D\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B"],
        ["\xE8\x9D\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C"],
        ["\xE8\x9D\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D"],
        ["\xE8\x9D\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E"],
        ["\xE8\x9D\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F"],
        ["\xE8\x9D\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0"],
        ["\xE8\x9D\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\xE8\xA0\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\xE8\x9E\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\xE8\x9E\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\xE8\x9E\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\xE8\x9E\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\xE8\x9F\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\xE8\x9E\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\xE8\x9F\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\xE8\x9F\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\xE9\x9B\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\xE8\x9E\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\xE8\x9F\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\xE8\x9E\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\xE8\x9F\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\xE8\x9F\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\xE8\x9E\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\xE8\x9F\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\xE8\x9F\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\xE8\x9F\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\xE8\xA0\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\xE8\xA0\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\xE8\x9F\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\xE8\x9F\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\xE8\x9F\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\xE8\xA0\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\xE8\x9F\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\xE8\xA0\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\xE8\xA0\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\xE8\xA0\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\xE8\xA0\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\xE8\xA0\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\xE8\xA0\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\xE8\xA0\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\xE8\xA0\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\xE8\xA0\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\xE8\xA0\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\xE8\xA1\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\xE8\xA1\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\xE8\xA1\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\xE8\xA1\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\xE8\xA1\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\xE8\xA1\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\xE8\xA1\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\xE8\xA2\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\xE8\xA1\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\xE8\xA2\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\xE8\xA1\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\xE8\xA1\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\xE8\xA2\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\xE8\xA1\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\xE8\xA2\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\xE8\xA2\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\xE8\xA2\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\xE8\xA2\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\xE8\xA2\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\xE8\xA2\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\xE8\xA2\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\xE8\xA2\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\xE8\xA2\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\xE8\xA2\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\xE8\xA2\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\xE8\xA3\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\xE8\xA3\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\xE8\xA3\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\xE8\xA3\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\xE8\xA3\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\xE8\xA3\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\xE8\xA3\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\xE8\xA4\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\xE8\xA3\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\xE8\xA3\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\xE8\xA3\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\xE8\xA3\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\xE8\xA4\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\xE8\xA4\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\xE8\xA4\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\xE8\xA4\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\xE8\xA5\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\xE8\xA4\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\xE8\xA4\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\xE8\xA4\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\xE8\xA4\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\xE8\xA5\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\xE8\xA5\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\xE8\xA4\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\xE8\xA4\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\xE8\xA4\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\xE8\xA5\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\xE8\xA4\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\xE8\xA5\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\xE8\xA5\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\xE8\xA5\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x40"],
        ["\xE8\xA5\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x41"],
        ["\xE8\xA5\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x42"],
        ["\xE8\xA5\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x43"],
        ["\xE8\xA5\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x44"],
        ["\xE8\xA5\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x45"],
        ["\xE8\xA5\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x46"],
        ["\xE8\xA5\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x47"],
        ["\xE8\xA6\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x48"],
        ["\xE8\xA6\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x49"],
        ["\xE8\xA6\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x4A"],
        ["\xE8\xA6\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x4B"],
        ["\xE8\xA6\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x4C"],
        ["\xE8\xA6\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x4D"],
        ["\xE8\xA6\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x4E"],
        ["\xE8\xA6\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x4F"],
        ["\xE8\xA6\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x50"],
        ["\xE8\xA6\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x51"],
        ["\xE8\xA6\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x52"],
        ["\xE8\xA6\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x53"],
        ["\xE8\xA6\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x54"],
        ["\xE8\xA6\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x55"],
        ["\xE8\xA7\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x56"],
        ["\xE8\xA7\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x57"],
        ["\xE8\xA7\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x58"],
        ["\xE8\xA7\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x59"],
        ["\xE8\xA7\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x5A"],
        ["\xE8\xA7\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x5B"],
        ["\xE8\xA7\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x5C"],
        ["\xE8\xA8\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x5D"],
        ["\xE8\xA8\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x5E"],
        ["\xE8\xA8\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x5F"],
        ["\xE8\xA8\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x60"],
        ["\xE8\xA8\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x61"],
        ["\xE8\xA8\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x62"],
        ["\xE8\xA8\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x63"],
        ["\xE8\xA8\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x64"],
        ["\xE8\xA9\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x65"],
        ["\xE8\xA9\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x66"],
        ["\xE8\xA9\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x67"],
        ["\xE8\xA9\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x68"],
        ["\xE8\xA9\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x69"],
        ["\xE8\xA9\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x6A"],
        ["\xE8\xA9\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x6B"],
        ["\xE8\xA9\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x6C"],
        ["\xE8\xA9\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x6D"],
        ["\xE8\xAA\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x6E"],
        ["\xE8\xAA\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x6F"],
        ["\xE8\xAA\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x70"],
        ["\xE8\xAA\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x71"],
        ["\xE8\xAA\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x72"],
        ["\xE8\xAA\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x73"],
        ["\xE8\xAA\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x74"],
        ["\xE8\xAA\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x75"],
        ["\xE8\xAA\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x76"],
        ["\xE8\xAA\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x77"],
        ["\xE8\xAB\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x78"],
        ["\xE8\xAB\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x79"],
        ["\xE8\xAB\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x7A"],
        ["\xE8\xAB\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x7B"],
        ["\xE8\xAB\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x7C"],
        ["\xE8\xAB\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x7D"],
        ["\xE8\xAB\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x7E"],
        ["\xE8\xAB\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x80"],
        ["\xE8\xAB\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x81"],
        ["\xE8\xAC\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x82"],
        ["\xE8\xAB\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x83"],
        ["\xE8\xAB\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x84"],
        ["\xE8\xAB\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x85"],
        ["\xE8\xAB\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x86"],
        ["\xE8\xAB\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x87"],
        ["\xE8\xAC\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x88"],
        ["\xE8\xAC\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x89"],
        ["\xE8\xAC\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A"],
        ["\xE8\xAB\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B"],
        ["\xE8\xAC\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C"],
        ["\xE8\xAC\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D"],
        ["\xE8\xAC\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E"],
        ["\xE8\xAC\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F"],
        ["\xE8\xAC\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x90"],
        ["\xE9\x9E\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x91"],
        ["\xE8\xAC\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x92"],
        ["\xE8\xAC\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x93"],
        ["\xE8\xAC\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x94"],
        ["\xE8\xAC\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x95"],
        ["\xE8\xAD\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x96"],
        ["\xE8\xAD\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x97"],
        ["\xE8\xAD\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x98"],
        ["\xE8\xAD\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x99"],
        ["\xE8\xAD\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A"],
        ["\xE8\xAD\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B"],
        ["\xE8\xAD\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C"],
        ["\xE8\xAD\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D"],
        ["\xE8\xAD\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E"],
        ["\xE8\xAD\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F"],
        ["\xE8\xAD\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0"],
        ["\xE8\xAD\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\xE8\xAD\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],
        ["\xE8\xAD\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],
        ["\xE8\xAE\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],
        ["\xE8\xAE\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],
        ["\xE8\xAE\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\xE8\xAE\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\xE8\xAE\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\xE8\xAE\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\xE8\xAE\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],
        ["\xE8\xAE\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\xE8\xB0\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\xE8\xB1\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],
        ["\xE8\xB0\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\xE8\xB1\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\xE8\xB1\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\xE8\xB1\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],
        ["\xE8\xB1\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],
        ["\xE8\xB1\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\xE8\xB1\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\xE8\xB1\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\xE8\xB1\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],
        ["\xE8\xB1\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],
        ["\xE8\xB2\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\xE8\xB2\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\xE8\xB2\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\xE8\xB2\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],
        ["\xE8\xB2\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],
        ["\xE8\xB2\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],
        ["\xE8\xB2\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],
        ["\xE8\xB1\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],
        ["\xE8\xB2\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\xE6\x88\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\xE8\xB2\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\xE8\xB2\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\xE8\xB2\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\xE8\xB2\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\xE8\xB2\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\xE8\xB2\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\xE8\xB2\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\xE8\xB3\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\xE8\xB3\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],
        ["\xE8\xB3\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],
        ["\xE8\xB3\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],
        ["\xE8\xB3\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],
        ["\xE8\xB3\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],
        ["\xE8\xB3\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\xE8\xB3\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\xE8\xB4\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\xE8\xB4\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\xE8\xB4\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\xE8\xB4\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\xE8\xB4\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\xE8\xB4\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\xE8\xB4\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\xE9\xBD\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\xE8\xB4\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\xE8\xB3\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\xE8\xB4\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\xE8\xB4\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\xE8\xB5\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\xE8\xB5\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],
        ["\xE8\xB5\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],
        ["\xE8\xB5\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\xE8\xB6\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],
        ["\xE8\xB6\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\xE8\xB7\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\xE8\xB6\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\xE8\xB6\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\xE8\xB7\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\xE8\xB7\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\xE8\xB7\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\xE8\xB7\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\xE8\xB7\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],
        ["\xE8\xB7\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],
        ["\xE8\xB7\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],
        ["\xE8\xB7\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],
        ["\xE8\xB7\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],
        ["\xE8\xB7\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\xE8\xB7\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\xE8\xB8\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\xE8\xB8\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\xE8\xB7\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\xE8\xB8\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\xE8\xB8\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\xE8\xB8\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xE8\xB8\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\xE8\xB9\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\xE8\xB8\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\xE8\xB8\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],
        ["\xE8\xB8\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],
        ["\xE8\xB9\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],
        ["\xE8\xB9\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x40"],
        ["\xE8\xB9\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x41"],
        ["\xE8\xB9\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x42"],
        ["\xE8\xB9\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x43"],
        ["\xE8\xB9\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x44"],
        ["\xE8\xB9\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x45"],
        ["\xE8\xB9\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x46"],
        ["\xE8\xB9\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x47"],
        ["\xE8\xB8\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x48"],
        ["\xE8\xB9\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x49"],
        ["\xE8\xB9\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x4A"],
        ["\xE8\xB9\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x4B"],
        ["\xE8\xB9\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x4C"],
        ["\xE8\xB9\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x4D"],
        ["\xE8\xBA\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x4E"],
        ["\xE8\xBA\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x4F"],
        ["\xE8\xBA\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x50"],
        ["\xE8\xBA\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x51"],
        ["\xE8\xBA\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x52"],
        ["\xE8\xBA\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x53"],
        ["\xE8\xBA\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x54"],
        ["\xE8\xBA\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x55"],
        ["\xE8\xBA\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x56"],
        ["\xE8\xBA\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x57"],
        ["\xE8\xBA\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x58"],
        ["\xE8\xBA\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x59"],
        ["\xE8\xBA\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x5A"],
        ["\xE8\xBA\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x5B"],
        ["\xE8\xBB\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x5C"],
        ["\xE8\xBA\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x5D"],
        ["\xE8\xBA\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x5E"],
        ["\xE8\xBB\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x5F"],
        ["\xE8\xBB\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x60"],
        ["\xE8\xBB\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x61"],
        ["\xE8\xBB\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x62"],
        ["\xE8\xBB\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x63"],
        ["\xE8\xBB\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x64"],
        ["\xE8\xBB\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x65"],
        ["\xE8\xBB\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x66"],
        ["\xE8\xBB\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x67"],
        ["\xE8\xBC\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],
        ["\xE8\xBC\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x69"],
        ["\xE8\xBC\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6A"],
        ["\xE8\xBC\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6B"],
        ["\xE8\xBC\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6C"],
        ["\xE8\xBC\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6D"],
        ["\xE8\xBC\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6E"],
        ["\xE8\xBC\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6F"],
        ["\xE8\xBC\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x70"],
        ["\xE8\xBC\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x71"],
        ["\xE8\xBC\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x72"],
        ["\xE8\xBC\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x73"],
        ["\xE8\xBC\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x74"],
        ["\xE8\xBC\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x75"],
        ["\xE8\xBD\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x76"],
        ["\xE8\xBD\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x77"],
        ["\xE8\xBC\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x78"],
        ["\xE8\xBD\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x79"],
        ["\xE8\xBD\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x7A"],
        ["\xE8\xBD\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x7B"],
        ["\xE8\xBD\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x7C"],
        ["\xE8\xBD\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x7D"],
        ["\xE8\xBD\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x7E"],
        ["\xE8\xBD\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x80"],
        ["\xE8\xBD\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x81"],
        ["\xE8\xBD\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x82"],
        ["\xE8\xBE\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x83"],
        ["\xE8\xBE\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x84"],
        ["\xE8\xBE\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x85"],
        ["\xE8\xBE\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x86"],
        ["\xE8\xBE\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x87"],
        ["\xE8\xBE\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x88"],
        ["\xE8\xBF\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x89"],
        ["\xE8\xBF\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A"],
        ["\xE8\xBF\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B"],
        ["\xE8\xBF\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C"],
        ["\xE8\xBF\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D"],
        ["\xE9\x82\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E"],
        ["\xE8\xBF\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F"],
        ["\xE9\x80\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x90"],
        ["\xE8\xBF\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x91"],
        ["\xE8\xBF\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x92"],
        ["\xE9\x80\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x93"],
        ["\xE9\x80\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x94"],
        ["\xE9\x80\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x95"],
        ["\xE9\x80\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x96"],
        ["\xE9\x80\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x97"],
        ["\xE9\x80\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x98"],
        ["\xE9\x80\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x99"],
        ["\xE9\x80\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A"],
        ["\xE9\x80\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B"],
        ["\xE9\x80\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C"],
        ["\xE9\x80\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D"],
        ["\xE8\xBF\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E"],
        ["\xE9\x81\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F"],
        ["\xE9\x81\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0"],
        ["\xE9\x81\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\xE9\x81\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],
        ["\xE9\x80\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],
        ["\xE9\x81\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],
        ["\xE9\x80\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],
        ["\xE9\x81\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],
        ["\xE9\x81\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],
        ["\xE9\x81\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],
        ["\xE9\x81\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],
        ["\xE9\x81\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\xE9\x81\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\xE9\x9A\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],
        ["\xE9\x81\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],
        ["\xE9\x82\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],
        ["\xE9\x81\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\xE9\x82\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\xE9\x82\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\xE9\x82\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\xE9\x82\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\xE9\x82\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\xE9\x82\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\xE9\x82\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\xE9\x82\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\xE9\x82\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\xE9\x83\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\xE9\x83\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\xE6\x89\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\xE9\x83\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\xE9\x84\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\xE9\x84\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\xE9\x84\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\xE9\x84\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\xE9\x84\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\xE9\x85\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\xE9\x85\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\xE9\x85\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\xE9\x85\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\xE9\x85\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\xE9\x85\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\xE9\x85\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\xE9\x85\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\xE9\x86\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\xE9\x86\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\xE9\x86\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\xE9\x86\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],
        ["\xE9\x86\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],
        ["\xE9\x86\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],
        ["\xE9\x86\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\xE9\x86\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\xE9\x86\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\xE9\x86\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\xE9\x87\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\xE9\x87\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\xE9\x87\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\xE9\x87\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\xE9\x87\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\xE9\x87\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\xE9\x87\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],
        ["\xE9\x87\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],
        ["\xE9\x87\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],
        ["\xE9\x87\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],
        ["\xE9\x87\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],
        ["\xE9\x87\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],
        ["\xE9\x88\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\xE9\x87\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],
        ["\xE9\x88\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\xE9\x88\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\xE9\x88\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\xE9\x88\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\xE9\x89\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\xE9\x89\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\xE9\x89\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\xE9\x89\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\xE9\x89\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],
        ["\xE9\x89\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],
        ["\xE9\x8A\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],
        ["\xE9\x88\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],
        ["\xE9\x89\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],
        ["\xE9\x89\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],
        ["\xE9\x8A\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\xE9\x8A\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\xE9\x8A\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\xE9\x8A\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\xE9\x89\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\xE9\x8B\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\xE9\x8A\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\xE9\x8A\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\xE9\x8B\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\xE9\x8C\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\xE9\x8B\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],
        ["\xE9\x8D\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],
        ["\xE9\x8C\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],
        ["\xE9\x8C\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x40"],
        ["\xE9\x8C\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x41"],
        ["\xE9\x8C\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x42"],
        ["\xE9\x8C\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x43"],
        ["\xE9\x8C\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x44"],
        ["\xE9\x8C\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x45"],
        ["\xE9\x8C\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x46"],
        ["\xE9\x8D\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x47"],
        ["\xE9\x8D\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x48"],
        ["\xE9\x8D\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x49"],
        ["\xE9\x8D\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x4A"],
        ["\xE9\x8D\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x4B"],
        ["\xE9\x8E\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x4C"],
        ["\xE9\x8E\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x4D"],
        ["\xE9\x8E\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x4E"],
        ["\xE9\x8E\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x4F"],
        ["\xE9\x8E\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x50"],
        ["\xE9\x8F\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x51"],
        ["\xE9\x8F\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x52"],
        ["\xE9\x8F\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x53"],
        ["\xE9\x8F\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x54"],
        ["\xE9\x8F\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x55"],
        ["\xE9\x8F\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x56"],
        ["\xE9\x8F\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x57"],
        ["\xE9\x8F\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x58"],
        ["\xE9\x8F\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x59"],
        ["\xE9\x8F\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x5A"],
        ["\xE9\x90\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x5B"],
        ["\xE9\x90\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x5C"],
        ["\xE9\x90\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x5D"],
        ["\xE9\x90\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x5E"],
        ["\xE9\x90\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x5F"],
        ["\xE9\x90\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x60"],
        ["\xE9\x90\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x61"],
        ["\xE9\x90\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x62"],
        ["\xE9\x90\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x63"],
        ["\xE9\x90\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x64"],
        ["\xE9\x90\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x65"],
        ["\xE9\x91\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x66"],
        ["\xE9\x91\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x67"],
        ["\xE9\x91\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x68"],
        ["\xE9\x91\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x69"],
        ["\xE9\x91\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x6A"],
        ["\xE9\x91\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x6B"],
        ["\xE9\x91\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x6C"],
        ["\xE9\x91\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x6D"],
        ["\xE9\x88\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x6E"],
        ["\xE9\x91\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x6F"],
        ["\xE9\x91\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x70"],
        ["\xE9\x91\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x71"],
        ["\xE9\x91\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x72"],
        ["\xE9\x91\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x73"],
        ["\xE9\x91\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x74"],
        ["\xE9\x91\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x75"],
        ["\xE9\x92\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x76"],
        ["\xE9\x91\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x77"],
        ["\xE9\x96\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x78"],
        ["\xE9\x96\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x79"],
        ["\xE9\x96\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x7A"],
        ["\xE9\x96\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x7B"],
        ["\xE9\x96\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x7C"],
        ["\xE9\x96\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x7D"],
        ["\xE9\x96\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x7E"],
        ["\xE9\x96\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x80"],
        ["\xE9\x96\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x81"],
        ["\xE9\x96\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x82"],
        ["\xE9\x96\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x83"],
        ["\xE9\x96\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x84"],
        ["\xE9\x96\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x85"],
        ["\xE9\x96\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x86"],
        ["\xE9\x96\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x87"],
        ["\xE9\x97\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x88"],
        ["\xE6\xBF\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x89"],
        ["\xE9\x97\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A"],
        ["\xE9\x97\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B"],
        ["\xE9\x97\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C"],
        ["\xE9\x97\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D"],
        ["\xE9\x97\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E"],
        ["\xE9\x97\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F"],
        ["\xE9\x97\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x90"],
        ["\xE9\x97\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x91"],
        ["\xE9\x97\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x92"],
        ["\xE9\x97\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x93"],
        ["\xE9\x98\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x94"],
        ["\xE9\x98\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x95"],
        ["\xE9\x98\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x96"],
        ["\xE9\x98\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x97"],
        ["\xE9\x99\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x98"],
        ["\xE9\x99\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x99"],
        ["\xE9\x99\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A"],
        ["\xE9\x99\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B"],
        ["\xE9\x99\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C"],
        ["\xE9\x99\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D"],
        ["\xE9\x99\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E"],
        ["\xE9\x99\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F"],
        ["\xE9\x99\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0"],
        ["\xE9\x99\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\xE9\x99\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],
        ["\xE9\x99\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],
        ["\xE9\x9A\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],
        ["\xE9\x9A\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],
        ["\xE9\x9A\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],
        ["\xE9\x9A\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],
        ["\xE9\x9A\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],
        ["\xE9\x9A\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],
        ["\xE9\x9A\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\xE9\x9A\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xE9\x9A\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],
        ["\xE9\x9A\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],
        ["\xE9\x9A\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\xE9\x9A\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],
        ["\xE9\x9A\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\xE9\x9B\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],
        ["\xE9\x9B\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\xE9\x9B\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],
        ["\xE9\x9B\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],
        ["\xE8\xA5\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],
        ["\xE9\x9B\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],
        ["\xE9\x9C\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],
        ["\xE9\x9B\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\xE9\x9B\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],
        ["\xE9\x9C\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],
        ["\xE9\x9C\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],
        ["\xE9\x9C\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],
        ["\xE9\x9C\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],
        ["\xE9\x9C\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],
        ["\xE9\x9C\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],
        ["\xE9\x9C\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\xE9\x9C\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\xE9\x9C\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\xE9\x9C\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\xE9\x9C\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\xE9\x9C\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\xE9\x9C\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\xE9\x9C\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\xE9\x9C\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\xE9\x9D\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\xE9\x9D\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],
        ["\xE9\x9D\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],
        ["\xE9\x9D\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],
        ["\xE9\x9D\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],
        ["\xE9\x9D\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],
        ["\xE9\x9D\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],
        ["\xE9\x9D\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\xE9\x9D\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\xE9\x9D\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\xE5\x8B\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\xE9\x9D\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\xE9\x9D\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\xE9\x9D\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\xE9\x9E\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\xE9\x9D\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xE9\x9E\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xE9\x9D\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\xE9\x9E\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\xE9\x9E\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],
        ["\xE9\x9E\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],
        ["\xE9\x9E\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],
        ["\xE9\x9E\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],
        ["\xE9\x9E\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\xE9\x9E\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],
        ["\xE9\x9E\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\xE9\x9E\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\xE9\x9E\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\xE9\x9F\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\xE9\x9F\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\xE9\x9F\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\xE9\x9F\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\xE9\x9F\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\xE9\x9F\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],
        ["\xE9\xBD\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\xE9\x9F\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\xE7\xAB\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],
        ["\xE9\x9F\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],
        ["\xE9\x9F\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],
        ["\xE9\xA0\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\xE9\xA0\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\xE9\xA0\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\xE9\xA0\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\xE9\xA0\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\xE9\xA0\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\xE9\xA0\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\xE9\xA1\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\xE9\xA1\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\xE9\xA1\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xE9\xA1\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\xE9\xA1\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\xE9\xA1\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],
        ["\xE9\xA1\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x40"],
        ["\xE9\xA1\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x41"],
        ["\xE9\xA1\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x42"],
        ["\xE9\xA2\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x43"],
        ["\xE9\xA2\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x44"],
        ["\xE9\xA2\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x45"],
        ["\xE9\xA2\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x46"],
        ["\xE9\xA3\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x47"],
        ["\xE9\xA3\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x48"],
        ["\xE9\xA3\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x49"],
        ["\xE9\xA3\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x4A"],
        ["\xE9\xA3\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x4B"],
        ["\xE9\xA4\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x4C"],
        ["\xE9\xA4\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x4D"],
        ["\xE9\xA4\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x4E"],
        ["\xE9\xA4\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x4F"],
        ["\xE9\xA4\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x50"],
        ["\xE9\xA4\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x51"],
        ["\xE9\xA4\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x52"],
        ["\xE9\xA4\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x53"],
        ["\xE9\xA4\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x54"],
        ["\xE9\xA4\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x55"],
        ["\xE9\xA4\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x56"],
        ["\xE9\xA4\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x57"],
        ["\xE9\xA4\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x58"],
        ["\xE9\xA4\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x59"],
        ["\xE9\xA5\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x5A"],
        ["\xE9\xA5\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x5B"],
        ["\xE9\xA5\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x5C"],
        ["\xE9\xA5\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x5D"],
        ["\xE9\xA5\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x5E"],
        ["\xE9\xA5\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x5F"],
        ["\xE9\xA5\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x60"],
        ["\xE9\xA5\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x61"],
        ["\xE9\xA5\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x62"],
        ["\xE9\xA6\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x63"],
        ["\xE9\xA6\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x64"],
        ["\xE9\xA6\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x65"],
        ["\xE9\xA6\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x66"],
        ["\xE9\xA6\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x67"],
        ["\xE9\xA6\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x68"],
        ["\xE9\xA7\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x69"],
        ["\xE9\xA7\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6A"],
        ["\xE9\xA7\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6B"],
        ["\xE9\xA7\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6C"],
        ["\xE9\xA7\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6D"],
        ["\xE9\xA7\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6E"],
        ["\xE9\xA7\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6F"],
        ["\xE9\xA7\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x70"],
        ["\xE9\xA7\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x71"],
        ["\xE9\xA7\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x72"],
        ["\xE9\xA7\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x73"],
        ["\xE9\xA8\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x74"],
        ["\xE9\xA8\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x75"],
        ["\xE9\xA8\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x76"],
        ["\xE9\xA7\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x77"],
        ["\xE9\xA8\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x78"],
        ["\xE9\xA8\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x79"],
        ["\xE9\xA8\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x7A"],
        ["\xE9\xA9\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x7B"],
        ["\xE9\xA9\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x7C"],
        ["\xE9\xA9\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x7D"],
        ["\xE9\xA9\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x7E"],
        ["\xE9\xA8\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x80"],
        ["\xE9\xA9\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x81"],
        ["\xE9\xA9\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x82"],
        ["\xE9\xA9\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x83"],
        ["\xE9\xA9\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x84"],
        ["\xE9\xA9\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x85"],
        ["\xE9\xA9\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x86"],
        ["\xE9\xA9\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x87"],
        ["\xE9\xA9\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x88"],
        ["\xE9\xA9\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x89"],
        ["\xE9\xA9\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A"],
        ["\xE9\xA9\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B"],
        ["\xE9\xAA\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C"],
        ["\xE9\xAA\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D"],
        ["\xE9\xAA\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E"],
        ["\xE9\xAB\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F"],
        ["\xE9\xAB\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x90"],
        ["\xE9\xAB\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x91"],
        ["\xE9\xAB\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x92"],
        ["\xE9\xAB\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x93"],
        ["\xE9\xAB\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x94"],
        ["\xE9\xAB\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x95"],
        ["\xE9\xAB\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x96"],
        ["\xE9\xAB\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x97"],
        ["\xE9\xAB\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x98"],
        ["\xE9\xAB\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x99"],
        ["\xE9\xAB\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A"],
        ["\xE9\xAB\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B"],
        ["\xE9\xAB\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C"],
        ["\xE9\xAB\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D"],
        ["\xE9\xAB\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E"],
        ["\xE9\xAB\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F"],
        ["\xE9\xAC\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0"],
        ["\xE9\xAC\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\xE9\xAC\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],
        ["\xE9\xAC\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],
        ["\xE9\xAC\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],
        ["\xE9\xAC\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],
        ["\xE9\xAC\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],
        ["\xE9\xAC\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],
        ["\xE9\xAC\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],
        ["\xE9\xAC\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],
        ["\xE9\xAC\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],
        ["\xE9\xAC\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\xE9\xAC\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],
        ["\xE9\xAC\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],
        ["\xE9\xAD\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],
        ["\xE9\xAD\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],
        ["\xE9\xAD\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\xE9\xAD\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],
        ["\xE9\xAD\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],
        ["\xE9\xAD\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],
        ["\xE9\xAD\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],
        ["\xE9\xAD\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],
        ["\xE9\xAE\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],
        ["\xE9\xAE\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],
        ["\xE9\xAE\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],
        ["\xE9\xAE\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],
        ["\xE9\xAE\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],
        ["\xE9\xAE\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],
        ["\xE9\xAE\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],
        ["\xE9\xAE\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],
        ["\xE9\xAE\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],
        ["\xE9\xAF\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],
        ["\xE9\xAF\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\xE9\xAE\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\xE9\xAF\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\xE9\xAF\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\xE9\xAF\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\xE9\xAF\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\xE9\xAF\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\xE9\xAF\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\xE9\xAF\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\xE9\xAF\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\xE9\xAF\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],
        ["\xE9\xB0\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],
        ["\xE9\xAF\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],
        ["\xE9\xAF\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],
        ["\xE9\xAF\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],
        ["\xE9\xB0\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],
        ["\xE9\xB0\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\xE9\xB0\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\xE9\xB0\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\xE9\xB0\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\xE9\xB0\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\xE9\xB0\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\xE9\xB0\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\xE9\xB0\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\xE9\xB0\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\xE9\xB0\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\xE9\xB0\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],
        ["\xE9\xB0\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],
        ["\xE9\xB0\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],
        ["\xE9\xB0\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],
        ["\xE9\xB0\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],
        ["\xE9\xB1\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],
        ["\xE9\xB0\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\xE9\xB1\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],
        ["\xE9\xB0\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\xE9\xB1\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\xE9\xB1\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\xE9\xB1\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\xE9\xB1\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\xE9\xB1\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\xE9\xB3\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\xE9\xB3\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\xE9\xB3\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],
        ["\xE9\xB4\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],
        ["\xE9\xB4\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],
        ["\xE9\xB3\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],
        ["\xE9\xB4\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],
        ["\xE9\xB4\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],
        ["\xE9\xB4\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\xE9\xB4\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\xE9\xB6\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\xE9\xB4\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xE9\xB4\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\xE9\xB5\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\xE9\xB4\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\xE9\xB4\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\xE9\xB5\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\xE9\xB4\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\xE9\xB4\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],
        ["\xE9\xB5\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],
        ["\xE9\xB5\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],
        ["\xE9\xB5\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x40"],
        ["\xE9\xB5\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x41"],
        ["\xE9\xB5\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x42"],
        ["\xE9\xB5\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x43"],
        ["\xE9\xB5\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x44"],
        ["\xE9\xB5\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x45"],
        ["\xE9\xB5\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x46"],
        ["\xE9\xB6\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x47"],
        ["\xE9\xB6\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x48"],
        ["\xE9\xB6\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x49"],
        ["\xE9\xB5\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x4A"],
        ["\xE9\xB5\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x4B"],
        ["\xE9\xB6\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x4C"],
        ["\xE9\xB6\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x4D"],
        ["\xE9\xB6\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x4E"],
        ["\xE9\xB6\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x4F"],
        ["\xE9\xB7\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x50"],
        ["\xE9\xB7\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x51"],
        ["\xE9\xB6\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x52"],
        ["\xE9\xB6\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x53"],
        ["\xE9\xB6\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x54"],
        ["\xE9\xB7\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x55"],
        ["\xE9\xB7\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x56"],
        ["\xE9\xB7\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x57"],
        ["\xE9\xB7\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x58"],
        ["\xE9\xB7\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x59"],
        ["\xE9\xB7\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x5A"],
        ["\xE9\xB7\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x5B"],
        ["\xE9\xB7\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x5C"],
        ["\xE9\xB7\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x5D"],
        ["\xE9\xB7\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x5E"],
        ["\xE9\xB8\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x5F"],
        ["\xE9\xB8\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x60"],
        ["\xE9\xB8\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x61"],
        ["\xE9\xB9\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x62"],
        ["\xE9\xB9\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x63"],
        ["\xE9\xB9\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x64"],
        ["\xE9\xBA\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x65"],
        ["\xE9\xBA\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x66"],
        ["\xE9\xBA\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x67"],
        ["\xE9\xBA\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x68"],
        ["\xE9\xBA\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x69"],
        ["\xE9\xBA\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6A"],
        ["\xE9\xBA\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6B"],
        ["\xE9\xBA\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6C"],
        ["\xE9\xBA\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6D"],
        ["\xE9\xBA\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6E"],
        ["\xE9\xBA\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6F"],
        ["\xE9\xBA\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x70"],
        ["\xE9\xBA\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x71"],
        ["\xE9\x9D\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x72"],
        ["\xE9\xBB\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x73"],
        ["\xE9\xBB\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x74"],
        ["\xE9\xBB\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x75"],
        ["\xE9\xBB\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x76"],
        ["\xE9\xBB\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x77"],
        ["\xE9\xBB\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x78"],
        ["\xE9\xBB\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x79"],
        ["\xE9\xBB\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x7A"],
        ["\xE9\xBB\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x7B"],
        ["\xE9\xBB\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x7C"],
        ["\xE9\xBB\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x7D"],
        ["\xE9\xBB\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x7E"],
        ["\xE9\xBB\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x80"],
        ["\xE9\xBB\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x81"],
        ["\xE9\xBB\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x82"],
        ["\xE9\xBB\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x83"],
        ["\xE9\xBB\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x84"],
        ["\xE9\xBB\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x85"],
        ["\xE9\xBB\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x86"],
        ["\xE9\xBC\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x87"],
        ["\xE9\xBC\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x88"],
        ["\xE7\x9A\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x89"],
        ["\xE9\xBC\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8A"],
        ["\xE9\xBC\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8B"],
        ["\xE9\xBC\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8C"],
        ["\xE9\xBC\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8D"],
        ["\xE9\xBD\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8E"],
        ["\xE9\xBD\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8F"],
        ["\xE9\xBD\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x90"],
        ["\xE9\xBD\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x91"],
        ["\xE9\xBD\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x92"],
        ["\xE9\xBD\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x93"],
        ["\xE9\xBD\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x94"],
        ["\xE9\xBD\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x95"],
        ["\xE9\xBD\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x96"],
        ["\xE9\xBD\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x97"],
        ["\xE9\xBD\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x98"],
        ["\xE9\xBD\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x99"],
        ["\xE9\xBD\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x9A"],
        ["\xE9\xBD\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x9B"],
        ["\xE9\xBE\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x9C"],
        ["\xE9\xBE\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x9D"],
        ["\xE9\xBE\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x9E"],
        ["\xE5\xA0\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x9F"],
        ["\xE6\xA7\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA0"],
        ["\xE9\x81\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],
        ["\xE7\x91\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],
        ["\xE5\x87\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],
        ["\xE7\x86\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],
        ["\xE2\x85\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xB3"],
        ["\xE2\x85\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xB4"],
        ["\xE2\x85\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xB5"],
        ["\xE2\x85\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xB6"],
        ["\xE2\x85\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xB7"],
        ["\xE2\x85\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xB8"],
        ["\xE2\x85\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xB9"],
        ["\xE2\x85\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xBA"],
        ["\xE2\x85\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xBB"],
        ["\xE2\x85\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xBC"],
        ["\xEF\xBF\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xEF\xBC\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAD"],
        ["\xEF\xBC\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAE"],
        ["\xE7\xBA\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB5"],
        ["\xE8\xA4\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x8E"],
        ["\xE9\x8D\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x58"],
        ["\xE9\x8A\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x4D"],
        ["\xE8\x93\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xD3"],
        ["\xE4\xBF\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xB7"],
        ["\xE7\x82\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x80"],
        ["\xE6\x98\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x54"],
        ["\xE6\xA3\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x89"],
        ["\xE9\x8B\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x42"],
        ["\xE6\x9B\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x56"],
        ["\xE5\xBD\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB8"],
        ["\xE4\xB8\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xA2"],
        ["\xE4\xBB\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xA6"],
        ["\xE4\xBB\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE4\xBC\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x5E"],
        ["\xE4\xBC\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xA9"],
        ["\xE4\xBC\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE4\xBD\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xAE"],
        ["\xE4\xBE\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x6C"],
        ["\xE4\xBE\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xB3"],
        ["\xE4\xBE\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x6D"],
        ["\xE4\xBE\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xB4"],
        ["\xE4\xBF\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\x81\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xBF"],
        ["\xE5\x80\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x7C"],
        ["\xE4\xBF\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\x80\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x7B"],
        ["\xE5\x81\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x80"],
        ["\xE5\x81\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x87"],
        ["\xE5\x81\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x7E"],
        ["\xE5\x82\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xC2"],
        ["\xE5\x83\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\x83\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\x85\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xCD"],
        ["\xE5\x85\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\x86\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xD2"],
        ["\xE5\x86\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\x87\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\x88\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xDB"],
        ["\xE5\x8A\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\x8A\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x62"],
        ["\xE5\x8B\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\x8B\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xE5"],
        ["\xE5\x8C\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xE9"],
        ["\xE5\x8C\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xEA"],
        ["\xE5\x8C\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x6D"],
        ["\xE5\x8D\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\x8E\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xF0"],
        ["\xE5\x8E\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xF2"],
        ["\xE5\x8F\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xEF\xA8\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\x92\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xF6"],
        ["\xE5\x92\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x8C"],
        ["\xE5\x92\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x40"],
        ["\xE5\x93\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x42"],
        ["\xE5\x96\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x49"],
        ["\xE5\x9D\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\x9D\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\x9E\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEA"],
        ["\xE5\x9F\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x6E"],
        ["\xE5\x9F\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x6D"],
        ["\xEF\xA8\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x6A"],
        ["\xEF\xA8\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x76"],
        ["\xE5\xA2\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x7C"],
        ["\xE5\xA2\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\xA4\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x59"],
        ["\xE5\xA5\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\xA5\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x64"],
        ["\xE5\xA5\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x89"],
        ["\xE5\xA5\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\xA6\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x8D"],
        ["\xE5\xA6\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\xAD\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x75"],
        ["\xE5\xAF\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2"],
        ["\xE7\x94\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC7"],
        ["\xE5\xAF\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x78"],
        ["\xE5\xAF\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x79"],
        ["\xE5\xB0\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x7B"],
        ["\xE5\xB2\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],
        ["\xE5\xB2\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x89"],
        ["\xE5\xB3\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\xB4\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x91"],
        ["\xE5\xB5\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x95"],
        ["\xEF\xA8\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x92"],
        ["\xE5\xB5\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],
        ["\xE5\xB5\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x97"],
        ["\xE5\xB6\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x9C"],
        ["\xE5\xB6\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],
        ["\xE5\xB7\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\xBC\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE5\xBC\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB4"],
        ["\xE5\xBD\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBC"],
        ["\xE5\xBE\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC3"],
        ["\xE5\xBF\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC5"],
        ["\xE6\x81\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\x82\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\x82\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCB"],
        ["\xE6\x83\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\x83\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD3"],
        ["\xE6\x84\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\x83\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD6"],
        ["\xE6\x84\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\x84\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD9"],
        ["\xE6\x84\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD8"],
        ["\xE6\x86\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE7"],
        ["\xE6\x88\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\x8A\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x41"],
        ["\xE6\x8F\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF2"],
        ["\xE6\x91\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF8"],
        ["\xE6\x92\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x6F"],
        ["\xE6\x93\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xFA"],
        ["\xE6\x95\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\x98\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x4B"],
        ["\xE6\x98\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x4D"],
        ["\xE6\x98\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\x98\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x4C"],
        ["\xE6\x98\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\x98\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x4E"],
        ["\xE6\x98\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x51"],
        ["\xE6\x99\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x5D"],
        ["\xE6\x99\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x9E"],
        ["\xE6\x99\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x5A"],
        ["\xEF\xA8\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\x99\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x5E"],
        ["\xE6\x9A\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAB"],
        ["\xE6\x9A\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x63"],
        ["\xE6\x9A\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x64"],
        ["\xE6\x9A\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1"],
        ["\xE6\x9B\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x6B"],
        ["\xE6\x9C\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xEF\xA4\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x6D"],
        ["\xE6\x9D\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x6F"],
        ["\xE6\x9E\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x77"],
        ["\xE6\xA1\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x7D"],
        ["\xE6\x9F\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x79"],
        ["\xE6\xA0\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x7C"],
        ["\xE6\xA1\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xDD"],
        ["\xE6\xA3\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xFB"],
        ["\xEF\xA8\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF7"],
        ["\xE6\xA5\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x98"],
        ["\xEF\xA8\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x9A"],
        ["\xE6\xA6\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x55"],
        ["\xE6\xA7\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA0"],
        ["\xE6\xA8\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x60"],
        ["\xE6\xA9\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAE"],
        ["\xE6\xA9\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x72"],
        ["\xE6\xA9\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAF"],
        ["\xE6\xA9\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x79"],
        ["\xE6\xAB\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\xAB\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB6"],
        ["\xE6\xAF\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC9"],
        ["\xE6\xB0\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xB3"],
        ["\xE6\xB1\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD0"],
        ["\xE6\xB2\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD5"],
        ["\xE6\xB1\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\xB3\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xC2"],
        ["\xE6\xB4\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDF"],
        ["\xE6\xB6\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE9"],
        ["\xE6\xB5\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\xB6\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\xB6\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xED"],
        ["\xE6\xB7\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xE6"],
        ["\xE6\xB7\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\xB7\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\xB7\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF4"],
        ["\xE6\xB8\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE6\xB9\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF8"],
        ["\xE6\xB8\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xEE"],
        ["\xE6\xB8\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xF1"],
        ["\xE6\xBA\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x43"],
        ["\xE6\xBE\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x4E"],
        ["\xE6\xBE\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x60"],
        ["\xE6\xBF\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x5A"],
        ["\xE7\x80\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x5B"],
        ["\xE7\x80\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x69"],
        ["\xE7\x80\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x5D"],
        ["\xE7\x82\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x64"],
        ["\xE7\x82\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x66"],
        ["\xE7\x84\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x6B"],
        ["\xE7\x84\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x8B"],
        ["\xE7\x85\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x76"],
        ["\xE7\x85\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x71"],
        ["\xE7\x85\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x72"],
        ["\xEF\xA8\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x79"],
        ["\xE7\x87\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x7D"],
        ["\xE7\x87\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x81"],
        ["\xE7\x8A\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xBB"],
        ["\xE7\x8A\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x89"],
        ["\xE7\x8C\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xEF\xA8\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x8F"],
        ["\xE7\x8D\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xD5"],
        ["\xE7\x8E\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE7\x8F\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x99"],
        ["\xE7\x8F\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x9B"],
        ["\xE7\x8F\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x9D"],
        ["\xE7\x8F\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE7\x90\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x9F"],
        ["\xE7\x8F\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE7\x90\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA4"],
        ["\xE7\x90\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA6"],
        ["\xE7\x90\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE7\x90\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA9"],
        ["\xE7\x91\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB1"],
        ["\xE7\x92\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB6"],
        ["\xE7\x92\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB9"],
        ["\xE7\x94\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC5"],
        ["\xE7\x95\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC8"],
        ["\xE7\x9A\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE7\x9A\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x8F"],
        ["\xE7\x9A\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE1"],
        ["\xE7\x9A\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDF"],
        ["\xE7\x9A\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE2"],
        ["\xEF\xA8\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE7\x9D\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF0"],
        ["\xE5\x8A\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x63"],
        ["\xE7\xA0\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xC1"],
        ["\xE7\xA1\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x41"],
        ["\xE7\xA1\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xC4"],
        ["\xE7\xA1\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE7\xA4\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xDC"],
        ["\xEF\xA8\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xEF\xA8\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x5B"],
        ["\xEF\xA8\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x5C"],
        ["\xE7\xA6\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xE5"],
        ["\xEF\xA8\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x60"],
        ["\xE7\xA6\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xE8"],
        ["\xE7\xAB\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x58"],
        ["\xE7\xAB\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x59"],
        ["\xEF\xA8\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE7\xAB\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x77"],
        ["\xE7\xAE\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x83"],
        ["\xEF\xA8\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE7\xB5\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA0"],
        ["\xE7\xB5\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA2"],
        ["\xE7\xB6\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xC5"],
        ["\xE7\xB6\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA6"],
        ["\xE7\xB7\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAA"],
        ["\xE7\xB9\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB3"],
        ["\xE7\xBD\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB7"],
        ["\xE7\xBE\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xEF\xA8\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE8\x8C\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEA"],
        ["\xE8\x8D\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEB"],
        ["\xE8\x8D\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xB1"],
        ["\xE8\x8F\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xFB"],
        ["\xE8\x8F\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE8\x91\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x47"],
        ["\xE8\x92\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x4E"],
        ["\xE8\x95\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xEF"],
        ["\xE8\x95\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x57"],
        ["\xE8\x95\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xEF\xA8\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x59"],
        ["\xE8\x96\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x5F"],
        ["\xEF\xA8\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x57"],
        ["\xEF\xA8\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x64"],
        ["\xE8\xA0\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE8\xA3\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x8D"],
        ["\xE8\xA8\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x9D"],
        ["\xE8\xA8\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA0"],
        ["\xE8\xA9\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA6"],
        ["\xE8\xAA\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA7"],
        ["\xE8\xAA\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xDE"],
        ["\xE8\xAB\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA9"],
        ["\xEF\xA8\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAC"],
        ["\xE8\xAB\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAB"],
        ["\xE8\xAD\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE8\xAD\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xED"],
        ["\xE8\xB3\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x4F"],
        ["\xE8\xB3\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB8"],
        ["\xE8\xB4\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBC"],
        ["\xE8\xB5\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xEF\xA8\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE8\xBB\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xEF\xA8\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x8E"],
        ["\xEF\xA8\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x81\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x83\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE5"],
        ["\xEF\xA8\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE8"],
        ["\xE9\x84\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEA"],
        ["\xE9\x84\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEE"],
        ["\xE9\x87\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xCC"],
        ["\xE9\x87\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xFA"],
        ["\xE9\x87\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x87\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x41"],
        ["\xE9\x87\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xD0"],
        ["\xE9\x87\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xFC"],
        ["\xE9\x87\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x40"],
        ["\xE9\x88\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x88\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x44"],
        ["\xE9\x88\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xD2"],
        ["\xE9\x88\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x47"],
        ["\xE9\x89\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x49"],
        ["\xE9\x88\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x48"],
        ["\xE9\x89\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xDA"],
        ["\xE9\x89\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xDD"],
        ["\xE9\x89\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xDB"],
        ["\xE9\x88\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x46"],
        ["\xE9\x89\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xE1"],
        ["\xE9\x8A\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xED"],
        ["\xE9\x89\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x89\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x4C"],
        ["\xE9\x8B\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xFA"],
        ["\xE9\x8B\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xF7"],
        ["\xE9\x8B\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xF8"],
        ["\xE9\x8B\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xF6"],
        ["\xEF\xA8\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x8B\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x8B\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x52"],
        ["\xE9\x8B\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x51"],
        ["\xE9\x8C\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x57"],
        ["\xE9\x8C\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x56"],
        ["\xE9\x8B\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x43"],
        ["\xEF\xA8\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x8C\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x48"],
        ["\xE9\x8B\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x53"],
        ["\xE9\x8C\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x47"],
        ["\xE9\x8C\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x44"],
        ["\xE9\x8D\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x5E"],
        ["\xE9\x8D\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x4F"],
        ["\xE9\x8E\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x8F\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x62"],
        ["\xE9\x8F\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x63"],
        ["\xE9\x8F\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x90\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x91\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x6C"],
        ["\xE9\x91\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x96\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xEF\xA7\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x7C"],
        ["\xEF\xA8\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x9A\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x7D"],
        ["\xE9\x9A\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x8C"],
        ["\xE9\x9C\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x86"],
        ["\xE9\x9C\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x87"],
        ["\xE9\x9D\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x9D\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x88"],
        ["\xE9\x9D\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x8A"],
        ["\xE9\x9D\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\x9D\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x9C"],
        ["\xE9\xA1\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x9F"],
        ["\xE9\xA1\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA3"],
        ["\xEF\xA8\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xEF\xA8\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\xA4\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xEF\xA8\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\xA6\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9"],
        ["\xE9\xA9\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB1"],
        ["\xE9\xAB\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\xAB\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x51"],
        ["\xE9\xAD\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC2"],
        ["\xE9\xAD\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC1"],
        ["\xE9\xAE\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC5"],
        ["\xE9\xAE\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x69"],
        ["\xE9\xAE\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\xB0\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCD"],
        ["\xE9\xB5\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDC"],
        ["\xE9\xB5\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xB2"],
        ["\xEF\xA8\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE9\xB8\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xCD"],
        ["\xE9\xBB\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF0"],
        ["\xE2\x80\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x5C"],
        ["\xE2\x80\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x61"],
        ["\xE2\x88\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x7C"],
        ["\xC2\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x91"],
        ["\xC2\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x92"],
        ["\xE3\x80\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xB1"],
        ["\xE3\x80\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xB2"],
        ["\xE3\x80\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xB3"],
        ["\xE3\x80\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xB4"],
        ["\xE3\x80\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xB5"],
        ["\xE3\x83\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xB6"],
        ["\xE3\x82\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xB7"],
        ["\xE2\x8A\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xC0"],
        ["\xE2\x8A\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xC1"],
        ["\xE2\x8A\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xC2"],
        ["\xE2\x8A\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xC3"],
        ["\xE2\x88\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xC4"],
        ["\xE2\x88\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xC5"],
        ["\xE2\x8C\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xC6"],
        ["\xE2\x8C\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xC7"],
        ["\xC2\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xCA"],
        ["\xE2\x8A\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xCF"],
        ["\xE2\x8A\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xD0"],
        ["\xE2\x8A\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xD1"],
        ["\xE2\x88\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xD3"],
        ["\xEF\xBD\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xD4"],
        ["\xEF\xBD\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xD5"],
        ["\xE3\x80\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xD6"],
        ["\xE3\x80\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xD7"],
        ["\xE3\x80\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xD8"],
        ["\xE3\x80\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xD9"],
        ["\xE2\x89\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE9"],
        ["\xE2\x89\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xEA"],
        ["\xE2\x89\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xEB"],
        ["\xE2\x89\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xEC"],
        ["\xE2\x89\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xED"],
        ["\xE2\x89\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xEE"],
        ["\xE2\x86\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xEF"],
        ["\xE2\x99\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF8"],
        ["\xE2\x99\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF9"],
        ["\xE2\x99\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xFA"],
        ["\xE2\x99\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xFB"],
        ["\xE2\x96\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x40"],
        ["\xE2\x96\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x41"],
        ["\xE2\x97\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x42"],
        ["\xE2\x97\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x43"],
        ["\xE2\x86\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x44"],
        ["\xE2\x86\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x45"],
        ["\xE2\x86\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x46"],
        ["\xE2\x86\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x47"],
        ["\xE2\x87\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x48"],
        ["\xE2\x87\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x49"],
        ["\xE2\x87\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x4A"],
        ["\xE2\x87\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x4B"],
        ["\xE2\x87\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x4C"],
        ["\xE2\xA4\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x4D"],
        ["\xE2\xA4\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x4E"],
        ["\xE2\xA6\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x59"],
        ["\xE2\x97\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x5A"],
        ["\xE3\x80\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x5B"],
        ["\xEF\xB9\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x5C"],
        ["\xEF\xB9\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x5D"],
        ["\xE2\x97\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x5E"],
        ["\xE2\x80\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x5F"],
        ["\xE2\x88\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x7A"],
        ["\xE2\x84\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x7B"],
        ["\xE2\x84\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x7C"],
        ["\xE3\x8F\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x7D"],
        ["\xE2\x84\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x7E"],
        ["\xE2\x84\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x80"],
        ["\xE3\x82\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x9B"],
        ["\xE2\x80\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x9C"],
        ["\xE2\xA7\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x9D"],
        ["\xE2\xA7\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x9E"],
        ["\xE3\x82\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xF2"],
        ["\xE3\x82\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xF3"],
        ["\xE3\x82\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xF4"],
        ["\xE3\x81\x8B\xE3\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xF5"],
        ["\xE3\x81\x8D\xE3\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xF6"],
        ["\xE3\x81\x8F\xE3\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xF7"],
        ["\xE3\x81\x91\xE3\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xF8"],
        ["\xE3\x81\x93\xE3\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xF9"],
        ["\xE3\x82\xAB\xE3\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x97"],
        ["\xE3\x82\xAD\xE3\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x98"],
        ["\xE3\x82\xAF\xE3\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x99"],
        ["\xE3\x82\xB1\xE3\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x9A"],
        ["\xE3\x82\xB3\xE3\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x9B"],
        ["\xE3\x82\xBB\xE3\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x9C"],
        ["\xE3\x83\x84\xE3\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x9D"],
        ["\xE3\x83\x88\xE3\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x9E"],
        ["\xE2\x99\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB7"],
        ["\xE2\x99\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB8"],
        ["\xE2\x99\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB9"],
        ["\xE2\x99\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xBA"],
        ["\xE2\x99\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xBB"],
        ["\xE2\x99\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xBC"],
        ["\xE2\x99\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xBD"],
        ["\xE2\x99\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xBE"],
        ["\xCF\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD7"],
        ["\xE2\x93\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD8"],
        ["\xE2\x93\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD9"],
        ["\xE2\x93\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xDA"],
        ["\xE2\x93\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xDB"],
        ["\xE2\x93\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xDC"],
        ["\xE2\x93\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xDD"],
        ["\xE2\x93\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xDE"],
        ["\xE2\x93\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xDF"],
        ["\xE2\x93\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xE0"],
        ["\xE2\x93\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xE1"],
        ["\xE2\x98\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xE2"],
        ["\xE2\x98\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xE3"],
        ["\xE3\x80\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xE4"],
        ["\xE2\x98\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xE5"],
        ["\xE2\x98\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xE6"],
        ["\xE2\x98\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xE7"],
        ["\xE2\x98\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xE8"],
        ["\xE2\x98\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xE9"],
        ["\xE2\x99\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xEA"],
        ["\xE2\x96\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xEB"],
        ["\xE3\x87\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xEC"],
        ["\xE3\x87\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xED"],
        ["\xE3\x87\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xEE"],
        ["\xE3\x87\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xEF"],
        ["\xE3\x87\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xF0"],
        ["\xE3\x87\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xF1"],
        ["\xE3\x87\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xF2"],
        ["\xE3\x87\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xF3"],
        ["\xE3\x87\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xF4"],
        ["\xE3\x87\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xF5"],
        ["\xE3\x87\xB7\xE3\x82\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xF6"],
        ["\xE3\x87\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xF7"],
        ["\xE3\x87\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xF8"],
        ["\xE3\x87\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xF9"],
        ["\xE3\x87\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xFA"],
        ["\xE3\x87\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xFB"],
        ["\xE3\x87\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xFC"],
        ["\xE2\x8E\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x61"],
        ["\xE2\x8E\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x62"],
        ["\xE2\x8F\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x63"],
        ["\xE2\x8F\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x64"],
        ["\xE2\x8F\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x65"],
        ["\xE2\x8F\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x66"],
        ["\xE2\x8F\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x67"],
        ["\xE2\x8F\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x68"],
        ["\xE2\x8F\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x69"],
        ["\xE2\x8F\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x6A"],
        ["\xE2\x8F\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x6B"],
        ["\xE2\x8F\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x6C"],
        ["\xE2\x8F\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x6D"],
        ["\xE2\x8F\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x6E"],
        ["\xE2\x8F\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x6F"],
        ["\xE3\x83\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x92"],
        ["\xE3\x83\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x93"],
        ["\xE3\x83\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x94"],
        ["\xE3\x83\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x95"],
        ["\xE2\x8B\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x96"],
        ["\xE2\x8B\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x97"],
        ["\xE2\x85\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x98"],
        ["\xE2\x85\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x99"],
        ["\xE2\x85\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x9A"],
        ["\xE2\x9C\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x9B"],
        ["\xE2\x8C\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x9C"],
        ["\xE2\x90\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x9D"],
        ["\xE2\x8F\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x9E"],
        ["\xE3\x89\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xBF"],
        ["\xE3\x89\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xC0"],
        ["\xE3\x89\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xC1"],
        ["\xE3\x89\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xC2"],
        ["\xE3\x89\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xC3"],
        ["\xE3\x89\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xC4"],
        ["\xE3\x89\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xC5"],
        ["\xE3\x89\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xC6"],
        ["\xE3\x89\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xC7"],
        ["\xE3\x89\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xC8"],
        ["\xE3\x89\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xC9"],
        ["\xE3\x89\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xCA"],
        ["\xE3\x89\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xCB"],
        ["\xE3\x89\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xCC"],
        ["\xE3\x89\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xCD"],
        ["\xE3\x8A\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xCE"],
        ["\xE3\x8A\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xCF"],
        ["\xE3\x8A\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xD0"],
        ["\xE3\x8A\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xD1"],
        ["\xE3\x8A\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xD2"],
        ["\xE3\x8A\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xD3"],
        ["\xE3\x8A\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xD4"],
        ["\xE3\x8A\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xD5"],
        ["\xE3\x8A\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xD6"],
        ["\xE3\x8A\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xD7"],
        ["\xE3\x8A\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xD8"],
        ["\xE3\x8A\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xD9"],
        ["\xE3\x8A\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xDA"],
        ["\xE3\x8A\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xDB"],
        ["\xE3\x8A\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xDC"],
        ["\xE2\x97\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xE5"],
        ["\xE2\x97\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xE6"],
        ["\xE2\x97\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xE7"],
        ["\xE2\x97\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xE8"],
        ["\xE2\x80\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xE9"],
        ["\xE2\x81\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xEA"],
        ["\xE2\x81\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xEB"],
        ["\xE2\x81\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xEC"],
        ["\xC7\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xED"],
        ["\xC7\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xEE"],
        ["\xC7\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xEF"],
        ["\xE1\xB8\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xF0"],
        ["\xE1\xB8\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xF1"],
        ["\xC7\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xF2"],
        ["\xC7\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xF3"],
        ["\xC7\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xF4"],
        ["\xC7\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xF5"],
        ["\xC7\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xF6"],
        ["\xC7\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xF7"],
        ["\xC7\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xF8"],
        ["\xC7\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xF9"],
        ["\xC7\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xFA"],
        ["\xE2\x82\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x40"],
        ["\xC2\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x41"],
        ["\xC2\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x42"],
        ["\xC2\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x43"],
        ["\xC2\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x44"],
        ["\xC2\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x45"],
        ["\xC2\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x46"],
        ["\xC2\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x47"],
        ["\xC2\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x48"],
        ["\xC2\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x49"],
        ["\xC2\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x4A"],
        ["\xC2\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x4B"],
        ["\xC2\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x4C"],
        ["\xC2\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x4D"],
        ["\xC2\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x4E"],
        ["\xC2\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x4F"],
        ["\xC2\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x50"],
        ["\xC2\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x51"],
        ["\xC2\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x52"],
        ["\xC2\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x53"],
        ["\xC2\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x54"],
        ["\xC2\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x55"],
        ["\xC3\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x56"],
        ["\xC3\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x57"],
        ["\xC3\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x58"],
        ["\xC3\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x59"],
        ["\xC3\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x5A"],
        ["\xC3\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x5B"],
        ["\xC3\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x5C"],
        ["\xC3\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x5D"],
        ["\xC3\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x5E"],
        ["\xC3\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x5F"],
        ["\xC3\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x60"],
        ["\xC3\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x61"],
        ["\xC3\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x62"],
        ["\xC3\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x63"],
        ["\xC3\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x64"],
        ["\xC3\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x65"],
        ["\xC3\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x66"],
        ["\xC3\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x67"],
        ["\xC3\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x68"],
        ["\xC3\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x69"],
        ["\xC3\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x6A"],
        ["\xC3\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x6B"],
        ["\xC3\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x6C"],
        ["\xC3\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x6D"],
        ["\xC3\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x6E"],
        ["\xC3\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x6F"],
        ["\xC3\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x70"],
        ["\xC3\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x71"],
        ["\xC3\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x72"],
        ["\xC3\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x73"],
        ["\xC3\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x74"],
        ["\xC3\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x75"],
        ["\xC3\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x76"],
        ["\xC3\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x77"],
        ["\xC3\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x78"],
        ["\xC3\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x79"],
        ["\xC3\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x7A"],
        ["\xC3\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x7B"],
        ["\xC3\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x7C"],
        ["\xC3\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x7D"],
        ["\xC3\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x7E"],
        ["\xC3\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x80"],
        ["\xC3\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x81"],
        ["\xC3\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x82"],
        ["\xC3\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x83"],
        ["\xC3\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x84"],
        ["\xC3\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x85"],
        ["\xC3\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x86"],
        ["\xC3\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x87"],
        ["\xC3\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x88"],
        ["\xC3\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x89"],
        ["\xC3\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x8A"],
        ["\xC3\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x8B"],
        ["\xC3\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x8C"],
        ["\xC3\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x8D"],
        ["\xC3\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x8E"],
        ["\xC3\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x8F"],
        ["\xC3\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x90"],
        ["\xC3\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x91"],
        ["\xC3\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x92"],
        ["\xC3\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x93"],
        ["\xC3\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x94"],
        ["\xC4\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x95"],
        ["\xC4\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x96"],
        ["\xC5\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x97"],
        ["\xC4\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x98"],
        ["\xC5\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x99"],
        ["\xC4\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x9A"],
        ["\xC4\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x9B"],
        ["\xC5\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x9C"],
        ["\xC4\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x9D"],
        ["\xC5\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x9E"],
        ["\xC4\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\x9F"],
        ["\xCB\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xA0"],
        ["\xC5\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xA1"],
        ["\xC4\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xA2"],
        ["\xC5\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xA3"],
        ["\xC5\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xA4"],
        ["\xC5\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xA5"],
        ["\xC5\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xA6"],
        ["\xC5\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xA7"],
        ["\xC5\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xA8"],
        ["\xC5\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xA9"],
        ["\xC4\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xAA"],
        ["\xCB\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xAB"],
        ["\xC5\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xAC"],
        ["\xC4\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xAD"],
        ["\xC5\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xAE"],
        ["\xCB\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xAF"],
        ["\xC5\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xB0"],
        ["\xC5\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xB1"],
        ["\xC5\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xB2"],
        ["\xC5\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xB3"],
        ["\xCB\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xB4"],
        ["\xC5\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xB5"],
        ["\xC5\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xB6"],
        ["\xC5\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xB7"],
        ["\xC4\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xB8"],
        ["\xC4\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xB9"],
        ["\xC4\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xBA"],
        ["\xC4\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xBB"],
        ["\xC4\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xBC"],
        ["\xC4\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xBD"],
        ["\xC4\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xBE"],
        ["\xC5\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xBF"],
        ["\xC5\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xC0"],
        ["\xC5\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xC1"],
        ["\xC5\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xC2"],
        ["\xC5\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xC3"],
        ["\xC5\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xC4"],
        ["\xC5\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xC5"],
        ["\xC5\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xC6"],
        ["\xC4\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xC7"],
        ["\xC4\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xC8"],
        ["\xC4\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xC9"],
        ["\xC4\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xCA"],
        ["\xC4\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xCB"],
        ["\xC4\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xCC"],
        ["\xC4\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xCD"],
        ["\xC4\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xCE"],
        ["\xC5\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xCF"],
        ["\xC5\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xD0"],
        ["\xC5\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xD1"],
        ["\xC5\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xD2"],
        ["\xC5\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xD3"],
        ["\xC5\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xD4"],
        ["\xC5\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xD5"],
        ["\xCB\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xD6"],
        ["\xC4\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xD7"],
        ["\xC4\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xD8"],
        ["\xC4\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xD9"],
        ["\xC4\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xDA"],
        ["\xC5\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xDB"],
        ["\xC5\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xDC"],
        ["\xC4\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xDD"],
        ["\xC4\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xDE"],
        ["\xC4\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xDF"],
        ["\xC4\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xE0"],
        ["\xC5\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xE1"],
        ["\xC5\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xE2"],
        ["\xC9\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xE3"],
        ["\xCA\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xE4"],
        ["\xC9\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xE5"],
        ["\xCA\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xE6"],
        ["\xCA\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xE7"],
        ["\xC9\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xE8"],
        ["\xC9\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xE9"],
        ["\xC9\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xEA"],
        ["\xCA\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xEB"],
        ["\xC9\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xEC"],
        ["\xC9\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xED"],
        ["\xC9\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xEE"],
        ["\xCA\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xEF"],
        ["\xCA\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xF0"],
        ["\xC9\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xF1"],
        ["\xC9\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xF2"],
        ["\xC9\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xF3"],
        ["\xC9\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xF4"],
        ["\xCA\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xF5"],
        ["\xCA\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xF6"],
        ["\xC9\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xF7"],
        ["\xC5\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xF8"],
        ["\xC9\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xF9"],
        ["\xCA\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xFA"],
        ["\xC4\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xFB"],
        ["\xCA\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x85\xFC"],
        ["\xCA\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x40"],
        ["\xC9\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x41"],
        ["\xCA\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x42"],
        ["\xC7\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x43"],
        ["\xC9\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x44"],
        ["\xC9\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x45"],
        ["\xCA\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x46"],
        ["\xC9\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x47"],
        ["\xC6\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x48"],
        ["\xC5\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x49"],
        ["\xC5\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x4A"],
        ["\xC9\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x4B"],
        ["\xCA\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x4C"],
        ["\xC9\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x4D"],
        ["\xC9\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x4E"],
        ["\xC9\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x4F"],
        ["\xC9\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x50"],
        ["\xC9\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x51"],
        ["\xC9\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x52"],
        ["\xC9\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x53"],
        ["\xCA\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x54"],
        ["\xC9\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x55"],
        ["\xCA\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x56"],
        ["\xC9\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x57"],
        ["\xC9\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x58"],
        ["\xC9\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x59"],
        ["\xCA\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x5A"],
        ["\xC9\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x5B"],
        ["\xCA\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x5C"],
        ["\xCA\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x5D"],
        ["\xC9\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x5E"],
        ["\xCA\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x5F"],
        ["\xC9\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x60"],
        ["\xC9\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x61"],
        ["\xC9\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x62"],
        ["\xC3\xA6\xCC\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x63"],
        ["\xC7\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x64"],
        ["\xE1\xBD\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x65"],
        ["\xE1\xBD\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x66"],
        ["\xC9\x94\xCC\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x67"],
        ["\xC9\x94\xCC\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x68"],
        ["\xCA\x8C\xCC\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x69"],
        ["\xCA\x8C\xCC\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x6A"],
        ["\xC9\x99\xCC\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x6B"],
        ["\xC9\x99\xCC\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x6C"],
        ["\xC9\x9A\xCC\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x6D"],
        ["\xC9\x9A\xCC\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x6E"],
        ["\xE1\xBD\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x6F"],
        ["\xE1\xBD\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x70"],
        ["\xCD\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x71"],
        ["\xCB\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x72"],
        ["\xCB\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x73"],
        ["\xCB\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x74"],
        ["\xCB\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x75"],
        ["\xCC\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x76"],
        ["\xE2\x80\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x77"],
        ["\xCC\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x78"],
        ["\xCC\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x79"],
        ["\xCC\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x7A"],
        ["\xCC\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x7B"],
        ["\xCC\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x7C"],
        ["\xCC\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x7D"],
        ["\xCC\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x7E"],
        ["\xCB\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x80"],
        ["\xCB\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x81"],
        ["\xCB\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x82"],
        ["\xCB\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x83"],
        ["\xCB\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x84"],
        ["\xCB\xA9\xCB\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x85"],
        ["\xCB\xA5\xCB\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x86"],
        ["\xCC\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x87"],
        ["\xCC\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x88"],
        ["\xCC\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x89"],
        ["\xCC\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x8A"],
        ["\xCC\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x8B"],
        ["\xCC\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x8C"],
        ["\xCC\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x8D"],
        ["\xCC\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x8E"],
        ["\xCC\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x8F"],
        ["\xCC\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x90"],
        ["\xCB\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x91"],
        ["\xCC\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x92"],
        ["\xCC\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x93"],
        ["\xCC\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x94"],
        ["\xCC\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x95"],
        ["\xCC\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x96"],
        ["\xCC\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x97"],
        ["\xCC\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x98"],
        ["\xCC\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x99"],
        ["\xCC\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x9A"],
        ["\xCC\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x9B"],
        ["\xCC\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x9C"],
        ["\xCC\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x9D"],
        ["\xCC\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x9E"],
        ["\xE2\x9D\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\x9F"],
        ["\xE2\x9D\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xA0"],
        ["\xE2\x9D\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xA1"],
        ["\xE2\x9D\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xA2"],
        ["\xE2\x9D\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xA3"],
        ["\xE2\x9D\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xA4"],
        ["\xE2\x9D\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xA5"],
        ["\xE2\x9D\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xA6"],
        ["\xE2\x9D\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xA7"],
        ["\xE2\x9D\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xA8"],
        ["\xE2\x93\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xA9"],
        ["\xE2\x93\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xAA"],
        ["\xE2\x93\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xAB"],
        ["\xE2\x93\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xAC"],
        ["\xE2\x93\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xAD"],
        ["\xE2\x93\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xAE"],
        ["\xE2\x93\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xAF"],
        ["\xE2\x93\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xB0"],
        ["\xE2\x93\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xB1"],
        ["\xE2\x93\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xB2"],
        ["\xE2\x85\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xBD"],
        ["\xE2\x85\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xBE"],
        ["\xE2\x93\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xBF"],
        ["\xE2\x93\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xC0"],
        ["\xE2\x93\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xC1"],
        ["\xE2\x93\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xC2"],
        ["\xE2\x93\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xC3"],
        ["\xE2\x93\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xC4"],
        ["\xE2\x93\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xC5"],
        ["\xE2\x93\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xC6"],
        ["\xE2\x93\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xC7"],
        ["\xE2\x93\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xC8"],
        ["\xE2\x93\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xC9"],
        ["\xE2\x93\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xCA"],
        ["\xE2\x93\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xCB"],
        ["\xE2\x93\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xCC"],
        ["\xE2\x93\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xCD"],
        ["\xE2\x93\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xCE"],
        ["\xE2\x93\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xCF"],
        ["\xE2\x93\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xD0"],
        ["\xE2\x93\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xD1"],
        ["\xE2\x93\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xD2"],
        ["\xE2\x93\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xD3"],
        ["\xE2\x93\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xD4"],
        ["\xE2\x93\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xD5"],
        ["\xE2\x93\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xD6"],
        ["\xE2\x93\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xD7"],
        ["\xE2\x93\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xD8"],
        ["\xE3\x8B\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xD9"],
        ["\xE3\x8B\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xDA"],
        ["\xE3\x8B\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xDB"],
        ["\xE3\x8B\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xDC"],
        ["\xE3\x8B\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xDD"],
        ["\xE3\x8B\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xDE"],
        ["\xE3\x8B\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xDF"],
        ["\xE3\x8B\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xE0"],
        ["\xE3\x8B\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xE1"],
        ["\xE3\x8B\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xE2"],
        ["\xE3\x8B\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xE3"],
        ["\xE3\x8B\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xE4"],
        ["\xE3\x8B\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xE5"],
        ["\xE3\x8B\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xE6"],
        ["\xE3\x8B\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xE7"],
        ["\xE3\x8B\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xE8"],
        ["\xE3\x8B\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xE9"],
        ["\xE3\x8B\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xEA"],
        ["\xE3\x8B\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xEB"],
        ["\xE3\x8B\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xEC"],
        ["\xE3\x8B\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xED"],
        ["\xE3\x8B\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xEE"],
        ["\xE3\x8B\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xEF"],
        ["\xE3\x8B\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xF0"],
        ["\xE3\x8B\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xF1"],
        ["\xE2\x81\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xFB"],
        ["\xE2\x81\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x86\xFC"],
        ["\xE2\x85\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x5E"],
        ["\xE2\x85\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x76"],
        ["\xE2\x9D\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x9D"],
        ["\xE2\x98\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x9E"],
        ["\xE4\xBF\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x9F"],
        ["\xF0\xA0\x80\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xA0"],
        ["\xE3\x90\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xA1"],
        ["\xE4\xB8\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xA3"],
        ["\xE4\xB8\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xA4"],
        ["\xE4\xBA\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xA5"],
        ["\xE4\xBB\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xA7"],
        ["\xE4\xBB\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xA8"],
        ["\xE4\xBC\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xAA"],
        ["\xE4\xBD\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xAB"],
        ["\xE4\xBD\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xAC"],
        ["\xE4\xBD\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xAD"],
        ["\xE4\xBD\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xAF"],
        ["\xE4\xBD\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xB0"],
        ["\xE4\xBD\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xB1"],
        ["\xE4\xBD\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xB2"],
        ["\xE4\xBE\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xB5"],
        ["\xEF\xA8\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xB6"],
        ["\xE4\xBF\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xB8"],
        ["\xE5\x80\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xB9"],
        ["\xE5\x80\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xBA"],
        ["\xE5\x80\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xBB"],
        ["\xE5\x80\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xBC"],
        ["\xE5\x80\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xBD"],
        ["\xE5\x80\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xBE"],
        ["\xE5\x80\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xC0"],
        ["\xE5\x81\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xC1"],
        ["\xE5\x83\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xC3"],
        ["\xE5\x83\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xC4"],
        ["\xE5\x83\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xC5"],
        ["\xE5\x83\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xC6"],
        ["\xEF\xA8\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xC7"],
        ["\xE5\x84\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xC8"],
        ["\xE5\x84\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xC9"],
        ["\xE5\x84\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xCA"],
        ["\xE5\x84\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xCB"],
        ["\xE5\x84\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xCC"],
        ["\xEF\xA8\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xCE"],
        ["\xE5\x85\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xCF"],
        ["\xE5\x85\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xD0"],
        ["\xE3\x92\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xD1"],
        ["\xE5\x87\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xD3"],
        ["\xE5\x87\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xD4"],
        ["\xE5\x87\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xD5"],
        ["\xE5\x87\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xD6"],
        ["\xE5\x87\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xD7"],
        ["\xE5\x88\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xD8"],
        ["\xE3\x93\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xD9"],
        ["\xE5\x88\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xDA"],
        ["\xE5\x89\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xDC"],
        ["\xE5\x89\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xDD"],
        ["\xE5\x89\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xDE"],
        ["\xE5\x8A\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xDF"],
        ["\xE5\x8B\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xE0"],
        ["\xEF\xA8\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xE1"],
        ["\xE5\x8B\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xE2"],
        ["\xE5\x8B\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xE3"],
        ["\xE5\x8B\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xE4"],
        ["\xEF\xA8\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xE6"],
        ["\xE5\x8B\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xE7"],
        ["\xE5\x8B\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xE8"],
        ["\xE5\x8C\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xEB"],
        ["\xEF\xA8\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xEC"],
        ["\xE5\x8D\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xED"],
        ["\xE5\x8D\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xEE"],
        ["\xE5\x8D\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xEF"],
        ["\xE5\x8E\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xF1"],
        ["\xE5\x90\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xF3"],
        ["\xE5\x90\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xF4"],
        ["\xE5\x91\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xF5"],
        ["\xE5\x91\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xF7"],
        ["\xE5\x91\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xF8"],
        ["\xE5\x91\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xF9"],
        ["\xE5\x92\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xFA"],
        ["\xE5\x92\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xFB"],
        ["\xE5\x92\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\xFC"],
        ["\xE5\x93\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x41"],
        ["\xE5\x94\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x43"],
        ["\xE5\x94\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x44"],
        ["\xE5\x94\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x45"],
        ["\xE5\x95\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x46"],
        ["\xE5\x95\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x47"],
        ["\xE5\x96\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x48"],
        ["\xE5\x96\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x4A"],
        ["\xEF\xA8\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x4B"],
        ["\xE5\x96\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x4C"],
        ["\xE5\x97\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x4D"],
        ["\xEF\xA8\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x4E"],
        ["\xE5\x98\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x4F"],
        ["\xE5\x98\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x50"],
        ["\xE5\x98\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x51"],
        ["\xE5\x99\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x52"],
        ["\xE5\x99\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x53"],
        ["\xE5\x99\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x54"],
        ["\xEF\xA8\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x55"],
        ["\xE5\x99\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x56"],
        ["\xE5\x99\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x57"],
        ["\xE5\x99\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x58"],
        ["\xE5\x9A\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x59"],
        ["\xE5\x9A\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x5A"],
        ["\xE5\x9A\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x5B"],
        ["\xE5\x9A\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x5C"],
        ["\xE5\x9A\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x5D"],
        ["\xE5\x9B\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x5E"],
        ["\xE5\x9B\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x5F"],
        ["\xE5\x9C\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x60"],
        ["\xF0\xA1\x88\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x61"],
        ["\xE5\x9C\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x62"],
        ["\xE5\x9C\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x63"],
        ["\xE5\x9C\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x64"],
        ["\xE5\x9C\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x65"],
        ["\xE5\x9D\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x66"],
        ["\xE5\x9D\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x67"],
        ["\xE5\x9D\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x68"],
        ["\xE5\x9E\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x69"],
        ["\xF0\xA1\x8C\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x6B"],
        ["\xE5\x9E\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x6C"],
        ["\xE5\x9F\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x6F"],
        ["\xE5\x9F\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x70"],
        ["\xE5\x9F\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x71"],
        ["\xE5\x9F\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x72"],
        ["\xE5\x9F\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x73"],
        ["\xE5\x9F\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x74"],
        ["\xE5\xA0\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x75"],
        ["\xE5\xA1\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x77"],
        ["\xE5\xA1\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x78"],
        ["\xEF\xA8\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x79"],
        ["\xE5\xA1\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x7A"],
        ["\xE5\xA2\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x7B"],
        ["\xEF\xA8\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x7D"],
        ["\xE5\xA2\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x7E"],
        ["\xF0\xA1\x91\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x80"],
        ["\xE5\xA3\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x81"],
        ["\xE5\xA3\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x82"],
        ["\xE5\xA3\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x83"],
        ["\xE5\xA3\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x84"],
        ["\xE5\xA3\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x85"],
        ["\xE5\xA3\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x86"],
        ["\xE5\xA4\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x87"],
        ["\xE8\x99\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x88"],
        ["\xE5\xA5\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x8A"],
        ["\xE5\xA6\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x8B"],
        ["\xE5\xA6\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x8C"],
        ["\xE5\xA7\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x8E"],
        ["\xE5\xA7\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x8F"],
        ["\xE5\xA7\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x90"],
        ["\xE5\xA8\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x91"],
        ["\xE5\xA8\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x92"],
        ["\xE5\xA9\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x93"],
        ["\xE5\xA9\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x94"],
        ["\xE5\xA9\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x95"],
        ["\xE5\xA9\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x96"],
        ["\xE5\xAA\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x97"],
        ["\xE5\xAA\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x98"],
        ["\xE5\xAA\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x99"],
        ["\xE5\xAB\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x9A"],
        ["\xF0\xA1\xA2\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x9B"],
        ["\xE5\xAC\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x9C"],
        ["\xE5\xAC\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x9D"],
        ["\xE5\x89\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x9E"],
        ["\xF0\xA0\xAE\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x73"],
        ["\xE5\xAD\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x74"],
        ["\xE5\xAD\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x76"],
        ["\xE5\xAE\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x77"],
        ["\xE5\xB0\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x7A"],
        ["\xE5\xB0\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x7C"],
        ["\xE5\xB0\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x7D"],
        ["\xE3\x9E\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x7E"],
        ["\xE5\xB1\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x80"],
        ["\xEF\xA8\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x81"],
        ["\xEF\xA8\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x82"],
        ["\xF0\xA1\x9A\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x83"],
        ["\xE5\xB1\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x84"],
        ["\xE5\xB2\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x85"],
        ["\xE5\xB2\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x86"],
        ["\xE5\xB2\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x87"],
        ["\xE5\xB2\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x88"],
        ["\xE5\xB3\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x8A"],
        ["\xE5\xB3\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x8B"],
        ["\xE5\xB3\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x8C"],
        ["\xE5\xB3\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x8D"],
        ["\xF0\xA1\xB8\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x8E"],
        ["\xE3\x9F\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x8F"],
        ["\xE5\xB4\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x90"],
        ["\xE5\xB5\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x93"],
        ["\xE5\xB5\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x94"],
        ["\xE5\xB5\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x96"],
        ["\xE5\xB6\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x98"],
        ["\xE5\xB6\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x99"],
        ["\xE5\xB6\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x9A"],
        ["\xE5\xB6\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x9B"],
        ["\xE5\xB7\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x9D"],
        ["\xE5\x90\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x9E"],
        ["\xE5\xBD\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x5A"],
        ["\xE5\x99\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA5"],
        ["\xE5\xB7\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA6"],
        ["\xE5\xB8\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA7"],
        ["\xE5\xB8\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA8"],
        ["\xE5\xB9\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA9"],
        ["\xE5\xB9\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAA"],
        ["\xE5\xBA\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAB"],
        ["\xEF\xA4\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAC"],
        ["\xE5\xBB\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAD"],
        ["\xE5\xBB\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAE"],
        ["\xE5\xBC\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAF"],
        ["\xE5\xBC\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB0"],
        ["\xE5\xBC\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB1"],
        ["\xE5\xBC\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],
        ["\xE5\xBC\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB3"],
        ["\xE5\xBC\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB5"],
        ["\xE5\xBC\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB6"],
        ["\xE5\xBD\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB7"],
        ["\xE5\xBD\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB9"],
        ["\xE5\xBD\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBA"],
        ["\xE5\xBD\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBB"],
        ["\xE5\xBD\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBD"],
        ["\xE5\xBE\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBE"],
        ["\xE5\xBE\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBF"],
        ["\xE5\xBE\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC0"],
        ["\xE5\xBE\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC1"],
        ["\xE5\xBE\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC2"],
        ["\xE5\xBF\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC4"],
        ["\xE5\xBF\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC6"],
        ["\xE5\xBF\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC7"],
        ["\xE6\x80\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC8"],
        ["\xE6\x80\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC9"],
        ["\xE6\x80\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCA"],
        ["\xE6\x80\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCB"],
        ["\xE6\x80\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCC"],
        ["\xE6\x81\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCD"],
        ["\xEF\xA8\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCE"],
        ["\xE6\x82\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCF"],
        ["\xE6\x82\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD0"],
        ["\xE6\x83\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD1"],
        ["\xE6\x83\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD2"],
        ["\xE6\x83\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD4"],
        ["\xE6\x83\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD5"],
        ["\xE6\x84\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD6"],
        ["\xE6\x84\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD7"],
        ["\xEF\xA8\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDA"],
        ["\xE6\x86\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDB"],
        ["\xEF\xA8\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDC"],
        ["\xE6\x86\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDD"],
        ["\xE6\x86\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDE"],
        ["\xEF\xA9\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDF"],
        ["\xE6\x88\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE0"],
        ["\xE6\x88\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE1"],
        ["\xE6\x89\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE2"],
        ["\xE6\x89\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE3"],
        ["\xE6\x89\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],
        ["\xE6\x89\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE5"],
        ["\xE6\x8A\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE6"],
        ["\xE6\x8B\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE7"],
        ["\xE6\x8B\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE8"],
        ["\xE6\x8B\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE9"],
        ["\xE6\x8C\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEA"],
        ["\xE6\x8C\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEB"],
        ["\xE6\x8C\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEC"],
        ["\xE6\x8D\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xED"],
        ["\xE6\x8D\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEE"],
        ["\xE6\x8D\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEF"],
        ["\xE6\x8F\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF0"],
        ["\xE6\x8F\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF1"],
        ["\xE6\x90\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF3"],
        ["\xE6\x90\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF4"],
        ["\xE6\x90\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF5"],
        ["\xE6\x91\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF6"],
        ["\xE6\x91\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF7"],
        ["\xE6\x91\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF9"],
        ["\xE6\x92\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xFB"],
        ["\xE6\x92\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xFC"],
        ["\xE6\x93\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x40"],
        ["\xE6\x93\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x41"],
        ["\xE6\x93\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x42"],
        ["\xE6\x93\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x43"],
        ["\xE6\x93\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x44"],
        ["\xE6\x94\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x45"],
        ["\xE6\x94\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x46"],
        ["\xEF\xA9\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x47"],
        ["\xE6\x95\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x48"],
        ["\xE6\x96\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x49"],
        ["\xEF\xA9\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x4A"],
        ["\xE6\x98\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x4F"],
        ["\xE6\x98\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x50"],
        ["\xE6\x98\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x52"],
        ["\xE6\x98\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x53"],
        ["\xE6\x98\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x55"],
        ["\xE6\x99\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x57"],
        ["\xE6\x99\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x58"],
        ["\xF0\xA3\x87\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x59"],
        ["\xE6\x99\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x5B"],
        ["\xE6\x99\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x5C"],
        ["\xE6\x99\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x5F"],
        ["\xE6\x99\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x60"],
        ["\xE6\x9A\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x61"],
        ["\xEF\xA9\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x62"],
        ["\xE6\x9A\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x65"],
        ["\xE6\x9B\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x66"],
        ["\xE6\x9B\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x67"],
        ["\xE3\xAC\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x68"],
        ["\xE6\x9B\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x69"],
        ["\xE6\x9B\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x6A"],
        ["\xE6\x9C\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x6C"],
        ["\xE6\x9C\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x6E"],
        ["\xE6\x9D\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x70"],
        ["\xE6\x9D\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x71"],
        ["\xE6\x9D\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x72"],
        ["\xE6\x9E\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x73"],
        ["\xE6\x9E\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x74"],
        ["\xE6\x9E\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x75"],
        ["\xE6\x9E\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x76"],
        ["\xE6\x9F\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x78"],
        ["\xE6\x9F\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x7A"],
        ["\xE6\x9F\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x7B"],
        ["\xE6\xA0\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x7E"],
        ["\xE6\xA0\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x80"],
        ["\xE6\xA0\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x81"],
        ["\xE6\xA1\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x82"],
        ["\xE6\xA1\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x83"],
        ["\xE6\xA1\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x84"],
        ["\xEF\xA9\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x85"],
        ["\xE6\xA2\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x86"],
        ["\xE6\xA2\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x87"],
        ["\xE6\xA2\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x88"],
        ["\xE6\xA3\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x8A"],
        ["\xE6\xA3\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x8B"],
        ["\xE6\xA3\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x8C"],
        ["\xE6\xA3\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x8D"],
        ["\xE6\xA3\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x8E"],
        ["\xE6\xA3\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x8F"],
        ["\xE6\xA4\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x90"],
        ["\xE6\xA5\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x91"],
        ["\xF0\xA3\x97\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x92"],
        ["\xE6\xA4\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x93"],
        ["\xE6\xA5\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x94"],
        ["\xE6\xA5\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x95"],
        ["\xE6\xA5\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x96"],
        ["\xE6\xA5\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x97"],
        ["\xE6\xA6\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x99"],
        ["\xE6\xA6\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x9B"],
        ["\xE6\xA6\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x9C"],
        ["\xE6\xA7\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x9D"],
        ["\xE3\xAE\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x9E"],
        ["\xE3\xAF\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\x9F"],
        ["\xE6\xA7\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA1"],
        ["\xE6\xA7\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA2"],
        ["\xE6\xA7\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA3"],
        ["\xE6\xA7\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA4"],
        ["\xE6\xA8\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA5"],
        ["\xE6\xA8\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA6"],
        ["\xF0\xA3\x9C\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA7"],
        ["\xE6\xA8\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA8"],
        ["\xE6\xA8\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA9"],
        ["\xE6\xA9\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAA"],
        ["\xE6\xA9\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAB"],
        ["\xE6\xA9\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAC"],
        ["\xE6\xA9\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAD"],
        ["\xF0\xA3\x9D\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB0"],
        ["\xE6\xAA\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB1"],
        ["\xE6\xAA\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB2"],
        ["\xE6\xAA\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB3"],
        ["\xE6\xAA\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB4"],
        ["\xE6\xAA\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB5"],
        ["\xE6\xAB\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB7"],
        ["\xE3\xB0\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB8"],
        ["\xEF\xA4\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB9"],
        ["\xE6\xAC\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBA"],
        ["\xE6\xAC\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBB"],
        ["\xE6\xAC\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBC"],
        ["\xE6\xAC\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBD"],
        ["\xE6\xAD\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBE"],
        ["\xE6\xAD\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBF"],
        ["\xE6\xAD\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC0"],
        ["\xE6\xAD\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC1"],
        ["\xE6\xAD\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC2"],
        ["\xE6\xAD\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC3"],
        ["\xE6\xAE\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC4"],
        ["\xE6\xAE\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC5"],
        ["\xE6\xAE\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC6"],
        ["\xEF\xA5\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC7"],
        ["\xE6\xAF\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC8"],
        ["\xE6\xAF\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCA"],
        ["\xE6\xAF\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCB"],
        ["\xE6\xB0\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCC"],
        ["\xE6\xB0\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCD"],
        ["\xE6\xB0\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCE"],
        ["\xE6\xB1\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCF"],
        ["\xE6\xB2\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD1"],
        ["\xE6\xB1\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD2"],
        ["\xE6\xB1\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD3"],
        ["\xE6\xB2\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD4"],
        ["\xE6\xB2\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD6"],
        ["\xE6\xB2\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD7"],
        ["\xE6\xB3\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD8"],
        ["\xE6\xB3\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD9"],
        ["\xE6\xB3\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDA"],
        ["\xE6\xB3\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDB"],
        ["\xE6\xB3\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDC"],
        ["\xE6\xB3\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDD"],
        ["\xF0\xA3\xB3\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDE"],
        ["\xE6\xB4\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE0"],
        ["\xE6\xB4\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE1"],
        ["\xE6\xB4\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE2"],
        ["\xE6\xB4\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE3"],
        ["\xE6\xB4\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE4"],
        ["\xE6\xB5\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE5"],
        ["\xE6\xB5\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE6"],
        ["\xEF\xA9\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE7"],
        ["\xE6\xB6\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE8"],
        ["\xE6\xB6\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEA"],
        ["\xE6\xB6\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEB"],
        ["\xE6\xB6\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEC"],
        ["\xE6\xB6\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEE"],
        ["\xE6\xB7\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEF"],
        ["\xE6\xB7\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF0"],
        ["\xE6\xB7\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF1"],
        ["\xE6\xB7\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF2"],
        ["\xE6\xB7\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF3"],
        ["\xEF\xA9\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF5"],
        ["\xE6\xB8\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF6"],
        ["\xE6\xB9\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF7"],
        ["\xE6\xB9\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF9"],
        ["\xE6\xBA\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xFA"],
        ["\xE6\xBA\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xFB"],
        ["\xE6\xBB\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xFC"],
        ["\xE6\xBB\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x40"],
        ["\xE6\xBB\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x41"],
        ["\xE6\xBC\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x42"],
        ["\xE6\xBC\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x43"],
        ["\xEF\xA9\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x44"],
        ["\xE6\xBC\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x45"],
        ["\xE6\xBC\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x46"],
        ["\xE6\xBC\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x47"],
        ["\xE6\xBD\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x48"],
        ["\xE6\xBD\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x49"],
        ["\xE6\xBD\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x4A"],
        ["\xE6\xBD\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x4B"],
        ["\xE6\xBD\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x4C"],
        ["\xE6\xBD\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x4D"],
        ["\xE6\xBE\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x4F"],
        ["\xE6\xBE\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x50"],
        ["\xE6\xBE\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x51"],
        ["\xE6\xBE\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x52"],
        ["\xE6\xBE\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x53"],
        ["\xE6\xBE\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x54"],
        ["\xE6\xBE\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x55"],
        ["\xE6\xBF\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x56"],
        ["\xE6\xBF\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x57"],
        ["\xE6\xBF\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x58"],
        ["\xE6\xBF\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x59"],
        ["\xE7\x80\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x5C"],
        ["\xE7\x81\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x5E"],
        ["\xE7\x81\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x5F"],
        ["\xE7\x81\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x60"],
        ["\xE7\x81\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x61"],
        ["\xE7\x81\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x62"],
        ["\xE7\x81\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x63"],
        ["\xE7\x82\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x65"],
        ["\xE7\x82\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x67"],
        ["\xE7\x83\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x68"],
        ["\xE7\x83\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x69"],
        ["\xE7\x83\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x6A"],
        ["\xE7\x84\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x6C"],
        ["\xE7\x84\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x6D"],
        ["\xE7\x84\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x6E"],
        ["\xE7\x84\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x6F"],
        ["\xE7\x84\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x70"],
        ["\xE7\x85\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x73"],
        ["\xEF\xA9\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x74"],
        ["\xE7\x85\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x75"],
        ["\xE7\x85\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x77"],
        ["\xE7\x85\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x78"],
        ["\xE7\x86\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x7A"],
        ["\xE7\x86\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x7B"],
        ["\xE7\x86\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x7C"],
        ["\xE7\x86\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x7E"],
        ["\xE7\x87\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x80"],
        ["\xE7\x88\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x82"],
        ["\xE7\x88\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x83"],
        ["\xE7\x89\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x84"],
        ["\xE7\x89\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x85"],
        ["\xE3\xB8\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x86"],
        ["\xE7\x8A\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x87"],
        ["\xE7\x8A\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x88"],
        ["\xE7\x8B\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x8A"],
        ["\xE7\x8B\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x8B"],
        ["\xF0\xA4\x9F\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x8C"],
        ["\xE7\x8C\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x8D"],
        ["\xE7\x8C\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x8E"],
        ["\xE7\x8D\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x90"],
        ["\xE7\x8D\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x91"],
        ["\xE7\x8D\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x92"],
        ["\xE7\x8E\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x93"],
        ["\xE7\x8E\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x94"],
        ["\xE7\x8E\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x95"],
        ["\xE7\x8E\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x96"],
        ["\xE7\x8E\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x97"],
        ["\xE7\x8E\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x98"],
        ["\xE7\x8F\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x9A"],
        ["\xE7\x8F\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x9C"],
        ["\xE7\x8F\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\x9E"],
        ["\xE7\x90\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA0"],
        ["\xE7\x90\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA1"],
        ["\xE7\x90\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA2"],
        ["\xEF\xA9\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA3"],
        ["\xE7\x90\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA5"],
        ["\xE7\x90\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA7"],
        ["\xE7\x90\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA8"],
        ["\xE7\x90\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],
        ["\xE7\x90\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],
        ["\xE7\x91\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAC"],
        ["\xE7\x91\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAD"],
        ["\xE7\x91\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAE"],
        ["\xE7\x91\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAF"],
        ["\xE7\x91\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB0"],
        ["\xE7\x91\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB2"],
        ["\xE7\x91\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB3"],
        ["\xE7\x92\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB4"],
        ["\xE7\x92\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB5"],
        ["\xE7\x92\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB7"],
        ["\xE7\x92\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB8"],
        ["\xE7\x92\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBA"],
        ["\xE7\x92\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBB"],
        ["\xE7\x92\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBC"],
        ["\xE7\x92\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBD"],
        ["\xE7\x92\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBE"],
        ["\xE7\x92\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBF"],
        ["\xE7\x92\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC0"],
        ["\xE7\x93\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC1"],
        ["\xE7\x93\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC2"],
        ["\xE7\x93\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC3"],
        ["\xE7\x93\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC4"],
        ["\xE7\x94\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC6"],
        ["\xE7\x95\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC9"],
        ["\xE7\x96\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCA"],
        ["\xE3\xBD\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCB"],
        ["\xE7\x97\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCC"],
        ["\xE7\x97\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCD"],
        ["\xE7\x98\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCE"],
        ["\xE7\x98\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCF"],
        ["\xE7\x98\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD0"],
        ["\xE7\x98\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD1"],
        ["\xE7\x98\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD2"],
        ["\xE7\x98\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD3"],
        ["\xE7\x98\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD4"],
        ["\xE7\x98\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD5"],
        ["\xE7\x98\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD6"],
        ["\xE7\x99\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD7"],
        ["\xE7\x99\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD8"],
        ["\xE7\x99\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD9"],
        ["\xE7\x99\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDA"],
        ["\xE7\x99\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDB"],
        ["\xE7\x99\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDC"],
        ["\xE7\x99\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDD"],
        ["\xE7\x9A\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDE"],
        ["\xE7\x9A\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE0"],
        ["\xE7\x9A\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE3"],
        ["\xE7\x9A\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE4"],
        ["\xE7\x9B\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE5"],
        ["\xE7\x9B\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE6"],
        ["\xE7\x9B\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE7"],
        ["\xE7\x9B\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE8"],
        ["\xE7\x9B\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE9"],
        ["\xE7\x9B\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEA"],
        ["\xE7\x9B\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEB"],
        ["\xE7\x9C\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEC"],
        ["\xE7\x9C\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xED"],
        ["\xE7\x9C\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEE"],
        ["\xE7\x9C\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEF"],
        ["\xE7\x9D\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF1"],
        ["\xE7\x9D\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF2"],
        ["\xE7\x9D\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF3"],
        ["\xE7\x9D\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF4"],
        ["\xE7\x9D\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF5"],
        ["\xE7\x9D\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF6"],
        ["\xE7\x9E\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF7"],
        ["\xE7\x9E\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF8"],
        ["\xE7\x9E\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF9"],
        ["\xE7\x9F\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xFA"],
        ["\xE7\xA0\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xFB"],
        ["\xF0\xA5\x92\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xFC"],
        ["\xE7\xA1\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x40"],
        ["\xE7\xA1\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x42"],
        ["\xE7\xA1\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x43"],
        ["\xE7\xA1\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x44"],
        ["\xE7\xA1\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x45"],
        ["\xEF\xA9\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x46"],
        ["\xE7\xA2\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x47"],
        ["\xF0\xA5\x94\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x48"],
        ["\xE7\xA2\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x49"],
        ["\xE7\xA3\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x4A"],
        ["\xE7\xA3\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x4B"],
        ["\xE7\xA4\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x4C"],
        ["\xE7\xA3\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x4D"],
        ["\xE7\xA4\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x4E"],
        ["\xE7\xA4\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x4F"],
        ["\xE7\xA4\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x50"],
        ["\xE7\xA4\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x51"],
        ["\xEF\xA9\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x52"],
        ["\xEF\xA9\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x53"],
        ["\xE7\xA5\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x54"],
        ["\xE7\xA5\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x55"],
        ["\xEF\xA9\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x56"],
        ["\xEF\xA9\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x57"],
        ["\xEF\xA9\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x58"],
        ["\xE7\xA5\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x59"],
        ["\xEF\xA9\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x5A"],
        ["\xE7\xA5\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x5D"],
        ["\xEF\xA9\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x5E"],
        ["\xEF\xA9\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x5F"],
        ["\xE7\xA6\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x61"],
        ["\xE7\xA6\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x62"],
        ["\xE7\xA6\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x63"],
        ["\xE7\xA7\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x64"],
        ["\xE7\xA7\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x65"],
        ["\xF0\xA5\x9D\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x66"],
        ["\xE7\xA7\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x67"],
        ["\xE7\xA7\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x68"],
        ["\xE7\xA7\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x69"],
        ["\xE7\xA7\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x6A"],
        ["\xE7\xA8\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x6B"],
        ["\xEF\xA9\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x6C"],
        ["\xE7\xA8\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x6D"],
        ["\xE7\xA9\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x6E"],
        ["\xE7\xA9\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x6F"],
        ["\xEF\xA9\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x70"],
        ["\xE7\xAA\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x71"],
        ["\xE7\xAA\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x72"],
        ["\xF0\xA5\xA7\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x73"],
        ["\xE7\xAA\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x74"],
        ["\xE7\xAA\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x75"],
        ["\xE7\xAB\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x76"],
        ["\xE7\xAB\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x78"],
        ["\xE7\xAC\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x79"],
        ["\xE7\xAC\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x7A"],
        ["\xE7\xAC\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x7B"],
        ["\xE7\xAD\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x7C"],
        ["\xE7\xAD\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x7D"],
        ["\xE7\xAD\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x7E"],
        ["\xE7\xAD\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x80"],
        ["\xE7\xAD\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x81"],
        ["\xE7\xAD\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x82"],
        ["\xEF\xA9\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x84"],
        ["\xE7\xAF\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x85"],
        ["\xE7\xAF\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x86"],
        ["\xE7\xB0\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x87"],
        ["\xE7\xB0\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x88"],
        ["\xE7\xB0\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x89"],
        ["\xE7\xB0\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x8A"],
        ["\xE7\xB0\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x8B"],
        ["\xE7\xB0\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x8C"],
        ["\xE4\x89\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x8D"],
        ["\xF0\xA5\xB6\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x8E"],
        ["\xE7\xB1\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x8F"],
        ["\xE7\xB1\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x90"],
        ["\xE7\xB1\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x91"],
        ["\xE7\xB2\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x92"],
        ["\xE7\xB2\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x93"],
        ["\xE7\xB2\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x94"],
        ["\xE7\xB2\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x95"],
        ["\xE7\xB3\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x96"],
        ["\xE7\xB3\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x97"],
        ["\xE7\xB3\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x98"],
        ["\xE7\xB4\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x99"],
        ["\xE7\xB4\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x9A"],
        ["\xE7\xB4\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x9B"],
        ["\xE7\xB4\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x9C"],
        ["\xE7\xB4\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x9D"],
        ["\xE7\xB4\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x9E"],
        ["\xE7\xB5\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\x9F"],
        ["\xE7\xB5\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA1"],
        ["\xE7\xB5\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA3"],
        ["\xE7\xB6\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA4"],
        ["\xE7\xB6\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA5"],
        ["\xE7\xB6\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA7"],
        ["\xE7\xB7\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA8"],
        ["\xE7\xB7\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA9"],
        ["\xE7\xB7\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAB"],
        ["\xEF\xA9\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAC"],
        ["\xE7\xB8\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAD"],
        ["\xE7\xB8\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAE"],
        ["\xE7\xB8\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAF"],
        ["\xE7\xB8\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB0"],
        ["\xEF\xA9\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB1"],
        ["\xE7\xB9\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB2"],
        ["\xE7\xB9\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB4"],
        ["\xE7\xBA\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB6"],
        ["\xEF\xA9\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB8"],
        ["\xE7\xBE\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB9"],
        ["\xE7\xBE\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBA"],
        ["\xE7\xBE\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBB"],
        ["\xE7\xBF\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBC"],
        ["\xE7\xBF\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBD"],
        ["\xE7\xBF\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBE"],
        ["\xE7\xBF\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBF"],
        ["\xE7\xBF\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC0"],
        ["\xE7\xBF\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC1"],
        ["\xEF\xA9\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC2"],
        ["\xE8\x80\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC3"],
        ["\xE8\x80\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC4"],
        ["\xE8\x80\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC5"],
        ["\xE8\x80\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC6"],
        ["\xE8\x80\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC7"],
        ["\xE8\x83\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC8"],
        ["\xE8\x83\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC9"],
        ["\xE8\x83\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCA"],
        ["\xE8\x83\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCB"],
        ["\xE8\x84\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCC"],
        ["\xE8\x85\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCD"],
        ["\xE8\x85\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCE"],
        ["\xE8\x85\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCF"],
        ["\xE8\x85\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD0"],
        ["\xE8\x85\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD1"],
        ["\xE8\x86\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD2"],
        ["\xE8\x87\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD3"],
        ["\xE8\x87\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD4"],
        ["\xE8\x87\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD5"],
        ["\xEF\xA9\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD6"],
        ["\xE4\x91\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD7"],
        ["\xE4\x91\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD8"],
        ["\xE8\x89\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD9"],
        ["\xE8\x89\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDA"],
        ["\xF0\xA6\xAB\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDB"],
        ["\xE8\x8A\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDC"],
        ["\xE8\x8A\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDD"],
        ["\xE8\x8A\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDE"],
        ["\xE8\x8A\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDF"],
        ["\xE8\x8A\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE0"],
        ["\xE8\x8A\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE1"],
        ["\xE8\x8A\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE2"],
        ["\xE8\x8A\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE3"],
        ["\xE8\x8A\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE4"],
        ["\xE8\x8B\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE5"],
        ["\xE8\x8B\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE6"],
        ["\xE8\x8B\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE7"],
        ["\xE8\x8B\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE8"],
        ["\xE8\x8C\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE9"],
        ["\xE8\x8C\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEC"],
        ["\xE8\x8C\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xED"],
        ["\xE8\x8C\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEE"],
        ["\xE8\x8D\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEF"],
        ["\xE8\x8D\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF0"],
        ["\xE8\x8D\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF1"],
        ["\xE8\x8D\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF2"],
        ["\xE8\x8D\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF3"],
        ["\xE8\x8E\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF4"],
        ["\xE8\x8E\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF5"],
        ["\xE8\x8E\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF6"],
        ["\xE8\x8E\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF7"],
        ["\xE8\x8E\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF8"],
        ["\xE8\x8E\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF9"],
        ["\xE8\x8F\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xFA"],
        ["\xE8\x8F\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xFC"],
        ["\xE8\x8F\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x40"],
        ["\xE8\x8F\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x41"],
        ["\xE8\x8F\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x42"],
        ["\xE8\x90\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x43"],
        ["\xE8\x90\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x44"],
        ["\xE8\x90\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x45"],
        ["\xEF\xA9\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x46"],
        ["\xE8\x91\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x48"],
        ["\xE8\x91\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x49"],
        ["\xE8\x91\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x4A"],
        ["\xE8\x92\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x4B"],
        ["\xE8\x92\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x4C"],
        ["\xE8\x92\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x4D"],
        ["\xE8\x92\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x4F"],
        ["\xE8\x93\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x50"],
        ["\xE8\x93\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x51"],
        ["\xF0\xA6\xB9\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x52"],
        ["\xE8\x94\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x53"],
        ["\xE8\x94\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x54"],
        ["\xE8\x94\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x55"],
        ["\xE8\x94\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x56"],
        ["\xE8\x95\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x58"],
        ["\xE8\x96\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x5A"],
        ["\xE8\x95\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x5B"],
        ["\xE8\x96\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x5C"],
        ["\xE8\x96\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x5D"],
        ["\xE8\x96\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x5E"],
        ["\xE8\x97\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x60"],
        ["\xE8\x97\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x61"],
        ["\xE8\x97\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x62"],
        ["\xE8\x98\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x63"],
        ["\xE8\x97\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x64"],
        ["\xE8\x98\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x65"],
        ["\xE8\x98\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x66"],
        ["\xE8\x98\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x67"],
        ["\xF0\xA7\x83\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x68"],
        ["\xE8\x98\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x69"],
        ["\xE8\x98\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x6A"],
        ["\xE8\x98\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x6B"],
        ["\xE8\x99\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x6C"],
        ["\xE8\x99\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x6D"],
        ["\xEF\xA4\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x6E"],
        ["\xE8\x99\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x6F"],
        ["\xE4\x96\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x70"],
        ["\xE8\x99\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x71"],
        ["\xE8\x99\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x72"],
        ["\xE8\x9A\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x73"],
        ["\xE8\x9A\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x74"],
        ["\xE8\x9B\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x75"],
        ["\xE8\x9B\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x76"],
        ["\xE8\x9B\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x77"],
        ["\xE8\x9C\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x78"],
        ["\xE8\x9D\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x79"],
        ["\xE8\x9E\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x7A"],
        ["\xE8\x9E\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x7B"],
        ["\xE8\x9E\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x7C"],
        ["\xE8\x9E\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x7D"],
        ["\xE8\x9E\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x7E"],
        ["\xE4\x97\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x80"],
        ["\xE8\x9F\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x81"],
        ["\xE8\x9F\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x82"],
        ["\xE8\xA0\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x83"],
        ["\xE8\xA0\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x84"],
        ["\xE8\xA0\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x85"],
        ["\xE8\xA0\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x86"],
        ["\xE8\xA0\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x87"],
        ["\xE8\xA2\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x88"],
        ["\xE8\xA2\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x89"],
        ["\xE8\xA3\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x8A"],
        ["\xE8\xA3\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x8B"],
        ["\xF0\xA7\x9A\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x8C"],
        ["\xEF\xA9\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x8F"],
        ["\xE8\xA4\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x90"],
        ["\xE8\xA4\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x91"],
        ["\xE8\xA4\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x92"],
        ["\xE8\xA4\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x93"],
        ["\xE8\xA4\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x94"],
        ["\xE8\xA4\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x95"],
        ["\xE8\xA4\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x96"],
        ["\xE8\xA5\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x97"],
        ["\xE8\xA6\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x98"],
        ["\xEF\xA9\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x99"],
        ["\xE8\xA7\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x9A"],
        ["\xE8\xA7\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x9B"],
        ["\xE8\xA7\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x9C"],
        ["\xE8\xA8\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x9E"],
        ["\xE8\xA8\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\x9F"],
        ["\xE8\xA9\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA1"],
        ["\xE8\xA9\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA2"],
        ["\xE8\xA9\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA3"],
        ["\xE8\xA9\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA4"],
        ["\xE8\xA9\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA5"],
        ["\xE8\xAB\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA8"],
        ["\xE8\xAB\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAA"],
        ["\xEF\xA9\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAD"],
        ["\xEF\xA9\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAE"],
        ["\xE8\xAD\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAF"],
        ["\xE8\xAD\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB0"],
        ["\xE8\xAD\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB1"],
        ["\xE8\xAD\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB2"],
        ["\xE8\xAE\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB3"],
        ["\xE8\xB1\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB4"],
        ["\xE8\xB1\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB5"],
        ["\xEF\xA9\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB6"],
        ["\xE8\xB3\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB7"],
        ["\xE8\xB3\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB9"],
        ["\xE8\xB3\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBA"],
        ["\xEF\xA9\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBB"],
        ["\xE8\xB4\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBD"],
        ["\xE8\xB6\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBE"],
        ["\xE8\xB7\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBF"],
        ["\xE8\xB7\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC0"],
        ["\xE8\xB7\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC1"],
        ["\xE8\xB8\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC2"],
        ["\xE8\xB8\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC3"],
        ["\xE8\xB8\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC4"],
        ["\xE8\xB9\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC5"],
        ["\xE8\xB9\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC6"],
        ["\xF0\xA8\x89\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC7"],
        ["\xE8\xBB\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC8"],
        ["\xE4\xA1\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC9"],
        ["\xE8\xBB\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCA"],
        ["\xE8\xBC\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCB"],
        ["\xE8\xBC\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCC"],
        ["\xE8\xBC\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCD"],
        ["\xE8\xBD\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCE"],
        ["\xF0\xA8\x8F\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCF"],
        ["\xE8\xBE\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD0"],
        ["\xE8\xBE\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD1"],
        ["\xE8\xBF\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD2"],
        ["\xE8\xBF\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD3"],
        ["\xE8\xBF\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD4"],
        ["\xE9\x80\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD5"],
        ["\xE9\x80\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD6"],
        ["\xEF\xA9\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD7"],
        ["\xE9\x82\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD8"],
        ["\xE9\x82\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD9"],
        ["\xE9\x82\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDA"],
        ["\xE9\x82\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDB"],
        ["\xE9\x82\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDC"],
        ["\xE9\x82\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDD"],
        ["\xE9\x82\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDE"],
        ["\xE9\x82\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDF"],
        ["\xE9\x83\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE0"],
        ["\xE9\x83\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE1"],
        ["\xE9\x83\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE2"],
        ["\xE9\x83\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE3"],
        ["\xE9\x83\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE4"],
        ["\xE9\x83\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE6"],
        ["\xE9\x83\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE7"],
        ["\xE9\x84\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE9"],
        ["\xE9\x84\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEB"],
        ["\xE9\x84\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEC"],
        ["\xE9\x84\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xED"],
        ["\xE9\x84\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEF"],
        ["\xE9\x84\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF0"],
        ["\xE9\x84\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF1"],
        ["\xE9\x84\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF2"],
        ["\xE9\x85\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF3"],
        ["\xE9\x85\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF4"],
        ["\xE9\x86\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF5"],
        ["\xE9\x86\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF6"],
        ["\xE9\x86\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF7"],
        ["\xE9\x86\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF8"],
        ["\xE9\x86\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF9"],
        ["\xE9\x87\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xFB"],
        ["\xE9\x87\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x42"],
        ["\xE9\x88\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x43"],
        ["\xE9\x88\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x45"],
        ["\xE9\x89\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x4A"],
        ["\xE9\x89\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x4B"],
        ["\xE9\x8B\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x4E"],
        ["\xE9\x8B\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x4F"],
        ["\xE9\x8B\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x50"],
        ["\xE9\x8C\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x54"],
        ["\xE9\x8C\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x55"],
        ["\xE9\x8D\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x59"],
        ["\xE9\x8D\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x5A"],
        ["\xE9\x8D\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x5B"],
        ["\xE9\x8D\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x5C"],
        ["\xE9\x8D\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x5D"],
        ["\xE9\x8E\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x5F"],
        ["\xE9\x8E\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x60"],
        ["\xE9\x8E\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x61"],
        ["\xE9\x8F\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x64"],
        ["\xE9\x90\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x65"],
        ["\xE9\x8F\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x66"],
        ["\xE9\x90\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x67"],
        ["\xE9\x91\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x68"],
        ["\xE9\x91\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x69"],
        ["\xE9\x91\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x6A"],
        ["\xE9\x91\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x6B"],
        ["\xE9\x91\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x6C"],
        ["\xE9\x96\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x6D"],
        ["\xE9\x96\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x6E"],
        ["\xE9\x96\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x6F"],
        ["\xE9\x96\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x70"],
        ["\xE9\x96\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x71"],
        ["\xE9\x96\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x72"],
        ["\xE9\x96\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x73"],
        ["\xE9\x97\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x74"],
        ["\xE9\x97\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x75"],
        ["\xE9\x97\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x76"],
        ["\xE4\xA6\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x77"],
        ["\xE9\x97\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x78"],
        ["\xE9\x97\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x79"],
        ["\xE9\x99\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x7A"],
        ["\xE9\x9A\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x7B"],
        ["\xE9\x9A\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x7E"],
        ["\xE9\x9A\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x80"],
        ["\xE9\x9B\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x81"],
        ["\xE9\x9B\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x82"],
        ["\xEF\xA9\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x83"],
        ["\xE9\x9B\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x84"],
        ["\xE9\x9B\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x85"],
        ["\xE9\x9D\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x89"],
        ["\xE9\x9D\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x8B"],
        ["\xE9\x9D\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x8C"],
        ["\xE9\x9D\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x8D"],
        ["\xE9\x9E\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x8E"],
        ["\xE9\x9E\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x8F"],
        ["\xE9\x9E\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x90"],
        ["\xE9\x9F\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x91"],
        ["\xE9\x9F\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x92"],
        ["\xE9\x9F\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x93"],
        ["\xE9\x9F\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x94"],
        ["\xE9\x9F\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x95"],
        ["\xEF\xA9\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x96"],
        ["\xE9\xA0\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x97"],
        ["\xE9\xA0\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x98"],
        ["\xE9\xA0\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x99"],
        ["\xE9\xA0\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x9A"],
        ["\xEF\xA9\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x9B"],
        ["\xE9\xA1\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x9C"],
        ["\xE9\xA1\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x9D"],
        ["\xE9\xA1\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\x9E"],
        ["\xE9\xA1\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA0"],
        ["\xE9\xA1\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA1"],
        ["\xEF\xA7\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA2"],
        ["\xE9\xA1\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4"],
        ["\xE9\xA2\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5"],
        ["\xE9\xA3\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA6"],
        ["\xE9\xA3\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7"],
        ["\xE9\xA5\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8"],
        ["\xE9\xA8\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAA"],
        ["\xE9\xA8\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAB"],
        ["\xE9\xA8\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAC"],
        ["\xE9\xA8\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAD"],
        ["\xE9\xA8\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAE"],
        ["\xE9\xA8\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAF"],
        ["\xE9\xA9\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB0"],
        ["\xE9\xA9\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB2"],
        ["\xE9\xAA\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB3"],
        ["\xE9\xAB\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB4"],
        ["\xE9\xAB\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB5"],
        ["\xE9\xAB\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB6"],
        ["\xE9\xAB\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB7"],
        ["\xE9\xAB\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB8"],
        ["\xE9\xAC\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9"],
        ["\xE9\xAC\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBA"],
        ["\xE9\xAC\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBB"],
        ["\xE4\xB0\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC"],
        ["\xE9\xAC\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD"],
        ["\xE9\xAD\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE"],
        ["\xE9\xAD\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF"],
        ["\xE9\xAD\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC0"],
        ["\xE9\xAE\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC3"],
        ["\xE9\xAE\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC4"],
        ["\xE9\xAE\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC6"],
        ["\xE9\xAE\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC7"],
        ["\xE9\xAF\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC8"],
        ["\xE9\xAF\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC9"],
        ["\xE9\xAF\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCA"],
        ["\xE9\xAF\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCB"],
        ["\xE9\xAF\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCC"],
        ["\xE9\xB0\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCE"],
        ["\xE9\xB1\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCF"],
        ["\xE9\xB1\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD0"],
        ["\xE9\xB1\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD1"],
        ["\xE9\xB1\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD2"],
        ["\xE9\xB1\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD3"],
        ["\xE9\xB1\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD4"],
        ["\xE9\xB1\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD5"],
        ["\xE9\xB4\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD6"],
        ["\xE9\xB4\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD7"],
        ["\xE9\xB5\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD8"],
        ["\xE9\xB5\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD9"],
        ["\xE9\xB5\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDA"],
        ["\xE9\xB5\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDB"],
        ["\xE9\xB5\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDD"],
        ["\xE9\xB6\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDE"],
        ["\xE9\xB6\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDF"],
        ["\xE9\xB7\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE0"],
        ["\xE9\xB6\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE1"],
        ["\xE9\xB6\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE2"],
        ["\xE9\xB7\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE3"],
        ["\xF0\xAA\x86\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE4"],
        ["\xE9\xB7\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE5"],
        ["\xE9\xB8\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE6"],
        ["\xE9\xB8\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE7"],
        ["\xE9\xB9\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE8"],
        ["\xE9\xBA\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE9"],
        ["\xE9\xBA\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEA"],
        ["\xE9\xBA\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEB"],
        ["\xE9\xBA\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEC"],
        ["\xE9\xBA\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xED"],
        ["\xE9\xBA\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEE"],
        ["\xE9\xBB\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEF"],
        ["\xE9\xBC\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF1"],
        ["\xE9\xBC\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF2"],
        ["\xE9\xBD\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF3"],
        ["\xE9\xBE\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF4"],
        ["\xE9\xBE\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF5"],
        ["\xE9\xBE\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF6"],
        ["\xE9\xBE\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF7"],
        ["\xE5\xA7\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF8"],
        ["\xE5\xB1\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF9"],
        ["\xE5\xB9\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xFA"],
        ["\xE7\x98\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xFB"],
        ["\xE7\xB9\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xFC"],
        ["\xF0\xA0\x82\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x40"],
        ["\xE4\xB8\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x41"],
        ["\xE4\xB8\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x42"],
        ["\xE4\xB8\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x43"],
        ["\xE4\xB8\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x44"],
        ["\xE4\xB8\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x45"],
        ["\xE4\xB8\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x46"],
        ["\xE4\xB9\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x47"],
        ["\xE4\xB9\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x48"],
        ["\xE4\xB9\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x49"],
        ["\xF0\xA0\x82\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x4A"],
        ["\xE4\xB9\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x4B"],
        ["\xE3\x90\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x4C"],
        ["\xF0\xA0\x82\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x4D"],
        ["\xE4\xB9\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x4E"],
        ["\xE4\xB9\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x4F"],
        ["\xE4\xBA\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x50"],
        ["\xE3\x90\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x51"],
        ["\xE3\x90\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x52"],
        ["\xE4\xBA\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x53"],
        ["\xE4\xBA\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x54"],
        ["\xF0\xA0\x86\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x55"],
        ["\xE4\xBA\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x56"],
        ["\xE4\xBB\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x57"],
        ["\xE4\xBB\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x58"],
        ["\xE4\xBB\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x59"],
        ["\xE4\xBB\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x5A"],
        ["\xE4\xBB\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x5B"],
        ["\xE4\xBB\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x5C"],
        ["\xE4\xBB\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x5D"],
        ["\xE4\xBC\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x5F"],
        ["\xE4\xBD\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x60"],
        ["\xE4\xBC\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x61"],
        ["\xE4\xBC\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x62"],
        ["\xE4\xBD\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x63"],
        ["\xE4\xBD\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x64"],
        ["\xF0\xA0\x88\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x65"],
        ["\xE4\xBD\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x66"],
        ["\xE4\xBD\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x67"],
        ["\xE4\xBD\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x68"],
        ["\xE4\xBD\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x69"],
        ["\xE4\xBE\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x6A"],
        ["\xE4\xBE\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x6B"],
        ["\xE4\xBF\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x6E"],
        ["\xE4\xBE\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x6F"],
        ["\xE4\xBE\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x70"],
        ["\xE4\xBF\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x71"],
        ["\xE4\xBF\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x72"],
        ["\xE4\xBF\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x73"],
        ["\xE4\xBF\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x74"],
        ["\xE3\x91\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x75"],
        ["\xE4\xBF\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x76"],
        ["\xE5\x80\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x77"],
        ["\xE5\x80\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x78"],
        ["\xE5\x80\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x79"],
        ["\xE5\x80\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x7A"],
        ["\xE3\x91\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x7D"],
        ["\xE5\x81\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x81"],
        ["\xE5\x81\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x82"],
        ["\xE5\x81\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x83"],
        ["\xE5\x81\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x84"],
        ["\xE5\x81\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x85"],
        ["\xE5\x81\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x86"],
        ["\xE5\x82\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x88"],
        ["\xE5\x82\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x89"],
        ["\xE5\x82\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x8A"],
        ["\xE5\x82\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x8B"],
        ["\xE5\x82\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x8C"],
        ["\xE5\x82\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x8D"],
        ["\xE5\x82\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x8E"],
        ["\xE5\x82\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x8F"],
        ["\xF0\xA0\x8C\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x90"],
        ["\xE5\x82\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x91"],
        ["\xE5\x82\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x92"],
        ["\xE5\x82\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x93"],
        ["\xE5\x83\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x94"],
        ["\xE5\x83\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x95"],
        ["\xE5\x83\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x96"],
        ["\xF0\xA0\x8E\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x97"],
        ["\xE5\x83\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x98"],
        ["\xF0\xA0\x8D\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x99"],
        ["\xE5\x83\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x9A"],
        ["\xE5\x83\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x9B"],
        ["\xE5\x83\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x9C"],
        ["\xE5\x83\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x9D"],
        ["\xE3\x92\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x9E"],
        ["\xE5\xAE\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\x9F"],
        ["\xE5\xAE\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0"],
        ["\xE3\x9D\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],
        ["\xE3\x9D\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3"],
        ["\xE5\xAF\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4"],
        ["\xE5\xAF\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5"],
        ["\xE3\x9D\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6"],
        ["\xE3\x9D\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7"],
        ["\xE5\xAF\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8"],
        ["\xE5\xAF\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9"],
        ["\xE3\x9D\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA"],
        ["\xE5\xB0\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],
        ["\xE5\xB0\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAC"],
        ["\xE5\xB0\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAD"],
        ["\xF0\xA1\xB1\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAE"],
        ["\xE5\xB1\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAF"],
        ["\xE5\xB1\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],
        ["\xE5\xB1\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB1"],
        ["\xE5\xB1\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB2"],
        ["\xE5\xB1\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB3"],
        ["\xE5\xB1\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB4"],
        ["\xF0\xA1\xB4\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB5"],
        ["\xF0\xA1\xB5\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB6"],
        ["\xE5\xB1\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB7"],
        ["\xF0\xA1\xB5\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB8"],
        ["\xF0\xA1\xB5\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB9"],
        ["\xE5\xB2\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBA"],
        ["\xE5\xB2\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBB"],
        ["\xE3\x9F\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBC"],
        ["\xF0\xA1\xB6\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBD"],
        ["\xF0\xA1\xB6\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBE"],
        ["\xE5\xB2\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBF"],
        ["\xE5\xB2\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],
        ["\xE5\xB2\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],
        ["\xF0\xA1\xB6\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],
        ["\xE5\xB2\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],
        ["\xE5\xB2\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],
        ["\xF0\xA1\xB6\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],
        ["\xE5\xB3\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],
        ["\xF0\xA1\xB7\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],
        ["\xF0\xA1\xB8\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],
        ["\xE5\xB4\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCA"],
        ["\xE5\xB4\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCB"],
        ["\xE5\xB4\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCC"],
        ["\xE5\xB4\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCD"],
        ["\xE5\xB4\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCE"],
        ["\xE5\xB4\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCF"],
        ["\xE5\xB4\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],
        ["\xE5\xB4\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],
        ["\xE5\xB4\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],
        ["\xE3\x9F\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],
        ["\xE5\xB5\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],
        ["\xE5\xB5\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],
        ["\xE3\x9F\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],
        ["\xE5\xB5\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],
        ["\xF0\xA1\xBC\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],
        ["\xE3\x9F\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDA"],
        ["\xE5\xB6\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDB"],
        ["\xE3\xA0\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDC"],
        ["\xE5\xB6\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDD"],
        ["\xE5\xB6\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDE"],
        ["\xE5\xB6\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDF"],
        ["\xE5\xB6\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],
        ["\xE5\xB6\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE1"],
        ["\xE5\xB6\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],
        ["\xE5\xB6\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],
        ["\xF0\xA1\xBD\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],
        ["\xE5\xB7\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],
        ["\xE5\xB7\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],
        ["\xE5\xB7\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],
        ["\xE5\xB7\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],
        ["\xF0\xA1\xBF\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEA"],
        ["\xE5\xB7\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEB"],
        ["\xE5\xB7\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEC"],
        ["\xE3\xA0\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xED"],
        ["\xE5\xB8\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEE"],
        ["\xE3\xA0\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEF"],
        ["\xE5\xB8\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],
        ["\xE5\xB8\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],
        ["\xE3\xA1\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],
        ["\xE5\xB8\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],
        ["\xE5\xB8\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],
        ["\xE5\xB8\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],
        ["\xE5\xB9\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],
        ["\xE3\xA1\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],
        ["\xE5\xB9\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],
        ["\xE3\xA1\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],
        ["\xE5\xB9\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xFA"],
        ["\xE5\xB9\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xFB"],
        ["\xE5\xB9\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xFC"],
        ["\xE5\x84\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x40"],
        ["\xF0\xA0\x8F\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x41"],
        ["\xE5\x84\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x42"],
        ["\xE5\x84\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x43"],
        ["\xF0\xA0\x91\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x44"],
        ["\xE5\x85\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x45"],
        ["\xF0\xA0\x94\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x46"],
        ["\xE5\x85\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x47"],
        ["\xE5\x86\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x48"],
        ["\xE5\x86\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x49"],
        ["\xE3\x92\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x4A"],
        ["\xE5\x86\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x4B"],
        ["\xE5\x86\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x4C"],
        ["\xE5\x86\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x4D"],
        ["\xE3\x93\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x4E"],
        ["\xE5\x86\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x4F"],
        ["\xF0\xA0\x97\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x50"],
        ["\xF0\xA0\x98\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x51"],
        ["\xE5\x87\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x52"],
        ["\xE5\x87\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x53"],
        ["\xE5\x88\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x54"],
        ["\xE5\x88\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x55"],
        ["\xE5\x88\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x56"],
        ["\xF0\xA0\x9D\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x57"],
        ["\xE5\x89\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x58"],
        ["\xE5\x89\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x59"],
        ["\xE5\x89\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x5A"],
        ["\xE5\x89\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x5B"],
        ["\xE5\x8A\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x5C"],
        ["\xE5\x8A\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x5D"],
        ["\xF0\xA0\xA0\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x5E"],
        ["\xE5\x8A\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x5F"],
        ["\xF0\xA0\xA0\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x60"],
        ["\xE5\x8A\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x61"],
        ["\xE5\x8A\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x64"],
        ["\xE5\x8A\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x65"],
        ["\xE5\x8B\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x66"],
        ["\xE3\x94\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x67"],
        ["\xE5\x8B\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x68"],
        ["\xF0\xA0\xA2\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x69"],
        ["\xE5\x8B\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x6A"],
        ["\xE5\x8C\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x6B"],
        ["\xE5\x8C\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x6C"],
        ["\xE5\x8C\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x6E"],
        ["\xE5\x8C\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x6F"],
        ["\xE5\x8D\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x70"],
        ["\xF0\xA0\xA5\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x71"],
        ["\xF0\xA0\xA6\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x72"],
        ["\xE5\x8D\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x73"],
        ["\xE5\x8D\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x74"],
        ["\xE5\x8D\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x75"],
        ["\xE5\x8E\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x76"],
        ["\xE5\x8E\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x77"],
        ["\xF0\xA0\xAB\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x78"],
        ["\xE5\x8E\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x79"],
        ["\xE5\x8F\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x7A"],
        ["\xF0\xA0\xAC\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x7B"],
        ["\xE3\x95\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x7C"],
        ["\xE3\x95\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x7D"],
        ["\xE5\x8F\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x7E"],
        ["\xE5\x8F\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x80"],
        ["\xE3\x95\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x81"],
        ["\xE5\x8F\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x82"],
        ["\xE5\x8F\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x83"],
        ["\xE5\x91\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x84"],
        ["\xE5\x90\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x85"],
        ["\xE5\x90\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x86"],
        ["\xE3\x95\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x87"],
        ["\xE5\x91\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x88"],
        ["\xE5\x91\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x89"],
        ["\xE5\x91\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x8A"],
        ["\xE5\x91\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x8B"],
        ["\xE5\x92\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x8D"],
        ["\xE5\x92\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x8E"],
        ["\xE5\x92\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x8F"],
        ["\xE5\x92\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x90"],
        ["\xE5\x92\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x91"],
        ["\xE5\x92\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x92"],
        ["\xE5\x92\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x93"],
        ["\xE5\x92\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x94"],
        ["\xE5\x92\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x95"],
        ["\xE5\x93\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x96"],
        ["\xF0\xA0\xB5\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x97"],
        ["\xE5\x93\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x98"],
        ["\xE5\x93\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x99"],
        ["\xE5\x93\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x9A"],
        ["\xE5\x93\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x9B"],
        ["\xE5\x94\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x9C"],
        ["\xE5\x94\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x9D"],
        ["\xE5\x94\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x9E"],
        ["\xE5\x94\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\x9F"],
        ["\xE5\x95\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA0"],
        ["\xE3\x96\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],
        ["\xE5\x95\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA2"],
        ["\xE5\x95\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA3"],
        ["\xE3\x96\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA4"],
        ["\xE5\x95\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA5"],
        ["\xE5\x95\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA6"],
        ["\xE5\x95\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA7"],
        ["\xF0\xA0\xB7\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA8"],
        ["\xE5\x95\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA9"],
        ["\xE5\x96\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAA"],
        ["\xE5\x96\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],
        ["\xE5\x96\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAC"],
        ["\xE3\x97\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAD"],
        ["\xE5\x97\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAE"],
        ["\xF0\xA0\xBA\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAF"],
        ["\xF0\xA0\xB9\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],
        ["\xE5\x96\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB1"],
        ["\xE5\x97\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB2"],
        ["\xE5\x97\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB3"],
        ["\xE5\x97\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB4"],
        ["\xE5\x97\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB5"],
        ["\xE3\x97\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB6"],
        ["\xE5\x97\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB7"],
        ["\xF0\xA0\xB9\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB8"],
        ["\xE5\x97\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB9"],
        ["\xE5\x98\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBA"],
        ["\xF0\xA0\xBD\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBB"],
        ["\xE5\x98\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBC"],
        ["\xE5\x98\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBD"],
        ["\xE5\x98\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBE"],
        ["\xE5\x98\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBF"],
        ["\xE3\x97\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],
        ["\xE5\x98\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],
        ["\xE5\x98\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],
        ["\xE5\x99\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],
        ["\xE5\x99\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],
        ["\xE5\x99\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],
        ["\xE5\x99\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],
        ["\xE5\x99\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],
        ["\xE3\x98\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],
        ["\xE5\x9A\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],
        ["\xE5\x9A\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCA"],
        ["\xE5\x9A\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCB"],
        ["\xE5\x9A\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCC"],
        ["\xE5\x9A\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCD"],
        ["\xE5\x9A\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCE"],
        ["\xE5\x9A\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCF"],
        ["\xE5\x9A\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],
        ["\xE5\x9B\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],
        ["\xE5\x9B\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],
        ["\xE5\x9B\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],
        ["\xE5\x9B\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],
        ["\xE5\x9B\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],
        ["\xE5\x9B\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],
        ["\xF0\xA1\x88\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],
        ["\xE5\x9C\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],
        ["\xE5\x9C\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],
        ["\xF0\xA1\x89\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDA"],
        ["\xE5\x9C\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDB"],
        ["\xF0\xA1\x89\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDC"],
        ["\xE5\x9D\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDD"],
        ["\xE5\x9D\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDE"],
        ["\xE5\x9D\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDF"],
        ["\xE5\x9D\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],
        ["\xF0\xA1\x89\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE1"],
        ["\xE5\x9D\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],
        ["\xE5\x9D\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],
        ["\xE5\x9D\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],
        ["\xE5\x9D\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],
        ["\xE5\x9D\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],
        ["\xE5\x9D\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],
        ["\xF0\xA1\x8B\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],
        ["\xF0\xA1\x8B\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],
        ["\xE5\x9E\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEB"],
        ["\xE5\x9E\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEC"],
        ["\xE5\x9E\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xED"],
        ["\xE5\x9E\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEE"],
        ["\xE5\x9F\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEF"],
        ["\xF0\xA1\x8B\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],
        ["\xE5\x9F\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],
        ["\xF0\xA1\x8C\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],
        ["\xF0\xA1\x8D\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],
        ["\xE5\x9F\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],
        ["\xE5\x9F\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],
        ["\xE5\x9F\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],
        ["\xE3\x99\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],
        ["\xE5\x9F\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],
        ["\xE5\x9F\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],
        ["\xE5\x9F\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xFA"],
        ["\xE5\xA0\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xFB"],
        ["\xE5\xA0\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xFC"],
        ["\xE5\xA0\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x40"],
        ["\xE5\xA0\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x41"],
        ["\xE5\xA0\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x42"],
        ["\xE5\xA0\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x43"],
        ["\xF0\xA1\x8F\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x44"],
        ["\xE5\xA1\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x45"],
        ["\xE5\xA1\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x46"],
        ["\xE5\xA1\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x47"],
        ["\xE5\xA2\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x48"],
        ["\xE5\xA2\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x49"],
        ["\xE5\xA2\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x4A"],
        ["\xE5\xA2\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x4B"],
        ["\xE5\xA2\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x4C"],
        ["\xE5\xA2\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x4D"],
        ["\xE5\xA2\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x4E"],
        ["\xE5\xA2\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x4F"],
        ["\xE5\xA2\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x50"],
        ["\xF0\xA1\x91\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x51"],
        ["\xE5\xA3\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x52"],
        ["\xE5\xA3\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x53"],
        ["\xE5\xA3\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x54"],
        ["\xE5\xA3\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x55"],
        ["\xE5\xA3\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x56"],
        ["\xE5\xA4\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x57"],
        ["\xE5\xA4\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x58"],
        ["\xE5\xA4\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x5A"],
        ["\xE5\xA4\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x5B"],
        ["\xE5\xA4\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x5C"],
        ["\xF0\xA1\x97\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x5D"],
        ["\xE3\x9A\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x5E"],
        ["\xE5\xA4\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x5F"],
        ["\xE3\x9A\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x60"],
        ["\xE5\xA5\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x61"],
        ["\xE3\x9A\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x62"],
        ["\xF0\xA6\xB0\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x63"],
        ["\xE5\xA5\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x65"],
        ["\xF0\xA1\x99\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x66"],
        ["\xE5\xA5\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x67"],
        ["\xE5\xA5\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x68"],
        ["\xE5\xA5\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x69"],
        ["\xE5\xA6\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x6A"],
        ["\xE5\xA6\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x6B"],
        ["\xE5\xA6\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x6C"],
        ["\xE5\xA7\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x6D"],
        ["\xE5\xA7\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x6E"],
        ["\xE5\xA7\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x6F"],
        ["\xE5\xA7\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x70"],
        ["\xE5\xA7\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x71"],
        ["\xE5\xA7\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x72"],
        ["\xE5\xA7\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x73"],
        ["\xF0\xA1\x9C\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x74"],
        ["\xF0\xA1\x9D\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x75"],
        ["\xE3\x9B\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x76"],
        ["\xE5\xA8\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x77"],
        ["\xE5\xA8\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x78"],
        ["\xE5\xA8\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x79"],
        ["\xE5\xA8\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x7A"],
        ["\xE5\xA8\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x7B"],
        ["\xE5\xA9\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x7C"],
        ["\xE5\xA9\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x7D"],
        ["\xE5\xA9\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x7E"],
        ["\xE5\xAA\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x80"],
        ["\xE5\xAA\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x81"],
        ["\xE5\xAA\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x82"],
        ["\xE5\xAA\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x83"],
        ["\xE5\xAA\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x84"],
        ["\xE5\xAA\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x85"],
        ["\xE5\xAA\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x86"],
        ["\xE5\xAA\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x87"],
        ["\xE5\xAA\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x88"],
        ["\xE5\xAA\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x89"],
        ["\xE5\xAB\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x8A"],
        ["\xE5\xAB\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x8B"],
        ["\xE5\xAB\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x8C"],
        ["\xE5\xAB\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x8D"],
        ["\xE5\xAB\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x8E"],
        ["\xE5\xAB\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x8F"],
        ["\xE5\xAB\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x90"],
        ["\xE5\xAC\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x91"],
        ["\xE5\xAC\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x92"],
        ["\xE5\xAC\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x93"],
        ["\xE5\xAC\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x94"],
        ["\xE5\xAC\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x95"],
        ["\xE5\xAD\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x96"],
        ["\xE5\xAD\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x97"],
        ["\xE5\xAD\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x98"],
        ["\xE5\xAD\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x99"],
        ["\xE5\xAD\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x9A"],
        ["\xE5\xAD\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x9B"],
        ["\xE5\xAE\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x9C"],
        ["\xE5\xAE\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x9D"],
        ["\xF0\xA1\xA7\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x9E"],
        ["\xE5\xB9\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\x9F"],
        ["\xF0\xA2\x85\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA0"],
        ["\xE5\xBA\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],
        ["\xE5\xBA\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA2"],
        ["\xE5\xBA\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA3"],
        ["\xE5\xBA\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA4"],
        ["\xE5\xBA\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA5"],
        ["\xE5\xBB\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA6"],
        ["\xE5\xBB\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA7"],
        ["\xE5\xBB\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA8"],
        ["\xF0\xA2\x8C\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA9"],
        ["\xE5\xBB\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAA"],
        ["\xE5\xBC\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],
        ["\xE5\xBC\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAC"],
        ["\xE5\xBC\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAD"],
        ["\xF0\xA2\x8E\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAE"],
        ["\xE5\xBC\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAF"],
        ["\xE5\xBD\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],
        ["\xE5\xBD\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB1"],
        ["\xE5\xBD\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB2"],
        ["\xE5\xBD\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB3"],
        ["\xE5\xBE\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB4"],
        ["\xE5\xBE\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB5"],
        ["\xE5\xBE\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB6"],
        ["\xE5\xBE\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB7"],
        ["\xE5\xBF\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB8"],
        ["\xE3\xA3\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB9"],
        ["\xE5\xBF\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBA"],
        ["\xE5\xBF\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBB"],
        ["\xE5\xBF\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBC"],
        ["\xE5\xBF\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBD"],
        ["\xE5\xBF\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBE"],
        ["\xE5\xBF\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBF"],
        ["\xE5\xBF\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],
        ["\xE5\xBF\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],
        ["\xE5\xBF\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],
        ["\xE5\xBF\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],
        ["\xE3\xA4\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],
        ["\xE6\x80\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],
        ["\xE6\x80\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],
        ["\xE6\x80\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],
        ["\xE3\xA4\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],
        ["\xE6\x81\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],
        ["\xE6\x81\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCA"],
        ["\xE6\x82\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCC"],
        ["\xE6\x82\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCD"],
        ["\xF0\xA2\x9B\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCE"],
        ["\xE6\x82\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCF"],
        ["\xE6\x82\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD0"],
        ["\xE6\x82\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD1"],
        ["\xE6\x83\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD2"],
        ["\xE6\x83\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD3"],
        ["\xE6\x83\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD4"],
        ["\xE6\x83\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD5"],
        ["\xE6\x83\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD7"],
        ["\xE6\x84\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD8"],
        ["\xE6\x84\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD9"],
        ["\xE6\x84\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDA"],
        ["\xE6\x84\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDB"],
        ["\xE6\x84\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDC"],
        ["\xE6\x84\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDD"],
        ["\xE3\xA5\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDE"],
        ["\xE6\x85\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDF"],
        ["\xE6\x85\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE0"],
        ["\xE6\x85\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE1"],
        ["\xE6\x85\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE2"],
        ["\xF0\xA2\xA1\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE3"],
        ["\xE6\x86\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE4"],
        ["\xE6\x86\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE5"],
        ["\xE6\x86\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE6"],
        ["\xE6\x86\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE8"],
        ["\xE6\x86\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE9"],
        ["\xE6\x86\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEA"],
        ["\xF0\xA2\xA2\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEB"],
        ["\xE6\x87\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEC"],
        ["\xE6\x87\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xED"],
        ["\xE6\x87\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEE"],
        ["\xE6\x87\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEF"],
        ["\xF0\xA2\xA6\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF0"],
        ["\xE6\x88\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF1"],
        ["\xE6\x88\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF2"],
        ["\xE6\x88\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF3"],
        ["\xE6\x89\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],
        ["\xE6\x89\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF5"],
        ["\xE6\x89\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF6"],
        ["\xE6\x89\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF7"],
        ["\xE6\x89\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF8"],
        ["\xE6\x89\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF9"],
        ["\xE6\x89\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xFA"],
        ["\xE6\x89\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xFB"],
        ["\xE6\x89\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xFC"],
        ["\xE6\x8A\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x40"],
        ["\xE6\x8B\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x42"],
        ["\xF0\xA2\xAA\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x43"],
        ["\xE6\x8B\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x44"],
        ["\xE6\x8C\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x45"],
        ["\xE6\x8C\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x46"],
        ["\xE6\x8C\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x47"],
        ["\xF0\xA2\xAD\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x48"],
        ["\xF0\xA2\xAD\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x49"],
        ["\xE6\x8C\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x4A"],
        ["\xE6\x8C\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x4B"],
        ["\xE6\x8C\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x4C"],
        ["\xE6\x8C\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x4D"],
        ["\xE6\x8D\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x4E"],
        ["\xE6\x8D\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x4F"],
        ["\xE6\x8D\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x50"],
        ["\xF0\xA2\xAD\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x51"],
        ["\xE6\x8D\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x52"],
        ["\xF0\xA2\xB0\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x53"],
        ["\xF0\xA2\xAE\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x54"],
        ["\xE6\x8D\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x55"],
        ["\xE6\x8E\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x56"],
        ["\xE6\x8E\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x57"],
        ["\xF0\xA2\xB0\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x58"],
        ["\xE6\x8E\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x59"],
        ["\xE6\x8E\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x5A"],
        ["\xE6\x8F\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x5B"],
        ["\xE6\x8F\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x5C"],
        ["\xE6\x8F\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x5D"],
        ["\xE6\x8F\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x5E"],
        ["\xE6\x8F\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x5F"],
        ["\xE6\x8F\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x60"],
        ["\xE6\x8F\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x61"],
        ["\xE6\x8F\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x62"],
        ["\xE6\x90\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x63"],
        ["\xE6\x90\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x64"],
        ["\xE6\x90\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x65"],
        ["\xE6\x90\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x66"],
        ["\xE6\x90\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x67"],
        ["\xE6\x91\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x68"],
        ["\xE6\x91\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x69"],
        ["\xE6\x91\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x6A"],
        ["\xE6\x91\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x6B"],
        ["\xE6\x91\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x6C"],
        ["\xE6\x92\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x6D"],
        ["\xE6\x92\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x6E"],
        ["\xE6\x92\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x70"],
        ["\xE6\x93\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x71"],
        ["\xE6\x93\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x72"],
        ["\xE6\x93\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x73"],
        ["\xE6\x93\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x74"],
        ["\xF0\xA2\xB7\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x75"],
        ["\xE6\x93\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x76"],
        ["\xE6\x93\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x77"],
        ["\xE6\x93\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x78"],
        ["\xE6\x94\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x79"],
        ["\xE3\xA9\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x7A"],
        ["\xE6\x94\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x7B"],
        ["\xE6\x94\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x7C"],
        ["\xE6\x94\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x7D"],
        ["\xE3\xA9\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x7E"],
        ["\xE6\x94\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x80"],
        ["\xE6\x94\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x81"],
        ["\xE6\x95\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x82"],
        ["\xE6\x95\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x83"],
        ["\xE6\x95\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x84"],
        ["\xE6\x95\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x85"],
        ["\xE6\x96\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x86"],
        ["\xE6\x96\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x87"],
        ["\xE6\x96\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x88"],
        ["\xE6\x96\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x89"],
        ["\xE6\x96\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x8A"],
        ["\xE6\x96\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x8B"],
        ["\xE6\x96\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x8C"],
        ["\xE6\x96\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x8D"],
        ["\xE6\x97\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x8E"],
        ["\xE6\x97\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x8F"],
        ["\xE6\x97\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x90"],
        ["\xE3\xAB\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x91"],
        ["\xE6\x97\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x92"],
        ["\xE6\x97\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x93"],
        ["\xE6\x97\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x94"],
        ["\xE6\x98\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x95"],
        ["\xE6\x98\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x96"],
        ["\xE6\x98\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x97"],
        ["\xE6\x98\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x98"],
        ["\xE6\x99\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x99"],
        ["\xE6\x99\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x9A"],
        ["\xE6\x99\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x9B"],
        ["\xE3\xAB\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x9C"],
        ["\xF0\xA3\x87\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x9D"],
        ["\xE6\x99\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\x9F"],
        ["\xE6\x99\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA0"],
        ["\xF0\xA3\x87\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA1"],
        ["\xF0\xA3\x86\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA2"],
        ["\xE6\x99\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA3"],
        ["\xE6\x99\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA4"],
        ["\xE6\x99\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA5"],
        ["\xE6\x99\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA6"],
        ["\xE6\x99\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA7"],
        ["\xE6\x9A\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA8"],
        ["\xE6\x9A\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA9"],
        ["\xE6\x9A\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAA"],
        ["\xE3\xAC\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAC"],
        ["\xE6\x9A\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAD"],
        ["\xE6\x9A\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAE"],
        ["\xE6\x9A\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAF"],
        ["\xE3\xAC\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0"],
        ["\xE3\xAC\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2"],
        ["\xE6\x9B\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3"],
        ["\xE3\xAB\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4"],
        ["\xE6\x9C\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5"],
        ["\xE6\x9C\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB6"],
        ["\xE6\x9C\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB7"],
        ["\xF0\xA3\x8D\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB8"],
        ["\xE6\x9C\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB9"],
        ["\xF0\xA3\x8F\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBA"],
        ["\xF0\xA3\x8F\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBB"],
        ["\xE6\x9D\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBC"],
        ["\xE6\x9D\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBD"],
        ["\xE6\x9D\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBE"],
        ["\xE6\x9D\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBF"],
        ["\xF0\xA3\x8F\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC0"],
        ["\xF0\xA3\x8F\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC1"],
        ["\xF0\xA3\x8F\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC2"],
        ["\xE6\x9D\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC3"],
        ["\xE6\x9D\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC4"],
        ["\xF0\xA3\x8F\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC5"],
        ["\xE6\x9E\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC6"],
        ["\xF0\xA3\x8F\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC7"],
        ["\xE8\x8D\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC8"],
        ["\xE6\xA0\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC9"],
        ["\xE6\x9E\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCA"],
        ["\xE6\x9E\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCB"],
        ["\xE6\x9F\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCC"],
        ["\xE6\x9F\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCD"],
        ["\xE6\x9F\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCE"],
        ["\xE6\x9F\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCF"],
        ["\xE6\x9F\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD0"],
        ["\xE6\x9F\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD1"],
        ["\xE6\x9F\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD2"],
        ["\xF0\xA3\x91\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD3"],
        ["\xF0\xA3\x91\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD4"],
        ["\xF0\xA3\x91\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD5"],
        ["\xE6\xA0\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD6"],
        ["\xE6\xA0\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD7"],
        ["\xE6\xA0\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD8"],
        ["\xF0\xA3\x91\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD9"],
        ["\xE6\xA0\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xDA"],
        ["\xE6\xA0\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xDB"],
        ["\xE6\xA0\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xDC"],
        ["\xE6\xA1\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xDE"],
        ["\xE6\xA1\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xDF"],
        ["\xE6\xA1\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE0"],
        ["\xE6\xA1\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE1"],
        ["\xE6\xA1\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE2"],
        ["\xE3\xAD\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE3"],
        ["\xE6\xA1\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE4"],
        ["\xE6\xA1\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE5"],
        ["\xE6\xA1\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE6"],
        ["\xE6\xA1\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE7"],
        ["\xE6\xA2\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE8"],
        ["\xE6\xA2\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xE9"],
        ["\xE6\xA2\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xEA"],
        ["\xE3\xAD\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xEB"],
        ["\xE6\xA2\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xEC"],
        ["\xE6\xA2\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xED"],
        ["\xE6\xA2\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xEE"],
        ["\xE6\xA2\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xEF"],
        ["\xE6\xA2\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF0"],
        ["\xE6\xA2\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF1"],
        ["\xE6\xA2\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF2"],
        ["\xE6\xA2\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF3"],
        ["\xE6\xA3\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF4"],
        ["\xF0\xA3\x93\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF5"],
        ["\xF0\xA3\x95\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF6"],
        ["\xE6\xA3\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF8"],
        ["\xE6\xA3\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xF9"],
        ["\xE6\xA3\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xFA"],
        ["\xE6\xA3\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xFC"],
        ["\xE6\xA3\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x40"],
        ["\xE6\xA3\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x41"],
        ["\xE6\xA3\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x42"],
        ["\xE6\xA3\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x43"],
        ["\xE6\xA3\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x44"],
        ["\xE6\xA4\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x45"],
        ["\xE6\xA4\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x46"],
        ["\xE3\xAE\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x47"],
        ["\xE3\xAE\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x48"],
        ["\xF0\xA3\x96\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x49"],
        ["\xE6\xA4\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x4A"],
        ["\xE3\xAE\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x4B"],
        ["\xE6\xA5\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x4C"],
        ["\xE6\xA5\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x4D"],
        ["\xE6\xA5\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x4E"],
        ["\xE6\xA5\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x4F"],
        ["\xE6\xA5\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x50"],
        ["\xE6\xA5\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x51"],
        ["\xE6\xA6\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x52"],
        ["\xE3\xAE\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x53"],
        ["\xE6\xA6\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x54"],
        ["\xE6\xA6\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x56"],
        ["\xE6\xA6\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x57"],
        ["\xE6\xA6\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x58"],
        ["\xE6\xA6\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x59"],
        ["\xE6\xA6\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x5A"],
        ["\xE6\xA7\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x5B"],
        ["\xE6\xA7\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x5C"],
        ["\xE6\xA7\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x5D"],
        ["\xF0\xA3\x98\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x5E"],
        ["\xF0\xA3\x99\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x5F"],
        ["\xF0\xA3\x98\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x61"],
        ["\xF0\xA3\x98\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x62"],
        ["\xE6\xA7\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x63"],
        ["\xE6\xA7\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x64"],
        ["\xE6\xA7\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x65"],
        ["\xE6\xA7\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x66"],
        ["\xE3\xAF\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x67"],
        ["\xE6\xA7\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x68"],
        ["\xE6\xA7\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x69"],
        ["\xE6\xA8\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x6A"],
        ["\xE6\xA8\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x6B"],
        ["\xE6\xA8\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x6C"],
        ["\xF0\xA3\x9C\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x6D"],
        ["\xE6\xA8\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x6E"],
        ["\xE6\xA8\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x6F"],
        ["\xE6\xA8\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x70"],
        ["\xE6\xA8\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x71"],
        ["\xE6\xA9\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x73"],
        ["\xE6\xA9\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x74"],
        ["\xE6\xA9\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x75"],
        ["\xE6\xA9\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x76"],
        ["\xE6\xA9\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x77"],
        ["\xF0\xA3\x9C\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x78"],
        ["\xE6\xAA\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x7A"],
        ["\xE6\xAA\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x7B"],
        ["\xE3\xAF\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x7C"],
        ["\xE6\xAA\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x7D"],
        ["\xE6\xAA\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x7E"],
        ["\xE6\xAA\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x80"],
        ["\xF0\xA3\x9D\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x81"],
        ["\xE6\xAA\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x82"],
        ["\xE6\xAA\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x83"],
        ["\xE6\xAB\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x84"],
        ["\xE6\xAB\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x85"],
        ["\xE6\xAB\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x86"],
        ["\xE6\xAB\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x87"],
        ["\xE6\xAB\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x88"],
        ["\xF0\xA3\x9F\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x89"],
        ["\xF0\xA3\x9F\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x8A"],
        ["\xE6\xAB\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x8B"],
        ["\xE6\xAB\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x8C"],
        ["\xE6\xAB\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x8D"],
        ["\xE6\xAB\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x8E"],
        ["\xE6\xAB\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x8F"],
        ["\xF0\xA3\xA0\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x90"],
        ["\xE6\xAC\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x91"],
        ["\xE6\xAC\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x92"],
        ["\xE6\xAC\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x93"],
        ["\xE6\xAC\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x94"],
        ["\xF0\xA3\xA0\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x95"],
        ["\xE6\xAC\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x96"],
        ["\xE3\xB0\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x97"],
        ["\xE6\xAC\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x98"],
        ["\xE6\xAD\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x99"],
        ["\xE6\xAD\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x9A"],
        ["\xE6\xAD\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x9B"],
        ["\xE6\xAD\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x9C"],
        ["\xE6\xAD\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x9D"],
        ["\xE6\xAE\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x9E"],
        ["\xE6\xAE\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\x9F"],
        ["\xE6\xAE\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xA0"],
        ["\xF0\xA3\xAA\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xA1"],
        ["\xE6\xAE\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xA2"],
        ["\xE6\xAE\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xA3"],
        ["\xE6\xAF\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xA4"],
        ["\xE6\xAF\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xA5"],
        ["\xE6\xAF\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xA6"],
        ["\xE6\xAF\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xA7"],
        ["\xE6\xAF\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xA8"],
        ["\xE6\xAF\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xA9"],
        ["\xE6\xAF\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xAA"],
        ["\xE6\xAF\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xAB"],
        ["\xE6\xB0\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xAC"],
        ["\xE6\xB0\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xAD"],
        ["\xE6\xB0\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xAE"],
        ["\xE6\xB0\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xAF"],
        ["\xE6\xB0\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xB0"],
        ["\xE6\xB0\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xB1"],
        ["\xF0\xA3\xB1\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xB2"],
        ["\xE6\xB1\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xB4"],
        ["\xE6\xB1\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xB5"],
        ["\xE6\xB1\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xB6"],
        ["\xE6\xB2\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xB7"],
        ["\xE6\xB2\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xB8"],
        ["\xE3\xB3\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xB9"],
        ["\xE6\xB2\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xBA"],
        ["\xE6\xB2\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xBB"],
        ["\xE6\xB2\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xBC"],
        ["\xE6\xB2\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xBD"],
        ["\xE6\xB3\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xBE"],
        ["\xE6\xB3\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xBF"],
        ["\xE3\xB3\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xC0"],
        ["\xE6\xB3\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xC1"],
        ["\xE6\xB3\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xC3"],
        ["\xE6\xB3\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xC4"],
        ["\xE6\xB3\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xC5"],
        ["\xE6\xB3\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xC6"],
        ["\xF0\xA3\xB4\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xC7"],
        ["\xE6\xB4\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xC8"],
        ["\xE6\xB4\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xC9"],
        ["\xE6\xB4\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xCA"],
        ["\xE6\xB4\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xCB"],
        ["\xE6\xB4\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xCC"],
        ["\xE6\xB1\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xCD"],
        ["\xE6\xB4\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xCE"],
        ["\xE6\xB4\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xCF"],
        ["\xE6\xB5\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xD0"],
        ["\xE6\xB5\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xD1"],
        ["\xE6\xB5\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xD2"],
        ["\xE6\xB5\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xD3"],
        ["\xE6\xB6\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xD4"],
        ["\xE6\xB6\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xD5"],
        ["\xE6\xB6\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xD6"],
        ["\xE6\xB6\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xD7"],
        ["\xE6\xB6\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xD8"],
        ["\xE6\xB6\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xD9"],
        ["\xF0\xA3\xB5\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xDA"],
        ["\xE6\xB8\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xDB"],
        ["\xF0\xA3\xB7\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xDC"],
        ["\xF0\xA3\xB7\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xDD"],
        ["\xF0\xA3\xB7\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xDE"],
        ["\xE6\xB6\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xDF"],
        ["\xE6\xB6\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xE0"],
        ["\xE6\xB6\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xE1"],
        ["\xE6\xB7\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xE2"],
        ["\xE6\xB4\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xE3"],
        ["\xE6\xB7\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xE4"],
        ["\xE6\xB7\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xE5"],
        ["\xE6\xB7\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xE7"],
        ["\xE6\xB7\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xE8"],
        ["\xE6\xB7\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xE9"],
        ["\xE6\xB7\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xEA"],
        ["\xE6\xB8\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xEB"],
        ["\xE6\xB8\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xEC"],
        ["\xE6\xB8\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xED"],
        ["\xE3\xB4\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xEF"],
        ["\xE6\xB8\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xF0"],
        ["\xE6\xB9\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xF2"],
        ["\xE6\xB9\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xF3"],
        ["\xE6\xB9\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xF4"],
        ["\xE6\xB9\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xF5"],
        ["\xE6\xB9\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xF6"],
        ["\xE6\xB9\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xF7"],
        ["\xE6\xB9\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xF8"],
        ["\xE6\xB9\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xF9"],
        ["\xE6\xB9\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xFA"],
        ["\xE6\xB9\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xFB"],
        ["\xE3\xB4\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF4\xFC"],
        ["\xE6\xBA\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x40"],
        ["\xE6\xBA\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x41"],
        ["\xE6\xBA\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x42"],
        ["\xE6\xBB\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x44"],
        ["\xE6\xBB\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x45"],
        ["\xE6\xBB\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x46"],
        ["\xE6\xBC\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x47"],
        ["\xE6\xBB\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x48"],
        ["\xE6\xBB\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x49"],
        ["\xE6\xBB\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x4A"],
        ["\xE6\xBC\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x4B"],
        ["\xE6\xBC\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x4C"],
        ["\xE6\xBC\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x4D"],
        ["\xE6\xBC\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x4E"],
        ["\xE6\xBC\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x4F"],
        ["\xE6\xBC\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x50"],
        ["\xF0\xA3\xBD\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x51"],
        ["\xE6\xBD\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x52"],
        ["\xE6\xBD\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x53"],
        ["\xE6\xBD\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x54"],
        ["\xE6\xBD\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x55"],
        ["\xE6\xBD\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x56"],
        ["\xE6\xBE\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x57"],
        ["\xE6\xBD\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x58"],
        ["\xE6\xBE\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x59"],
        ["\xE6\xBE\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x5A"],
        ["\xE6\xBE\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x5B"],
        ["\xE6\xBE\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x5C"],
        ["\xE6\xBE\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x5D"],
        ["\xE6\xBE\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x5E"],
        ["\xE3\xB5\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x5F"],
        ["\xE6\xBF\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x61"],
        ["\xE6\xBF\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x62"],
        ["\xE6\xBF\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x63"],
        ["\xE6\xBF\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x64"],
        ["\xE6\xBF\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x65"],
        ["\xF0\xA4\x82\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x66"],
        ["\xE6\xBF\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x67"],
        ["\xE7\x80\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x68"],
        ["\xE7\x80\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x6A"],
        ["\xE7\x80\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x6B"],
        ["\xF0\xA4\x84\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x6C"],
        ["\xE7\x80\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x6D"],
        ["\xE7\x80\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x6E"],
        ["\xE7\x80\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x6F"],
        ["\xE7\x81\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x70"],
        ["\xE7\x81\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x71"],
        ["\xE7\x81\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x72"],
        ["\xE3\xB6\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x73"],
        ["\xE7\x81\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x74"],
        ["\xE7\x81\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x75"],
        ["\xE7\x81\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x76"],
        ["\xE7\x81\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x77"],
        ["\xE7\x81\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x78"],
        ["\xE7\x81\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x79"],
        ["\xE7\x81\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x7A"],
        ["\xE7\x82\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x7B"],
        ["\xE7\x82\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x7C"],
        ["\xE7\x82\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x7D"],
        ["\xE7\x82\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x7E"],
        ["\xF0\xA4\x87\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x81"],
        ["\xE7\x82\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x82"],
        ["\xE7\x82\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x83"],
        ["\xF0\xA4\x87\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x84"],
        ["\xE7\x83\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x85"],
        ["\xE7\x83\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x86"],
        ["\xE7\x83\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x87"],
        ["\xE7\x83\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x88"],
        ["\xE7\x83\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x89"],
        ["\xE7\x84\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x8A"],
        ["\xE7\x84\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x8C"],
        ["\xE7\x84\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x8D"],
        ["\xE7\x84\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x8E"],
        ["\xE7\x84\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x8F"],
        ["\xE3\xB7\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x90"],
        ["\xE7\x84\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x91"],
        ["\xE7\x84\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x92"],
        ["\xE7\x85\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x93"],
        ["\xE7\x85\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x94"],
        ["\xE7\x85\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x95"],
        ["\xE7\x85\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x96"],
        ["\xE3\xB7\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x97"],
        ["\xE7\x86\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x98"],
        ["\xE7\x86\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x99"],
        ["\xE7\x86\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x9A"],
        ["\xE7\x86\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x9B"],
        ["\xE7\x86\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x9C"],
        ["\xE7\x86\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x9D"],
        ["\xE7\x86\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x9E"],
        ["\xE7\x86\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\x9F"],
        ["\xF0\xA4\x8E\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xA0"],
        ["\xE7\x87\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xA1"],
        ["\xE7\x87\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xA2"],
        ["\xE7\x87\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xA3"],
        ["\xE7\x87\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xA4"],
        ["\xE7\x88\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xA5"],
        ["\xE3\xB8\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xA6"],
        ["\xEF\xA9\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xA7"],
        ["\xE7\x88\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xA8"],
        ["\xE7\x88\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xA9"],
        ["\xE7\x88\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xAA"],
        ["\xE7\x88\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xAB"],
        ["\xE4\xB8\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xAC"],
        ["\xE7\x89\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xAD"],
        ["\xE7\x89\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xAE"],
        ["\xE7\x89\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xAF"],
        ["\xE7\x89\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xB0"],
        ["\xF0\xA4\x98\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xB1"],
        ["\xE7\x89\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xB2"],
        ["\xE7\x89\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xB3"],
        ["\xE7\x89\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xB4"],
        ["\xE7\x89\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xB5"],
        ["\xE7\x8A\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xB6"],
        ["\xF0\xA4\x9A\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xB7"],
        ["\xE7\x8A\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xB8"],
        ["\xE7\x8A\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xB9"],
        ["\xE7\x8A\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xBA"],
        ["\xE7\x8B\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xBC"],
        ["\xE3\xB9\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xBD"],
        ["\xE7\x8B\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xBE"],
        ["\xE3\xB9\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xBF"],
        ["\xE3\xB9\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xC0"],
        ["\xE7\x8B\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xC1"],
        ["\xE7\x8B\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xC2"],
        ["\xE7\x8C\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xC3"],
        ["\xE7\x8C\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xC4"],
        ["\xE7\x8C\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xC5"],
        ["\xE7\x8C\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xC6"],
        ["\xE3\xBA\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xC7"],
        ["\xE7\x8C\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xC8"],
        ["\xE7\x8C\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xC9"],
        ["\xE7\x8C\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xCA"],
        ["\xE7\x8C\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xCB"],
        ["\xE7\x8C\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xCC"],
        ["\xE7\x8D\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xCD"],
        ["\xE3\xBA\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xCE"],
        ["\xE7\x8D\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xCF"],
        ["\xE7\x8D\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xD0"],
        ["\xF0\xA4\xA2\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xD1"],
        ["\xE7\x8D\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xD2"],
        ["\xE7\x8D\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xD3"],
        ["\xE7\x8D\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xD4"],
        ["\xE7\x8E\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xD6"],
        ["\xE7\x8E\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xD7"],
        ["\xE7\x8E\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xD8"],
        ["\xE7\x8E\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xD9"],
        ["\xE7\x8E\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xDA"],
        ["\xE7\x8E\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xDB"],
        ["\xE7\x8E\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xDC"],
        ["\xE7\x8E\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xDD"],
        ["\xE7\x8E\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xDE"],
        ["\xE7\x8E\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xDF"],
        ["\xE7\x8E\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xE0"],
        ["\xE7\x8E\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xE1"],
        ["\xE7\x8E\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xE2"],
        ["\xE7\x8E\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xE3"],
        ["\xE7\x8F\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xE4"],
        ["\xE7\x8F\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xE5"],
        ["\xE7\x8F\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xE6"],
        ["\xE7\x8F\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xE7"],
        ["\xE7\x8F\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xE8"],
        ["\xE7\x90\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xE9"],
        ["\xE7\x8F\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xEA"],
        ["\xE7\x90\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xEB"],
        ["\xE7\x90\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xEC"],
        ["\xE7\x90\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xED"],
        ["\xE7\x90\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xEE"],
        ["\xE7\x91\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xEF"],
        ["\xE7\x91\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xF0"],
        ["\xE7\x91\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xF1"],
        ["\xE7\x91\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xF2"],
        ["\xE7\x91\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xF3"],
        ["\xE7\x91\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xF4"],
        ["\xE7\x91\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xF5"],
        ["\xE7\x92\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xF6"],
        ["\xE7\x92\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xF7"],
        ["\xE7\x92\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xF8"],
        ["\xF0\xA4\xA9\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xF9"],
        ["\xE7\x92\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xFA"],
        ["\xE7\x92\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xFB"],
        ["\xE7\x92\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF5\xFC"],
        ["\xE7\x92\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x40"],
        ["\xE7\x92\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x41"],
        ["\xE7\x92\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x42"],
        ["\xE7\x92\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x43"],
        ["\xE7\x92\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x44"],
        ["\xE7\x92\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x45"],
        ["\xE7\x92\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x46"],
        ["\xE7\x92\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x47"],
        ["\xE7\x93\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x48"],
        ["\xE7\x93\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x49"],
        ["\xE7\x93\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x4A"],
        ["\xE7\x93\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x4B"],
        ["\xE7\x93\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x4C"],
        ["\xF0\xA4\xAD\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x4D"],
        ["\xE7\x93\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x4E"],
        ["\xF0\xA4\xAD\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x4F"],
        ["\xE7\x94\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x50"],
        ["\xE7\x94\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x51"],
        ["\xE7\x94\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x52"],
        ["\xE3\xBD\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x53"],
        ["\xF0\xA4\xB0\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x54"],
        ["\xE7\x94\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x55"],
        ["\xE7\x94\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x56"],
        ["\xE7\x95\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x57"],
        ["\xE7\x95\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x58"],
        ["\xE7\x95\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x59"],
        ["\xE7\x95\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x5A"],
        ["\xE7\x95\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x5B"],
        ["\xE7\x95\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x5C"],
        ["\xE7\x95\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x5D"],
        ["\xE7\x95\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x5E"],
        ["\xE7\x95\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x5F"],
        ["\xE7\x95\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x60"],
        ["\xE7\x95\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x61"],
        ["\xE7\x96\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x62"],
        ["\xF0\xA4\xB4\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x63"],
        ["\xE7\x96\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x64"],
        ["\xE3\xBD\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x65"],
        ["\xE7\x96\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x66"],
        ["\xE3\xBD\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x67"],
        ["\xE7\x96\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x68"],
        ["\xE7\x96\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x69"],
        ["\xE7\x96\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x6A"],
        ["\xE7\x97\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x6B"],
        ["\xE7\x97\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x6C"],
        ["\xE7\x97\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x6D"],
        ["\xE7\x97\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x6E"],
        ["\xE7\x97\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x6F"],
        ["\xE7\x97\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x70"],
        ["\xE7\x97\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x71"],
        ["\xE7\x97\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x72"],
        ["\xE7\x97\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x73"],
        ["\xE7\x97\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x74"],
        ["\xE7\x97\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x75"],
        ["\xE7\x97\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x76"],
        ["\xE7\x98\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x77"],
        ["\xE7\x98\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x78"],
        ["\xE7\x98\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x79"],
        ["\xE7\x98\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x7A"],
        ["\xE3\xBE\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x7B"],
        ["\xF0\xA4\xB8\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x7C"],
        ["\xE7\x98\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x7D"],
        ["\xE7\x98\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x7E"],
        ["\xE7\x98\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x80"],
        ["\xF0\xA4\xB8\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x81"],
        ["\xE7\x98\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x82"],
        ["\xE7\x98\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x83"],
        ["\xE7\x98\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x84"],
        ["\xE7\x98\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x85"],
        ["\xF0\xA4\xB9\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x86"],
        ["\xE3\xBF\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x87"],
        ["\xE7\x99\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x88"],
        ["\xF0\xA4\xBA\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x89"],
        ["\xE7\x99\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x8A"],
        ["\xE7\x99\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x8B"],
        ["\xE3\xBF\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x8C"],
        ["\xE7\x99\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x8D"],
        ["\xE7\x9A\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x8E"],
        ["\xE7\x9A\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x90"],
        ["\xE7\x9A\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x91"],
        ["\xE7\x9A\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x92"],
        ["\xE7\x9A\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x93"],
        ["\xE7\x9A\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x94"],
        ["\xF0\xA5\x81\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x95"],
        ["\xE7\x9B\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x96"],
        ["\xF0\xA5\x81\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x97"],
        ["\xE7\x9B\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x98"],
        ["\xE7\x9B\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x99"],
        ["\xF0\xA5\x84\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x9A"],
        ["\xE7\x9C\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x9B"],
        ["\xE7\x9C\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x9C"],
        ["\xE7\x9C\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x9D"],
        ["\xE7\x9C\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x9E"],
        ["\xF0\xA5\x86\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\x9F"],
        ["\xE4\x80\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xA0"],
        ["\xF0\xA5\x87\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xA1"],
        ["\xF0\xA5\x87\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xA2"],
        ["\xE7\x9D\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xA3"],
        ["\xE7\x9D\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xA4"],
        ["\xE7\x9D\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xA5"],
        ["\xF0\xA5\x88\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xA6"],
        ["\xE7\x9D\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xA7"],
        ["\xE7\x9D\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xA8"],
        ["\xE7\x9D\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xA9"],
        ["\xF0\xA5\x89\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xAA"],
        ["\xE4\x81\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xAB"],
        ["\xE7\x9E\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xAC"],
        ["\xE7\x9E\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xAD"],
        ["\xE7\x9E\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xAE"],
        ["\xE7\x9E\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xAF"],
        ["\xE7\x9E\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xB0"],
        ["\xE7\x9F\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xB1"],
        ["\xE7\x9F\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xB2"],
        ["\xE7\x9F\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xB3"],
        ["\xE7\x9F\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xB4"],
        ["\xE7\x9F\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xB5"],
        ["\xE7\x9F\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xB6"],
        ["\xE4\x82\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xB7"],
        ["\xE7\x9F\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xB8"],
        ["\xE7\x9F\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xB9"],
        ["\xE7\x9F\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xBA"],
        ["\xF0\xA5\x90\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xBB"],
        ["\xE7\xA0\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xBC"],
        ["\xE7\xA0\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xBD"],
        ["\xE7\xA0\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xBE"],
        ["\xE7\xA0\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xBF"],
        ["\xE7\xA0\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xC0"],
        ["\xE7\xA0\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xC2"],
        ["\xE7\xA1\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xC3"],
        ["\xE7\xA1\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xC5"],
        ["\xF0\xA5\x93\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xC6"],
        ["\xE7\xA2\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xC7"],
        ["\xE7\xA2\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xC8"],
        ["\xE7\xA2\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xC9"],
        ["\xE7\xA2\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xCA"],
        ["\xE7\xA2\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xCB"],
        ["\xE7\xA2\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xCC"],
        ["\xE7\xA2\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xCD"],
        ["\xE7\xA3\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xCE"],
        ["\xE7\xA3\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xCF"],
        ["\xE7\xA3\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xD0"],
        ["\xE7\xA3\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xD1"],
        ["\xE7\xA3\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xD2"],
        ["\xE7\xA3\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xD3"],
        ["\xE7\xA3\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xD4"],
        ["\xE7\xA3\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xD5"],
        ["\xE7\xA3\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xD6"],
        ["\xE7\xA3\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xD7"],
        ["\xE7\xA3\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xD8"],
        ["\xF0\xA5\x96\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xD9"],
        ["\xE7\xA4\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xDA"],
        ["\xE7\xA4\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xDB"],
        ["\xE7\xA4\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xDD"],
        ["\xE7\xA4\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xDE"],
        ["\xE7\xA5\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xDF"],
        ["\xE7\xA5\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xE0"],
        ["\xE7\xA5\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xE1"],
        ["\xE4\x84\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xE2"],
        ["\xE7\xA5\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xE3"],
        ["\xE7\xA5\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xE4"],
        ["\xE7\xA6\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xE6"],
        ["\xE7\xA6\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xE7"],
        ["\xE7\xA6\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xE9"],
        ["\xE7\xA6\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xEA"],
        ["\xE7\xA6\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xEB"],
        ["\xE7\xA6\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xEC"],
        ["\xE7\xA7\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xED"],
        ["\xE7\xA7\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xEE"],
        ["\xE7\xA7\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xEF"],
        ["\xE7\xA7\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xF0"],
        ["\xE7\xA7\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xF1"],
        ["\xE4\x85\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xF2"],
        ["\xF0\xA5\x9E\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xF3"],
        ["\xF0\xA5\x9E\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xF4"],
        ["\xE4\x85\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xF5"],
        ["\xE7\xA8\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xF6"],
        ["\xE7\xA8\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xF7"],
        ["\xE7\xA8\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xF8"],
        ["\xE7\xA8\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xF9"],
        ["\xE7\xA8\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xFA"],
        ["\xE4\x85\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xFB"],
        ["\xE7\xA8\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF6\xFC"],
        ["\xE7\xA8\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x40"],
        ["\xE7\xA9\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x41"],
        ["\xE7\xA9\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x42"],
        ["\xE7\xA9\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x43"],
        ["\xE7\xA9\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x44"],
        ["\xE7\xA9\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x45"],
        ["\xE7\xA9\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x46"],
        ["\xE7\xA9\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x47"],
        ["\xE7\xA9\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x48"],
        ["\xE7\xA9\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x49"],
        ["\xE7\xA9\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x4A"],
        ["\xE7\xA9\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x4B"],
        ["\xE7\xAA\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x4C"],
        ["\xE7\xAA\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x4D"],
        ["\xE7\xAA\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x4E"],
        ["\xE7\xAA\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x4F"],
        ["\xE7\xAA\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x50"],
        ["\xF0\xA5\xA7\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x51"],
        ["\xE4\x86\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x52"],
        ["\xE7\xAA\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x53"],
        ["\xE7\xAA\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x54"],
        ["\xE7\xAA\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x55"],
        ["\xE4\x86\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x56"],
        ["\xE7\xAB\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x57"],
        ["\xE7\xAB\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x5A"],
        ["\xE7\xAB\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x5B"],
        ["\xF0\xA5\xAB\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x5C"],
        ["\xF0\xA5\xAB\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x5D"],
        ["\xE7\xAC\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x5E"],
        ["\xF0\xA5\xAB\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x5F"],
        ["\xE7\xAC\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x60"],
        ["\xE7\xAC\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x61"],
        ["\xE7\xAC\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x62"],
        ["\xE7\xAC\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x63"],
        ["\xE7\xAC\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x64"],
        ["\xE7\xAC\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x65"],
        ["\xE4\x87\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x66"],
        ["\xE4\x87\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x67"],
        ["\xE7\xAD\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x68"],
        ["\xE7\xAD\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x69"],
        ["\xE4\x87\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x6A"],
        ["\xE7\xAD\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x6B"],
        ["\xE7\xAD\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x6C"],
        ["\xE7\xAD\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x6D"],
        ["\xE7\xAD\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x6E"],
        ["\xE7\xAD\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x6F"],
        ["\xE7\xAD\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x70"],
        ["\xF0\xA5\xAE\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x71"],
        ["\xE4\x88\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x72"],
        ["\xE7\xAE\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x73"],
        ["\xE7\xAE\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x74"],
        ["\xE7\xAE\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x75"],
        ["\xE4\x88\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x76"],
        ["\xE7\xAE\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x77"],
        ["\xE7\xAE\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x78"],
        ["\xE7\xAE\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x79"],
        ["\xE7\xAF\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x7A"],
        ["\xE7\xAF\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x7B"],
        ["\xF0\xA5\xB1\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x7C"],
        ["\xF0\xA5\xB1\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x7D"],
        ["\xE7\xAF\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x7E"],
        ["\xE7\xAF\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x80"],
        ["\xE7\xAF\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x81"],
        ["\xE7\xAF\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x82"],
        ["\xE7\xAF\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x83"],
        ["\xE7\xB0\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x84"],
        ["\xE7\xB0\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x85"],
        ["\xE7\xB0\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x86"],
        ["\xE7\xB0\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x87"],
        ["\xE7\xB0\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x88"],
        ["\xE7\xB1\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x89"],
        ["\xE7\xB1\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x8A"],
        ["\xE7\xB1\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x8B"],
        ["\xE7\xB1\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x8C"],
        ["\xE7\xB1\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x8D"],
        ["\xE7\xB1\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x8E"],
        ["\xE7\xB1\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x8F"],
        ["\xE7\xB1\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x90"],
        ["\xE7\xB1\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x91"],
        ["\xE7\xB1\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x92"],
        ["\xF0\xA5\xB8\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x93"],
        ["\xF0\xA5\xB9\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x94"],
        ["\xF0\xA5\xB9\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x95"],
        ["\xE7\xB2\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x96"],
        ["\xF0\xA5\xB9\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x97"],
        ["\xE7\xB2\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x98"],
        ["\xE7\xB2\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x99"],
        ["\xE7\xB2\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x9A"],
        ["\xF0\xA5\xBB\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x9B"],
        ["\xE7\xB3\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x9C"],
        ["\xF0\xA5\xBB\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x9D"],
        ["\xE7\xB3\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x9E"],
        ["\xE7\xB3\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\x9F"],
        ["\xF0\xA5\xBB\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xA0"],
        ["\xE7\xB3\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xA1"],
        ["\xF0\xA5\xBC\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xA2"],
        ["\xE7\xB3\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xA3"],
        ["\xE7\xB3\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xA4"],
        ["\xF0\xA5\xBD\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xA5"],
        ["\xE7\xB3\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xA6"],
        ["\xE7\xB4\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xA7"],
        ["\xE7\xB4\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xA8"],
        ["\xE4\x8B\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xA9"],
        ["\xE7\xB4\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xAA"],
        ["\xE7\xB4\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xAB"],
        ["\xF0\xA5\xBF\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xAC"],
        ["\xF0\xA5\xBF\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xAD"],
        ["\xE7\xB4\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xAE"],
        ["\xE7\xB4\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xAF"],
        ["\xE7\xB5\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xB0"],
        ["\xE7\xB5\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xB1"],
        ["\xF0\xA6\x80\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xB2"],
        ["\xF0\xA5\xBF\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xB3"],
        ["\xE4\x8B\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xB4"],
        ["\xE7\xB5\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xB5"],
        ["\xE7\xB5\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xB6"],
        ["\xE7\xB5\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xB7"],
        ["\xE7\xB5\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xB8"],
        ["\xE4\x8B\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xB9"],
        ["\xE7\xB5\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xBA"],
        ["\xF0\xA6\x80\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xBB"],
        ["\xE7\xB6\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xBC"],
        ["\xE7\xB6\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xBD"],
        ["\xE7\xB6\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xBE"],
        ["\xE7\xB6\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xBF"],
        ["\xF0\xA6\x81\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xC0"],
        ["\xE7\xB6\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xC1"],
        ["\xE7\xB6\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xC2"],
        ["\xE7\xB6\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xC3"],
        ["\xE7\xB6\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xC4"],
        ["\xE7\xB7\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xC6"],
        ["\xE7\xB7\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xC7"],
        ["\xE7\xB7\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xC8"],
        ["\xE7\xB7\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xC9"],
        ["\xE7\xB7\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xCA"],
        ["\xE7\xB7\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xCB"],
        ["\xE4\x8C\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xCC"],
        ["\xF0\xA6\x83\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xCD"],
        ["\xEF\xA9\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xCE"],
        ["\xE7\xB8\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xCF"],
        ["\xE7\xB8\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xD0"],
        ["\xE7\xB8\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xD1"],
        ["\xE7\xB8\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xD2"],
        ["\xE7\xB8\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xD3"],
        ["\xE7\xB8\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xD4"],
        ["\xE7\xB9\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xD5"],
        ["\xE7\xB9\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xD6"],
        ["\xE7\xB9\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xD7"],
        ["\xE7\xB9\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xD8"],
        ["\xE7\xBA\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xD9"],
        ["\xE7\xBA\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xDA"],
        ["\xE4\x8C\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xDB"],
        ["\xE7\xBA\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xDC"],
        ["\xE7\xBA\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xDD"],
        ["\xE7\xBA\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xDE"],
        ["\xE4\x8D\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xDF"],
        ["\xE7\xBC\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xE0"],
        ["\xE7\xBC\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xE1"],
        ["\xE7\xBC\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xE2"],
        ["\xE7\xBD\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xE3"],
        ["\xE7\xBD\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xE4"],
        ["\xE7\xBD\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xE5"],
        ["\xE3\x93\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xE6"],
        ["\xF0\xA6\x89\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xE7"],
        ["\xE7\xBD\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xE8"],
        ["\xF0\xA6\x8A\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xE9"],
        ["\xE7\xBD\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xEA"],
        ["\xE7\xBD\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xEB"],
        ["\xE7\xBD\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xEC"],
        ["\xE7\xBD\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xED"],
        ["\xE7\xBD\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xEE"],
        ["\xE7\xBD\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xEF"],
        ["\xF0\xA6\x8D\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xF0"],
        ["\xE7\xBE\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xF1"],
        ["\xE5\x85\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xF2"],
        ["\xF0\xA3\xB4\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xF3"],
        ["\xE7\xBE\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xF4"],
        ["\xE7\xBE\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xF5"],
        ["\xE7\xBE\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xF6"],
        ["\xF0\xA6\x90\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xF7"],
        ["\xE7\xBF\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xF8"],
        ["\xE7\xBF\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xF9"],
        ["\xE7\xBF\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xFA"],
        ["\xE7\xBF\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xFB"],
        ["\xE7\xBF\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF7\xFC"],
        ["\xE7\xBF\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x40"],
        ["\xE8\x80\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x41"],
        ["\xE8\x80\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x42"],
        ["\xE8\x80\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x43"],
        ["\xE8\x80\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x44"],
        ["\xE8\x80\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x45"],
        ["\xE8\x80\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x46"],
        ["\xE8\x80\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x47"],
        ["\xE8\x80\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x48"],
        ["\xE8\x80\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x49"],
        ["\xE8\x81\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x4A"],
        ["\xE8\x81\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x4B"],
        ["\xE8\x81\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x4C"],
        ["\xE8\x81\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x4D"],
        ["\xE8\x81\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x4E"],
        ["\xE8\x82\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x4F"],
        ["\xE8\x82\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x50"],
        ["\xE8\x82\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x51"],
        ["\xE8\x82\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x52"],
        ["\xE8\x82\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x53"],
        ["\xF0\xA6\x99\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x54"],
        ["\xE8\x83\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x55"],
        ["\xE8\x83\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x56"],
        ["\xE8\x83\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x57"],
        ["\xE8\x83\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x58"],
        ["\xF0\xA6\x9A\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x59"],
        ["\xE8\x84\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x5A"],
        ["\xE8\x83\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x5B"],
        ["\xE8\x83\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x5C"],
        ["\xE4\x8F\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x5D"],
        ["\xE8\x84\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x5E"],
        ["\xE8\x84\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x5F"],
        ["\xE8\x84\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x60"],
        ["\xE4\x8F\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x61"],
        ["\xE8\x84\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x62"],
        ["\xE8\x84\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x63"],
        ["\xE8\x84\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x64"],
        ["\xF0\xA6\x9C\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x65"],
        ["\xE8\x84\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x66"],
        ["\xE4\x90\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x67"],
        ["\xE8\x85\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x68"],
        ["\xE4\x90\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x69"],
        ["\xE8\x86\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x6A"],
        ["\xE4\x90\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x6B"],
        ["\xE8\x86\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x6C"],
        ["\xE8\x86\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x6D"],
        ["\xE4\x90\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x6E"],
        ["\xE8\x86\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x6F"],
        ["\xE8\x86\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x70"],
        ["\xE8\x87\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x71"],
        ["\xE8\x87\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x72"],
        ["\xE8\x87\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x73"],
        ["\xE8\x87\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x74"],
        ["\xF0\xA6\xA3\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x75"],
        ["\xE8\x87\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x76"],
        ["\xF0\xA6\xA3\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x77"],
        ["\xE8\x87\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x78"],
        ["\xF0\xA6\xA5\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x79"],
        ["\xE8\x87\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x7A"],
        ["\xE8\x87\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x7B"],
        ["\xF0\xA6\xA5\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x7C"],
        ["\xE8\x88\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x7D"],
        ["\xF0\xA6\xA7\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x7E"],
        ["\xE8\x88\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x80"],
        ["\xE8\x88\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x81"],
        ["\xE8\x88\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x82"],
        ["\xF0\xA6\xA8\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x83"],
        ["\xE8\x88\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x84"],
        ["\xE8\x88\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x85"],
        ["\xE8\x88\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x86"],
        ["\xE8\x89\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x87"],
        ["\xE8\x89\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x88"],
        ["\xE8\x89\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x89"],
        ["\xF0\xA6\xA9\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x8A"],
        ["\xE8\x89\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x8B"],
        ["\xE4\x91\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x8C"],
        ["\xE8\x89\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x8D"],
        ["\xE4\x91\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x8E"],
        ["\xE8\x89\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x8F"],
        ["\xF0\xA6\xAA\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x90"],
        ["\xE8\x89\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x91"],
        ["\xE8\x89\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x92"],
        ["\xF0\xA6\xAA\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x93"],
        ["\xEF\xA9\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x94"],
        ["\xEF\xA9\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x95"],
        ["\xE8\x89\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x96"],
        ["\xE4\x92\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x97"],
        ["\xE8\x89\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x98"],
        ["\xE8\x89\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x99"],
        ["\xE8\x8A\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x9A"],
        ["\xE8\x8A\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x9B"],
        ["\xE8\x8A\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x9C"],
        ["\xE8\x8A\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x9D"],
        ["\xE8\x8A\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x9E"],
        ["\xE8\x8A\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\x9F"],
        ["\xE8\x8A\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xA0"],
        ["\xE8\x8A\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xA1"],
        ["\xE8\x8A\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xA2"],
        ["\xE8\x8B\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xA3"],
        ["\xE8\x8B\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xA4"],
        ["\xE8\x8B\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xA5"],
        ["\xE8\x8C\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xA6"],
        ["\xE8\x8C\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xA7"],
        ["\xE8\x8C\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xA8"],
        ["\xE8\x8D\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xA9"],
        ["\xE8\x8C\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xAA"],
        ["\xE8\x8C\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xAB"],
        ["\xE8\x8C\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xAC"],
        ["\xE8\x8C\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xAD"],
        ["\xE8\x8D\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xAE"],
        ["\xE8\x8D\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xAF"],
        ["\xE4\x92\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xB0"],
        ["\xE4\x93\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xB2"],
        ["\xE4\x92\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xB3"],
        ["\xE8\x8E\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xB4"],
        ["\xE8\x8E\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xB5"],
        ["\xE8\x8E\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xB6"],
        ["\xE8\x8E\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xB7"],
        ["\xE8\x8E\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xB8"],
        ["\xE8\x8F\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xB9"],
        ["\xE8\x8F\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xBA"],
        ["\xE8\x8F\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xBB"],
        ["\xE8\x8F\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xBC"],
        ["\xE8\x8F\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xBD"],
        ["\xE8\x8F\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xBE"],
        ["\xE8\x90\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xBF"],
        ["\xE8\x90\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xC0"],
        ["\xE8\x90\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xC1"],
        ["\xF0\xA6\xB1\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xC2"],
        ["\xE8\x90\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xC3"],
        ["\xE8\x90\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xC4"],
        ["\xE8\x91\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xC5"],
        ["\xE8\x91\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xC6"],
        ["\xE8\x91\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xC7"],
        ["\xE8\x91\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xC8"],
        ["\xE8\x91\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xC9"],
        ["\xE8\x91\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xCA"],
        ["\xE8\x91\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xCB"],
        ["\xF0\xA6\xB3\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xCC"],
        ["\xE8\x91\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xCD"],
        ["\xE8\x91\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xCE"],
        ["\xE8\x91\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xCF"],
        ["\xE8\x91\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xD0"],
        ["\xE8\x92\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xD1"],
        ["\xE4\x94\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xD2"],
        ["\xE8\x92\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xD4"],
        ["\xE8\x92\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xD5"],
        ["\xE8\x92\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xD6"],
        ["\xE4\x94\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xD7"],
        ["\xE8\x93\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xD8"],
        ["\xE8\x93\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xD9"],
        ["\xE8\x93\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xDA"],
        ["\xF0\xA6\xB9\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xDB"],
        ["\xE8\x93\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xDC"],
        ["\xE8\x93\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xDD"],
        ["\xE8\x93\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xDE"],
        ["\xE8\x93\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xDF"],
        ["\xE8\x93\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xE0"],
        ["\xE8\x93\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xE1"],
        ["\xE8\x93\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xE2"],
        ["\xE8\x94\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xE3"],
        ["\xE8\x94\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xE4"],
        ["\xE8\x94\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xE5"],
        ["\xE8\x94\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xE6"],
        ["\xE8\x94\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xE7"],
        ["\xE8\x94\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xE8"],
        ["\xE8\x95\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xE9"],
        ["\xE8\x95\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xEA"],
        ["\xE4\x94\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xEB"],
        ["\xE4\x95\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xEC"],
        ["\xE8\x94\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xED"],
        ["\xE8\x95\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xEE"],
        ["\xE8\x95\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xF0"],
        ["\xE8\x95\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xF1"],
        ["\xE8\x95\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xF2"],
        ["\xF0\xA6\xBE\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xF3"],
        ["\xE8\x95\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xF4"],
        ["\xE8\x95\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xF5"],
        ["\xE8\x95\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xF6"],
        ["\xE8\x96\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xF7"],
        ["\xE8\x96\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xF8"],
        ["\xE8\x96\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xF9"],
        ["\xE8\x96\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xFA"],
        ["\xE8\x96\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xFB"],
        ["\xF0\xA6\xBF\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF8\xFC"],
        ["\xF0\xA6\xBF\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x40"],
        ["\xF0\xA6\xBF\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x41"],
        ["\xE8\x96\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x42"],
        ["\xE8\x96\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x43"],
        ["\xE8\x97\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x44"],
        ["\xE8\x97\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x45"],
        ["\xE8\x97\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x46"],
        ["\xE8\x97\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x47"],
        ["\xE8\x97\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x48"],
        ["\xE8\x97\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x49"],
        ["\xE8\x97\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x4A"],
        ["\xE8\x97\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x4B"],
        ["\xE8\x98\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x4C"],
        ["\xE8\x98\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x4D"],
        ["\xE8\x98\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x4E"],
        ["\xE8\x98\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x4F"],
        ["\xE8\x98\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x50"],
        ["\xE8\x98\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x51"],
        ["\xF0\xA7\x84\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x52"],
        ["\xE8\x98\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x53"],
        ["\xE8\x98\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x54"],
        ["\xF0\xA7\x84\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x55"],
        ["\xE8\x99\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x56"],
        ["\xE8\x99\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x58"],
        ["\xE8\x99\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x59"],
        ["\xE8\x99\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x5A"],
        ["\xE8\x99\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x5B"],
        ["\xE8\x99\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x5C"],
        ["\xE8\x9A\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x5D"],
        ["\xE8\x9A\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x5E"],
        ["\xE8\x9A\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x5F"],
        ["\xE8\x9A\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x60"],
        ["\xE8\x9A\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x61"],
        ["\xE8\x9A\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x62"],
        ["\xE8\x9A\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x63"],
        ["\xE8\x9A\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x65"],
        ["\xE8\x9A\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x66"],
        ["\xE8\x9B\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x67"],
        ["\xE8\x9B\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x68"],
        ["\xE8\x9B\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x69"],
        ["\xE8\x9B\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x6A"],
        ["\xE8\x9B\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x6B"],
        ["\xE8\x9B\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x6C"],
        ["\xE8\x9B\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x6D"],
        ["\xE4\x96\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x6E"],
        ["\xE8\x9C\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x6F"],
        ["\xE8\x9C\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x70"],
        ["\xE8\x9C\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x71"],
        ["\xE8\x9C\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x72"],
        ["\xE8\x9C\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x73"],
        ["\xE8\x9C\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x74"],
        ["\xE8\x9C\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x75"],
        ["\xE8\x9C\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x76"],
        ["\xE8\x9C\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x77"],
        ["\xE8\x9C\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x78"],
        ["\xE8\x9C\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x79"],
        ["\xE8\x9C\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x7A"],
        ["\xE8\x9D\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x7B"],
        ["\xE8\x9D\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x7C"],
        ["\xE8\x9D\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x7D"],
        ["\xE8\x9D\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x7E"],
        ["\xE8\x9D\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x80"],
        ["\xE8\x9D\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x81"],
        ["\xE8\x9D\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x82"],
        ["\xE8\x9D\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x83"],
        ["\xF0\xA7\x8F\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x84"],
        ["\xF0\xA7\x8F\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x85"],
        ["\xE8\x9E\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x86"],
        ["\xE8\x9E\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x87"],
        ["\xE8\x9E\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x88"],
        ["\xE8\x9E\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x89"],
        ["\xE8\x9E\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x8A"],
        ["\xF0\xA7\x8F\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x8B"],
        ["\xE4\x97\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x8C"],
        ["\xE8\x9E\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x8D"],
        ["\xF0\xA7\x90\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x8E"],
        ["\xE8\x9F\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x8F"],
        ["\xE8\x9F\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x90"],
        ["\xE8\x9F\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x91"],
        ["\xE8\x9F\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x92"],
        ["\xF0\xA7\x91\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x93"],
        ["\xE8\x9F\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x94"],
        ["\xE8\x9F\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x95"],
        ["\xE8\x9F\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x96"],
        ["\xE8\x9F\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x97"],
        ["\xE8\x9F\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x98"],
        ["\xE8\x9F\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x99"],
        ["\xE8\xA0\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x9A"],
        ["\xE8\xA0\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x9B"],
        ["\xE8\xA0\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x9C"],
        ["\xE8\xA0\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x9D"],
        ["\xE8\xA0\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x9E"],
        ["\xE8\xA0\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\x9F"],
        ["\xE8\xA0\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xA0"],
        ["\xE8\xA0\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xA1"],
        ["\xE4\x98\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xA2"],
        ["\xE8\xA1\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xA3"],
        ["\xE8\xA1\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xA4"],
        ["\xE8\xA1\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xA5"],
        ["\xE8\xA1\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xA6"],
        ["\xF0\xA7\x98\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xA7"],
        ["\xF0\xA7\x98\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xA8"],
        ["\xE8\xA1\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xA9"],
        ["\xF0\xA7\x98\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xAA"],
        ["\xE8\xA1\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xAB"],
        ["\xE8\xA2\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xAC"],
        ["\xE8\xA2\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xAD"],
        ["\xE8\xA2\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xAE"],
        ["\xE8\xA2\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xAF"],
        ["\xE8\xA3\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xB0"],
        ["\xE8\xA3\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xB1"],
        ["\xF0\xA7\x9A\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xB2"],
        ["\xE8\xA3\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xB3"],
        ["\xE8\xA3\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xB4"],
        ["\xE8\xA3\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xB5"],
        ["\xE8\xA3\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xB6"],
        ["\xE8\xA3\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xB7"],
        ["\xE4\x99\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xB8"],
        ["\xE8\xA4\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xB9"],
        ["\xF0\xA7\x9C\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xBA"],
        ["\xE8\xA4\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xBB"],
        ["\xF0\xA7\x9C\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xBC"],
        ["\xE8\xA5\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xBD"],
        ["\xE8\xA5\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xBE"],
        ["\xE8\xA5\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xBF"],
        ["\xF0\xA7\x9D\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xC0"],
        ["\xE4\x99\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xC1"],
        ["\xE8\xA5\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xC2"],
        ["\xE8\xA6\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xC3"],
        ["\xE8\xA6\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xC4"],
        ["\xE8\xA6\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xC5"],
        ["\xE8\xA6\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xC6"],
        ["\xE8\xA6\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xC7"],
        ["\xE8\xA6\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xC8"],
        ["\xE8\xA7\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xC9"],
        ["\xE8\xA7\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xCA"],
        ["\xE8\xA7\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xCB"],
        ["\xE4\x9A\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xCC"],
        ["\xE8\xA7\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xCD"],
        ["\xE8\xA7\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xCE"],
        ["\xE8\xA7\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xCF"],
        ["\xE8\xA7\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xD0"],
        ["\xE4\x9A\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xD1"],
        ["\xE8\xA8\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xD2"],
        ["\xE8\xA8\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xD3"],
        ["\xF0\xA7\xA6\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xD4"],
        ["\xE8\xA8\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xD5"],
        ["\xE8\xA8\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xD6"],
        ["\xE8\xA8\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xD7"],
        ["\xE8\xA9\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xD8"],
        ["\xE8\xA9\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xD9"],
        ["\xE8\xA9\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xDA"],
        ["\xE8\xAA\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xDB"],
        ["\xE8\xAA\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xDC"],
        ["\xE8\xAA\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xDD"],
        ["\xE8\xAB\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xDF"],
        ["\xE8\xAB\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xE0"],
        ["\xF0\xA7\xAA\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xE1"],
        ["\xE8\xAC\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xE2"],
        ["\xE8\xAC\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xE3"],
        ["\xE8\xAC\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xE4"],
        ["\xE8\xAC\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xE5"],
        ["\xE8\xAC\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xE6"],
        ["\xE8\xAC\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xE7"],
        ["\xE8\xAD\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xE8"],
        ["\xE4\x9C\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xE9"],
        ["\xE8\xAD\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xEA"],
        ["\xE8\xAD\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xEB"],
        ["\xE8\xAD\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xEC"],
        ["\xE8\xAE\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xEE"],
        ["\xE8\xAE\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xEF"],
        ["\xE8\xAE\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xF0"],
        ["\xE8\xAE\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xF1"],
        ["\xE8\xAE\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xF2"],
        ["\xE8\xAE\x9E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xF3"],
        ["\xE8\xB0\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xF4"],
        ["\xF0\xA7\xAE\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xF5"],
        ["\xE8\xB0\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xF6"],
        ["\xF0\xA7\xAE\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xF7"],
        ["\xF0\xA7\xAF\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xF8"],
        ["\xE8\xB1\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xF9"],
        ["\xE8\xB1\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xFA"],
        ["\xE8\xB1\x8F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xFB"],
        ["\xE8\xB1\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xF9\xFC"],
        ["\xE8\xB2\xA4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x4A"],
        ["\xE8\xB3\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x4B"],
        ["\xE8\xB3\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x4C"],
        ["\xE8\xB3\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x4D"],
        ["\xF0\xA7\xB6\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x4E"],
        ["\xE8\xB3\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x50"],
        ["\xF0\xA7\xB8\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x51"],
        ["\xE8\xB4\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x52"],
        ["\xE8\xB4\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x53"],
        ["\xE8\xB5\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x54"],
        ["\xE8\xB6\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x55"],
        ["\xE8\xB6\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x56"],
        ["\xE8\xB6\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x57"],
        ["\xF0\xA7\xBE\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x58"],
        ["\xE8\xB7\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x59"],
        ["\xE8\xB7\x88",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x5A"],
        ["\xE8\xB7\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x5B"],
        ["\xE4\x9F\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x5E"],
        ["\xE8\xB7\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x5F"],
        ["\xE8\xB8\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x65"],
        ["\xE4\xA0\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x68"],
        ["\xE4\xA1\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x7B"],
        ["\xE8\xBF\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x90"],
        ["\xE9\x81\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x9B"],
        ["\xE9\x81\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x9C"],
        ["\xE4\xA2\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xA5"],
        ["\xE9\x83\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xB1"],
        ["\xE9\x89\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xD8"],
        ["\xE9\x89\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xE0"],
        ["\xE9\x8A\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xE8"],
        ["\xE9\x8A\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xEA"],
        ["\xE9\x8E\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x58"],
        ["\xE9\x8F\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x5E"],
        ["\xE9\x96\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x75"],
        ["\xE9\x98\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x7D"],
        ["\xE9\x98\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x7E"],
        ["\xE9\x98\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x80"],
        ["\xE9\x98\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x82"],
        ["\xE9\x9A\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x86"],
        ["\xE4\xA7\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x8A"],
        ["\xE4\xA7\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x90"],
        ["\xE9\x9B\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x92"],
        ["\xE4\xA8\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x95"],
        ["\xE4\xA8\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x98"],
        ["\xE9\x9D\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x9D"],
        ["\xE9\x9D\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x9F"],
        ["\xE9\x9F\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xA9"],
        ["\xE9\xA0\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB1"],
        ["\xE9\xA0\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB3"],
        ["\xE9\xA0\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB4"],
        ["\xE4\xAA\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB5"],
        ["\xE9\xA0\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB7"],
        ["\xE4\xAC\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xD3"],
        ["\xE9\xA4\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xDA"],
        ["\xE9\xA5\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xE9"],
        ["\xE9\xA6\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xEA"],
        ["\xE9\xA7\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xF6"],
        ["\xE9\xA7\xBC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xF7"],
        ["\xE9\xA8\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xF9"],
        ["\xE9\xA8\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xFB"],
        ["\xE9\xA8\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xFC"],
        ["\xE9\xA8\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x40"],
        ["\xE9\xA8\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x41"],
        ["\xE9\xA9\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x42"],
        ["\xE9\xA9\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x43"],
        ["\xE9\xA9\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x44"],
        ["\xE4\xAF\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x45"],
        ["\xE9\xAA\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x46"],
        ["\xE4\xAF\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x47"],
        ["\xE9\xAA\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x48"],
        ["\xE4\xAF\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x49"],
        ["\xE9\xAA\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x4A"],
        ["\xE9\xAB\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x4C"],
        ["\xE9\xAB\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x4D"],
        ["\xE9\xAB\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x4E"],
        ["\xE9\xAB\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x4F"],
        ["\xE4\xAF\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x50"],
        ["\xE9\xAB\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x52"],
        ["\xE9\xAB\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x53"],
        ["\xE9\xAB\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x54"],
        ["\xE9\xAC\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x55"],
        ["\xE9\xAC\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x56"],
        ["\xE9\xAC\x90",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x57"],
        ["\xE9\xAC\x92",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x58"],
        ["\xE9\xAC\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x59"],
        ["\xE9\xAC\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x5A"],
        ["\xE9\xAC\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x5B"],
        ["\xE9\xAC\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x5C"],
        ["\xE9\xAC\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x5D"],
        ["\xE4\xB0\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x5E"],
        ["\xE9\xAD\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x5F"],
        ["\xE9\xAD\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x60"],
        ["\xE9\xAD\xA5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x61"],
        ["\xE9\xAD\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x62"],
        ["\xE9\xAD\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x63"],
        ["\xE9\xAD\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x64"],
        ["\xE9\xAD\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x65"],
        ["\xE9\xAD\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x66"],
        ["\xE9\xAE\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x67"],
        ["\xE9\xAE\xAC",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x68"],
        ["\xF0\xA9\xB7\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x6A"],
        ["\xF0\xA9\xB8\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x6B"],
        ["\xE9\xAE\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x6C"],
        ["\xE9\xAE\xB8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x6D"],
        ["\xE9\xAE\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x6E"],
        ["\xE9\xAF\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x6F"],
        ["\xE9\xAF\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x70"],
        ["\xE9\xAF\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x71"],
        ["\xE9\xAF\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x72"],
        ["\xE9\xAF\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x73"],
        ["\xE9\xAF\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x74"],
        ["\xE9\xAF\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x75"],
        ["\xE9\xAF\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x76"],
        ["\xE9\xAF\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x77"],
        ["\xF0\xA9\xB8\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x78"],
        ["\xE9\xAF\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x79"],
        ["\xF0\xA9\xBA\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x7A"],
        ["\xE9\xAF\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x7B"],
        ["\xF0\xA9\xB9\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x7C"],
        ["\xE9\xB0\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x7D"],
        ["\xE9\xB0\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x7E"],
        ["\xE9\xB0\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x80"],
        ["\xE9\xB0\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x81"],
        ["\xE9\xB0\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x82"],
        ["\xE9\xB0\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x83"],
        ["\xE9\xB0\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x84"],
        ["\xE9\xB0\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x85"],
        ["\xE9\xB0\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x86"],
        ["\xF0\xA9\xBB\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x87"],
        ["\xE9\xB0\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x88"],
        ["\xE9\xB0\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x89"],
        ["\xE9\xB0\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x8A"],
        ["\xE9\xB1\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x8B"],
        ["\xE9\xB1\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x8C"],
        ["\xF0\xA9\xBB\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x8D"],
        ["\xE9\xB1\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x8E"],
        ["\xE9\xB1\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x8F"],
        ["\xF0\xA9\xBB\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x90"],
        ["\xE9\xB1\x94",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x91"],
        ["\xE9\xB1\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x92"],
        ["\xE9\xB1\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x93"],
        ["\xE9\xB1\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x94"],
        ["\xE9\xB1\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x95"],
        ["\xE9\xB1\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x96"],
        ["\xE9\xB1\xAA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x97"],
        ["\xE9\xB1\xAB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x98"],
        ["\xE9\xB1\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x99"],
        ["\xE9\xB1\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x9A"],
        ["\xE9\xB1\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x9B"],
        ["\xE9\xB1\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x9C"],
        ["\xE9\xB1\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x9D"],
        ["\xE9\xB1\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x9E"],
        ["\xE9\xB3\xA6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x9F"],
        ["\xE9\xB3\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xA0"],
        ["\xE9\xB4\x8B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xA1"],
        ["\xE9\xB4\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xA2"],
        ["\xF0\xA9\xBF\x8E",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xA3"],
        ["\xE9\xB4\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xA4"],
        ["\xE9\xB4\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xA5"],
        ["\xE9\xB4\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xA6"],
        ["\xF0\xAA\x80\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xA7"],
        ["\xE4\xB3\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xA8"],
        ["\xF0\xAA\x80\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xA9"],
        ["\xE9\xB4\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xAA"],
        ["\xE4\xB3\x91",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xAB"],
        ["\xE9\xB5\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xAC"],
        ["\xE9\xB5\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xAD"],
        ["\xE9\xB5\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xAE"],
        ["\xE9\xB5\xA2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xAF"],
        ["\xF0\xAA\x83\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xB0"],
        ["\xE9\xB5\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xB1"],
        ["\xF0\xAA\x82\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xB3"],
        ["\xE9\xB5\xB3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xB4"],
        ["\xE9\xB5\xB6",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xB5"],
        ["\xE9\xB5\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xB6"],
        ["\xE9\xB5\xBE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xB7"],
        ["\xE9\xB6\x84",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xB8"],
        ["\xE9\xB6\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xB9"],
        ["\xE9\xB6\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xBA"],
        ["\xE9\xB6\xA1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xBB"],
        ["\xE9\xB6\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xBC"],
        ["\xE9\xB6\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xBD"],
        ["\xE9\xB6\xB9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xBE"],
        ["\xE9\xB6\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xBF"],
        ["\xE9\xB7\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xC0"],
        ["\xE9\xB7\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xC1"],
        ["\xE9\xB7\x89",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xC2"],
        ["\xE9\xB7\x96",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xC3"],
        ["\xE9\xB7\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xC4"],
        ["\xE9\xB7\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xC5"],
        ["\xE9\xB7\xA0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xC6"],
        ["\xE9\xB7\xA3",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xC7"],
        ["\xE9\xB7\xB4",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xC8"],
        ["\xE4\xB4\x87",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xC9"],
        ["\xE9\xB8\x8A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xCA"],
        ["\xE9\xB8\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xCB"],
        ["\xE9\xB8\x8D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xCC"],
        ["\xE9\xB8\x9C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xCE"],
        ["\xE9\xB8\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xCF"],
        ["\xE9\xB9\xBB",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xD0"],
        ["\xF0\xA2\x88\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xD1"],
        ["\xE9\xBA\x80",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xD2"],
        ["\xE9\xBA\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xD3"],
        ["\xE9\xBA\x9B",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xD4"],
        ["\xE9\xBA\xA8",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xD5"],
        ["\xF0\xAA\x8E\x8C",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xD6"],
        ["\xE9\xBA\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xD7"],
        ["\xF0\xAA\x90\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xD8"],
        ["\xE9\xBB\x9F",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xD9"],
        ["\xE9\xBB\xA7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xDA"],
        ["\xE9\xBB\xAE",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xDB"],
        ["\xE9\xBB\xBF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xDC"],
        ["\xE9\xBC\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xDD"],
        ["\xE4\xB5\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xDE"],
        ["\xE9\xBC\x83",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xDF"],
        ["\xE9\xBC\x97",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xE0"],
        ["\xE9\xBC\x99",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xE1"],
        ["\xE9\xBC\xAF",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xE2"],
        ["\xE9\xBC\xB7",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xE3"],
        ["\xE9\xBC\xBA",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xE4"],
        ["\xE9\xBC\xBD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xE5"],
        ["\xE9\xBD\x81",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xE6"],
        ["\xE9\xBD\x85",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xE7"],
        ["\xE9\xBD\x86",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xE8"],
        ["\xE9\xBD\x93",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xE9"],
        ["\xE9\xBD\x95",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xEA"],
        ["\xE9\xBD\x98",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xEB"],
        ["\xF0\xAA\x97\xB1",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xEC"],
        ["\xE9\xBD\x9D",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xED"],
        ["\xF0\xAA\x98\x82",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xEE"],
        ["\xE9\xBD\xA9",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xEF"],
        ["\xF0\xAA\x98\x9A",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xF0"],
        ["\xE9\xBD\xAD",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xF1"],
        ["\xE9\xBD\xB0",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xF2"],
        ["\xE9\xBD\xB5",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xF3"],
        ["\xF0\xAA\x9A\xB2",'sjis2004','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\xF4"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
