package Bundle::Math::Base;
use strict;
use warnings;

$VERSION = '1.00';

1;

__END__

=head1 NAME

Bundle::Math::Base - Bundle related to calculations between different bases

=head1 SYNOPSIS

 perl -MCPAN -e 'install Bundle::Math::Base'

=head1 CONTENTS

Math::Base36

Math::Base85

Math::BaseArith

Math::BaseCalc

Math::BaseCnv

Math::Roman

=head1 DESCRIPTION

This is a bundle of modules related to calculations between different bases.

Please have a look at L<Bundle::Math>.

If you would like to see a specific module included in a future version of
this bundle, please send me an email or use rt.cpan.org.

=head1 AUTHOR

Steffen Mueller E<lt>bundlemath-module at steffen-mueller dot netE<gt>

=cut 
