# Generated by default/object.tt
package Paws::SecurityHub::AwsCertificateManagerCertificateDomainValidationOption;
  use Moose;
  has DomainName => (is => 'ro', isa => 'Str');
  has ResourceRecord => (is => 'ro', isa => 'Paws::SecurityHub::AwsCertificateManagerCertificateResourceRecord');
  has ValidationDomain => (is => 'ro', isa => 'Str');
  has ValidationEmails => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has ValidationMethod => (is => 'ro', isa => 'Str');
  has ValidationStatus => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsCertificateManagerCertificateDomainValidationOption

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsCertificateManagerCertificateDomainValidationOption object:

  $service_obj->Method(Att1 => { DomainName => $value, ..., ValidationStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsCertificateManagerCertificateDomainValidationOption object:

  $result = $service_obj->Method(...);
  $result->Att1->DomainName

=head1 DESCRIPTION

Contains information about one of the following:

=over

=item *

The initial validation of each domain name that occurs as a result of
the C<RequestCertificate> request

=item *

The validation of each domain name in the certificate, as it pertains
to AWS Certificate Manager managed renewal

=back


=head1 ATTRIBUTES


=head2 DomainName => Str

A fully qualified domain name (FQDN) in the certificate.


=head2 ResourceRecord => L<Paws::SecurityHub::AwsCertificateManagerCertificateResourceRecord>

The CNAME record that is added to the DNS database for domain
validation.


=head2 ValidationDomain => Str

The domain name that AWS Certificate Manager uses to send domain
validation emails.


=head2 ValidationEmails => ArrayRef[Str|Undef]

A list of email addresses that AWS Certificate Manager uses to send
domain validation emails.


=head2 ValidationMethod => Str

The method used to validate the domain name.


=head2 ValidationStatus => Str

The validation status of the domain name.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

