/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.UnpackedImageData;

class BandMergeOpImage
extends PointOpImage {
    ColorModel[] colorModels;

    public BandMergeOpImage(Vector vector, Map map, ImageLayout imageLayout) {
        super(vector, BandMergeOpImage.layoutHelper(vector, imageLayout), map, true);
        this.permitInPlaceOperation();
        int n = vector.size();
        this.colorModels = new ColorModel[n];
        int n2 = 0;
        while (n2 < n) {
            this.colorModels[n2] = ((RenderedImage)vector.get(n2)).getColorModel();
            ++n2;
        }
    }

    private static int totalNumBands(Vector vector) {
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            RenderedImage renderedImage = (RenderedImage)vector.get(n2);
            n = renderedImage.getColorModel() instanceof IndexColorModel ? (n += renderedImage.getColorModel().getNumComponents()) : (n += renderedImage.getSampleModel().getNumBands());
            ++n2;
        }
        return n;
    }

    private static ImageLayout layoutHelper(Vector vector, ImageLayout imageLayout) {
        Object object;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        int n = vector.size();
        int n2 = BandMergeOpImage.totalNumBands(vector);
        int n3 = 0;
        RenderedImage renderedImage = (RenderedImage)vector.get(0);
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        int n4 = 0;
        while (n4 < n) {
            renderedImage = (RenderedImage)vector.get(n4);
            rectangle = rectangle.intersection(new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight()));
            int n5 = renderedImage.getSampleModel().getTransferType();
            n3 = n5 > n3 ? n5 : n3;
            ++n4;
        }
        SampleModel sampleModel = imageLayout2.getSampleModel((RenderedImage)vector.get(0));
        if (sampleModel.getNumBands() < n2) {
            object = new int[n2];
            int n6 = 0;
            while (n6 < n2) {
                object[n6] = n6;
                ++n6;
            }
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, n3, rectangle.width, rectangle.height, n2);
            imageLayout2.setSampleModel(sampleModel);
        }
        if ((object = (Object)imageLayout2.getColorModel(null)) != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, (ColorModel)object)) {
            imageLayout2.unsetValid(512);
        }
        return imageLayout2;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = writableRaster.getTransferType();
        switch (n) {
            case 0: {
                this.byteLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 3: {
                this.intLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 4: {
                this.floatLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            case 5: {
                this.doubleLoop(rasterArray, writableRaster, rectangle);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void byteLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = rasterArray.length;
        int[] nArray = new int[n];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n];
        int n2 = 0;
        while (n2 < n) {
            pixelAccessorArray[n2] = new PixelAccessor(rasterArray[n2].getSampleModel(), this.colorModels[n2]);
            nArray[n2] = this.colorModels[n2] instanceof IndexColorModel ? this.colorModels[n2].getNumComponents() : rasterArray[n2].getNumBands();
            ++n2;
        }
        int n3 = writableRaster.getNumBands();
        int n4 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n4, true);
        byte[][] byArray = (byte[][])unpackedImageData.data;
        int n5 = 0;
        int n6 = 0;
        while (n5 < n) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n5] instanceof IndexColorModel ? pixelAccessorArray[n5].getComponents(rasterArray[n5], rectangle, rasterArray[n5].getSampleModel().getTransferType()) : pixelAccessorArray[n5].getPixels(rasterArray[n5], rectangle, rasterArray[n5].getSampleModel().getTransferType(), false);
            int n7 = unpackedImageData2.pixelStride;
            int n8 = unpackedImageData2.lineStride;
            int n9 = unpackedImageData.pixelStride;
            int n10 = unpackedImageData.lineStride;
            int n11 = rectangle.width;
            int n12 = 0;
            while (n12 < nArray[n5]) {
                if (n6 >= n3) break;
                byte[] byArray2 = byArray[n6];
                byte[][] byArray3 = (byte[][])unpackedImageData2.data;
                byte[] byArray4 = byArray3[n12];
                int n13 = unpackedImageData2.bandOffsets[n12];
                int n14 = unpackedImageData.bandOffsets[n6];
                int n15 = 0;
                while (n15 < rectangle.height) {
                    int n16 = 0;
                    int n17 = n13;
                    int n18 = n14;
                    while (n16 < n11) {
                        byArray2[n18] = byArray4[n17];
                        ++n16;
                        n17 += n7;
                        n18 += n9;
                    }
                    ++n15;
                    n13 += n8;
                    n14 += n10;
                }
                ++n12;
                ++n6;
            }
            ++n5;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void shortLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = rasterArray.length;
        int[] nArray = new int[n];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n];
        int n2 = 0;
        while (n2 < n) {
            pixelAccessorArray[n2] = new PixelAccessor(rasterArray[n2].getSampleModel(), this.colorModels[n2]);
            nArray[n2] = this.colorModels[n2] instanceof IndexColorModel ? this.colorModels[n2].getNumComponents() : rasterArray[n2].getNumBands();
            ++n2;
        }
        int n3 = writableRaster.getNumBands();
        int n4 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n4, true);
        short[][] sArray = (short[][])unpackedImageData.data;
        int n5 = 0;
        int n6 = 0;
        while (n5 < n) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n5] instanceof IndexColorModel ? pixelAccessorArray[n5].getComponents(rasterArray[n5], rectangle, rasterArray[n5].getSampleModel().getTransferType()) : pixelAccessorArray[n5].getPixels(rasterArray[n5], rectangle, rasterArray[n5].getSampleModel().getTransferType(), false);
            int n7 = unpackedImageData2.pixelStride;
            int n8 = unpackedImageData2.lineStride;
            int n9 = unpackedImageData.pixelStride;
            int n10 = unpackedImageData.lineStride;
            int n11 = rectangle.width;
            int n12 = 0;
            while (n12 < nArray[n5]) {
                if (n6 < n3) {
                    short[][] sArray2 = (short[][])unpackedImageData2.data;
                    int n13 = unpackedImageData2.bandOffsets[n12];
                    int n14 = unpackedImageData.bandOffsets[n6];
                    int n15 = 0;
                    while (n15 < rectangle.height) {
                        int n16 = 0;
                        int n17 = n13;
                        int n18 = n14;
                        while (n16 < n11) {
                            sArray[n6][n18] = sArray2[n12][n17];
                            ++n16;
                            n17 += n7;
                            n18 += n9;
                        }
                        ++n15;
                        n13 += n8;
                        n14 += n10;
                    }
                }
                ++n12;
                ++n6;
            }
            ++n5;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void intLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = rasterArray.length;
        int[] nArray = new int[n];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n];
        int n2 = 0;
        while (n2 < n) {
            pixelAccessorArray[n2] = new PixelAccessor(rasterArray[n2].getSampleModel(), this.colorModels[n2]);
            nArray[n2] = this.colorModels[n2] instanceof IndexColorModel ? this.colorModels[n2].getNumComponents() : rasterArray[n2].getNumBands();
            ++n2;
        }
        int n3 = writableRaster.getNumBands();
        int n4 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n4, true);
        int[][] nArray2 = (int[][])unpackedImageData.data;
        int n5 = 0;
        int n6 = 0;
        while (n5 < n) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n5] instanceof IndexColorModel ? pixelAccessorArray[n5].getComponents(rasterArray[n5], rectangle, rasterArray[n5].getSampleModel().getTransferType()) : pixelAccessorArray[n5].getPixels(rasterArray[n5], rectangle, rasterArray[n5].getSampleModel().getTransferType(), false);
            int n7 = unpackedImageData2.pixelStride;
            int n8 = unpackedImageData2.lineStride;
            int n9 = unpackedImageData.pixelStride;
            int n10 = unpackedImageData.lineStride;
            int n11 = rectangle.width;
            int n12 = 0;
            while (n12 < nArray[n5]) {
                if (n6 < n3) {
                    int[][] nArray3 = (int[][])unpackedImageData2.data;
                    int n13 = unpackedImageData2.bandOffsets[n12];
                    int n14 = unpackedImageData.bandOffsets[n6];
                    int n15 = 0;
                    while (n15 < rectangle.height) {
                        int n16 = 0;
                        int n17 = n13;
                        int n18 = n14;
                        while (n16 < n11) {
                            nArray2[n6][n18] = nArray3[n12][n17];
                            ++n16;
                            n17 += n7;
                            n18 += n9;
                        }
                        ++n15;
                        n13 += n8;
                        n14 += n10;
                    }
                }
                ++n12;
                ++n6;
            }
            ++n5;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void floatLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = rasterArray.length;
        int[] nArray = new int[n];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n];
        int n2 = 0;
        while (n2 < n) {
            pixelAccessorArray[n2] = new PixelAccessor(rasterArray[n2].getSampleModel(), this.colorModels[n2]);
            nArray[n2] = this.colorModels[n2] instanceof IndexColorModel ? this.colorModels[n2].getNumComponents() : rasterArray[n2].getNumBands();
            ++n2;
        }
        int n3 = writableRaster.getNumBands();
        int n4 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n4, true);
        float[][] fArray = (float[][])unpackedImageData.data;
        int n5 = 0;
        int n6 = 0;
        while (n5 < n) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n5] instanceof IndexColorModel ? pixelAccessorArray[n5].getComponents(rasterArray[n5], rectangle, rasterArray[n5].getSampleModel().getTransferType()) : pixelAccessorArray[n5].getPixels(rasterArray[n5], rectangle, rasterArray[n5].getSampleModel().getTransferType(), false);
            int n7 = unpackedImageData2.pixelStride;
            int n8 = unpackedImageData2.lineStride;
            int n9 = unpackedImageData.pixelStride;
            int n10 = unpackedImageData.lineStride;
            int n11 = rectangle.width;
            int n12 = 0;
            while (n12 < nArray[n5]) {
                if (n6 < n3) {
                    float[][] fArray2 = (float[][])unpackedImageData2.data;
                    int n13 = unpackedImageData2.bandOffsets[n12];
                    int n14 = unpackedImageData.bandOffsets[n6];
                    int n15 = 0;
                    while (n15 < rectangle.height) {
                        int n16 = 0;
                        int n17 = n13;
                        int n18 = n14;
                        while (n16 < n11) {
                            fArray[n6][n18] = fArray2[n12][n17];
                            ++n16;
                            n17 += n7;
                            n18 += n9;
                        }
                        ++n15;
                        n13 += n8;
                        n14 += n10;
                    }
                }
                ++n12;
                ++n6;
            }
            ++n5;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }

    private void doubleLoop(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        int n = rasterArray.length;
        int[] nArray = new int[n];
        PixelAccessor[] pixelAccessorArray = new PixelAccessor[n];
        int n2 = 0;
        while (n2 < n) {
            pixelAccessorArray[n2] = new PixelAccessor(rasterArray[n2].getSampleModel(), this.colorModels[n2]);
            nArray[n2] = this.colorModels[n2] instanceof IndexColorModel ? this.colorModels[n2].getNumComponents() : rasterArray[n2].getNumBands();
            ++n2;
        }
        int n3 = writableRaster.getNumBands();
        int n4 = writableRaster.getTransferType();
        PixelAccessor pixelAccessor = new PixelAccessor(writableRaster.getSampleModel(), null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n4, true);
        double[][] dArray = (double[][])unpackedImageData.data;
        int n5 = 0;
        int n6 = 0;
        while (n5 < n) {
            UnpackedImageData unpackedImageData2 = this.colorModels[n5] instanceof IndexColorModel ? pixelAccessorArray[n5].getComponents(rasterArray[n5], rectangle, rasterArray[n5].getSampleModel().getTransferType()) : pixelAccessorArray[n5].getPixels(rasterArray[n5], rectangle, rasterArray[n5].getSampleModel().getTransferType(), false);
            int n7 = unpackedImageData2.pixelStride;
            int n8 = unpackedImageData2.lineStride;
            int n9 = unpackedImageData.pixelStride;
            int n10 = unpackedImageData.lineStride;
            int n11 = rectangle.width;
            int n12 = 0;
            while (n12 < nArray[n5]) {
                if (n6 < n3) {
                    double[][] dArray2 = (double[][])unpackedImageData2.data;
                    int n13 = unpackedImageData2.bandOffsets[n12];
                    int n14 = unpackedImageData.bandOffsets[n6];
                    int n15 = 0;
                    while (n15 < rectangle.height) {
                        int n16 = 0;
                        int n17 = n13;
                        int n18 = n14;
                        while (n16 < n11) {
                            dArray[n6][n18] = dArray2[n12][n17];
                            ++n16;
                            n17 += n7;
                            n18 += n9;
                        }
                        ++n15;
                        n13 += n8;
                        n14 += n10;
                    }
                }
                ++n12;
                ++n6;
            }
            ++n5;
        }
        pixelAccessor.setPixels(unpackedImageData);
    }
}

