#!/usr/bin/perl

package eBay::API::XML::Call::GetContextualKeywords;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetContextualKeywords.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetContextualKeywords

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetContextualKeywords inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetContextualKeywords::GetContextualKeywordsRequestType;
use eBay::API::XML::Call::GetContextualKeywords::GetContextualKeywordsResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetContextualKeywords';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetContextualKeywords::GetContextualKeywordsRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetContextualKeywords::GetContextualKeywordsResponseType';
}

#
# input properties
#

=head2 setCategoryID()

The ID of the category to which keywords are to be limited.
Zero or more category IDs can be specified.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'xs:string'

=cut
       
sub setCategoryID {
   my $self   = shift;
   my $sCategoryID = shift;
   $self->getRequestDataType()->setCategoryID($sCategoryID);
}

=head2 setEncoding()

Web page encoding by which the URL is to be handled, such as ISO-8859-1.

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut
       
sub setEncoding {
   my $self   = shift;
   my $sEncoding = shift;
   $self->getRequestDataType()->setEncoding($sEncoding);
}

=head2 setURL()

The URL of the web page from which eBay is to extract keywords.

  RequiredInput: Yes
#    Argument: 'xs:anyURI'

=cut
       
sub setURL {
   my $self   = shift;
   my $sURL = shift;
   $self->getRequestDataType()->setURL($sURL);
}



#
# output properties
#

=head2 getContextSearchAsset()

An array of either keyword/category pairs or categories, with ranking and score.

  Returned: Always
#    Returns: reference to an array  
                      of 'ns:ContextSearchAssetType'

=cut
       
sub getContextSearchAsset {
   my $self = shift;
   return $self->getResponseDataType()->getContextSearchAsset();
}





1;   
