#!/usr/bin/perl

package eBay::API::XML::Call::GetExpressWishList::GetExpressWishListRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetExpressWishListRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetExpressWishList::GetExpressWishListRequestType

=head1 DESCRIPTION

Enables users to retrieve and view eBay Express wish lists. Wish list is a feature
currently available on the eBay Express web site. This call does not enable creation,
modification, or removal of wish lists. Wish lists may be public or private. Private wish
lists are available for viewing only by their owners. User ID is not returned in the
response. Only one of the search input fields, (FirstName, LastName, UserID, and WishListID)
is recognized in a request. When all search input fields are included in a request, WishListID
takes precedence, followed by UserID, which is followed by FirstName and/or LastName. If none
of the search input fields are used, the call returns the wish list of the requesting user.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetExpressWishList::GetExpressWishListRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::PaginationType;
use eBay::API::XML::DataType::Enum::WishListSortCodeType;


my @gaProperties = ( [ 'FirstName', 'xs:string', '', '', '' ]
	, [ 'LastName', 'xs:string', '', '', '' ]
	, [ 'Pagination', 'ns:PaginationType', ''
	     ,'eBay::API::XML::DataType::PaginationType', '1' ]
	, [ 'SortOrder', 'ns:WishListSortCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::WishListSortCodeType', '' ]
	, [ 'UserID', 'xs:string', '', '', '' ]
	, [ 'WishListID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setFirstName()

User first name. Can be used in combination with LastName. Will be ignored if either UserID or
WishListID is included in the request.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setFirstName {
  my $self = shift;
  $self->{'FirstName'} = shift
}

=head2 getFirstName()

#    Returns: 'xs:string'

=cut

sub getFirstName {
  my $self = shift;
  return $self->{'FirstName'};
}


=head2 setLastName()

User last name. Can be used in combination with FirstName. Will be ignored if either UserID or
WishListID is included in the request.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setLastName {
  my $self = shift;
  $self->{'LastName'} = shift
}

=head2 getLastName()

#    Returns: 'xs:string'

=cut

sub getLastName {
  my $self = shift;
  return $self->{'LastName'};
}


=head2 setPagination()

Contains the data that control the pagination of items or products in any returned wish list.

  RequiredInput: No
#    Argument: 'ns:PaginationType'

=cut

sub setPagination {
  my $self = shift;
  $self->{'Pagination'} = shift
}

=head2 getPagination()

#    Returns: 'ns:PaginationType'

=cut

sub getPagination {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Pagination'
		,'eBay::API::XML::DataType::PaginationType');
}


=head2 setSortOrder()

Sort order for returned results. Default is CreationDateDescending, which returns the most
recently added wish list items first.

  RequiredInput: No
#    Argument: 'ns:WishListSortCodeType'

=cut

sub setSortOrder {
  my $self = shift;
  $self->{'SortOrder'} = shift
}

=head2 getSortOrder()

#    Returns: 'ns:WishListSortCodeType'

=cut

sub getSortOrder {
  my $self = shift;
  return $self->{'SortOrder'};
}


=head2 setUserID()

eBay user ID. Can be used as an alternative to WishListID or to the combination FirstName and LastName.
If WishListID is used, UserID will be ignored. This value is not returned in the response.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setUserID {
  my $self = shift;
  $self->{'UserID'} = shift
}

=head2 getUserID()

#    Returns: 'xs:string'

=cut

sub getUserID {
  my $self = shift;
  return $self->{'UserID'};
}


=head2 setWishListID()

Identifies an eBay Express wish list. When used in a request, UserID and FirstName and LastName are ignored.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setWishListID {
  my $self = shift;
  $self->{'WishListID'} = shift
}

=head2 getWishListID()

#    Returns: 'xs:string'

=cut

sub getWishListID {
  my $self = shift;
  return $self->{'WishListID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
