/**
 * pdfXtk-Extras - PDF Extraction Toolkit Extras
 * Copyright (c) by the authors/contributors.  All rights reserved.
 * This project includes code from PDFBox and TouchGraph.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the names pdfXtk or PDF Extraction Toolkit; nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * http://pdfxtk.sourceforge.net
 *
 */
package at.ac.tuwien.dbai.pdfwrap.comparators;

import java.util.Comparator;

import at.ac.tuwien.dbai.pdfwrap.model.graph.*;
import at.ac.tuwien.dbai.pdfwrap.model.document.*;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;

/**
 * @author Tamir Hassan, hassan@dbai.tuwien.ac.at
 * @version GraphWrap Beta 1
 */
public class ColumnEdgeAttributeComparator implements Comparator<AdjacencyEdge>
{
	public int compare(AdjacencyEdge o1, AdjacencyEdge o2)
	{
		// > means 'before'
		
		// shorter edge (line spacing) > longer edge
		// smaller width difference > larger width difference (forget about alignment for now)
		// smaller font > larger font
		// same font size > differing font sizes
		// edges that contain non-text segments
		
		// TODO: Generics for AdjacencyEdge!
		
		GenericSegment f1 = o1.getNodeFrom();
		GenericSegment t1 = o1.getNodeTo();
		GenericSegment f2 = o2.getNodeFrom();
		GenericSegment t2 = o2.getNodeTo();
		
		boolean text1 = false, text2 = false;
		if (f1 instanceof TextSegment && t1 instanceof TextSegment)
			text1 = true;
		if (f2 instanceof TextSegment && t2 instanceof TextSegment)
			text2 = true;
		
		if (text1 && text2)
		{	
			TextSegment ft1 = (TextSegment)f1;
			TextSegment tt1 = (TextSegment)t1;
			TextSegment ft2 = (TextSegment)f2;
			TextSegment tt2 = (TextSegment)t2;
			
			boolean align1 = false, align2 = false;
			if ((Utils.within(ft1.getX1(), tt1.getX1(), 
				(float)(Utils.avg(ft1.getFontSize(), tt1.getFontSize()) * 0.125)))
			|| (Utils.within(ft1.getXmid(), tt1.getXmid(), 
					(float)(Utils.avg(ft1.getFontSize(), tt1.getFontSize()) * 0.125)))
			|| (Utils.within(ft1.getX2(), tt1.getX2(), 
					(float)(Utils.avg(ft1.getFontSize(), tt1.getFontSize()) * 0.125))))
				align1 = true;
			
			if ((Utils.within(ft2.getX1(), tt2.getX1(), 
					(float)(Utils.avg(ft2.getFontSize(), tt2.getFontSize()) * 0.125)))
			|| (Utils.within(ft2.getXmid(), tt2.getXmid(), 
					(float)(Utils.avg(ft2.getFontSize(), tt2.getFontSize()) * 0.125)))
			|| (Utils.within(ft2.getX2(), tt2.getX2(), 
					(float)(Utils.avg(ft2.getFontSize(), tt2.getFontSize()) * 0.125))))
				align2 = true;
			
			if (align1 && align2)
			{
				// narrower/wider
				TextSegment ls1, ls2;
				if (ft1.getWidth() > tt1.getWidth())
					ls1 = ft1; else ls1 = tt1;
				if (ft2.getWidth() > tt2.getWidth())
					ls2 = ft2; else ls2 = tt2;
					
				if (ls1.getWidth() < ls2.getWidth()) return -1;
				else if (ls1.getWidth() == ls2.getWidth()) return 0;
				else return -1;
			}
			else if (align1) return -1;
			else if (align2) return 1;
			else return 0;
		}
		else if (text1)
		{
			// first element comes before second
			return -1;
		}
		else if (text2)
		{
			// second element comes before first
			return 1;
		}
		else
		{
			// neither is a text segment; equal
			return 0;
		}
	}

	public boolean equals(Object obj)
	{
		return obj.equals(this);
	}
}