import java.util.regex.*;
/*
 * BracketsTokenizer.java
 *
 * Created on 4. November 2005, 18:03
 */


/**
 *
 *  This class implements a tokenizer which does some parsing on 
 *  strings with brackets.
 *
 * @author  Olle Nebendahl
 */
class BracketsTokenizer 
{ 
    
    public static OLL getTokens(String s, String openBracket, String closeBracket)
    {
        OLL result = new OLL();
        String[] temp = split(s,openBracket,closeBracket);
        while(temp[1]!=null)
        {
            result.append(temp[1]);
            temp=split(temp[2],openBracket,closeBracket);
        }
        return result;
    }

    public static String[] split(String s, String openBracket, String closeBracket)
    {
        ILL openBrackets = new ILL();
        ILL closeBrackets = new ILL();
        indexBrackets(openBrackets,openBracket,s);
        indexBrackets(closeBrackets,closeBracket,s);

        int l = closeBrackets.size()+openBrackets.size();
        
        if(l>1)
        {
            boolean[] bracketType = new boolean[l];
            int[] bracketPosition = new int[l];
    
            run(openBrackets,closeBrackets,bracketType,bracketPosition,s);
            
            int[] startStop = getToken(bracketPosition,bracketType,s,openBracket,closeBracket);
            
            String[] result = new String[3];
            if(startStop[0]!=-1)
            {
                result[0]=s.substring(0,startStop[0]);
                result[1]=s.substring(startStop[0]+openBracket.length(),startStop[1]);
                result[2]=s.substring(startStop[1]+closeBracket.length(),s.length());
                return result;
            }
        }
        String[] result = new String[3];
        result[0]=new String(s);
        result[1]=null;
        result[2]=null;
        
        return result;
    }

/*
    boolean[] bracketType;
    int[] bracketPosition;
    
    private ILL openBrackets;
    private ILL closeBrackets;
    private String openBracket;
    private String closeBracket;
    private String input;
    
    private int count;*/
    

    private static void run(ILL openBrackets, ILL closeBrackets, boolean[] bracketType, int[] bracketPosition, String input )
    {
        openBrackets.reset();
        closeBrackets.reset();
        
        int l = bracketType.length;
        
        int i;
        int j=0;

        int il= input.length();
        
        int o=il;
        int c=il;
        
        while(j<l)
        {
            if(o==il)
                if(openBrackets.hasNext())o=openBrackets.getNext();
                else o=il+1;
            if(c==il)
                if(closeBrackets.hasNext())c=closeBrackets.getNext();
                else c=il+1;
            if(o<c)
                {
                    bracketType[j]=true;
                    bracketPosition[j]=o;
                    o=il;
                }
                else
                {
                    bracketType[j]=false;
                    bracketPosition[j]=c;
                    c=il;
                }
                j++;
        }
    }
    
    private static void indexBrackets(ILL ill, String bracket, String input)
    {
        int k = input.indexOf(bracket);
        while(k>-1) 
        {
            ill.append(k);
            k=input.indexOf(bracket,k+bracket.length());
        }
    }
         
    
    private static int[] getToken(int[] bracketPosition, boolean[] bracketType, String input, String openBracket, String closeBracket)
    {
        int[] result = new int[2];
        int l = bracketType.length;
        int i = 0;
        
        int lastPos = -1;
        
        int o=0; int c =0;
        
        while(i<l)
        {
            if(bracketType[i])
                o++; 
            else c++;
            if(o==1&&c==0)
            {
                lastPos=bracketPosition[i];//+openBracket.length();
            }
            if(o==c&&c>0)
            {
                result[0]=lastPos;
                result[1]=bracketPosition[i];
                return result;
            }
            i++;
        }
        result[0]=-1;
        return result;
    }
    

    public static void main(String[] a)
    {
        OLL res = getTokens(a[0],a[1],a[2]);
        res.reset();
        while(res.hasNext())
            System.out.println(res.getNext());
    }
}


/*
class BToken
{
    boolean openBracket;
    int pos;
    BToken(boolean b, int i)
    {
        openBracket=b;
        pos=i;
    }
}
*/
