import javax.swing.*;

/*
 * OLL.java
 *
 */

/**
 *
 *  simple linked list for Objects
 *  providing standard functionality
 *
 * @author  Olle Nebendahl
 */

class OLL 
{
    private OLLNode first;
    private OLLNode last;
    private OLLNode iterNext;
    
    public String delim = "";
    
    public void reset(){ iterNext=first; }
    
    public boolean hasNext(){ return iterNext!=null; }
    
    public String toString()
    {
        StringBuffer result = new StringBuffer();
        reset();
        while(hasNext())
        {
            result.append(getNext());
            result.append(delim);
        }
        return result.toString();
    }

    private int count=0;
    
    public int getCount(){return count;}
    public int size(){ return count; }
    
    public Object getFirst()
    { 
        if(null==first) return null; 
        reset();
        return getNext(); 
    }
    
    public Object getNext()
    {
        Object result = iterNext.container;
        iterNext=iterNext.next;
        return result; 
    }
    
    public Object[] asArray()
    {
        Object[] result = new Object[count];
        OLLNode node=first;
        int i = count;
        while(i>0)
        {
            result[count-i]=node.container; //###
            i--;
            node=node.next;
        }
        return result;
    }
  
    public String[] asStringArray()
    {
        String[] result = new String[count];
        OLLNode node=first;
        int i = count;
        while(i>0)
        {
            result[count-i]=node.container.toString();//###
            i--;
            node=node.next;
        }
        return result;
    }
  
  
    public void add(Object i)
    {
        if(count==0)
        {
            first=new OLLNode();
            first.container=i;
            last=first;
        }
        else
        {
            OLLNode newNode=new OLLNode();
            newNode.container=i;
            newNode.next=first;
            first=newNode;
        }
        count++;
    }

    public void append(Object i)
    {
        if(count==0)
        {
            first=new OLLNode();
            first.container=i;
            last=first;
        }
        else
        {
            OLLNode newNode=new OLLNode();
            newNode.container=i;
            last.next=newNode;
            last=newNode;
        }
        count++;
    }
    
    public void append(OLL appList)
    {
        if(null==appList)return;
        appList.reset();
        while(appList.hasNext())
        {
            append(appList.getNext());
        }
    }
    
    public static DefaultListModel getAsDefaultListModel(OLL li)
    {
        DefaultListModel result = new DefaultListModel();
        li.reset();
        while(li.hasNext())result.addElement(li.getNext());
        return result;
    }
}


class OLLNode
{
    Object container;
    OLLNode next;
}
