import javax.swing.*;
/*
 * SlidePool.java
 *
 * Created on 14. November 2005, 21:44
 */


/**
 * SlidePool is/was the project name of CMS4talks.
 * This class represents in fact the fully functional main class/window
 * without copyleft-hint and logo. 
 *
 * @author  Olle Nebendahl
 */

public abstract class SlidePool extends JFrame {
    
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton scanDirButton;
    private JButton workingCollButton;
    private JButton talkListButton;
    protected final JPanel jPanel1 = new JPanel();
    private JPanel jPanel2;
    private JPanel jPanel2b;
    protected JPanel jPanel3;
    
    TalkListGUI talkList;
    

    /** Creates new form SlidePool */
    public SlidePool() {
        initComponents();
    }
    
    protected void initComponents() {
        //jPanel1 = new JPanel();
        jPanel2 = new JPanel();
        jPanel2b= new JPanel();
        
        jPanel3 = new JPanel();

        jButton1 = new JButton();
        jButton2 = new JButton();
        jButton3 = new JButton();
        jButton4 = new JButton();

        scanDirButton = new JButton();
        workingCollButton = new JButton();
        talkListButton = new JButton();
        

        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));

        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        getContentPane().add(jPanel1);

        jPanel2.setLayout(new BoxLayout(jPanel2, BoxLayout.X_AXIS));
        jPanel2b.setLayout(new BoxLayout(jPanel2b, BoxLayout.X_AXIS));

        jPanel3.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));
        



        jButton1.setText("add talk");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jPanel2.add(jButton1);

        workingCollButton.setText("show working collection");
        workingCollButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                workingCollButtonActionPerformed(evt);
            }
        });

        jPanel2b.add(workingCollButton);

        talkListButton.setText("show talk list");
        talkListButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                talkListButtonActionPerformed(evt);
            }
        });

        jPanel2b.add(talkListButton);

        scanDirButton.setText("add talks");
        scanDirButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                scanDirButtonActionPerformed(evt);
            }
        });

        jPanel2.add(scanDirButton);


        jButton2.setText("Preferences: package paths");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jPanel2.add(jButton2);

        jButton4.setText("Preferences: preferred createslide commands");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });

        jPanel2.add(jButton4);


        jButton3.setText("search for slides");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        jPanel2.add(jButton3);

        getContentPane().add(jPanel2);
        getContentPane().add(jPanel2b);

        getContentPane().add(jPanel3);

        pack();
    }

    public void setVisible(boolean b)
    {
        if(!b)
        {
            getLocation(Constants.mainWindowCoordinates);
            Constants.savePreferences();
        }
        else setLocation(Constants.mainWindowCoordinates);
        super.setVisible(b);
    }
    
    public void dispose()
    {
            getLocation(Constants.prefSlidePoolCoordinates);
            Constants.savePreferences();
            System.out.println("GoodBye");
            System.out.println("Possibly Java won't terminate. Make sure all Your current work is saved. Then it is save to press CTRL+C to terminate Java.");
            super.dispose();
    }


    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) 
    {
        final PrefSlideCommandsGUI pg = new PrefSlideCommandsGUI(this, true);
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                pg.setVisible(true);
            }
        });
    }

    private void workingCollButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        WorkingPool.setVisible(true);
    }

    private void talkListButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        if(null==talkList)
        {
            talkList=new TalkListGUI(this,false);
            TalkWrapper.talkList=talkList.myListModel;
        }
        talkList.setVisible(true);
    }
    
    
    private void scanDirButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        TalkLoader tl = new TalkLoader(this,Constants.prefLastOpenDir);    
    }

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) 
    {
        FoundGUI.main(new String[2]);
    }

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) 
    {
        final PrefPathGUI pg = new PrefPathGUI(this, true);
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                pg.setVisible(true);
            }
        });
    }

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) 
    {
        TalkLoader tl = new TalkLoader(this);
        /*
        PCG.setLocationRelativeTo(null);
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                PCG.setVisible(true);
            }
        });*/
    
    
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new cms4talks().setVisible(true);
            }
        });
    }
}
