# This file belongs to the CEP package | Ten plik nale/zy do pakietu CEP
# This package is public domain        | Pakiet stanowi dobro powszechne
# For more info see `0CEP_LIC.ENG'     | Wi/ecej informacji w ,,0CEP_LIC.POL''
# ===========================================================================
# E: "CEP filtered EPS" --> "EPS" converter
#      input - input file name
#      OUTF  - output file name
#      TMPSX - temporary PostScript file name 
#
# P: Konwerter "CEP filtered EPS" --> "EPS"
#      wej/scie - nazwa pliku konwertowanego
#      OUTF    - nazwa pliku wyj/sciowego
#      TMPSX   - nazwa tymczasowego pliku PostScriptowego

BEGIN {# preparing temporary files | przygotowywanie plik/ow tymczasowych
  ver_no=1.03
  gs_abort="2 2 .quit" 
  chop_EOD=1
  if (TMPSX=="") TMPSX="tmp.psx"
  flag="begin"
}

 # check carefully whether the file to be processed was created by CEP
 # sprawd/xmy staranne czy mamy do czynienia z plikiem stworzonym przez CEP-a

{l=$0 "\n"} # l is a candidate for a prolog line
flag~"begin" && /^%%Creator: CEP/ {flag="cep"; l=""} # ignore CEP comment
flag~"cep"   && /^%UNCEPInfo:/ && NF==5 {
  # store CEP data, ignore CEP comment
  pre_lines=0+$2; buff_num=0+$3; buff_len=0+$4; pos_lines=0+$5
  flag="uncep"; l=""
}
flag~"uncep" && /^\/_fltrd_file currentfile .+ \/_read_string .+ def$/ {
  # store CEP decoding scheme, ignore CEP line
  decodeline=$0; flag="good"; l="" 
}
{prolog=prolog l} # lengthen prolog
flag!~"uncep|good" && /^[^%]/ {exit} # emergency exit (CEP comment not found
                                     # in DSC comment block)
flag~"uncep|good" && NR==pre_lines {exit} # exit after prolog

END {
   # error handling | obs/luga b/l/ed/ow
  if (flag!~"good")  errmessage("not a CEP file",1)
  if (!is_A85() && !is_HEX()) 
    errmessage("CEP file was modified (strange coding), can't uncompress",4)
  printf "UNCEP ver. " ver_no ", decoding:"
  if (is_A85()) printf " A85"
  if (is_HEX()) printf " Hex"
  if (is_LZW()) printf ", LZW"
  if (is_RLE()) printf ", RLE"
  if (is_ZIP()) printf ", Flate"
  print ""

   # restore preamble of EPS file
   # odtworzenie preambu/ly pliku EPS

  if (gsub(/_fltrd_file/,"currentfile",prolog)==0)
    errmessage("CEP file was modified, can't uncompress",4)
  if (gsub(/_read_string/,"readhexstring",prolog)==0)
    errmessage("CEP file was modified, can't uncompress",4)
  gsub(/%/,"%%",prolog) # neutralizing printf | podmiana dla printf

   # WRITE PostScript ENCODING PROGRAM | TWORZENIE PROGRAMU Postscript-owego
  out_ps("(" ps_fname(OUTF) ") (w) file /w_file exch def")
  out_ps("(" ps_fname(FILENAME) ") (r) file /r_file exch def")
  out_ps("/l_string 255 string def")
  out_ps("/p_string 4096 string def")
  out_ps("/b_string " buff_len " string def")
  out_ps("/flushclose {dup flushfile closefile} def")
   # copy preamble | przepisywanie preambu/ly
  out_ps(pre_lines " {r_file l_string readline pop pop} repeat")
  out_ps(pre_lines-3 " {currentfile l_string readline pop")
  out_ps("w_file exch writestring w_file (\\n) writestring} repeat")
  out_ps_block(prolog)
  out_ps("%--- PROLOG END | KONIEC PROLOGU")
   # prepare decoding | przygotowywanie filtr/ow dekoduj/acych
  if (is_A85()) out_ps("r_file /ASCII85Decode filter")
  if (is_HEX()) out_ps("r_file /ASCIIHexDecode filter")
  if (is_LZW()) out_ps("dup /LZWDecode filter")
  if (is_RLE()) out_ps("dup /RunLengthDecode filter")
  if (is_ZIP()) out_ps("dup /FlateDecode filter")
  out_ps("/d_file exch def")
  if (chop_EOD) {# remove EOD mark 
    out_ps("{not {dup length 1 sub 0 exch getinterval} if")
    out_ps(" w_file exch writestring p_string}")
  } else out_ps("w_file")
  out_ps("/ASCIIHexEncode filter")
   # loop decoding the EPS file | p/etla dekoduj/aca plik EPS 
  out_ps(buff_num " {dup d_file b_string")
  out_ps(" readstring pop writestring} repeat")
  out_ps("flushclose d_file closefile")
  if (is_LZW() || is_RLE() || is_ZIP()) out_ps("closefile")
   # copy postamble | przepisanie postambu/ly
  out_ps(pos_lines+1 " {r_file l_string readline pop")
  out_ps("w_file exch writestring w_file (\\n) writestring} repeat")
  out_ps("w_file flushclose r_file closefile quit")
  printf "."
}

function ps_fname(s) {gsub(/\\/,"/",s); return(s)}

function out_ps(s) {print s > TMPSX}
function out_ps_block(block) {printf block > TMPSX}

function out_ps_errorhandler() {
  out_ps("/errq {" gs_abort "} def")
  out_ps("errordict begin ")
  out_ps("/ioerror {(\\010!Input/Output error occurred. (Disk full?)\\n\\007)")
  out_ps("  print errq} def")
  out_ps("/handleerror {$error begin (Something went wrong) print")
  out_ps("  (\\n Error: ) print errorname 255 string cvs print")
  out_ps("  (\\n\\007) print end errq} def")
  out_ps("end")
   #
  out_ps("systemdict /resourcestatus known not")
  out_ps("{(\\010!This version of Ghostscript doesn't support required Level 2 features\\n\\007)")
  out_ps("  print quit} if")
  if (is_A85()) check_filter("ASCII85Decode", "ASCII85Decode filter")
  if (is_HEX()) check_filter("ASCIIHexDecode", "ASCIIHexDecode filter")
  if (is_LZW()) check_filter("LZWDecode", "LZWDecode filter")
  if (is_RLE()) check_filter("RunLengthDecode", "RunLengthDecode filter")
  if (is_ZIP()) check_filter("FlateDecode", "FlateDecode filter")
}
  function check_filter(name, expl) {
    out_ps("/" name " /Filter resourcestatus {pop pop}")
    out_ps("{(\\010!This version of Ghostscript doesn't support " expl "\\n\\007)")
    out_ps("  print errq} ifelse")
  }

function errmessage(errname, errnum) {
 print "UNCEP ERROR:", errname "\007"; exit(errnum)
}

 # determine file decoding method | ustalanie sposobu dekodowania pliku 
function is_A85() {return (decodeline~/\/ASCII85Decode/)}
function is_HEX() {return (decodeline~/\/ASCIIHexDecode/)}
function is_LZW() {return (decodeline~/\/LZWDecode/)}
function is_RLE() {return (decodeline~/\/RunLengthDecode/)}
function is_ZIP() {return (decodeline~/\/FlateDecode/)}
