/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.status;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.status.StatusInformation;

@Path(value="/status")
@Produces(value={"application/json", "application/xml"})
public class StatusResource {
    @Inject
    private Monitor monitor;

    @GET
    public StatusInformation getTables() {
        Status managerStatus;
        Status gcStatus;
        Status tServerStatus = Status.ERROR;
        Status coordinatorStatus = this.monitor.getCoordinatorHost().isPresent() ? Status.OK : Status.ERROR;
        ManagerMonitorInfo mmi = this.monitor.getMmi();
        if (mmi != null) {
            gcStatus = this.monitor.getGcStatus() != null ? Status.OK : Status.ERROR;
            List managers = this.monitor.getContext().getManagerLocations();
            managerStatus = managers.isEmpty() ? Status.ERROR : Status.OK;
            int tServerUp = mmi.getTServerInfoSize();
            int tServerDown = mmi.getDeadTabletServersSize();
            int tServerBad = mmi.getBadTServersSize();
            if ((tServerDown > 0 || tServerBad > 0) && tServerUp > 0) {
                tServerStatus = Status.WARN;
            } else if ((tServerDown == 0 || tServerBad == 0) && tServerUp > 0) {
                tServerStatus = Status.OK;
            } else if (tServerUp == 0) {
                tServerStatus = Status.ERROR;
            }
        } else {
            managerStatus = Status.ERROR;
            gcStatus = this.monitor.getGcStatus() == null ? Status.ERROR : Status.OK;
            tServerStatus = Status.ERROR;
        }
        return new StatusInformation(managerStatus.toString(), gcStatus.toString(), tServerStatus.toString(), coordinatorStatus.toString(), this.monitor.recentLogs().numEvents(), this.monitor.recentLogs().eventsIncludeErrors(), this.monitor.getProblemSummary().entrySet().size());
    }

    public static enum Status {
        OK,
        ERROR,
        WARN;

    }
}

