/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iteratorsImpl.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.YieldCallback;
import org.apache.accumulo.core.iteratorsImpl.system.InterruptibleIterator;

public class SourceSwitchingIterator
implements InterruptibleIterator {
    private DataSource source;
    private SortedKeyValueIterator<Key, Value> iter;
    private Optional<YieldCallback<Key>> yield = Optional.empty();
    private Key key;
    private Value val;
    private Range range;
    private boolean inclusive;
    private Collection<ByteSequence> columnFamilies;
    private final boolean onlySwitchAfterRow;
    private final List<SourceSwitchingIterator> copies;

    private SourceSwitchingIterator(DataSource source, boolean onlySwitchAfterRow, List<SourceSwitchingIterator> copies) {
        this.source = source;
        this.onlySwitchAfterRow = onlySwitchAfterRow;
        this.copies = copies;
        copies.add(this);
    }

    public SourceSwitchingIterator(DataSource source, boolean onlySwitchAfterRow) {
        this(source, onlySwitchAfterRow, new ArrayList<SourceSwitchingIterator>());
    }

    public SourceSwitchingIterator(DataSource source) {
        this(source, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        List<SourceSwitchingIterator> list = this.copies;
        synchronized (list) {
            return new SourceSwitchingIterator(this.source.getDeepCopyDataSource(env), this.onlySwitchAfterRow, this.copies);
        }
    }

    @Override
    public Key getTopKey() {
        return this.key;
    }

    @Override
    public Value getTopValue() {
        return this.val;
    }

    @Override
    public boolean hasTop() {
        return this.key != null;
    }

    @Override
    public void enableYielding(YieldCallback<Key> yield) {
        this.yield = Optional.of(yield);
        if (!this.onlySwitchAfterRow && this.iter != null) {
            this.iter.enableYielding(yield);
        }
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void next() throws IOException {
        List<SourceSwitchingIterator> list = this.copies;
        synchronized (list) {
            this.readNext(false);
        }
    }

    private void readNext(boolean initialSeek) throws IOException {
        boolean seekNeeded;
        boolean yielded = this.yield.isPresent() && this.yield.orElseThrow().hasYielded();
        boolean bl = seekNeeded = yielded || !this.onlySwitchAfterRow && this.switchSource() || initialSeek;
        if (seekNeeded) {
            if (initialSeek) {
                this.iter.seek(this.range, this.columnFamilies, this.inclusive);
            } else if (yielded) {
                Key yieldPosition = this.yield.orElseThrow().getPositionAndReset();
                if (!this.range.contains(yieldPosition)) {
                    throw new IOException("Underlying iterator yielded to a position outside of its range: " + String.valueOf(yieldPosition) + " not in " + String.valueOf(this.range));
                }
                this.iter.seek(new Range(yieldPosition, false, this.range.getEndKey(), this.range.isEndKeyInclusive()), this.columnFamilies, this.inclusive);
            } else {
                this.iter.seek(new Range(this.key, false, this.range.getEndKey(), this.range.isEndKeyInclusive()), this.columnFamilies, this.inclusive);
            }
        } else {
            this.iter.next();
            if (this.onlySwitchAfterRow && this.iter.hasTop() && !this.source.isCurrent() && !this.key.getRowData().equals(this.iter.getTopKey().getRowData())) {
                this.switchSource();
                this.iter.seek(new Range(this.key.followingKey(PartialKey.ROW), true, this.range.getEndKey(), this.range.isEndKeyInclusive()), this.columnFamilies, this.inclusive);
            }
        }
        if (this.iter.hasTop()) {
            if (this.yield.isPresent() && this.yield.orElseThrow().hasYielded()) {
                throw new IOException("Coding error: hasTop returned true but has yielded at " + String.valueOf(this.yield.orElseThrow().getPositionAndReset()));
            }
            Key nextKey = this.iter.getTopKey();
            Value nextVal = this.iter.getTopValue();
            try {
                this.key = (Key)nextKey.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IOException(e);
            }
            this.val = nextVal;
        } else {
            this.key = null;
            this.val = null;
        }
    }

    private boolean switchSource() throws IOException {
        if (!this.source.isCurrent()) {
            this.source = this.source.getNewDataSource();
            this.iter = this.source.iterator();
            if (!this.onlySwitchAfterRow && this.yield.isPresent()) {
                this.iter.enableYielding(this.yield.orElseThrow());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        List<SourceSwitchingIterator> list = this.copies;
        synchronized (list) {
            this.range = range;
            this.inclusive = inclusive;
            this.columnFamilies = columnFamilies;
            if (this.iter == null) {
                this.iter = this.source.iterator();
                if (!this.onlySwitchAfterRow && this.yield.isPresent()) {
                    this.iter.enableYielding(this.yield.orElseThrow());
                }
            }
            this.readNext(true);
        }
    }

    private void _switchNow() throws IOException {
        if (this.onlySwitchAfterRow) {
            throw new IllegalStateException("Can only switch on row boundaries");
        }
        if (this.switchSource() && this.key != null) {
            this.iter.seek(new Range(this.key, true, this.range.getEndKey(), this.range.isEndKeyInclusive()), this.columnFamilies, this.inclusive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchNow() throws IOException {
        List<SourceSwitchingIterator> list = this.copies;
        synchronized (list) {
            for (SourceSwitchingIterator ssi : this.copies) {
                ssi._switchNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterruptFlag(AtomicBoolean flag) {
        List<SourceSwitchingIterator> list = this.copies;
        synchronized (list) {
            if (this.copies.size() != 1) {
                throw new IllegalStateException("setInterruptFlag() called after deep copies made " + this.copies.size());
            }
            if (this.iter != null) {
                ((InterruptibleIterator)this.iter).setInterruptFlag(flag);
            }
            this.source.setInterruptFlag(flag);
        }
    }

    public static interface DataSource {
        public boolean isCurrent();

        public DataSource getNewDataSource();

        public DataSource getDeepCopyDataSource(IteratorEnvironment var1);

        public SortedKeyValueIterator<Key, Value> iterator() throws IOException;

        public void setInterruptFlag(AtomicBoolean var1);

        default public void close(boolean sawErrors) {
        }
    }
}

