/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.balancer;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.manager.balancer.AssignmentParamsImpl;
import org.apache.accumulo.core.manager.balancer.BalanceParamsImpl;
import org.apache.accumulo.core.spi.balancer.BalancerEnvironment;
import org.apache.accumulo.core.spi.balancer.DoNothingBalancer;
import org.apache.accumulo.core.spi.balancer.SimpleLoadBalancer;
import org.apache.accumulo.core.spi.balancer.TabletBalancer;
import org.apache.accumulo.core.spi.balancer.data.TabletMigration;
import org.apache.accumulo.core.spi.balancer.data.TabletServerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableLoadBalancer
implements TabletBalancer {
    private static final Logger log = LoggerFactory.getLogger(TableLoadBalancer.class);
    protected BalancerEnvironment environment;
    Map<TableId, TabletBalancer> perTableBalancers = new HashMap<TableId, TabletBalancer>();

    @Override
    public void init(BalancerEnvironment balancerEnvironment) {
        this.environment = balancerEnvironment;
    }

    private TabletBalancer constructNewBalancerForTable(String clazzName, TableId tableId) throws Exception {
        String context = this.environment.tableContext(tableId);
        Class<TabletBalancer> clazz = ClassLoaderUtil.loadClass(context, clazzName, TabletBalancer.class);
        Constructor<TabletBalancer> constructor = clazz.getConstructor(TableId.class);
        return constructor.newInstance(tableId);
    }

    protected String getLoadBalancerClassNameForTable(TableId table) {
        if (this.environment.isTableOnline(table)) {
            return this.environment.getConfiguration(table).get(Property.TABLE_LOAD_BALANCER.getKey());
        }
        return null;
    }

    private TabletBalancer constructAndInitializeBalancer(String clazzName, TableId tableId) {
        try {
            TabletBalancer balancer = this.constructNewBalancerForTable(clazzName, tableId);
            balancer.init(this.environment);
            return balancer;
        }
        catch (Exception e) {
            log.warn("Failed to load table balancer class {} for table {}", new Object[]{clazzName, tableId, e});
            return null;
        }
    }

    protected TabletBalancer getBalancerForTable(TableId tableId) {
        TabletBalancer balancer = this.perTableBalancers.get(tableId);
        String clazzName = this.getLoadBalancerClassNameForTable(tableId);
        if (clazzName == null) {
            clazzName = SimpleLoadBalancer.class.getName();
        }
        if (balancer == null || !clazzName.equals(balancer.getClass().getName())) {
            balancer = this.constructAndInitializeBalancer(clazzName, tableId);
            if (balancer == null) {
                balancer = this.constructAndInitializeBalancer(DoNothingBalancer.class.getName(), tableId);
                log.error("Fell back to balancer {} for table {}", (Object)DoNothingBalancer.class.getName(), (Object)tableId);
            }
            log.info("Loaded class {} for table {}", (Object)balancer.getClass().getName(), (Object)tableId);
            this.perTableBalancers.put(tableId, balancer);
        }
        return balancer;
    }

    @Override
    public void getAssignments(TabletBalancer.AssignmentParameters params) {
        HashMap groupedUnassigned = new HashMap();
        params.unassignedTablets().forEach((tid, lastTserver) -> groupedUnassigned.computeIfAbsent(tid.getTable(), k -> new HashMap()).put(tid, lastTserver));
        for (Map.Entry e : groupedUnassigned.entrySet()) {
            HashMap<TabletId, TabletServerId> newAssignments = new HashMap<TabletId, TabletServerId>();
            this.getBalancerForTable((TableId)e.getKey()).getAssignments(new AssignmentParamsImpl(params.currentStatus(), (Map)e.getValue(), newAssignments));
            newAssignments.forEach(params::addAssignment);
        }
    }

    @Override
    public long balance(TabletBalancer.BalanceParameters params) {
        long minBalanceTime = 5000L;
        for (Map.Entry<String, TableId> entry : params.getTablesToBalance().entrySet()) {
            String tableName = entry.getKey();
            TableId tableId = entry.getValue();
            ArrayList<TabletMigration> newMigrations = new ArrayList<TabletMigration>();
            long tableBalanceTime = this.getBalancerForTable(tableId).balance(new BalanceParamsImpl(params.currentStatus(), params.currentMigrations(), newMigrations, params.partitionName() + ":" + String.valueOf(tableId), Map.of(tableName, tableId)));
            if (tableBalanceTime < minBalanceTime) {
                minBalanceTime = tableBalanceTime;
            }
            params.migrationsOut().addAll(newMigrations);
        }
        return minBalanceTime;
    }
}

