/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.lang.ref.Cleaner;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.util.cleaner.CleanerUtil;
import org.apache.accumulo.tserver.NativeMap;
import org.slf4j.Logger;

public class NativeMapCleanerUtil {
    private static final Cleaner[] NMI_CLEANERS = new Cleaner[7];

    public static Cleaner.Cleanable deleteNM(Object obj, Logger log, AtomicLong nmPtr) {
        Objects.requireNonNull(nmPtr);
        Objects.requireNonNull(log);
        return CleanerUtil.CLEANER.register(obj, () -> {
            long nmPointer = nmPtr.get();
            if (nmPointer != 0L) {
                log.warn(String.format("Deallocating native map 0x%016x in finalize", nmPointer));
                NativeMap._deleteNativeMap(nmPointer);
            }
        });
    }

    public static Cleaner.Cleanable deleteNMIterator(Object obj, AtomicLong nmiPtr) {
        Objects.requireNonNull(nmiPtr);
        int cleanerIndex = (int)(nmiPtr.get() % (long)NMI_CLEANERS.length);
        if (cleanerIndex < 0) {
            cleanerIndex += NMI_CLEANERS.length;
        }
        return NMI_CLEANERS[cleanerIndex].register(obj, () -> {
            long nmiPointer = nmiPtr.get();
            if (nmiPointer != 0L) {
                NativeMap._deleteNMI(nmiPointer);
            }
        });
    }

    static {
        for (int i = 0; i < NMI_CLEANERS.length; ++i) {
            NativeMapCleanerUtil.NMI_CLEANERS[i] = Cleaner.create();
        }
    }
}

