/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compactions;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.admin.compaction.CompactableFile;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.CompactableFileImpl;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.spi.compaction.CompactionJob;
import org.apache.accumulo.core.spi.compaction.CompactionKind;
import org.apache.accumulo.core.spi.compaction.CompactionServiceId;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.accumulo.tserver.compactions.ExternalCompactionJob;

public interface Compactable {
    public TableId getTableId();

    public KeyExtent getExtent();

    public Optional<Files> getFiles(CompactionServiceId var1, CompactionKind var2);

    public void compact(CompactionServiceId var1, CompactionJob var2, BooleanSupplier var3, RateLimiter var4, RateLimiter var5, long var6);

    public CompactionServiceId getConfiguredService(CompactionKind var1);

    public double getCompactionRatio();

    public ExternalCompactionJob reserveExternalCompaction(CompactionServiceId var1, CompactionJob var2, String var3, ExternalCompactionId var4);

    public void commitExternalCompaction(ExternalCompactionId var1, long var2, long var4);

    public void externalCompactionFailed(ExternalCompactionId var1);

    public boolean isActive(ExternalCompactionId var1);

    public void getExternalCompactionIds(Consumer<ExternalCompactionId> var1);

    public static class Files {
        public final Set<CompactableFile> allFiles;
        public final Set<CompactableFile> candidates;
        public final Collection<CompactionJob> compacting;
        public final Map<String, String> executionHints;

        public Files(SortedMap<StoredTabletFile, DataFileValue> allFiles, Set<StoredTabletFile> candidates, Collection<CompactionJob> running) {
            this(allFiles, candidates, running, Map.of());
        }

        public Files(SortedMap<StoredTabletFile, DataFileValue> allFiles, Set<StoredTabletFile> candidates, Collection<CompactionJob> running, Map<String, String> executionHints) {
            this.allFiles = allFiles.entrySet().stream().map(entry -> new CompactableFileImpl((StoredTabletFile)entry.getKey(), (DataFileValue)entry.getValue())).collect(Collectors.toUnmodifiableSet());
            this.candidates = candidates.stream().map(stf -> new CompactableFileImpl(stf, (DataFileValue)allFiles.get(stf))).collect(Collectors.toUnmodifiableSet());
            this.compacting = Set.copyOf(running);
            Preconditions.checkArgument((boolean)this.allFiles.containsAll(this.candidates), (String)"Candidates not in set of all files %s %s", this.allFiles, this.candidates);
            Set compactingFiles = this.compacting.stream().flatMap(job -> job.getFiles().stream()).collect(Collectors.toSet());
            Preconditions.checkArgument((boolean)this.allFiles.containsAll(compactingFiles), (String)"Compacting files %s not in set of all files: %s", compactingFiles, this.allFiles);
            Preconditions.checkArgument((boolean)Collections.disjoint(compactingFiles, this.candidates), (String)"Compacting and candidates overlap %s %s", compactingFiles, this.candidates);
            this.executionHints = executionHints;
        }

        public String toString() {
            return "Files [allFiles=" + String.valueOf(this.allFiles) + ", candidates=" + String.valueOf(this.candidates) + ", compacting=" + String.valueOf(this.compacting) + ", hints=" + String.valueOf(this.executionHints) + "]";
        }
    }
}

