/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionReason;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.compaction.FileCompactor;
import org.apache.accumulo.server.iterators.SystemIteratorEnvironment;
import org.apache.accumulo.server.iterators.SystemIteratorEnvironmentImpl;
import org.apache.accumulo.tserver.MinorCompactionReason;

public class MinCEnv
implements FileCompactor.CompactionEnv {
    private final MinorCompactionReason reason;
    private final SortedKeyValueIterator<Key, Value> iter;

    public MinCEnv(MinorCompactionReason reason, SortedKeyValueIterator<Key, Value> iter) {
        this.reason = reason;
        this.iter = iter;
    }

    public boolean isCompactionEnabled() {
        return true;
    }

    public IteratorUtil.IteratorScope getIteratorScope() {
        return IteratorUtil.IteratorScope.minc;
    }

    public RateLimiter getReadLimiter() {
        return null;
    }

    public RateLimiter getWriteLimiter() {
        return null;
    }

    public SystemIteratorEnvironment createIteratorEnv(ServerContext context, AccumuloConfiguration acuTableConf, TableId tableId) {
        return (SystemIteratorEnvironment)new SystemIteratorEnvironmentImpl.Builder(context).withScope(IteratorUtil.IteratorScope.minc).withTableId(tableId).build();
    }

    public SortedKeyValueIterator<Key, Value> getMinCIterator() {
        return this.iter;
    }

    public TCompactionReason getReason() {
        switch (this.reason) {
            case USER: {
                return TCompactionReason.USER;
            }
            case CLOSE: {
                return TCompactionReason.CLOSE;
            }
        }
        return TCompactionReason.SYSTEM;
    }
}

