/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.minicluster;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ClientInfoImpl;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.minicluster.MiniAccumuloConfig;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterImpl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;

public class MiniAccumuloCluster
implements AutoCloseable {
    private MiniAccumuloClusterImpl impl;

    private MiniAccumuloCluster(MiniAccumuloConfigImpl config) throws IOException {
        this.impl = new MiniAccumuloClusterImpl(config);
    }

    public MiniAccumuloCluster(File dir, String rootPassword) throws IOException {
        this(new MiniAccumuloConfigImpl(dir, rootPassword));
    }

    public MiniAccumuloCluster(MiniAccumuloConfig config) throws IOException {
        this(config.getImpl());
    }

    public void start() throws IOException, InterruptedException {
        this.impl.start();
    }

    public Set<Pair<ServerType, Integer>> getDebugPorts() {
        return this.impl.getDebugPorts();
    }

    public String getInstanceName() {
        return this.impl.getInstanceName();
    }

    public String getZooKeepers() {
        return this.impl.getZooKeepers();
    }

    public void stop() throws IOException, InterruptedException {
        this.impl.stop();
    }

    @Override
    public void close() throws IOException {
        try {
            this.stop();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public MiniAccumuloConfig getConfig() {
        return new MiniAccumuloConfig(this.impl.getConfig());
    }

    @Deprecated(since="2.0.0")
    public Connector getConnector(String user, String passwd) throws AccumuloException, AccumuloSecurityException {
        return Connector.from((AccumuloClient)this.impl.createAccumuloClient(user, (AuthenticationToken)new PasswordToken((CharSequence)passwd)));
    }

    public AccumuloClient createAccumuloClient(String user, AuthenticationToken token) {
        return this.impl.createAccumuloClient(user, token);
    }

    @Deprecated(since="2.0.0")
    public ClientConfiguration getClientConfig() {
        return this.impl.getClientConfig();
    }

    public Properties getClientProperties() {
        return this.impl.getClientProperties();
    }

    public static Properties getClientProperties(File directory) {
        File clientProps = new File(new File(directory, "conf"), "accumulo-client.properties");
        Preconditions.checkArgument((boolean)clientProps.exists());
        return ClientInfoImpl.toProperties((Path)clientProps.toPath());
    }
}

