/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientConfConverter;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.clientImpl.InstanceOperationsImpl;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.server.ServerDirs;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class ServerInfo
implements ClientInfo {
    private final SiteConfiguration siteConfig;
    private final Configuration hadoopConf;
    private final InstanceId instanceID;
    private final String instanceName;
    private final String zooKeepers;
    private final int zooKeepersSessionTimeOut;
    private final VolumeManager volumeManager;
    private final ZooCache zooCache;
    private final ServerDirs serverDirs;
    private final Credentials credentials;

    ServerInfo(SiteConfiguration siteConfig, String instanceName, String zooKeepers, int zooKeepersSessionTimeOut) {
        SingletonManager.setMode((SingletonManager.Mode)SingletonManager.Mode.SERVER);
        this.siteConfig = siteConfig;
        this.hadoopConf = new Configuration();
        this.instanceName = instanceName;
        this.zooKeepers = zooKeepers;
        this.zooKeepersSessionTimeOut = zooKeepersSessionTimeOut;
        try {
            this.volumeManager = VolumeManagerImpl.get((AccumuloConfiguration)siteConfig, this.hadoopConf);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.zooCache = new ZooCacheFactory().getZooCache(zooKeepers, zooKeepersSessionTimeOut);
        String instanceNamePath = "/accumulo/instances/" + instanceName;
        byte[] iidb = this.zooCache.get(instanceNamePath);
        if (iidb == null) {
            throw new IllegalStateException("Instance name " + instanceName + " does not exist in zookeeper. Run \"accumulo org.apache.accumulo.server.util.ListInstances\" to see a list.");
        }
        this.instanceID = InstanceId.of((String)new String(iidb, StandardCharsets.UTF_8));
        if (this.zooCache.get("/accumulo/" + this.instanceID) == null) {
            if (instanceName == null) {
                throw new IllegalStateException("Instance id " + this.instanceID + " does not exist in zookeeper");
            }
            throw new IllegalStateException("Instance id " + this.instanceID + " pointed to by the name " + instanceName + " does not exist in zookeeper");
        }
        this.serverDirs = new ServerDirs((AccumuloConfiguration)siteConfig, this.hadoopConf);
        this.credentials = SystemCredentials.get(this.instanceID, siteConfig);
    }

    ServerInfo(SiteConfiguration config) {
        SingletonManager.setMode((SingletonManager.Mode)SingletonManager.Mode.SERVER);
        this.siteConfig = config;
        this.hadoopConf = new Configuration();
        try {
            this.volumeManager = VolumeManagerImpl.get((AccumuloConfiguration)this.siteConfig, this.hadoopConf);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.serverDirs = new ServerDirs((AccumuloConfiguration)this.siteConfig, this.hadoopConf);
        Path instanceIdPath = this.serverDirs.getInstanceIdLocation(this.volumeManager.getFirst());
        this.instanceID = VolumeManager.getInstanceIDFromHdfs(instanceIdPath, this.hadoopConf);
        this.zooKeepers = config.get(Property.INSTANCE_ZK_HOST);
        this.zooKeepersSessionTimeOut = (int)config.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT);
        this.zooCache = new ZooCacheFactory().getZooCache(this.zooKeepers, this.zooKeepersSessionTimeOut);
        this.instanceName = InstanceOperationsImpl.lookupInstanceName((ZooCache)this.zooCache, (InstanceId)this.instanceID);
        this.credentials = SystemCredentials.get(this.instanceID, this.siteConfig);
    }

    ServerInfo(SiteConfiguration config, String instanceName, InstanceId instanceID) {
        SingletonManager.setMode((SingletonManager.Mode)SingletonManager.Mode.SERVER);
        this.siteConfig = config;
        this.hadoopConf = new Configuration();
        try {
            this.volumeManager = VolumeManagerImpl.get((AccumuloConfiguration)this.siteConfig, this.hadoopConf);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.instanceID = instanceID;
        this.zooKeepers = config.get(Property.INSTANCE_ZK_HOST);
        this.zooKeepersSessionTimeOut = (int)config.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT);
        this.zooCache = new ZooCacheFactory().getZooCache(this.zooKeepers, this.zooKeepersSessionTimeOut);
        this.instanceName = instanceName;
        this.serverDirs = new ServerDirs((AccumuloConfiguration)this.siteConfig, this.hadoopConf);
        this.credentials = SystemCredentials.get(instanceID, this.siteConfig);
    }

    public SiteConfiguration getSiteConfiguration() {
        return this.siteConfig;
    }

    public VolumeManager getVolumeManager() {
        return this.volumeManager;
    }

    public InstanceId getInstanceID() {
        return this.instanceID;
    }

    public String getZooKeepers() {
        return this.zooKeepers;
    }

    public int getZooKeepersSessionTimeOut() {
        return this.zooKeepersSessionTimeOut;
    }

    public String getPrincipal() {
        return this.getCredentials().getPrincipal();
    }

    public AuthenticationToken getAuthenticationToken() {
        return this.getCredentials().getToken();
    }

    public boolean saslEnabled() {
        return this.getSiteConfiguration().getBoolean(Property.INSTANCE_RPC_SASL_ENABLED);
    }

    public Properties getProperties() {
        Properties properties = ClientConfConverter.toProperties((AccumuloConfiguration)this.getSiteConfiguration());
        properties.setProperty(ClientProperty.INSTANCE_ZOOKEEPERS.getKey(), this.getZooKeepers());
        properties.setProperty(ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT.getKey(), Integer.toString(this.getZooKeepersSessionTimeOut()));
        properties.setProperty(ClientProperty.INSTANCE_NAME.getKey(), this.getInstanceName());
        ClientProperty.setAuthenticationToken((Properties)properties, (AuthenticationToken)this.getAuthenticationToken());
        properties.setProperty(ClientProperty.AUTH_PRINCIPAL.getKey(), this.getPrincipal());
        return properties;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public ServerDirs getServerDirs() {
        return this.serverDirs;
    }
}

